/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.hive.orc.OrcSerde;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.orc.OrcBatchPageSourceFactory;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.joda.time.DateTimeZone;

public class DwrfBatchPageSourceFactory
implements HiveBatchPageSourceFactory {
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final int domainCompactionThreshold;
    private final OrcFileTailSource orcFileTailSource;
    private final StripeMetadataSource stripeMetadataSource;

    @Inject
    public DwrfBatchPageSourceFactory(TypeManager typeManager, HiveClientConfig config, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, OrcFileTailSource orcFileTailSource, StripeMetadataSource stripeMetadataSource) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.domainCompactionThreshold = Objects.requireNonNull(config, "config is null").getDomainCompactionThreshold();
        this.orcFileTailSource = Objects.requireNonNull(orcFileTailSource, "orcFileTailSource is null");
        this.stripeMetadataSource = Objects.requireNonNull(stripeMetadataSource, "stripeMetadataSource is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Storage storage, Map<String, String> tableParameters, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, HiveFileContext hiveFileContext) {
        if (!OrcSerde.class.getName().equals(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        if (fileSize == 0L) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "ORC file is empty: " + path);
        }
        return Optional.of(OrcBatchPageSourceFactory.createOrcPageSource(OrcEncoding.DWRF, this.hdfsEnvironment, session.getUser(), configuration, path, start, length, fileSize, columns, false, effectivePredicate, hiveStorageTimeZone, this.typeManager, HiveSessionProperties.getOrcMaxBufferSize(session), HiveSessionProperties.getOrcStreamBufferSize(session), HiveSessionProperties.getOrcLazyReadSmallRanges(session), false, this.stats, this.domainCompactionThreshold, this.orcFileTailSource, this.stripeMetadataSource, hiveFileContext, new OrcReaderOptions(HiveSessionProperties.getOrcMaxMergeDistance(session), HiveSessionProperties.getOrcTinyStripeThreshold(session), HiveSessionProperties.getOrcMaxReadBlockSize(session), HiveSessionProperties.isOrcZstdJniDecompressionEnabled(session))));
    }
}

