/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.pagefile;

import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.orc.stream.DataOutput;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class PageFileFooterOutput
implements DataOutput {
    public static final int FOOTER_LENGTH_IN_BYTES = 4;
    private final List<Long> stripeOffsets;
    private final Slice compressionSlice;

    public PageFileFooterOutput(List<Long> stripeOffsets, HiveCompressionCodec compressionCodec) {
        this.stripeOffsets = ImmutableList.copyOf((Collection)Objects.requireNonNull(stripeOffsets, "stripeOffsets is null"));
        this.compressionSlice = Slices.utf8Slice((String)Objects.requireNonNull(compressionCodec, "compressionCodec is null").name());
    }

    public long size() {
        long size = 4L;
        if (!this.stripeOffsets.isEmpty()) {
            size += (long)(4 + this.compressionSlice.length() + 4 + 8 * this.stripeOffsets.size());
        }
        return size;
    }

    public void writeData(SliceOutput sliceOutput) {
        if (!this.stripeOffsets.isEmpty()) {
            sliceOutput.writeInt(this.compressionSlice.length());
            sliceOutput.writeBytes(this.compressionSlice);
            sliceOutput.writeInt(this.stripeOffsets.size());
            for (long offset : this.stripeOffsets) {
                sliceOutput.writeLong(offset);
            }
        }
        sliceOutput.writeInt(Math.toIntExact(this.size()));
    }

    public static PageFileFooterOutput createEmptyPageFileFooterOutput() {
        return new PageFileFooterOutput((List<Long>)ImmutableList.of(), HiveCompressionCodec.NONE);
    }
}

