/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.ForCachingDirectoryLister;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;
import org.weakref.jmx.Managed;

public class CachingDirectoryLister
implements DirectoryLister {
    private final Cache<Path, List<HiveFileInfo>> cache;
    private final CachedTableChecker cachedTableChecker;
    protected final DirectoryLister delegate;

    @Inject
    public CachingDirectoryLister(@ForCachingDirectoryLister DirectoryLister delegate, HiveClientConfig hiveClientConfig) {
        this(delegate, hiveClientConfig.getFileStatusCacheExpireAfterWrite(), hiveClientConfig.getFileStatusCacheMaxSize(), hiveClientConfig.getFileStatusCacheTables());
    }

    public CachingDirectoryLister(DirectoryLister delegate, Duration expireAfterWrite, long maxSize, List<String> tables) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.cache = CacheBuilder.newBuilder().maximumWeight(maxSize).weigher((key, value) -> value.size()).expireAfterWrite(expireAfterWrite.toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
        this.cachedTableChecker = new CachedTableChecker(Objects.requireNonNull(tables, "tables is null"));
    }

    @Override
    public Iterator<HiveFileInfo> list(ExtendedFileSystem fileSystem, Table table, Path path, NamenodeStats namenodeStats, HiveDirectoryContext hiveDirectoryContext) {
        List files = (List)this.cache.getIfPresent((Object)path);
        if (files != null) {
            return files.iterator();
        }
        Iterator<HiveFileInfo> iterator = this.delegate.list(fileSystem, table, path, namenodeStats, hiveDirectoryContext);
        if (hiveDirectoryContext.isCacheable() && this.cachedTableChecker.isCachedTable(table.getSchemaTableName())) {
            return this.cachingIterator(iterator, path);
        }
        return iterator;
    }

    private Iterator<HiveFileInfo> cachingIterator(final Iterator<HiveFileInfo> iterator, final Path path) {
        return new Iterator<HiveFileInfo>(){
            private final List<HiveFileInfo> files = new ArrayList<HiveFileInfo>();

            @Override
            public boolean hasNext() {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    CachingDirectoryLister.this.cache.put((Object)path, (Object)ImmutableList.copyOf(this.files));
                }
                return hasNext;
            }

            @Override
            public HiveFileInfo next() {
                HiveFileInfo next = (HiveFileInfo)iterator.next();
                this.files.add(next);
                return next;
            }
        };
    }

    @Managed
    public void flushCache() {
        this.cache.invalidateAll();
    }

    @Managed
    public Double getHitRate() {
        return this.cache.stats().hitRate();
    }

    @Managed
    public Double getMissRate() {
        return this.cache.stats().missRate();
    }

    @Managed
    public long getHitCount() {
        return this.cache.stats().hitCount();
    }

    @Managed
    public long getMissCount() {
        return this.cache.stats().missCount();
    }

    @Managed
    public long getRequestCount() {
        return this.cache.stats().requestCount();
    }

    private static class CachedTableChecker {
        private final Set<SchemaTableName> cachedTableNames;
        private final boolean cacheAllTables;

        public CachedTableChecker(List<String> cachedTables) {
            this.cacheAllTables = cachedTables.contains("*");
            if (this.cacheAllTables) {
                Preconditions.checkArgument((cachedTables.size() == 1 ? 1 : 0) != 0, (Object)"Only '*' is expected when caching all tables");
                this.cachedTableNames = ImmutableSet.of();
            } else {
                this.cachedTableNames = (Set)cachedTables.stream().map(SchemaTableName::valueOf).collect(ImmutableSet.toImmutableSet());
            }
        }

        public boolean isCachedTable(SchemaTableName schemaTableName) {
            return this.cacheAllTables || this.cachedTableNames.contains(schemaTableName);
        }
    }
}

