/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class CopyOnWriteConfiguration
extends Configuration {
    private final Object lock = new Object();
    private Configuration config;
    private boolean isMutable;

    public CopyOnWriteConfiguration(Configuration config) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.isMutable = false;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void set(String name, String value) {
        this.checkAndSet(() -> this.config.set(name, value));
    }

    public void set(String name, String value, String source) {
        this.checkAndSet(() -> this.config.set(name, value, source));
    }

    public synchronized void setIfUnset(String name, String value) {
        this.checkAndSet(() -> this.config.setIfUnset(name, value));
    }

    public void setInt(String name, int value) {
        this.checkAndSet(() -> this.config.setInt(name, value));
    }

    public void setLong(String name, long value) {
        this.checkAndSet(() -> this.config.setLong(name, value));
    }

    public void setFloat(String name, float value) {
        this.checkAndSet(() -> this.config.setFloat(name, value));
    }

    public void setDouble(String name, double value) {
        this.checkAndSet(() -> this.config.setDouble(name, value));
    }

    public void setBoolean(String name, boolean value) {
        this.checkAndSet(() -> this.config.setBoolean(name, value));
    }

    public void setBooleanIfUnset(String name, boolean value) {
        this.checkAndSet(() -> this.config.setBooleanIfUnset(name, value));
    }

    public <T extends Enum<T>> void setEnum(String name, T value) {
        this.checkAndSet(() -> this.config.setEnum(name, value));
    }

    public void setTimeDuration(String name, long value, TimeUnit unit) {
        this.checkAndSet(() -> this.config.setTimeDuration(name, value, unit));
    }

    public void setPattern(String name, Pattern pattern) {
        this.checkAndSet(() -> this.config.setPattern(name, pattern));
    }

    public void setStrings(String name, String ... values) {
        this.checkAndSet(() -> this.config.setStrings(name, values));
    }

    public void setSocketAddr(String name, InetSocketAddress addr) {
        this.checkAndSet(() -> this.config.setSocketAddr(name, addr));
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        this.checkAndSet(() -> this.config.setClass(name, theClass, xface));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.checkAndSet(() -> this.config.setClassLoader(classLoader));
    }

    public synchronized void setQuietMode(boolean quietMode) {
        this.checkAndSet(() -> this.config.setQuietMode(quietMode));
    }

    public void setDeprecatedProperties() {
        this.checkAndSet(() -> this.config.setDeprecatedProperties());
    }

    public synchronized void unset(String name) {
        this.checkAndSet(() -> this.config.unset(name));
    }

    public String get(String name) {
        return this.config.get(name);
    }

    public String get(String name, String defaultValue) {
        return this.config.get(name, defaultValue);
    }

    public String getTrimmed(String name) {
        return this.config.getTrimmed(name);
    }

    public String getTrimmed(String name, String defaultValue) {
        return this.config.getTrimmed(name, defaultValue);
    }

    public String getRaw(String name) {
        return this.config.getRaw(name);
    }

    public int getInt(String name, int defaultValue) {
        return this.config.getInt(name, defaultValue);
    }

    public int[] getInts(String name) {
        return this.config.getInts(name);
    }

    public long getLong(String name, long defaultValue) {
        return this.config.getLong(name, defaultValue);
    }

    public long getLongBytes(String name, long defaultValue) {
        return this.config.getLongBytes(name, defaultValue);
    }

    public float getFloat(String name, float defaultValue) {
        return this.config.getFloat(name, defaultValue);
    }

    public double getDouble(String name, double defaultValue) {
        return this.config.getDouble(name, defaultValue);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.config.getBoolean(name, defaultValue);
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        return (T)this.config.getEnum(name, defaultValue);
    }

    public long getTimeDuration(String name, long defaultValue, TimeUnit unit) {
        return this.config.getTimeDuration(name, defaultValue, unit);
    }

    public Pattern getPattern(String name, Pattern defaultValue) {
        return this.config.getPattern(name, defaultValue);
    }

    public Configuration.IntegerRanges getRange(String name, String defaultValue) {
        return this.config.getRange(name, defaultValue);
    }

    public Collection<String> getStringCollection(String name) {
        return this.config.getStringCollection(name);
    }

    public String[] getStrings(String name) {
        return this.config.getStrings(name);
    }

    public String[] getStrings(String name, String ... defaultValue) {
        return this.config.getStrings(name, defaultValue);
    }

    public Collection<String> getTrimmedStringCollection(String name) {
        return this.config.getTrimmedStringCollection(name);
    }

    public String[] getTrimmedStrings(String name) {
        return this.config.getTrimmedStrings(name);
    }

    public String[] getTrimmedStrings(String name, String ... defaultValue) {
        return this.config.getTrimmedStrings(name, defaultValue);
    }

    public char[] getPassword(String name) throws IOException {
        return this.config.getPassword(name);
    }

    public InetSocketAddress getSocketAddr(String hostProperty, String addressProperty, String defaultAddressValue, int defaultPort) {
        return this.config.getSocketAddr(hostProperty, addressProperty, defaultAddressValue, defaultPort);
    }

    public InetSocketAddress getSocketAddr(String name, String defaultAddress, int defaultPort) {
        return this.config.getSocketAddr(name, defaultAddress, defaultPort);
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        return this.config.getClassByName(name);
    }

    public Class<?> getClassByNameOrNull(String name) {
        return this.config.getClassByNameOrNull(name);
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        return this.config.getClasses(name, (Class[])defaultValue);
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        return this.config.getClass(name, defaultValue);
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        return this.config.getClass(name, defaultValue, xface);
    }

    public <U> List<U> getInstances(String name, Class<U> xface) {
        return this.config.getInstances(name, xface);
    }

    public Path getLocalPath(String dirsProp, String path) throws IOException {
        return this.config.getLocalPath(dirsProp, path);
    }

    public File getFile(String dirsProp, String path) throws IOException {
        return this.config.getFile(dirsProp, path);
    }

    public URL getResource(String name) {
        return this.config.getResource(name);
    }

    public InputStream getConfResourceAsInputStream(String name) {
        return this.config.getConfResourceAsInputStream(name);
    }

    public Reader getConfResourceAsReader(String name) {
        return this.config.getConfResourceAsReader(name);
    }

    public Set<String> getFinalParameters() {
        return this.config.getFinalParameters();
    }

    public int size() {
        return this.config.size();
    }

    public void clear() {
        this.config.clear();
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.config.iterator();
    }

    public ClassLoader getClassLoader() {
        return this.config.getClassLoader();
    }

    public void readFields(DataInput in) throws IOException {
        this.config.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.config.write(out);
    }

    public void writeXml(OutputStream out) throws IOException {
        this.config.writeXml(out);
    }

    public void writeXml(Writer out) throws IOException {
        this.config.writeXml(out);
    }

    public Map<String, String> getValByRegex(String regex) {
        return this.config.getValByRegex(regex);
    }

    public String toString() {
        return this.config.toString();
    }

    public void addResource(String name) {
        this.config.addResource(name);
    }

    public void addResource(URL url) {
        this.config.addResource(url);
    }

    public void addResource(Path file) {
        this.config.addResource(file);
    }

    public void addResource(InputStream in) {
        this.config.addResource(in);
    }

    public void addResource(InputStream in, String name) {
        this.config.addResource(in, name);
    }

    public void addResource(Configuration conf) {
        this.config.addResource(conf);
    }

    public synchronized void reloadConfiguration() {
        this.config.reloadConfiguration();
    }

    public synchronized String[] getPropertySources(String name) {
        return this.config.getPropertySources(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndSet(Runnable action) {
        if (this.isMutable) {
            action.run();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Configuration originalConfig = this.config;
            this.config = new Configuration(originalConfig);
            this.isMutable = true;
            action.run();
        }
    }
}

