/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.concurrent.ExecutorServiceAdapter;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.json.JsonCodecBinder;
import com.facebook.airlift.json.smile.SmileCodecBinder;
import com.facebook.presto.cache.ForCachingFileSystem;
import com.facebook.presto.hive.CacheQuotaRequirementProvider;
import com.facebook.presto.hive.CacheStatsMBean;
import com.facebook.presto.hive.CachingDirectoryLister;
import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.ConfigBasedCacheQuotaRequirementProvider;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.DynamicConfigurationProvider;
import com.facebook.presto.hive.EncryptionInformationSource;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.ForCachingDirectoryLister;
import com.facebook.presto.hive.ForCachingHiveMetastore;
import com.facebook.presto.hive.ForFileRename;
import com.facebook.presto.hive.ForHiveClient;
import com.facebook.presto.hive.ForMetastoreHdfsEnvironment;
import com.facebook.presto.hive.ForUpdatingHiveMetadata;
import com.facebook.presto.hive.ForZeroRowFileCreator;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HadoopDirectoryLister;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveAnalyzeProperties;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCoercionPolicy;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveConnectorId;
import com.facebook.presto.hive.HiveDwrfEncryptionProvider;
import com.facebook.presto.hive.HiveEncryptionInformationProvider;
import com.facebook.presto.hive.HiveEventClient;
import com.facebook.presto.hive.HiveFileRenamer;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveLocationService;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HiveMetadataUpdaterProvider;
import com.facebook.presto.hive.HiveNodePartitioningProvider;
import com.facebook.presto.hive.HivePageSinkProvider;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionObjectBuilder;
import com.facebook.presto.hive.HivePartitionStats;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSelectivePageSourceFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplitManager;
import com.facebook.presto.hive.HiveStagingFileCommitter;
import com.facebook.presto.hive.HiveTableProperties;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.HiveZeroRowFileCreator;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.MetastoreClientModule;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.PartitionObjectBuilder;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.RcFileFileWriterFactory;
import com.facebook.presto.hive.S3SelectRecordCursorProvider;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ZeroRowFileCreator;
import com.facebook.presto.hive.cache.HiveCachingHdfsConfiguration;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.datasink.OutputStreamDataSinkFactory;
import com.facebook.presto.hive.metastore.HiveMetastoreCacheStats;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.MetastoreCacheStats;
import com.facebook.presto.hive.orc.DwrfBatchPageSourceFactory;
import com.facebook.presto.hive.orc.DwrfSelectivePageSourceFactory;
import com.facebook.presto.hive.orc.OrcBatchPageSourceFactory;
import com.facebook.presto.hive.orc.OrcSelectivePageSourceFactory;
import com.facebook.presto.hive.orc.TupleDomainFilterCache;
import com.facebook.presto.hive.pagefile.PageFilePageSourceFactory;
import com.facebook.presto.hive.pagefile.PageFileWriterFactory;
import com.facebook.presto.hive.parquet.ParquetFileWriterFactory;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.parquet.ParquetSelectivePageSourceFactory;
import com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import com.facebook.presto.hive.rule.HivePlanOptimizerProvider;
import com.facebook.presto.hive.s3.PrestoS3ClientFactory;
import com.facebook.presto.orc.CachingStripeMetadataSource;
import com.facebook.presto.orc.DwrfAwareStripeMetadataSourceFactory;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.UnsupportedEncryptionLibrary;
import com.facebook.presto.orc.cache.CachingOrcFileTailSource;
import com.facebook.presto.orc.cache.OrcCacheConfig;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.orc.metadata.OrcFileTail;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.parquet.cache.CachingParquetMetadataSource;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.cache.ParquetCacheConfig;
import com.facebook.presto.parquet.cache.ParquetFileMetadata;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.facebook.presto.spi.connector.ConnectorMetadataUpdaterProvider;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Singleton;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;
import org.weakref.jmx.guice.ExportBinder;

public class HiveClientModule
implements Module {
    private final String connectorId;

    public HiveClientModule(String connectorId) {
        this.connectorId = connectorId;
    }

    public void configure(Binder binder) {
        binder.bind(HiveConnectorId.class).toInstance((Object)new HiveConnectorId(this.connectorId));
        binder.bind(TypeTranslator.class).toInstance((Object)new HiveTypeTranslator());
        binder.bind(CoercionPolicy.class).to(HiveCoercionPolicy.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfigurationInitializer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, DynamicConfigurationProvider.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HiveClientConfig.class);
        binder.bind(HiveSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(HiveTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(HiveAnalyzeProperties.class).in(Scopes.SINGLETON);
        binder.bind(NamenodeStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(NamenodeStats.class).as(ObjectNames.generatedNameOf(NamenodeStats.class, (String)this.connectorId));
        binder.bind(PrestoS3ClientFactory.class).in(Scopes.SINGLETON);
        binder.bind(DirectoryLister.class).annotatedWith(ForCachingDirectoryLister.class).to(HadoopDirectoryLister.class).in(Scopes.SINGLETON);
        binder.bind(DirectoryLister.class).to(CachingDirectoryLister.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DirectoryLister.class).as(ObjectNames.generatedNameOf(CachingDirectoryLister.class, (String)this.connectorId));
        Multibinder recordCursorProviderBinder = Multibinder.newSetBinder((Binder)binder, HiveRecordCursorProvider.class);
        recordCursorProviderBinder.addBinding().to(S3SelectRecordCursorProvider.class).in(Scopes.SINGLETON);
        recordCursorProviderBinder.addBinding().to(GenericHiveRecordCursorProvider.class).in(Scopes.SINGLETON);
        binder.bind(HiveWriterStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveWriterStats.class).as(ObjectNames.generatedNameOf(HiveWriterStats.class, (String)this.connectorId));
        binder.bind(HiveFileRenamer.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HiveFileRenamer.class).as(ObjectNames.generatedNameOf(HiveFileRenamer.class, (String)this.connectorId));
        Multibinder.newSetBinder((Binder)binder, EventClient.class).addBinding().to(HiveEventClient.class).in(Scopes.SINGLETON);
        binder.bind(HivePartitionManager.class).in(Scopes.SINGLETON);
        binder.bind(LocationService.class).to(HiveLocationService.class).in(Scopes.SINGLETON);
        binder.bind(TableParameterCodec.class).in(Scopes.SINGLETON);
        binder.bind(HivePartitionStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(HivePartitionStats.class).as(ObjectNames.generatedNameOf(HivePartitionStats.class, (String)this.connectorId));
        binder.bind(HiveMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind((TypeLiteral)new TypeLiteral<Supplier<TransactionalMetadata>>(){}).to(HiveMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(StagingFileCommitter.class).to(HiveStagingFileCommitter.class).in(Scopes.SINGLETON);
        binder.bind(ZeroRowFileCreator.class).to(HiveZeroRowFileCreator.class).in(Scopes.SINGLETON);
        binder.bind(PartitionObjectBuilder.class).to(HivePartitionObjectBuilder.class).in(Scopes.SINGLETON);
        binder.bind(HiveTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(HiveSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(CacheQuotaRequirementProvider.class).to(ConfigBasedCacheQuotaRequirementProvider.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ConnectorSplitManager.class).as(ObjectNames.generatedNameOf(HiveSplitManager.class, (String)this.connectorId));
        binder.bind(ConnectorPageSourceProvider.class).to(HivePageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(HivePageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).to(HiveNodePartitioningProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPlanOptimizerProvider.class).to(HivePlanOptimizerProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorMetadataUpdaterProvider.class).to(HiveMetadataUpdaterProvider.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(PartitionUpdate.class);
        SmileCodecBinder.smileCodecBinder((Binder)binder).bindSmileCodec(PartitionUpdate.class);
        binder.bind(FileFormatDataSourceStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(FileFormatDataSourceStats.class).as(ObjectNames.generatedNameOf(FileFormatDataSourceStats.class, (String)this.connectorId));
        binder.bind(EncryptionLibrary.class).annotatedWith(HiveDwrfEncryptionProvider.ForCryptoService.class).to(UnsupportedEncryptionLibrary.class).in(Scopes.SINGLETON);
        binder.bind(EncryptionLibrary.class).annotatedWith(HiveDwrfEncryptionProvider.ForUnknown.class).to(UnsupportedEncryptionLibrary.class).in(Scopes.SINGLETON);
        binder.bind(HiveDwrfEncryptionProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ParquetCacheConfig.class, this.connectorId);
        Multibinder pageSourceFactoryBinder = Multibinder.newSetBinder((Binder)binder, HiveBatchPageSourceFactory.class);
        pageSourceFactoryBinder.addBinding().to(OrcBatchPageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(DwrfBatchPageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(ParquetPageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(RcFilePageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(PageFilePageSourceFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OrcCacheConfig.class, this.connectorId);
        binder.bind(TupleDomainFilterCache.class).in(Scopes.SINGLETON);
        binder.bind(HdfsEnvironment.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfiguration.class).annotatedWith(ForMetastoreHdfsEnvironment.class).to(HiveCachingHdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfiguration.class).annotatedWith(ForCachingFileSystem.class).to(HiveHdfsConfiguration.class).in(Scopes.SINGLETON);
        Multibinder selectivePageSourceFactoryBinder = Multibinder.newSetBinder((Binder)binder, HiveSelectivePageSourceFactory.class);
        selectivePageSourceFactoryBinder.addBinding().to(OrcSelectivePageSourceFactory.class).in(Scopes.SINGLETON);
        selectivePageSourceFactoryBinder.addBinding().to(DwrfSelectivePageSourceFactory.class).in(Scopes.SINGLETON);
        selectivePageSourceFactoryBinder.addBinding().to(ParquetSelectivePageSourceFactory.class).in(Scopes.SINGLETON);
        binder.bind(DataSinkFactory.class).to(OutputStreamDataSinkFactory.class).in(Scopes.SINGLETON);
        Multibinder fileWriterFactoryBinder = Multibinder.newSetBinder((Binder)binder, HiveFileWriterFactory.class);
        binder.bind(OrcFileWriterFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(OrcFileWriterFactory.class).as(ObjectNames.generatedNameOf(OrcFileWriterFactory.class, (String)this.connectorId));
        ConfigBinder.configBinder((Binder)binder).bindConfig(OrcFileWriterConfig.class);
        fileWriterFactoryBinder.addBinding().to(OrcFileWriterFactory.class).in(Scopes.SINGLETON);
        fileWriterFactoryBinder.addBinding().to(RcFileFileWriterFactory.class).in(Scopes.SINGLETON);
        fileWriterFactoryBinder.addBinding().to(PageFileWriterFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ParquetFileWriterConfig.class);
        fileWriterFactoryBinder.addBinding().to(ParquetFileWriterFactory.class).in(Scopes.SINGLETON);
        binder.bind(MetastoreCacheStats.class).to(HiveMetastoreCacheStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(MetastoreCacheStats.class).as(ObjectNames.generatedNameOf(MetastoreCacheStats.class, (String)this.connectorId));
        binder.install((Module)new MetastoreClientModule());
        binder.bind(HiveEncryptionInformationProvider.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, EncryptionInformationSource.class);
        binder.bind(PartitionMutator.class).to(HivePartitionMutator.class).in(Scopes.SINGLETON);
        binder.bind(ColumnConverterProvider.class).to(HiveColumnConverterProvider.class).in(Scopes.SINGLETON);
    }

    @ForHiveClient
    @Singleton
    @Provides
    public ExecutorService createHiveClientExecutor(HiveConnectorId hiveClientId) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-" + hiveClientId + "-%s")));
    }

    @ForCachingHiveMetastore
    @Singleton
    @Provides
    public ExecutorService createCachingHiveMetastoreExecutor(HiveConnectorId hiveClientId, MetastoreClientConfig metastoreClientConfig) {
        return Executors.newFixedThreadPool(metastoreClientConfig.getMaxMetastoreRefreshThreads(), Threads.daemonThreadsNamed((String)("hive-metastore-" + hiveClientId + "-%s")));
    }

    @ForUpdatingHiveMetadata
    @Singleton
    @Provides
    public ExecutorService createUpdatingHiveMetadataExecutor(HiveConnectorId hiveClientId) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-metadata-updater-" + hiveClientId + "-%s")));
    }

    @ForFileRename
    @Singleton
    @Provides
    public ListeningExecutorService createFileRanemeExecutor(HiveConnectorId hiveClientId, HiveClientConfig hiveClientConfig) {
        return MoreExecutors.listeningDecorator((ExecutorService)new ExecutorServiceAdapter((Executor)new BoundedExecutor((Executor)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-rename-" + hiveClientId + "-%s"))), hiveClientConfig.getMaxConcurrentFileRenames())));
    }

    @ForZeroRowFileCreator
    @Singleton
    @Provides
    public ListeningExecutorService createZeroRowFileCreatorExecutor(HiveConnectorId hiveClientId, HiveClientConfig hiveClientConfig) {
        return MoreExecutors.listeningDecorator((ExecutorService)new ExecutorServiceAdapter((Executor)new BoundedExecutor((Executor)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-create-zero-row-file-" + hiveClientId + "-%s"))), hiveClientConfig.getMaxConcurrentZeroRowFileCreations())));
    }

    @Singleton
    @Provides
    public OrcFileTailSource createOrcFileTailSource(OrcCacheConfig orcCacheConfig, MBeanExporter exporter) {
        int expectedFileTailSizeInBytes = Math.toIntExact(orcCacheConfig.getExpectedFileTailSize().toBytes());
        boolean dwrfStripeCacheEnabled = orcCacheConfig.isDwrfStripeCacheEnabled();
        StorageOrcFileTailSource orcFileTailSource = new StorageOrcFileTailSource(expectedFileTailSizeInBytes, dwrfStripeCacheEnabled);
        if (orcCacheConfig.isFileTailCacheEnabled()) {
            Cache cache = CacheBuilder.newBuilder().maximumWeight(orcCacheConfig.getFileTailCacheSize().toBytes()).weigher((id, tail) -> ((OrcFileTail)tail).getFooterSize() + ((OrcFileTail)tail).getMetadataSize()).expireAfterAccess(orcCacheConfig.getFileTailCacheTtlSinceLastAccess().toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
            CacheStatsMBean cacheStatsMBean = new CacheStatsMBean(cache);
            orcFileTailSource = new CachingOrcFileTailSource((OrcFileTailSource)orcFileTailSource, cache);
            exporter.export(ObjectNames.generatedNameOf(CacheStatsMBean.class, (String)(this.connectorId + "_OrcFileTail")), (Object)cacheStatsMBean);
        }
        return orcFileTailSource;
    }

    @Singleton
    @Provides
    public StripeMetadataSourceFactory createStripeMetadataSourceFactory(OrcCacheConfig orcCacheConfig, MBeanExporter exporter) {
        StorageStripeMetadataSource stripeMetadataSource = new StorageStripeMetadataSource();
        if (orcCacheConfig.isStripeMetadataCacheEnabled()) {
            Cache footerCache = CacheBuilder.newBuilder().maximumWeight(orcCacheConfig.getStripeFooterCacheSize().toBytes()).weigher((id, footer) -> Math.toIntExact(((Slice)footer).getRetainedSize())).expireAfterAccess(orcCacheConfig.getStripeFooterCacheTtlSinceLastAccess().toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
            Cache streamCache = CacheBuilder.newBuilder().maximumWeight(orcCacheConfig.getStripeStreamCacheSize().toBytes()).weigher((id, stream) -> Math.toIntExact(((Slice)stream).getRetainedSize())).expireAfterAccess(orcCacheConfig.getStripeStreamCacheTtlSinceLastAccess().toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
            CacheStatsMBean footerCacheStatsMBean = new CacheStatsMBean(footerCache);
            CacheStatsMBean streamCacheStatsMBean = new CacheStatsMBean(streamCache);
            exporter.export(ObjectNames.generatedNameOf(CacheStatsMBean.class, (String)(this.connectorId + "_StripeFooter")), (Object)footerCacheStatsMBean);
            exporter.export(ObjectNames.generatedNameOf(CacheStatsMBean.class, (String)(this.connectorId + "_StripeStream")), (Object)streamCacheStatsMBean);
            Optional<Object> rowGroupIndexCache = Optional.empty();
            if (orcCacheConfig.isRowGroupIndexCacheEnabled()) {
                rowGroupIndexCache = Optional.of(CacheBuilder.newBuilder().maximumWeight(orcCacheConfig.getRowGroupIndexCacheSize().toBytes()).weigher((id, rowGroupIndices) -> Math.toIntExact(((List)rowGroupIndices).stream().mapToLong(RowGroupIndex::getRetainedSizeInBytes).sum())).expireAfterAccess(orcCacheConfig.getStripeStreamCacheTtlSinceLastAccess().toMillis(), TimeUnit.MILLISECONDS).recordStats().build());
                CacheStatsMBean rowGroupIndexCacheStatsMBean = new CacheStatsMBean((Cache)rowGroupIndexCache.get());
                exporter.export(ObjectNames.generatedNameOf(CacheStatsMBean.class, (String)(this.connectorId + "_StripeStreamRowGroupIndex")), (Object)rowGroupIndexCacheStatsMBean);
            }
            stripeMetadataSource = new CachingStripeMetadataSource((StripeMetadataSource)stripeMetadataSource, footerCache, streamCache, rowGroupIndexCache);
        }
        StripeMetadataSourceFactory factory = StripeMetadataSourceFactory.of((StripeMetadataSource)stripeMetadataSource);
        if (orcCacheConfig.isDwrfStripeCacheEnabled()) {
            factory = new DwrfAwareStripeMetadataSourceFactory(factory);
        }
        return factory;
    }

    @Singleton
    @Provides
    public ParquetMetadataSource createParquetMetadataSource(ParquetCacheConfig parquetCacheConfig, MBeanExporter exporter) {
        MetadataReader parquetMetadataSource = new MetadataReader();
        if (parquetCacheConfig.isMetadataCacheEnabled()) {
            Cache cache = CacheBuilder.newBuilder().maximumWeight(parquetCacheConfig.getMetadataCacheSize().toBytes()).weigher((id, metadata) -> ((ParquetFileMetadata)metadata).getMetadataSize()).expireAfterAccess(parquetCacheConfig.getMetadataCacheTtlSinceLastAccess().toMillis(), TimeUnit.MILLISECONDS).recordStats().build();
            CacheStatsMBean cacheStatsMBean = new CacheStatsMBean(cache);
            parquetMetadataSource = new CachingParquetMetadataSource(cache, (ParquetMetadataSource)parquetMetadataSource);
            exporter.export(ObjectNames.generatedNameOf(CacheStatsMBean.class, (String)(this.connectorId + "_ParquetMetadata")), (Object)cacheStatsMBean);
        }
        return parquetMetadataSource;
    }
}

