/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;

public final class HiveDecimalParser {
    private HiveDecimalParser() {
    }

    public static BigDecimal parseHiveDecimal(byte[] bytes, int start, int length, DecimalType columnType) {
        BigDecimal parsed = new BigDecimal(new String(bytes, start, length, StandardCharsets.UTF_8));
        if (parsed.scale() > columnType.getScale()) {
            parsed = parsed.setScale(columnType.getScale(), RoundingMode.HALF_UP);
        }
        return Decimals.rescale((BigDecimal)parsed, (DecimalType)columnType);
    }
}

