/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;

public class WrapperJobConf
extends JobConf {
    private final Configuration config;

    public WrapperJobConf(Configuration config) {
        this.config = Objects.requireNonNull(config, "config is null");
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.config.iterator();
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        return this.config.getClassByName(name);
    }

    public Class<?> getClassByNameOrNull(String name) {
        return this.config.getClassByNameOrNull(name);
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        return this.config.getClass(name, defaultValue);
    }

    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        return this.config.getClass(name, defaultValue, xface);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.config.setClassLoader(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.config.getClassLoader();
    }

    public void set(String name, String value) {
        this.config.set(name, value);
    }

    public String get(String name, String defaultValue) {
        return this.config.get(name, defaultValue);
    }

    public String get(String name) {
        if (this.config == null) {
            return super.get(name);
        }
        String result = this.config.get(name);
        return result != null ? result : super.get(name);
    }

    public void setBoolean(String name, boolean value) {
        this.config.setBoolean(name, value);
    }

    public void setBooleanIfUnset(String name, boolean value) {
        this.config.setBooleanIfUnset(name, value);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.config.getBoolean(name, defaultValue);
    }

    public void setInt(String name, int value) {
        this.config.setInt(name, value);
    }

    public int getInt(String name, int defaultValue) {
        return this.config.getInt(name, defaultValue);
    }

    public int[] getInts(String name) {
        return this.config.getInts(name);
    }

    public void setDouble(String name, double value) {
        this.config.setDouble(name, value);
    }

    public double getDouble(String name, double defaultValue) {
        return this.config.getDouble(name, defaultValue);
    }

    public void setFloat(String name, float value) {
        this.config.setFloat(name, value);
    }

    public float getFloat(String name, float defaultValue) {
        return this.config.getFloat(name, defaultValue);
    }

    public void setLong(String name, long value) {
        this.config.setLong(name, value);
    }

    public long getLong(String name, long defaultValue) {
        return this.config.getLong(name, defaultValue);
    }

    public synchronized void unset(String name) {
        this.config.unset(name);
    }

    public synchronized void setIfUnset(String name, String value) {
        this.config.setIfUnset(name, value);
    }

    public void readFields(DataInput in) throws IOException {
        this.config.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.config.write(out);
    }

    public void clear() {
        super.clear();
        this.config.clear();
    }
}

