/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveOrcAggregatedMemoryContext;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.DwrfKeyProvider;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcBatchRecordReader;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcPredicate;
import com.facebook.presto.orc.OrcReader;
import com.facebook.presto.orc.OrcReaderOptions;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.AbstractIterator;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TempFileReader
extends AbstractIterator<Page> {
    private final int columnCount;
    private final OrcBatchRecordReader reader;

    public TempFileReader(List<Type> types, OrcDataSource dataSource) {
        Objects.requireNonNull(types, "types is null");
        this.columnCount = types.size();
        try {
            OrcReader orcReader = new OrcReader(dataSource, OrcEncoding.ORC, (OrcFileTailSource)new StorageOrcFileTailSource(), (StripeMetadataSource)new StorageStripeMetadataSource(), (OrcAggregatedMemoryContext)new HiveOrcAggregatedMemoryContext(), new OrcReaderOptions(new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(16.0, DataSize.Unit.MEGABYTE), false), false, DwrfEncryptionProvider.NO_ENCRYPTION, DwrfKeyProvider.EMPTY, new RuntimeStats());
            HashMap<Integer, Type> includedColumns = new HashMap<Integer, Type>();
            for (int i = 0; i < types.size(); ++i) {
                includedColumns.put(i, types.get(i));
            }
            this.reader = orcReader.createBatchRecordReader(includedColumns, OrcPredicate.TRUE, DateTimeZone.UTC, (OrcAggregatedMemoryContext)new HiveOrcAggregatedMemoryContext(), 1);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to read temporary data");
        }
    }

    protected Page computeNext() {
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            int batchSize = this.reader.nextBatch();
            if (batchSize <= 0) {
                return (Page)this.endOfData();
            }
            Block[] blocks = new Block[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                blocks[i] = this.reader.readBlock(i).getLoadedBlock();
            }
            return new Page(batchSize, blocks);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to read temporary data");
        }
    }
}

