/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.event.client.EventClient;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.SortOrder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.HiveWriter;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.RecordFileWriter;
import com.facebook.presto.hive.SortingFileWriterFactory;
import com.facebook.presto.hive.WriteCompletedEvent;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.HivePageSinkMetadataProvider;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SortingColumn;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;

public class HiveWriterFactory {
    private static final int MAX_BUCKET_COUNT = 100000;
    private static final int BUCKET_NUMBER_PADDING = Integer.toString(99999).length();
    private static final Iterable<Pattern> BUCKET_PATTERNS = ImmutableList.of((Object)Pattern.compile("(0\\d+)_\\d+.*"), (Object)Pattern.compile("\\d{8}_\\d{6}_\\d{5}_[a-z0-9]{5}_bucket-(\\d+)(?:[-_.].*)?"));
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final String schemaName;
    private final String tableName;
    private final boolean isCreateTable;
    private final List<DataColumn> dataColumns;
    private final List<String> partitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final HiveCompressionCodec compressionCodec;
    private final Map<String, String> additionalTableParameters;
    private final LocationHandle locationHandle;
    private final LocationService locationService;
    private final String queryId;
    private final HivePageSinkMetadataProvider pageSinkMetadataProvider;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final JobConf conf;
    private final Table table;
    private final Optional<SortingFileWriterFactory> sortingFileWriterFactory;
    private final boolean immutablePartitions;
    private final HiveClientConfig.InsertExistingPartitionsBehavior insertExistingPartitionsBehavior;
    private final ConnectorSession session;
    private final OptionalInt bucketCount;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final Map<String, String> sessionProperties;
    private final HiveWriterStats hiveWriterStats;
    private final boolean writeToTempFile;
    private final Optional<EncryptionInformation> encryptionInformation;

    public HiveWriterFactory(Set<HiveFileWriterFactory> fileWriterFactories, String schemaName, String tableName, boolean isCreateTable, List<HiveColumnHandle> inputColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, HiveCompressionCodec compressionCodec, Map<String, String> additionalTableParameters, OptionalInt bucketCount, List<SortingColumn> sortedBy, LocationHandle locationHandle, LocationService locationService, String queryId, HivePageSinkMetadataProvider pageSinkMetadataProvider, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, PageSorter pageSorter, DataSize sortBufferSize, int maxOpenSortFiles, boolean immutablePartitions, ConnectorSession session, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties, HiveWriterStats hiveWriterStats, OrcFileWriterFactory orcFileWriterFactory, boolean commitRequired, Optional<EncryptionInformation> encryptionInformation) {
        Path writePath;
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.isCreateTable = isCreateTable;
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.additionalTableParameters = ImmutableMap.copyOf(Objects.requireNonNull(additionalTableParameters, "additionalTableParameters is null"));
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.pageSinkMetadataProvider = Objects.requireNonNull(pageSinkMetadataProvider, "pageSinkMetadataProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.immutablePartitions = immutablePartitions;
        this.insertExistingPartitionsBehavior = HiveSessionProperties.getInsertExistingPartitionsBehavior(session);
        if (immutablePartitions) {
            Preconditions.checkArgument((this.insertExistingPartitionsBehavior != HiveClientConfig.InsertExistingPartitionsBehavior.APPEND ? 1 : 0) != 0, (Object)"insertExistingPartitionsBehavior cannot be APPEND");
        }
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        ImmutableList.Builder partitionColumnNames = ImmutableList.builder();
        ImmutableList.Builder partitionColumnTypes = ImmutableList.builder();
        ImmutableList.Builder dataColumns = ImmutableList.builder();
        for (HiveColumnHandle column2 : inputColumns) {
            HiveType hiveType = column2.getHiveType();
            if (column2.isPartitionKey()) {
                partitionColumnNames.add((Object)column2.getName());
                partitionColumnTypes.add((Object)typeManager.getType(column2.getTypeSignature()));
                continue;
            }
            dataColumns.add((Object)new DataColumn(column2.getName(), hiveType));
        }
        this.partitionColumnNames = partitionColumnNames.build();
        this.partitionColumnTypes = partitionColumnTypes.build();
        this.dataColumns = dataColumns.build();
        if (isCreateTable) {
            this.table = null;
            LocationService.WriteInfo writeInfo = locationService.getQueryWriteInfo(locationHandle);
            Preconditions.checkArgument((writeInfo.getWriteMode() != LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY ? 1 : 0) != 0, (Object)"CREATE TABLE write mode cannot be DIRECT_TO_TARGET_EXISTING_DIRECTORY");
            writePath = writeInfo.getWritePath();
        } else {
            Optional table = pageSinkMetadataProvider.getTable();
            if (!table.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table %s.%s was dropped during insert", schemaName, tableName));
            }
            this.table = (Table)table.get();
            writePath = locationService.getQueryWriteInfo(locationHandle).getWritePath();
        }
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        if (bucketCount.isPresent()) {
            Preconditions.checkArgument((bucketCount.getAsInt() < 100000 ? 1 : 0) != 0, (Object)"bucketCount must be smaller than 100000");
        }
        this.session = Objects.requireNonNull(session, "session is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
        this.sessionProperties = (Map)hiveSessionProperties.getSessionProperties().stream().collect(ImmutableMap.toImmutableMap(PropertyMetadata::getName, entry -> {
            Object value = session.getProperty(entry.getName(), entry.getJavaType());
            return value == null ? "null" : value.toString();
        }));
        this.conf = ConfigurationUtils.configureCompression(hdfsEnvironment.getConfiguration(new HdfsContext(session, schemaName, tableName, locationHandle.getTargetPath().toString(), isCreateTable), writePath), compressionCodec);
        if (!sortedBy.isEmpty()) {
            List types = (List)this.dataColumns.stream().map(column -> column.getHiveType().getType(typeManager)).collect(ImmutableList.toImmutableList());
            HashMap<String, Integer> columnIndexes = new HashMap<String, Integer>();
            for (int i = 0; i < this.dataColumns.size(); ++i) {
                columnIndexes.put(this.dataColumns.get(i).getName(), i);
            }
            ArrayList<Integer> sortFields = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (SortingColumn column3 : sortedBy) {
                Integer index = (Integer)columnIndexes.get(column3.getColumnName());
                if (index == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Sorting column '%s' does not exist in table '%s.%s'", column3.getColumnName(), schemaName, tableName));
                }
                sortFields.add(index);
                sortOrders.add(column3.getOrder().getSortOrder());
            }
            this.sortingFileWriterFactory = Optional.of(new SortingFileWriterFactory(hdfsEnvironment, session, this.conf, types, sortFields, sortOrders, sortBufferSize, maxOpenSortFiles, pageSorter, orcFileWriterFactory, HiveSessionProperties.isSortedWriteToTempPathEnabled(session), HiveSessionProperties.getSortedWriteTempPathSubdirectoryCount(session)));
        } else {
            this.sortingFileWriterFactory = Optional.empty();
        }
        try {
            hdfsEnvironment.getFileSystem(session.getUser(), writePath, (Configuration)this.conf);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + writePath, (Throwable)e);
        }
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
        this.writeToTempFile = commitRequired;
        this.encryptionInformation = Objects.requireNonNull(encryptionInformation, "encryptionInformation is null");
    }

    public HiveWriter createWriter(Page partitionColumns, int position, OptionalInt bucketNumber) {
        if (this.bucketCount.isPresent()) {
            Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"Bucket not provided for bucketed table");
            Preconditions.checkArgument((bucketNumber.getAsInt() < this.bucketCount.getAsInt() ? 1 : 0) != 0, (String)"Bucket number %s must be less than bucket count %s", (Object)bucketNumber, (Object)this.bucketCount);
        } else {
            Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0, (Object)"Bucket number provided by for table that is not bucketed");
        }
        List partitionValues = MetastoreUtil.createPartitionValues(this.partitionColumnTypes, (Page)partitionColumns, (int)position);
        Optional<String> partitionName = !this.partitionColumnNames.isEmpty() ? Optional.of(FileUtils.makePartName(this.partitionColumnNames, (List)partitionValues)) : Optional.empty();
        WriterParameters writerParameters = this.getWriterParameters(partitionName, bucketNumber);
        Properties schema = writerParameters.getSchema();
        schema.putAll(this.additionalTableParameters);
        this.validateSchema(partitionName, writerParameters.getSchema());
        String extension = HiveWriterFactory.getFileExtension(writerParameters.getOutputStorageFormat(), this.compressionCodec);
        String targetFileName = bucketNumber.isPresent() ? (HiveSessionProperties.isFileRenamingEnabled(this.session) ? String.valueOf(bucketNumber.getAsInt()) : HiveWriterFactory.computeBucketedFileName(this.queryId, bucketNumber.getAsInt()) + extension) : this.queryId + "_" + UUID.randomUUID() + extension;
        String writeFileName = this.writeToTempFile ? ".tmp.presto." + this.queryId + "_" + UUID.randomUUID() + extension : targetFileName;
        Path path = new Path(writerParameters.getWriteInfo().getWritePath(), writeFileName);
        HiveFileWriter hiveFileWriter = null;
        for (HiveFileWriterFactory fileWriterFactory : this.fileWriterFactories) {
            Optional<HiveFileWriter> fileWriter = fileWriterFactory.createFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), writerParameters.getOutputStorageFormat(), schema, this.conf, this.session, this.encryptionInformation);
            if (!fileWriter.isPresent()) continue;
            hiveFileWriter = fileWriter.get();
            break;
        }
        if (hiveFileWriter == null) {
            hiveFileWriter = new RecordFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), writerParameters.getOutputStorageFormat(), schema, this.partitionStorageFormat.getEstimatedWriterSystemMemoryUsage(), this.conf, this.typeManager, this.session);
        }
        if (this.sortingFileWriterFactory.isPresent()) {
            hiveFileWriter = this.sortingFileWriterFactory.get().createSortingFileWriter(path, hiveFileWriter, bucketNumber.orElse(Math.abs(path.hashCode() % 1024)), writerParameters.getWriteInfo().getTempPath());
        }
        boolean writeTempData = this.locationHandle.getTableType() == LocationHandle.TableType.TEMPORARY || this.locationHandle.getTempPath().isPresent() || this.writeToTempFile;
        return new HiveWriter(hiveFileWriter, partitionName, writerParameters.getUpdateMode(), new PartitionUpdate.FileWriteInfo(writeFileName, targetFileName, Optional.empty()), writerParameters.getWriteInfo().getWritePath().toString(), writerParameters.getWriteInfo().getTargetPath().toString(), this.createCommitEventListener(path, partitionName, hiveFileWriter, writerParameters), this.hiveWriterStats, writeTempData);
    }

    private WriterParameters getWriterParameters(Optional<String> partitionName, OptionalInt bucketNumber) {
        if (this.table == null) {
            if (partitionName.isPresent()) {
                return this.getWriterParametersForNewPartitionedTable(partitionName.get());
            }
            return this.getWriterParametersForNewUnpartitionedTable();
        }
        if (!partitionName.isPresent()) {
            return this.getWriterParametersForExistingUnpartitionedTable(bucketNumber);
        }
        return this.getWriterParametersForExistingPartitionedTable(partitionName.get(), bucketNumber);
    }

    private WriterParameters getWriterParametersForNewUnpartitionedTable() {
        return new WriterParameters(PartitionUpdate.UpdateMode.NEW, HiveWriterFactory.createHiveSchema(this.dataColumns), this.locationService.getTableWriteInfo(this.locationHandle), StorageFormat.fromHiveStorageFormat((HiveStorageFormat)this.tableStorageFormat));
    }

    private WriterParameters getWriterParametersForNewPartitionedTable(String partitionName) {
        HdfsContext context;
        LocationService.WriteInfo writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, Optional.empty(), partitionName);
        if (!writeInfo.getWriteMode().isWritePathSameAsTargetPath() && MetastoreUtil.pathExists((HdfsContext)(context = new HdfsContext(this.session, this.schemaName, this.tableName, this.locationHandle.getTargetPath().toString(), true)), (HdfsEnvironment)this.hdfsEnvironment, (Path)writeInfo.getTargetPath())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for new partition '%s' of table '%s.%s' already exists: %s", partitionName, this.schemaName, this.tableName, writeInfo.getTargetPath()));
        }
        return new WriterParameters(PartitionUpdate.UpdateMode.NEW, HiveWriterFactory.createHiveSchema(this.dataColumns), writeInfo, StorageFormat.fromHiveStorageFormat((HiveStorageFormat)this.partitionStorageFormat));
    }

    private WriterParameters getWriterParametersForExistingUnpartitionedTable(OptionalInt bucketNumber) {
        if (!this.table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE)) {
            if (bucketNumber.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into bucketed unpartitioned Hive table");
            }
            if (this.immutablePartitions) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Unpartitioned Hive tables are immutable");
            }
        }
        return new WriterParameters(PartitionUpdate.UpdateMode.APPEND, MetastoreUtil.getHiveSchema((Table)this.table), this.locationService.getTableWriteInfo(this.locationHandle), StorageFormat.fromHiveStorageFormat((HiveStorageFormat)this.tableStorageFormat));
    }

    private WriterParameters getWriterParametersForExistingPartitionedTable(String partitionName, OptionalInt bucketNumber) {
        if (MetastoreUtil.isPrestoMaterializedView((Table)this.table)) {
            return this.getWriterParametersForOverwritePartition(partitionName);
        }
        switch (this.insertExistingPartitionsBehavior) {
            case APPEND: {
                return this.getWriterParametersForAppendPartition(partitionName, bucketNumber);
            }
            case OVERWRITE: {
                return this.getWriterParametersForOverwritePartition(partitionName);
            }
            case ERROR: {
                return this.getWriterParametersForImmutablePartition(partitionName);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported insert existing partitions behavior: %s", new Object[]{this.insertExistingPartitionsBehavior}));
    }

    private WriterParameters getWriterParametersForAppendPartition(String partitionName, OptionalInt bucketNumber) {
        Optional partition = this.pageSinkMetadataProvider.getPartition(MetastoreUtil.toPartitionValues((String)partitionName));
        if (!partition.isPresent()) {
            return new WriterParameters(PartitionUpdate.UpdateMode.NEW, MetastoreUtil.getHiveSchema((Table)this.table), this.locationService.getPartitionWriteInfo(this.locationHandle, Optional.empty(), partitionName), StorageFormat.fromHiveStorageFormat((HiveStorageFormat)this.partitionStorageFormat));
        }
        Preconditions.checkState((!this.immutablePartitions ? 1 : 0) != 0);
        if (bucketNumber.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into existing partition of bucketed Hive table: " + partitionName);
        }
        HiveWriterFactory.checkPartitionSchemeSameAsTableScheme(this.tableName, partitionName, this.table.getDataColumns(), ((Partition)partition.get()).getColumns());
        HiveWriteUtils.checkPartitionIsWritable(partitionName, (Partition)partition.get());
        return new WriterParameters(PartitionUpdate.UpdateMode.APPEND, MetastoreUtil.getHiveSchema((Partition)((Partition)partition.get()), (Table)this.table), this.locationService.getPartitionWriteInfo(this.locationHandle, partition, partitionName), ((Partition)partition.get()).getStorage().getStorageFormat());
    }

    private WriterParameters getWriterParametersForOverwritePartition(String partitionName) {
        LocationService.WriteInfo writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, Optional.empty(), partitionName);
        return new WriterParameters(PartitionUpdate.UpdateMode.OVERWRITE, MetastoreUtil.getHiveSchema((Table)this.table), writeInfo, StorageFormat.fromHiveStorageFormat((HiveStorageFormat)this.partitionStorageFormat));
    }

    private WriterParameters getWriterParametersForImmutablePartition(String partitionName) {
        Optional partition;
        LocationService.WriteInfo writerInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, Optional.empty(), partitionName);
        if ((writerInfo.getWriteMode() == LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY || HiveSessionProperties.isFailFastOnInsertIntoImmutablePartitionsEnabled(this.session)) && (partition = this.pageSinkMetadataProvider.getPartition(MetastoreUtil.toPartitionValues((String)partitionName))).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into an existing partition of Hive table: " + partitionName);
        }
        return new WriterParameters(PartitionUpdate.UpdateMode.NEW, MetastoreUtil.getHiveSchema((Table)this.table), writerInfo, StorageFormat.fromHiveStorageFormat((HiveStorageFormat)this.partitionStorageFormat));
    }

    private void validateSchema(Optional<String> partitionName, Properties schema) {
        List fileColumnNames = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)schema.getProperty("columns", ""));
        List fileColumnHiveTypes = HiveType.toHiveTypes((String)schema.getProperty("columns.types", ""));
        Map inputColumnMap = this.dataColumns.stream().collect(Collectors.toMap(DataColumn::getName, Function.identity()));
        Sets.SetView missingColumns = Sets.difference(inputColumnMap.keySet(), new HashSet(fileColumnNames));
        if (!missingColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table %s.%s does not have columns %s", schema, this.tableName, missingColumns));
        }
        if (fileColumnNames.size() != fileColumnHiveTypes.size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Partition '%s' in table '%s.%s' has mismatched metadata for column names and types", partitionName, this.schemaName, this.tableName));
        }
        for (int fileIndex = 0; fileIndex < fileColumnNames.size(); ++fileIndex) {
            HiveType inputHiveType;
            String columnName = (String)fileColumnNames.get(fileIndex);
            HiveType fileColumnHiveType = (HiveType)fileColumnHiveTypes.get(fileIndex);
            if (fileColumnHiveType.equals((Object)(inputHiveType = ((DataColumn)inputColumnMap.get(columnName)).getHiveType()))) continue;
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s.%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", columnName, this.schemaName, this.tableName, inputHiveType, partitionName, columnName, fileColumnHiveType));
        }
    }

    private Consumer<HiveWriter> createCommitEventListener(Path path, Optional<String> partitionName, HiveFileWriter hiveFileWriter, WriterParameters writerParameters) {
        return hiveWriter -> {
            Optional<Object> size;
            try {
                size = Optional.of(this.hdfsEnvironment.getFileSystem(this.session.getUser(), path, (Configuration)this.conf).getFileStatus(path).getLen());
            }
            catch (IOException | RuntimeException e) {
                size = Optional.empty();
            }
            this.eventClient.post((Object[])new WriteCompletedEvent[]{new WriteCompletedEvent(this.session.getQueryId(), path.toString(), this.schemaName, this.tableName, partitionName.orElse(null), writerParameters.getOutputStorageFormat().getOutputFormat(), hiveFileWriter.getClass().getName(), this.nodeManager.getCurrentNode().getVersion(), this.nodeManager.getCurrentNode().getHost(), this.session.getIdentity().getPrincipal().map(Principal::getName).orElse(null), this.nodeManager.getEnvironment(), this.sessionProperties, size.orElse(null), hiveWriter.getRowCount())});
        };
    }

    public boolean isCreateTable() {
        return this.isCreateTable;
    }

    public LocationHandle getLocationHandle() {
        return this.locationHandle;
    }

    public static String computeBucketedFileName(String queryId, int bucket) {
        String paddedBucket = Strings.padStart((String)Integer.toString(bucket), (int)BUCKET_NUMBER_PADDING, (char)'0');
        return String.format("0%s_0_%s", paddedBucket, queryId);
    }

    public static OptionalInt getBucketNumber(String fileName) {
        for (Pattern pattern : BUCKET_PATTERNS) {
            Matcher matcher = pattern.matcher(fileName);
            if (!matcher.matches()) continue;
            return OptionalInt.of(Integer.parseInt(matcher.group(1)));
        }
        if (fileName.matches("\\d+")) {
            return OptionalInt.of(Integer.parseInt(fileName));
        }
        return OptionalInt.empty();
    }

    public static String getFileExtension(StorageFormat storageFormat, HiveCompressionCodec compressionCodec) {
        if (compressionCodec == HiveCompressionCodec.NONE || !HiveIgnoreKeyTextOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return "";
        }
        if (!compressionCodec.getCodec().isPresent()) {
            return new DefaultCodec().getDefaultExtension();
        }
        try {
            return compressionCodec.getCodec().get().getConstructor(new Class[0]).newInstance(new Object[0]).getDefaultExtension();
        }
        catch (ReflectiveOperationException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Failed to load compression codec: " + compressionCodec.getCodec().get(), (Throwable)e);
        }
    }

    private static Properties createHiveSchema(List<DataColumn> dataColumns) {
        Properties schema = new Properties();
        schema.setProperty("columns", dataColumns.stream().map(DataColumn::getName).collect(Collectors.joining(",")));
        schema.setProperty("columns.types", dataColumns.stream().map(DataColumn::getHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
        return schema;
    }

    private static void checkPartitionSchemeSameAsTableScheme(String tableName, String partitionName, List<Column> tableColumns, List<Column> existingPartitionColumns) {
        for (int i = 0; i < Math.min(existingPartitionColumns.size(), tableColumns.size()); ++i) {
            HiveType partitionType;
            HiveType tableType = tableColumns.get(i).getType();
            if (tableType.equals((Object)(partitionType = existingPartitionColumns.get(i).getType()))) continue;
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("You are trying to write into an existing partition in a table. The table schema has changed since the creation of the partition. Inserting rows into such partition is not supported. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumns.get(i).getName(), tableName, tableType, partitionName, existingPartitionColumns.get(i).getName(), partitionType));
        }
    }

    private static class WriterParameters {
        private final PartitionUpdate.UpdateMode updateMode;
        private final Properties schema;
        private final LocationService.WriteInfo writeInfo;
        private final StorageFormat outputStorageFormat;

        private WriterParameters(PartitionUpdate.UpdateMode updateMode, Properties schema, LocationService.WriteInfo writeInfo, StorageFormat outputStorageFormat) {
            this.updateMode = Objects.requireNonNull(updateMode, "updateMode is null");
            this.schema = Objects.requireNonNull(schema, "schema is null");
            this.writeInfo = Objects.requireNonNull(writeInfo, "writeInfo is null");
            this.outputStorageFormat = Objects.requireNonNull(outputStorageFormat, "outputStorageFormat is null");
        }

        public PartitionUpdate.UpdateMode getUpdateMode() {
            return this.updateMode;
        }

        public Properties getSchema() {
            return this.schema;
        }

        public LocationService.WriteInfo getWriteInfo() {
            return this.writeInfo;
        }

        public StorageFormat getOutputStorageFormat() {
            return this.outputStorageFormat;
        }
    }

    private static class DataColumn {
        private final String name;
        private final HiveType hiveType;

        public DataColumn(String name, HiveType hiveType) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        }

        public String getName() {
            return this.name;
        }

        public HiveType getHiveType() {
            return this.hiveType;
        }
    }
}

