/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionResult;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hive.metastore.ProtectMode;
import org.joda.time.DateTimeZone;

public class HivePartitionManager {
    private final DateTimeZone timeZone;
    private final boolean assumeCanonicalPartitionKeys;
    private final TypeManager typeManager;
    private final int maxPartitionsPerScan;
    private final int domainCompactionThreshold;
    private final boolean partitionFilteringFromMetastoreEnabled;

    @Inject
    public HivePartitionManager(TypeManager typeManager, HiveClientConfig hiveClientConfig) {
        this(typeManager, hiveClientConfig.getDateTimeZone(), hiveClientConfig.isAssumeCanonicalPartitionKeys(), hiveClientConfig.getMaxPartitionsPerScan(), hiveClientConfig.getDomainCompactionThreshold(), hiveClientConfig.isPartitionFilteringFromMetastoreEnabled());
    }

    public HivePartitionManager(TypeManager typeManager, DateTimeZone timeZone, boolean assumeCanonicalPartitionKeys, int maxPartitionsPerScan, int domainCompactionThreshold, boolean partitionFilteringFromMetastoreEnabled) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.maxPartitionsPerScan = maxPartitionsPerScan;
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.partitionFilteringFromMetastoreEnabled = partitionFilteringFromMetastoreEnabled;
    }

    public Iterable<HivePartition> getPartitionsIterator(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, ConnectorSession session) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicateColumnHandles = constraint.getSummary();
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(session, metastore, tableName, HiveSessionProperties.isOfflineDataDebugModeEnabled(session));
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List partitionTypes = partitionColumns.stream().map(column -> this.typeManager.getType(column.getTypeSignature())).collect(Collectors.toList());
        Map<Column, Domain> effectivePredicate = this.createPartitionPredicates(metastore, session, (TupleDomain<ColumnHandle>)effectivePredicateColumnHandles, partitionColumns, this.assumeCanonicalPartitionKeys);
        if (partitionColumns.isEmpty()) {
            return ImmutableList.of((Object)new HivePartition(tableName));
        }
        return () -> {
            List<String> partitionNames = this.partitionFilteringFromMetastoreEnabled ? this.getFilteredPartitionNames(session, metastore, tableName, effectivePredicate) : this.getAllPartitionNames(session, metastore, tableName, constraint);
            return partitionNames.stream().map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionTypes, constraint)).filter(Optional::isPresent).map(Optional::get).iterator();
        };
    }

    private Map<Column, Domain> createPartitionPredicates(SemiTransactionalHiveMetastore metastore, ConnectorSession session, TupleDomain<ColumnHandle> effectivePredicateColumnHandles, List<HiveColumnHandle> partitionColumns, boolean assumeCanonicalPartitionKeys) {
        Optional domains = effectivePredicateColumnHandles.getDomains();
        if (domains.isPresent()) {
            Map columnHandleDomainMap = (Map)domains.get();
            ImmutableMap.Builder partitionPredicateBuilder = ImmutableMap.builder();
            MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), metastore.getColumnConverterProvider());
            for (HiveColumnHandle partitionColumn : partitionColumns) {
                Column key = new Column(partitionColumn.getName(), partitionColumn.getHiveType(), partitionColumn.getComment(), metastoreContext.getColumnConverter().getTypeMetadata(partitionColumn.getHiveType(), partitionColumn.getTypeSignature()));
                if (columnHandleDomainMap.containsKey(partitionColumn)) {
                    if (assumeCanonicalPartitionKeys) {
                        partitionPredicateBuilder.put((Object)key, columnHandleDomainMap.get(partitionColumn));
                        continue;
                    }
                    Type type = this.typeManager.getType(partitionColumn.getTypeSignature());
                    if (type instanceof VarcharType || type instanceof CharType) {
                        partitionPredicateBuilder.put((Object)key, columnHandleDomainMap.get(partitionColumn));
                        continue;
                    }
                    Domain allDomain = Domain.all((Type)this.typeManager.getType(partitionColumn.getTypeSignature()));
                    partitionPredicateBuilder.put((Object)key, (Object)allDomain);
                    continue;
                }
                Domain allDomain = Domain.all((Type)this.typeManager.getType(partitionColumn.getTypeSignature()));
                partitionPredicateBuilder.put((Object)key, (Object)allDomain);
            }
            return partitionPredicateBuilder.build();
        }
        return ImmutableMap.of();
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, Constraint<ColumnHandle> constraint, ConnectorSession session) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicate = constraint.getSummary();
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(session, metastore, tableName, HiveSessionProperties.isOfflineDataDebugModeEnabled(session));
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List<HivePartition> partitions = this.getPartitionsAsList(this.getPartitionsIterator(metastore, tableHandle, constraint, session).iterator());
        Optional<HiveBucketHandle> hiveBucketHandle = this.getBucketHandle(table, session, (TupleDomain<ColumnHandle>)effectivePredicate);
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = hiveBucketHandle.flatMap(value -> HiveBucketing.getHiveBucketFilter(table, (TupleDomain<ColumnHandle>)effectivePredicate));
        if (!this.queryUsesHiveBucketColumn((TupleDomain<ColumnHandle>)effectivePredicate) && hiveBucketHandle.isPresent() && this.queryAccessesTooManyBuckets(hiveBucketHandle.get(), bucketFilter, partitions, session)) {
            hiveBucketHandle = Optional.empty();
            bucketFilter = Optional.empty();
        }
        if (effectivePredicate.isNone()) {
            return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitions, (TupleDomain<? extends ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), hiveBucketHandle, Optional.empty());
        }
        TupleDomain compactEffectivePredicate = effectivePredicate.compact(this.domainCompactionThreshold);
        if (partitionColumns.isEmpty()) {
            return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitions, (TupleDomain<? extends ColumnHandle>)compactEffectivePredicate, (TupleDomain<ColumnHandle>)effectivePredicate, (TupleDomain<ColumnHandle>)TupleDomain.all(), hiveBucketHandle, bucketFilter);
        }
        TupleDomain remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(partitionColumns))));
        TupleDomain enforcedTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (com.google.common.base.Predicate)Predicates.in(partitionColumns)));
        return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitions, (TupleDomain<? extends ColumnHandle>)compactEffectivePredicate, (TupleDomain<ColumnHandle>)remainingTupleDomain, (TupleDomain<ColumnHandle>)enforcedTupleDomain, hiveBucketHandle, bucketFilter);
    }

    private Optional<HiveBucketHandle> getBucketHandle(Table table, ConnectorSession session, TupleDomain<ColumnHandle> effectivePredicate) {
        if (table.getTableType().equals((Object)PrestoTableType.TEMPORARY_TABLE)) {
            return HiveBucketing.getHiveBucketHandle(table);
        }
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(table);
        if (!hiveBucketHandle.isPresent() || HiveSessionProperties.shouldIgnoreTableBucketing(session)) {
            return Optional.empty();
        }
        if (this.queryUsesHiveBucketColumn(effectivePredicate)) {
            return hiveBucketHandle;
        }
        int requiredTableBucketCount = HiveSessionProperties.getMinBucketCountToNotIgnoreTableBucketing(session);
        if (hiveBucketHandle.get().getTableBucketCount() < requiredTableBucketCount) {
            return Optional.empty();
        }
        return hiveBucketHandle;
    }

    private boolean queryUsesHiveBucketColumn(TupleDomain<ColumnHandle> effectivePredicate) {
        if (!effectivePredicate.getDomains().isPresent()) {
            return false;
        }
        return ((Map)effectivePredicate.getDomains().get()).keySet().stream().anyMatch(key -> ((HiveColumnHandle)key).getName().equals("$bucket"));
    }

    private boolean queryAccessesTooManyBuckets(HiveBucketHandle handle, Optional<HiveBucketing.HiveBucketFilter> filter, List<HivePartition> partitions, ConnectorSession session) {
        int bucketsPerPartition = filter.map(hiveBucketFilter -> hiveBucketFilter.getBucketsToKeep().size()).orElseGet(handle::getReadBucketCount);
        return bucketsPerPartition * partitions.size() > HiveSessionProperties.getMaxBucketsForGroupedExecution(session);
    }

    private List<HivePartition> getPartitionsAsList(Iterator<HivePartition> partitionsIterator) {
        ImmutableList.Builder partitionList = ImmutableList.builder();
        int count = 0;
        while (partitionsIterator.hasNext()) {
            HivePartition partition = partitionsIterator.next();
            if (count == this.maxPartitionsPerScan) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_EXCEEDED_PARTITION_LIMIT, String.format("Query over table '%s' can potentially read more than %s partitions", partition.getTableName(), this.maxPartitionsPerScan));
            }
            partitionList.add((Object)partition);
            ++count;
        }
        return partitionList.build();
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, ConnectorTableHandle tableHandle, List<List<String>> partitionValuesList, ConnectorSession session) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.getTable(session, metastore, tableName, HiveSessionProperties.isOfflineDataDebugModeEnabled(session));
        List<HiveColumnHandle> partitionColumns = HiveUtil.getPartitionKeyColumnHandles(table);
        List partitionColumnTypes = (List)partitionColumns.stream().map(column -> this.typeManager.getType(column.getTypeSignature())).collect(ImmutableList.toImmutableList());
        List partitionList = (List)partitionValuesList.stream().map(partitionValues -> MetastoreUtil.makePartName((List)table.getPartitionColumns(), (List)partitionValues)).map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionColumnTypes, (Constraint<ColumnHandle>)Constraint.alwaysTrue())).map(partition -> (HivePartition)partition.orElseThrow(() -> new VerifyException("partition must exist"))).collect(ImmutableList.toImmutableList());
        Optional<HiveBucketHandle> bucketHandle = HiveSessionProperties.shouldIgnoreTableBucketing(session) ? Optional.empty() : HiveBucketing.getHiveBucketHandle(table);
        return new HivePartitionResult(partitionColumns, table.getDataColumns(), table.getParameters(), partitionList, (TupleDomain<? extends ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.none(), bucketHandle, Optional.empty());
    }

    private Optional<HivePartition> parseValuesAndFilterPartition(SchemaTableName tableName, String partitionId, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes, Constraint<ColumnHandle> constraint) {
        HivePartition partition = HivePartitionManager.parsePartition(tableName, partitionId, partitionColumns, partitionColumnTypes, this.timeZone);
        Map domains = (Map)constraint.getSummary().getDomains().get();
        for (HiveColumnHandle column : partitionColumns) {
            NullableValue value = partition.getKeys().get(column);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return Optional.empty();
        }
        if (constraint.predicate().isPresent() && !((Predicate)constraint.predicate().get()).test(partition.getKeys())) {
            return Optional.empty();
        }
        return Optional.of(partition);
    }

    private Table getTable(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, boolean offlineDataDebugModeEnabled) {
        Optional target = metastore.getTable(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), metastore.getColumnConverterProvider()), tableName.getSchemaName(), tableName.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(tableName);
        }
        Table table = (Table)target.get();
        if (!offlineDataDebugModeEnabled) {
            MetastoreUtil.verifyOnline((SchemaTableName)tableName, Optional.empty(), (ProtectMode)MetastoreUtil.getProtectMode((Table)table), (Map)table.getParameters());
        }
        return table;
    }

    private List<String> getFilteredPartitionNames(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, Map<Column, Domain> partitionPredicates) {
        if (partitionPredicates.isEmpty()) {
            return ImmutableList.of();
        }
        return (List)metastore.getPartitionNamesByFilter(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), metastore.getColumnConverterProvider()), tableName.getSchemaName(), tableName.getTableName(), partitionPredicates).orElseThrow(() -> new TableNotFoundException(tableName));
    }

    private List<String> getAllPartitionNames(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName tableName, Constraint<ColumnHandle> constraint) {
        if (constraint.getSummary().isNone()) {
            return ImmutableList.of();
        }
        return (List)metastore.getPartitionNames(new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), metastore.getColumnConverterProvider()), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
    }

    public static HivePartition parsePartition(SchemaTableName tableName, String partitionName, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes, DateTimeZone timeZone) {
        List partitionColumnNames = partitionColumns.stream().map(HiveColumnHandle::getName).collect(Collectors.toList());
        List partitionValues = MetastoreUtil.extractPartitionValues((String)partitionName, Optional.of(partitionColumnNames));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue(partitionName, (String)partitionValues.get(i), partitionColumnTypes.get(i), timeZone);
            builder.put((Object)column, (Object)parsedValue);
        }
        ImmutableMap values = builder.build();
        return new HivePartition(tableName, partitionName, (Map<ColumnHandle, NullableValue>)values);
    }
}

