/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.statistics;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.hive.HiveBasicStatistics;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.metastore.BooleanStatistics;
import com.facebook.presto.hive.metastore.DateStatistics;
import com.facebook.presto.hive.metastore.DecimalStatistics;
import com.facebook.presto.hive.metastore.DoubleStatistics;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.IntegerStatistics;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.statistics.HiveStatisticsProvider;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.DoubleRange;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;

public class MetastoreHiveStatisticsProvider
implements HiveStatisticsProvider {
    private static final Logger log = Logger.get(MetastoreHiveStatisticsProvider.class);
    private final PartitionsStatisticsProvider statisticsProvider;

    public MetastoreHiveStatisticsProvider(SemiTransactionalHiveMetastore metastore) {
        Objects.requireNonNull(metastore, "metastore is null");
        this.statisticsProvider = (session, table, hivePartitions) -> MetastoreHiveStatisticsProvider.getPartitionsStatistics(session, metastore, table, hivePartitions);
    }

    @VisibleForTesting
    MetastoreHiveStatisticsProvider(PartitionsStatisticsProvider statisticsProvider) {
        this.statisticsProvider = Objects.requireNonNull(statisticsProvider, "statisticsProvider is null");
    }

    private static Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession session, SemiTransactionalHiveMetastore metastore, SchemaTableName table, List<HivePartition> hivePartitions) {
        if (hivePartitions.isEmpty()) {
            return ImmutableMap.of();
        }
        boolean unpartitioned = hivePartitions.stream().anyMatch(partition -> partition.getPartitionId().equals("<UNPARTITIONED>"));
        MetastoreContext metastoreContext = new MetastoreContext(session.getIdentity(), session.getQueryId(), session.getClientInfo(), session.getSource(), MetastoreUtil.getMetastoreHeaders((ConnectorSession)session), MetastoreUtil.isUserDefinedTypeEncodingEnabled((ConnectorSession)session), metastore.getColumnConverterProvider());
        if (unpartitioned) {
            Preconditions.checkArgument((hivePartitions.size() == 1 ? 1 : 0) != 0, (Object)"expected only one hive partition");
            return ImmutableMap.of((Object)"<UNPARTITIONED>", (Object)metastore.getTableStatistics(metastoreContext, table.getSchemaName(), table.getTableName()));
        }
        Set partitionNames = (Set)hivePartitions.stream().map(HivePartition::getPartitionId).collect(ImmutableSet.toImmutableSet());
        return metastore.getPartitionStatistics(metastoreContext, table.getSchemaName(), table.getTableName(), partitionNames);
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, SchemaTableName table, Map<String, ColumnHandle> columns, Map<String, Type> columnTypes, List<HivePartition> partitions) {
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        if (partitions.isEmpty()) {
            return this.createZeroStatistics(columns, columnTypes);
        }
        int sampleSize = HiveSessionProperties.getPartitionStatisticsSampleSize(session);
        List<HivePartition> partitionsSample = MetastoreHiveStatisticsProvider.getPartitionsSample(partitions, sampleSize);
        try {
            Map<String, PartitionStatistics> statisticsSample = this.statisticsProvider.getPartitionsStatistics(session, table, partitionsSample);
            MetastoreHiveStatisticsProvider.validatePartitionStatistics(table, statisticsSample);
            return MetastoreHiveStatisticsProvider.getTableStatistics(columns, columnTypes, partitions, statisticsSample);
        }
        catch (PrestoException e) {
            if (e.getErrorCode().equals((Object)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS.toErrorCode()) && HiveSessionProperties.isIgnoreCorruptedStatistics(session)) {
                log.error((Throwable)e);
                return TableStatistics.empty();
            }
            throw e;
        }
    }

    private TableStatistics createZeroStatistics(Map<String, ColumnHandle> columns, Map<String, Type> columnTypes) {
        TableStatistics.Builder result = TableStatistics.builder();
        result.setRowCount(Estimate.of((double)0.0));
        result.setTotalSize(Estimate.of((double)0.0));
        columns.forEach((columnName, columnHandle) -> {
            Type columnType = (Type)columnTypes.get(columnName);
            Verify.verify((columnType != null ? 1 : 0) != 0, (String)"columnType is missing for column: %s", (Object)columnName);
            ColumnStatistics.Builder columnStatistics = ColumnStatistics.builder();
            columnStatistics.setNullsFraction(Estimate.of((double)0.0));
            columnStatistics.setDistinctValuesCount(Estimate.of((double)0.0));
            if (MetastoreHiveStatisticsProvider.hasDataSize(columnType)) {
                columnStatistics.setDataSize(Estimate.of((double)0.0));
            }
            result.setColumnStatistics(columnHandle, columnStatistics.build());
        });
        return result.build();
    }

    @VisibleForTesting
    static List<HivePartition> getPartitionsSample(List<HivePartition> partitions, int sampleSize) {
        Preconditions.checkArgument((sampleSize > 0 ? 1 : 0) != 0, (Object)"sampleSize is expected to be greater than zero");
        if (partitions.size() <= sampleSize) {
            return partitions;
        }
        ArrayList<HivePartition> result = new ArrayList<HivePartition>();
        int samplesLeft = sampleSize;
        HivePartition min = partitions.get(0);
        HivePartition max = partitions.get(0);
        for (HivePartition partition2 : partitions) {
            if (partition2.getPartitionId().compareTo(min.getPartitionId()) < 0) {
                min = partition2;
                continue;
            }
            if (partition2.getPartitionId().compareTo(max.getPartitionId()) <= 0) continue;
            max = partition2;
        }
        result.add(min);
        if (--samplesLeft > 0) {
            result.add(max);
            --samplesLeft;
        }
        if (samplesLeft > 0) {
            HashFunction hashFunction = Hashing.murmur3_128();
            Comparator<Map.Entry> hashComparator = Comparator.comparing(Map.Entry::getValue).thenComparing(entry -> ((HivePartition)entry.getKey()).getPartitionId());
            partitions.stream().filter(partition -> !result.contains(partition)).map(partition -> Maps.immutableEntry((Object)partition, (Object)hashFunction.hashUnencodedChars((CharSequence)partition.getPartitionId()).asLong())).sorted(hashComparator).limit(samplesLeft).forEachOrdered(entry -> result.add((HivePartition)entry.getKey()));
        }
        return Collections.unmodifiableList(result);
    }

    @VisibleForTesting
    static void validatePartitionStatistics(SchemaTableName table, Map<String, PartitionStatistics> partitionStatistics) {
        partitionStatistics.forEach((partition, statistics) -> {
            HiveBasicStatistics basicStatistics = statistics.getBasicStatistics();
            OptionalLong rowCount = basicStatistics.getRowCount();
            rowCount.ifPresent(count -> MetastoreHiveStatisticsProvider.checkStatistics(count >= 0L, table, partition, "rowCount must be greater than or equal to zero: %s", count));
            basicStatistics.getFileCount().ifPresent(count -> MetastoreHiveStatisticsProvider.checkStatistics(count >= 0L, table, partition, "fileCount must be greater than or equal to zero: %s", count));
            basicStatistics.getInMemoryDataSizeInBytes().ifPresent(size -> MetastoreHiveStatisticsProvider.checkStatistics(size >= 0L, table, partition, "inMemoryDataSizeInBytes must be greater than or equal to zero: %s", size));
            basicStatistics.getOnDiskDataSizeInBytes().ifPresent(size -> MetastoreHiveStatisticsProvider.checkStatistics(size >= 0L, table, partition, "onDiskDataSizeInBytes must be greater than or equal to zero: %s", size));
            statistics.getColumnStatistics().forEach((column, columnStatistics) -> MetastoreHiveStatisticsProvider.validateColumnStatistics(table, partition, column, rowCount, columnStatistics));
        });
    }

    private static void validateColumnStatistics(SchemaTableName table, String partition, String column, OptionalLong rowCount, HiveColumnStatistics columnStatistics) {
        columnStatistics.getMaxValueSizeInBytes().ifPresent(maxValueSizeInBytes -> MetastoreHiveStatisticsProvider.checkStatistics(maxValueSizeInBytes >= 0L, table, partition, column, "maxValueSizeInBytes must be greater than or equal to zero: %s", maxValueSizeInBytes));
        columnStatistics.getTotalSizeInBytes().ifPresent(totalSizeInBytes -> MetastoreHiveStatisticsProvider.checkStatistics(totalSizeInBytes >= 0L, table, partition, column, "totalSizeInBytes must be greater than or equal to zero: %s", totalSizeInBytes));
        columnStatistics.getNullsCount().ifPresent(nullsCount -> {
            MetastoreHiveStatisticsProvider.checkStatistics(nullsCount >= 0L, table, partition, column, "nullsCount must be greater than or equal to zero: %s", nullsCount);
            if (rowCount.isPresent()) {
                MetastoreHiveStatisticsProvider.checkStatistics(nullsCount <= rowCount.getAsLong(), table, partition, column, "nullsCount must be less than or equal to rowCount. nullsCount: %s. rowCount: %s.", nullsCount, rowCount.getAsLong());
            }
        });
        columnStatistics.getDistinctValuesCount().ifPresent(distinctValuesCount -> {
            MetastoreHiveStatisticsProvider.checkStatistics(distinctValuesCount >= 0L, table, partition, column, "distinctValuesCount must be greater than or equal to zero: %s", distinctValuesCount);
            if (rowCount.isPresent()) {
                MetastoreHiveStatisticsProvider.checkStatistics(distinctValuesCount <= rowCount.getAsLong(), table, partition, column, "distinctValuesCount must be less than or equal to rowCount. distinctValuesCount: %s. rowCount: %s.", distinctValuesCount, rowCount.getAsLong());
            }
            if (rowCount.isPresent() && columnStatistics.getNullsCount().isPresent()) {
                long nonNullsCount = rowCount.getAsLong() - columnStatistics.getNullsCount().getAsLong();
                MetastoreHiveStatisticsProvider.checkStatistics(distinctValuesCount <= nonNullsCount, table, partition, column, "distinctValuesCount must be less than or equal to nonNullsCount. distinctValuesCount: %s. nonNullsCount: %s.", distinctValuesCount, nonNullsCount);
            }
        });
        columnStatistics.getIntegerStatistics().ifPresent(integerStatistics -> {
            OptionalLong min = integerStatistics.getMin();
            OptionalLong max = integerStatistics.getMax();
            if (min.isPresent() && max.isPresent()) {
                MetastoreHiveStatisticsProvider.checkStatistics(min.getAsLong() <= max.getAsLong(), table, partition, column, "integerStatistics.min must be less than or equal to integerStatistics.max. integerStatistics.min: %s. integerStatistics.max: %s.", min.getAsLong(), max.getAsLong());
            }
        });
        columnStatistics.getDoubleStatistics().ifPresent(doubleStatistics -> {
            OptionalDouble min = doubleStatistics.getMin();
            OptionalDouble max = doubleStatistics.getMax();
            if (min.isPresent() && max.isPresent() && !Double.isNaN(min.getAsDouble()) && !Double.isNaN(max.getAsDouble())) {
                MetastoreHiveStatisticsProvider.checkStatistics(min.getAsDouble() <= max.getAsDouble(), table, partition, column, "doubleStatistics.min must be less than or equal to doubleStatistics.max. doubleStatistics.min: %s. doubleStatistics.max: %s.", min.getAsDouble(), max.getAsDouble());
            }
        });
        columnStatistics.getDecimalStatistics().ifPresent(decimalStatistics -> {
            Optional min = decimalStatistics.getMin();
            Optional max = decimalStatistics.getMax();
            if (min.isPresent() && max.isPresent()) {
                MetastoreHiveStatisticsProvider.checkStatistics(((BigDecimal)min.get()).compareTo((BigDecimal)max.get()) <= 0, table, partition, column, "decimalStatistics.min must be less than or equal to decimalStatistics.max. decimalStatistics.min: %s. decimalStatistics.max: %s.", min.get(), max.get());
            }
        });
        columnStatistics.getDateStatistics().ifPresent(dateStatistics -> {
            Optional min = dateStatistics.getMin();
            Optional max = dateStatistics.getMax();
            if (min.isPresent() && max.isPresent()) {
                MetastoreHiveStatisticsProvider.checkStatistics(((LocalDate)min.get()).compareTo((ChronoLocalDate)max.get()) <= 0, table, partition, column, "dateStatistics.min must be less than or equal to dateStatistics.max. dateStatistics.min: %s. dateStatistics.max: %s.", min.get(), max.get());
            }
        });
        columnStatistics.getBooleanStatistics().ifPresent(booleanStatistics -> {
            OptionalLong falseCount = booleanStatistics.getFalseCount();
            OptionalLong trueCount = booleanStatistics.getTrueCount();
            falseCount.ifPresent(count -> MetastoreHiveStatisticsProvider.checkStatistics(count >= 0L, table, partition, column, "falseCount must be greater than or equal to zero: %s", count));
            trueCount.ifPresent(count -> MetastoreHiveStatisticsProvider.checkStatistics(count >= 0L, table, partition, column, "trueCount must be greater than or equal to zero: %s", count));
            if (rowCount.isPresent() && falseCount.isPresent()) {
                MetastoreHiveStatisticsProvider.checkStatistics(falseCount.getAsLong() <= rowCount.getAsLong(), table, partition, column, "booleanStatistics.falseCount must be less than or equal to rowCount. booleanStatistics.falseCount: %s. rowCount: %s.", falseCount.getAsLong(), rowCount.getAsLong());
            }
            if (rowCount.isPresent() && trueCount.isPresent()) {
                MetastoreHiveStatisticsProvider.checkStatistics(trueCount.getAsLong() <= rowCount.getAsLong(), table, partition, column, "booleanStatistics.trueCount must be less than or equal to rowCount. booleanStatistics.trueCount: %s. rowCount: %s.", trueCount.getAsLong(), rowCount.getAsLong());
            }
        });
    }

    private static void checkStatistics(boolean expression, SchemaTableName table, String partition, String column, String message, Object ... args) {
        if (!expression) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS, String.format("Corrupted partition statistics (Table: %s Partition: [%s] Column: %s): %s", table, partition, column, String.format(message, args)));
        }
    }

    private static void checkStatistics(boolean expression, SchemaTableName table, String partition, String message, Object ... args) {
        if (!expression) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CORRUPTED_COLUMN_STATISTICS, String.format("Corrupted partition statistics (Table: %s Partition: [%s]): %s", table, partition, String.format(message, args)));
        }
    }

    private static TableStatistics getTableStatistics(Map<String, ColumnHandle> columns, Map<String, Type> columnTypes, List<HivePartition> partitions, Map<String, PartitionStatistics> statistics) {
        if (statistics.isEmpty()) {
            return TableStatistics.empty();
        }
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"partitions is empty");
        OptionalDouble optionalAverageRowsPerPartition = MetastoreHiveStatisticsProvider.calculateAverageRowsPerPartition(statistics.values());
        if (!optionalAverageRowsPerPartition.isPresent()) {
            return TableStatistics.empty();
        }
        double averageRowsPerPartition = optionalAverageRowsPerPartition.getAsDouble();
        Verify.verify((averageRowsPerPartition >= 0.0 ? 1 : 0) != 0, (String)"averageRowsPerPartition must be greater than or equal to zero", (Object[])new Object[0]);
        int queriedPartitionsCount = partitions.size();
        double rowCount = averageRowsPerPartition * (double)queriedPartitionsCount;
        TableStatistics.Builder result = TableStatistics.builder();
        result.setRowCount(Estimate.of((double)rowCount));
        OptionalDouble optionalAverageSizePerPartition = MetastoreHiveStatisticsProvider.calculateAverageSizePerPartition(statistics.values());
        if (optionalAverageSizePerPartition.isPresent()) {
            double averageSizePerPartition = optionalAverageSizePerPartition.getAsDouble();
            Verify.verify((averageSizePerPartition >= 0.0 ? 1 : 0) != 0, (String)"averageSizePerPartition must be greater than or equal to zero: %s", (Object)averageSizePerPartition);
            double totalSize = averageSizePerPartition * (double)queriedPartitionsCount;
            result.setTotalSize(Estimate.of((double)totalSize));
        }
        for (Map.Entry<String, ColumnHandle> column : columns.entrySet()) {
            String columnName = column.getKey();
            HiveColumnHandle columnHandle = (HiveColumnHandle)column.getValue();
            Type columnType = columnTypes.get(columnName);
            ColumnStatistics columnStatistics = columnHandle.isPartitionKey() ? MetastoreHiveStatisticsProvider.createPartitionColumnStatistics(columnHandle, columnType, partitions, statistics, averageRowsPerPartition, rowCount) : MetastoreHiveStatisticsProvider.createDataColumnStatistics(columnName, columnType, rowCount, statistics.values());
            result.setColumnStatistics((ColumnHandle)columnHandle, columnStatistics);
        }
        return result.build();
    }

    @VisibleForTesting
    static OptionalDouble calculateAverageRowsPerPartition(Collection<PartitionStatistics> statistics) {
        return statistics.stream().map(PartitionStatistics::getBasicStatistics).map(HiveBasicStatistics::getRowCount).filter(OptionalLong::isPresent).mapToLong(OptionalLong::getAsLong).peek(count -> Verify.verify((count >= 0L ? 1 : 0) != 0, (String)"count must be greater than or equal to zero", (Object[])new Object[0])).average();
    }

    @VisibleForTesting
    static OptionalDouble calculateAverageSizePerPartition(Collection<PartitionStatistics> statistics) {
        return statistics.stream().map(PartitionStatistics::getBasicStatistics).map(HiveBasicStatistics::getInMemoryDataSizeInBytes).filter(OptionalLong::isPresent).mapToLong(OptionalLong::getAsLong).peek(size -> Verify.verify((size >= 0L ? 1 : 0) != 0, (String)"size must be greater than or equal to zero", (Object[])new Object[0])).average();
    }

    private static ColumnStatistics createPartitionColumnStatistics(HiveColumnHandle column, Type type, List<HivePartition> partitions, Map<String, PartitionStatistics> statistics, double averageRowsPerPartition, double rowCount) {
        List nonEmptyPartitions = (List)partitions.stream().filter(partition -> MetastoreHiveStatisticsProvider.getPartitionRowCount(partition.getPartitionId(), statistics).orElse(averageRowsPerPartition) != 0.0).collect(ImmutableList.toImmutableList());
        return ColumnStatistics.builder().setDistinctValuesCount(Estimate.of((double)MetastoreHiveStatisticsProvider.calculateDistinctPartitionKeys(column, nonEmptyPartitions))).setNullsFraction(Estimate.of((double)MetastoreHiveStatisticsProvider.calculateNullsFractionForPartitioningKey(column, partitions, statistics, averageRowsPerPartition, rowCount))).setRange(MetastoreHiveStatisticsProvider.calculateRangeForPartitioningKey(column, type, nonEmptyPartitions)).setDataSize(MetastoreHiveStatisticsProvider.calculateDataSizeForPartitioningKey(column, type, partitions, statistics, averageRowsPerPartition)).build();
    }

    @VisibleForTesting
    static long calculateDistinctPartitionKeys(HiveColumnHandle column, List<HivePartition> partitions) {
        return partitions.stream().map(partition -> partition.getKeys().get(column)).filter(value -> !value.isNull()).distinct().count();
    }

    @VisibleForTesting
    static double calculateNullsFractionForPartitioningKey(HiveColumnHandle column, List<HivePartition> partitions, Map<String, PartitionStatistics> statistics, double averageRowsPerPartition, double rowCount) {
        if (rowCount == 0.0) {
            return 0.0;
        }
        double estimatedNullsCount = partitions.stream().filter(partition -> partition.getKeys().get(column).isNull()).map(HivePartition::getPartitionId).mapToDouble(partitionName -> MetastoreHiveStatisticsProvider.getPartitionRowCount(partitionName, statistics).orElse(averageRowsPerPartition)).sum();
        return MetastoreHiveStatisticsProvider.normalizeFraction(estimatedNullsCount / rowCount);
    }

    private static double normalizeFraction(double fraction) {
        Preconditions.checkArgument((!Double.isNaN(fraction) ? 1 : 0) != 0, (Object)"fraction is NaN");
        Preconditions.checkArgument((boolean)Double.isFinite(fraction), (Object)"fraction must be finite");
        if (fraction < 0.0) {
            return 0.0;
        }
        if (fraction > 1.0) {
            return 1.0;
        }
        return fraction;
    }

    @VisibleForTesting
    static Estimate calculateDataSizeForPartitioningKey(HiveColumnHandle column, Type type, List<HivePartition> partitions, Map<String, PartitionStatistics> statistics, double averageRowsPerPartition) {
        if (!MetastoreHiveStatisticsProvider.hasDataSize(type)) {
            return Estimate.unknown();
        }
        double dataSize = 0.0;
        for (HivePartition partition : partitions) {
            int length = MetastoreHiveStatisticsProvider.getSize(partition.getKeys().get(column));
            double rowCount = MetastoreHiveStatisticsProvider.getPartitionRowCount(partition.getPartitionId(), statistics).orElse(averageRowsPerPartition);
            dataSize += (double)length * rowCount;
        }
        return Estimate.of((double)dataSize);
    }

    private static boolean hasDataSize(Type type) {
        return Varchars.isVarcharType((Type)type) || Chars.isCharType((Type)type);
    }

    private static int getSize(NullableValue nullableValue) {
        if (nullableValue.isNull()) {
            return 0;
        }
        Object value = nullableValue.getValue();
        Preconditions.checkArgument((boolean)(value instanceof Slice), (Object)"value is expected to be of Slice type");
        return ((Slice)value).length();
    }

    private static OptionalDouble getPartitionRowCount(String partitionName, Map<String, PartitionStatistics> statistics) {
        PartitionStatistics partitionStatistics = statistics.get(partitionName);
        if (partitionStatistics == null) {
            return OptionalDouble.empty();
        }
        OptionalLong rowCount = partitionStatistics.getBasicStatistics().getRowCount();
        if (rowCount.isPresent()) {
            Verify.verify((rowCount.getAsLong() >= 0L ? 1 : 0) != 0, (String)"rowCount must be greater than or equal to zero", (Object[])new Object[0]);
            return OptionalDouble.of(rowCount.getAsLong());
        }
        return OptionalDouble.empty();
    }

    @VisibleForTesting
    static Optional<DoubleRange> calculateRangeForPartitioningKey(HiveColumnHandle column, Type type, List<HivePartition> partitions) {
        if (!MetastoreHiveStatisticsProvider.isRangeSupported(type)) {
            return Optional.empty();
        }
        List values = (List)partitions.stream().map(HivePartition::getKeys).map(keys -> (NullableValue)keys.get(column)).filter(value -> !value.isNull()).map(NullableValue::getValue).map(value -> MetastoreHiveStatisticsProvider.convertPartitionValueToDouble(type, value)).collect(ImmutableList.toImmutableList());
        if (values.isEmpty()) {
            return Optional.empty();
        }
        double min = (Double)values.get(0);
        double max = (Double)values.get(0);
        for (Double value2 : values) {
            if (value2 > max) {
                max = value2;
            }
            if (!(value2 < min)) continue;
            min = value2;
        }
        return Optional.of(new DoubleRange(min, max));
    }

    @VisibleForTesting
    static double convertPartitionValueToDouble(Type type, Object value) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            return ((Long)value).longValue();
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return (Double)value;
        }
        if (type.equals(RealType.REAL)) {
            return Float.intBitsToFloat(((Long)value).intValue());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (Decimals.isShortDecimal((Type)decimalType)) {
                return Double.parseDouble(Decimals.toString((long)((Long)value), (int)decimalType.getScale()));
            }
            if (Decimals.isLongDecimal((Type)decimalType)) {
                return Double.parseDouble(Decimals.toString((Slice)((Slice)value), (int)decimalType.getScale()));
            }
            throw new IllegalArgumentException("Unexpected decimal type: " + decimalType);
        }
        if (type.equals(DateType.DATE)) {
            return ((Long)value).longValue();
        }
        throw new IllegalArgumentException("Unexpected type: " + type);
    }

    @VisibleForTesting
    static ColumnStatistics createDataColumnStatistics(String column, Type type, double rowsCount, Collection<PartitionStatistics> partitionStatistics) {
        List columnStatistics = (List)partitionStatistics.stream().map(PartitionStatistics::getColumnStatistics).map(statistics -> (HiveColumnStatistics)statistics.get(column)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (columnStatistics.isEmpty()) {
            return ColumnStatistics.empty();
        }
        return ColumnStatistics.builder().setDistinctValuesCount(MetastoreHiveStatisticsProvider.calculateDistinctValuesCount(columnStatistics)).setNullsFraction(MetastoreHiveStatisticsProvider.calculateNullsFraction(column, partitionStatistics)).setDataSize(MetastoreHiveStatisticsProvider.calculateDataSize(column, partitionStatistics, rowsCount)).setRange(MetastoreHiveStatisticsProvider.calculateRange(type, columnStatistics)).build();
    }

    @VisibleForTesting
    static Estimate calculateDistinctValuesCount(List<HiveColumnStatistics> columnStatistics) {
        return columnStatistics.stream().map(MetastoreHiveStatisticsProvider::getDistinctValuesCount).filter(OptionalLong::isPresent).map(OptionalLong::getAsLong).peek(distinctValuesCount -> Verify.verify((distinctValuesCount >= 0L ? 1 : 0) != 0, (String)"distinctValuesCount must be greater than or equal to zero", (Object[])new Object[0])).max(Long::compare).map(Estimate::of).orElse(Estimate.unknown());
    }

    private static OptionalLong getDistinctValuesCount(HiveColumnStatistics statistics) {
        if (statistics.getBooleanStatistics().isPresent() && ((BooleanStatistics)statistics.getBooleanStatistics().get()).getFalseCount().isPresent() && ((BooleanStatistics)statistics.getBooleanStatistics().get()).getTrueCount().isPresent()) {
            long falseCount = ((BooleanStatistics)statistics.getBooleanStatistics().get()).getFalseCount().getAsLong();
            long trueCount = ((BooleanStatistics)statistics.getBooleanStatistics().get()).getTrueCount().getAsLong();
            return OptionalLong.of((falseCount > 0L ? 1 : 0) + (trueCount > 0L ? 1 : 0));
        }
        if (statistics.getDistinctValuesCount().isPresent()) {
            return statistics.getDistinctValuesCount();
        }
        return OptionalLong.empty();
    }

    @VisibleForTesting
    static Estimate calculateNullsFraction(String column, Collection<PartitionStatistics> partitionStatistics) {
        List statisticsWithKnownRowCountAndNullsCount = (List)partitionStatistics.stream().filter(statistics -> {
            if (!statistics.getBasicStatistics().getRowCount().isPresent()) {
                return false;
            }
            HiveColumnStatistics columnStatistics = (HiveColumnStatistics)statistics.getColumnStatistics().get(column);
            if (columnStatistics == null) {
                return false;
            }
            return columnStatistics.getNullsCount().isPresent();
        }).collect(ImmutableList.toImmutableList());
        if (statisticsWithKnownRowCountAndNullsCount.isEmpty()) {
            return Estimate.unknown();
        }
        long totalNullsCount = 0L;
        long totalRowCount = 0L;
        for (PartitionStatistics statistics2 : statisticsWithKnownRowCountAndNullsCount) {
            long rowCount = statistics2.getBasicStatistics().getRowCount().orElseThrow(() -> new VerifyException("rowCount is not present"));
            Verify.verify((rowCount >= 0L ? 1 : 0) != 0, (String)"rowCount must be greater than or equal to zero", (Object[])new Object[0]);
            HiveColumnStatistics columnStatistics = (HiveColumnStatistics)statistics2.getColumnStatistics().get(column);
            Verify.verify((columnStatistics != null ? 1 : 0) != 0, (String)"columnStatistics is null", (Object[])new Object[0]);
            long nullsCount = columnStatistics.getNullsCount().orElseThrow(() -> new VerifyException("nullsCount is not present"));
            Verify.verify((nullsCount >= 0L ? 1 : 0) != 0, (String)"nullsCount must be greater than or equal to zero", (Object[])new Object[0]);
            Verify.verify((nullsCount <= rowCount ? 1 : 0) != 0, (String)"nullsCount must be less than or equal to rowCount. nullsCount: %s. rowCount: %s.", (long)nullsCount, (long)rowCount);
            totalNullsCount += nullsCount;
            totalRowCount += rowCount;
        }
        if (totalRowCount == 0L) {
            return Estimate.zero();
        }
        Verify.verify((totalNullsCount <= totalRowCount ? 1 : 0) != 0, (String)"totalNullsCount must be less than or equal to totalRowCount. totalNullsCount: %s. totalRowCount: %s.", (long)totalNullsCount, (long)totalRowCount);
        return Estimate.of((double)((double)totalNullsCount / (double)totalRowCount));
    }

    @VisibleForTesting
    static Estimate calculateDataSize(String column, Collection<PartitionStatistics> partitionStatistics, double totalRowCount) {
        List statisticsWithKnownRowCountAndDataSize = (List)partitionStatistics.stream().filter(statistics -> {
            if (!statistics.getBasicStatistics().getRowCount().isPresent()) {
                return false;
            }
            HiveColumnStatistics columnStatistics = (HiveColumnStatistics)statistics.getColumnStatistics().get(column);
            if (columnStatistics == null) {
                return false;
            }
            return columnStatistics.getTotalSizeInBytes().isPresent();
        }).collect(ImmutableList.toImmutableList());
        if (statisticsWithKnownRowCountAndDataSize.isEmpty()) {
            return Estimate.unknown();
        }
        long knownRowCount = 0L;
        long knownDataSize = 0L;
        for (PartitionStatistics statistics2 : statisticsWithKnownRowCountAndDataSize) {
            long rowCount = statistics2.getBasicStatistics().getRowCount().orElseThrow(() -> new VerifyException("rowCount is not present"));
            Verify.verify((rowCount >= 0L ? 1 : 0) != 0, (String)"rowCount must be greater than or equal to zero", (Object[])new Object[0]);
            HiveColumnStatistics columnStatistics = (HiveColumnStatistics)statistics2.getColumnStatistics().get(column);
            Verify.verify((columnStatistics != null ? 1 : 0) != 0, (String)"columnStatistics is null", (Object[])new Object[0]);
            long dataSize = columnStatistics.getTotalSizeInBytes().orElseThrow(() -> new VerifyException("totalSizeInBytes is not present"));
            Verify.verify((dataSize >= 0L ? 1 : 0) != 0, (String)"dataSize must be greater than or equal to zero", (Object[])new Object[0]);
            knownRowCount += rowCount;
            knownDataSize += dataSize;
        }
        if (totalRowCount == 0.0) {
            return Estimate.zero();
        }
        if (knownRowCount == 0L) {
            return Estimate.unknown();
        }
        double averageValueDataSizeInBytes = (double)knownDataSize / (double)knownRowCount;
        return Estimate.of((double)(averageValueDataSizeInBytes * totalRowCount));
    }

    @VisibleForTesting
    static Optional<DoubleRange> calculateRange(Type type, List<HiveColumnStatistics> columnStatistics) {
        if (!MetastoreHiveStatisticsProvider.isRangeSupported(type)) {
            return Optional.empty();
        }
        return columnStatistics.stream().map(statistics -> MetastoreHiveStatisticsProvider.createRange(type, statistics)).filter(Optional::isPresent).map(Optional::get).reduce(DoubleRange::union);
    }

    private static boolean isRangeSupported(Type type) {
        return type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(RealType.REAL) || type.equals(DoubleType.DOUBLE) || type.equals(DateType.DATE) || type instanceof DecimalType;
    }

    private static Optional<DoubleRange> createRange(Type type, HiveColumnStatistics statistics) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            return statistics.getIntegerStatistics().flatMap(integerStatistics -> MetastoreHiveStatisticsProvider.createIntegerRange(type, integerStatistics));
        }
        if (type.equals(DoubleType.DOUBLE) || type.equals(RealType.REAL)) {
            return statistics.getDoubleStatistics().flatMap(MetastoreHiveStatisticsProvider::createDoubleRange);
        }
        if (type.equals(DateType.DATE)) {
            return statistics.getDateStatistics().flatMap(MetastoreHiveStatisticsProvider::createDateRange);
        }
        if (type instanceof DecimalType) {
            return statistics.getDecimalStatistics().flatMap(MetastoreHiveStatisticsProvider::createDecimalRange);
        }
        throw new IllegalArgumentException("Unexpected type: " + type);
    }

    private static Optional<DoubleRange> createIntegerRange(Type type, IntegerStatistics statistics) {
        if (statistics.getMin().isPresent() && statistics.getMax().isPresent()) {
            return Optional.of(MetastoreHiveStatisticsProvider.createIntegerRange(type, statistics.getMin().getAsLong(), statistics.getMax().getAsLong()));
        }
        return Optional.empty();
    }

    private static DoubleRange createIntegerRange(Type type, long min, long max) {
        return new DoubleRange((double)MetastoreHiveStatisticsProvider.normalizeIntegerValue(type, min), (double)MetastoreHiveStatisticsProvider.normalizeIntegerValue(type, max));
    }

    private static long normalizeIntegerValue(Type type, long value) {
        if (type.equals(BigintType.BIGINT)) {
            return value;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return Ints.saturatedCast((long)value);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return Shorts.saturatedCast((long)value);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return SignedBytes.saturatedCast((long)value);
        }
        throw new IllegalArgumentException("Unexpected type: " + type);
    }

    private static Optional<DoubleRange> createDoubleRange(DoubleStatistics statistics) {
        if (statistics.getMin().isPresent() && statistics.getMax().isPresent() && !Double.isNaN(statistics.getMin().getAsDouble()) && !Double.isNaN(statistics.getMax().getAsDouble())) {
            return Optional.of(new DoubleRange(statistics.getMin().getAsDouble(), statistics.getMax().getAsDouble()));
        }
        return Optional.empty();
    }

    private static Optional<DoubleRange> createDateRange(DateStatistics statistics) {
        if (statistics.getMin().isPresent() && statistics.getMax().isPresent()) {
            return Optional.of(new DoubleRange((double)((LocalDate)statistics.getMin().get()).toEpochDay(), (double)((LocalDate)statistics.getMax().get()).toEpochDay()));
        }
        return Optional.empty();
    }

    private static Optional<DoubleRange> createDecimalRange(DecimalStatistics statistics) {
        if (statistics.getMin().isPresent() && statistics.getMax().isPresent()) {
            return Optional.of(new DoubleRange(((BigDecimal)statistics.getMin().get()).doubleValue(), ((BigDecimal)statistics.getMax().get()).doubleValue()));
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static interface PartitionsStatisticsProvider {
        public Map<String, PartitionStatistics> getPartitionsStatistics(ConnectorSession var1, SchemaTableName var2, List<HivePartition> var3);
    }
}

