/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.hadoop.TextLineLengthLimitExceededException;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.util.SerDeUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.joda.time.DateTimeZone;

class GenericHiveRecordCursor<K, V extends Writable>
implements RecordCursor {
    private static final DateTimeZone JVM_TIME_ZONE = DateTimeZone.getDefault();
    private final Path path;
    private final RecordReader<K, V> recordReader;
    private final K key;
    private final V value;
    private final Deserializer deserializer;
    private final Type[] types;
    private final HiveType[] hiveTypes;
    private final StructObjectInspector rowInspector;
    private final ObjectInspector[] fieldInspectors;
    private final StructField[] structFields;
    private final boolean[] loaded;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final Object[] objects;
    private final boolean[] nulls;
    private final long totalBytes;
    private final DateTimeZone hiveStorageTimeZone;
    private long completedBytes;
    private Object rowData;
    private boolean closed;

    public GenericHiveRecordCursor(Configuration configuration, Path path, RecordReader<K, V> recordReader, long totalBytes, Properties splitSchema, List<HiveColumnHandle> columns, ZoneId hiveStorageTimeZoneId, TypeManager typeManager) {
        this(configuration, path, recordReader, totalBytes, splitSchema, columns, GenericHiveRecordCursor.getDateTimeZone(hiveStorageTimeZoneId), typeManager);
    }

    private static DateTimeZone getDateTimeZone(ZoneId hiveStorageTimeZoneId) {
        Objects.requireNonNull(hiveStorageTimeZoneId, "hiveStorageTimeZoneId is null");
        return DateTimeZone.forID((String)hiveStorageTimeZoneId.getId());
    }

    public GenericHiveRecordCursor(Configuration configuration, Path path, RecordReader<K, V> recordReader, long totalBytes, Properties splitSchema, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(recordReader, "recordReader is null");
        Preconditions.checkArgument((totalBytes >= 0L ? 1 : 0) != 0, (Object)"totalBytes is negative");
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.path = path;
        this.recordReader = recordReader;
        this.totalBytes = totalBytes;
        this.key = recordReader.createKey();
        this.value = (Writable)recordReader.createValue();
        this.hiveStorageTimeZone = hiveStorageTimeZone;
        this.deserializer = HiveUtil.getDeserializer(configuration, splitSchema);
        this.rowInspector = HiveUtil.getTableObjectInspector(this.deserializer);
        int size = columns.size();
        this.types = new Type[size];
        this.hiveTypes = new HiveType[size];
        this.structFields = new StructField[size];
        this.fieldInspectors = new ObjectInspector[size];
        this.loaded = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        for (int i = 0; i < columns.size(); ++i) {
            StructField field;
            HiveColumnHandle column = columns.get(i);
            Preconditions.checkState((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (Object)"column type must be regular");
            this.types[i] = typeManager.getType(column.getTypeSignature());
            this.hiveTypes[i] = column.getHiveType();
            this.structFields[i] = field = this.rowInspector.getStructFieldRef(column.getName());
            this.fieldInspectors[i] = field.getFieldObjectInspector();
        }
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            if (this.closed || !this.recordReader.next(this.key, this.value)) {
                this.close();
                return false;
            }
            Arrays.fill(this.loaded, false);
            this.rowData = this.deserializer.deserialize(this.value);
            return true;
        }
        catch (IOException | RuntimeException | SerDeException e) {
            HiveUtil.closeWithSuppression(this, e);
            if (e instanceof TextLineLengthLimitExceededException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Line too long in text file: " + this.path, e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseBooleanColumn(fieldId);
        }
        return this.booleans[fieldId];
    }

    private void parseBooleanColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.booleans[column] = (Boolean)fieldValue;
            this.nulls[column] = false;
        }
    }

    public long getLong(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Long.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseLongColumn(fieldId);
        }
        return this.longs[fieldId];
    }

    private void parseLongColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.longs[column] = GenericHiveRecordCursor.getLongExpressedValue(fieldValue, this.hiveStorageTimeZone);
            this.nulls[column] = false;
        }
    }

    private static long getLongExpressedValue(Object value, DateTimeZone hiveTimeZone) {
        if (value instanceof Date) {
            long storageTime = ((Date)value).getTime();
            long utcMillis = storageTime + (long)JVM_TIME_ZONE.getOffset(storageTime);
            return TimeUnit.MILLISECONDS.toDays(utcMillis);
        }
        if (value instanceof Timestamp) {
            long parsedJvmMillis = ((Timestamp)value).getTime();
            long hiveMillis = JVM_TIME_ZONE.convertUTCToLocal(parsedJvmMillis);
            return hiveTimeZone.convertLocalToUTC(hiveMillis, false);
        }
        if (value instanceof Float) {
            return Float.floatToRawIntBits(((Float)value).floatValue());
        }
        return ((Number)value).longValue();
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseDoubleColumn(fieldId);
        }
        return this.doubles[fieldId];
    }

    private void parseDoubleColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            this.doubles[column] = ((Number)fieldValue).doubleValue();
            this.nulls[column] = false;
        }
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Slice.class);
        if (!this.loaded[fieldId]) {
            this.parseStringColumn(fieldId);
        }
        return this.slices[fieldId];
    }

    private void parseStringColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            PrimitiveObjectInspector inspector = (PrimitiveObjectInspector)this.fieldInspectors[column];
            Slice value = inspector.preferWritable() ? GenericHiveRecordCursor.parseStringFromPrimitiveWritableObjectValue(this.types[column], inspector.getPrimitiveWritableObject(fieldData)) : GenericHiveRecordCursor.parseStringFromPrimitiveJavaObjectValue(this.types[column], inspector.getPrimitiveJavaObject(fieldData));
            this.slices[column] = value;
            this.nulls[column] = false;
        }
    }

    private static Slice parseStringFromPrimitiveWritableObjectValue(Type type, Object fieldValue) {
        Text hiveValue;
        Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
        if (fieldValue instanceof Text) {
            hiveValue = (Text)fieldValue;
        } else if (fieldValue instanceof BytesWritable) {
            hiveValue = (BytesWritable)fieldValue;
        } else if (fieldValue instanceof HiveVarcharWritable) {
            hiveValue = ((HiveVarcharWritable)fieldValue).getTextValue();
        } else if (fieldValue instanceof HiveCharWritable) {
            hiveValue = ((HiveCharWritable)fieldValue).getTextValue();
        } else {
            throw new IllegalStateException("unsupported string field type: " + fieldValue.getClass().getName());
        }
        Slice value = GenericHiveRecordCursor.trimStringToCharacterLimits(type, Slices.wrappedBuffer((byte[])hiveValue.getBytes(), (int)0, (int)hiveValue.getLength()));
        return Slices.copyOf((Slice)value);
    }

    private static Slice parseStringFromPrimitiveJavaObjectValue(Type type, Object fieldValue) {
        Slice value;
        Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
        if (fieldValue instanceof String) {
            value = Slices.utf8Slice((String)((String)fieldValue));
        } else if (fieldValue instanceof byte[]) {
            value = Slices.wrappedBuffer((byte[])((byte[])fieldValue));
        } else if (fieldValue instanceof HiveVarchar) {
            value = Slices.utf8Slice((String)((HiveVarchar)fieldValue).getValue());
        } else if (fieldValue instanceof HiveChar) {
            value = Slices.utf8Slice((String)((HiveChar)fieldValue).getValue());
        } else {
            throw new IllegalStateException("unsupported string field type: " + fieldValue.getClass().getName());
        }
        value = GenericHiveRecordCursor.trimStringToCharacterLimits(type, value);
        if (!value.isCompact()) {
            return Slices.copyOf((Slice)value);
        }
        return value;
    }

    private static Slice trimStringToCharacterLimits(Type type, Slice value) {
        if (Varchars.isVarcharType((Type)type)) {
            return Varchars.truncateToLength((Slice)value, (Type)type);
        }
        if (Chars.isCharType((Type)type)) {
            return Chars.truncateToLengthAndTrimSpaces((Slice)value, (Type)type);
        }
        return value;
    }

    private void parseDecimalColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (Object)"fieldValue should not be null");
            HiveDecimal decimal = (HiveDecimal)fieldValue;
            DecimalType columnType = (DecimalType)this.types[column];
            BigInteger unscaledDecimal = Decimals.rescale((BigInteger)decimal.unscaledValue(), (int)decimal.scale(), (int)columnType.getScale());
            if (columnType.isShort()) {
                this.longs[column] = unscaledDecimal.longValue();
            } else {
                this.slices[column] = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
            }
            this.nulls[column] = false;
        }
    }

    public Object getObject(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        this.validateType(fieldId, Block.class);
        if (!this.loaded[fieldId]) {
            this.parseObjectColumn(fieldId);
        }
        return this.objects[fieldId];
    }

    private void parseObjectColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            this.objects[column] = SerDeUtils.getBlockObject(this.types[column], fieldData, this.fieldInspectors[column]);
            this.nulls[column] = false;
        }
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseColumn(fieldId);
        }
        return this.nulls[fieldId];
    }

    private void parseColumn(int column) {
        Type type = this.types[column];
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            this.parseBooleanColumn(column);
        } else if (BigintType.BIGINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (RealType.REAL.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            this.parseDoubleColumn(column);
        } else if (Varchars.isVarcharType((Type)type) || VarbinaryType.VARBINARY.equals((Object)type)) {
            this.parseStringColumn(column);
        } else if (Chars.isCharType((Type)type)) {
            this.parseStringColumn(column);
        } else if (HiveUtil.isStructuralType(this.hiveTypes[column])) {
            this.parseObjectColumn(column);
        } else if (DateType.DATE.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (type instanceof DecimalType) {
            this.parseDecimalColumn(column);
        } else {
            throw new UnsupportedOperationException("Unsupported column type: " + type);
        }
    }

    private void validateType(int fieldId, Class<?> type) {
        if (!this.types[fieldId].getJavaType().equals(type)) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", type, this.types[fieldId], fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

