/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveBucketProperty;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitPartitionInfo;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.HiveWriterFactory;
import com.facebook.presto.hive.HudiDirectoryLister;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.NestedDirectoryPolicy;
import com.facebook.presto.hive.PartitionLoader;
import com.facebook.presto.hive.S3SelectPushdown;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.hive.util.HiveFileIterator;
import com.facebook.presto.hive.util.InternalHiveSplitFactory;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.function.IntPredicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;

public class StoragePartitionLoader
extends PartitionLoader {
    private static final ListenableFuture<?> COMPLETED_FUTURE = Futures.immediateFuture(null);
    private final Table table;
    private final Optional<Domain> pathDomain;
    private final Optional<BucketSplitInfo> tableBucketInfo;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsContext hdfsContext;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final boolean recursiveDirWalkerEnabled;
    private final ConnectorSession session;
    private final Deque<Iterator<InternalHiveSplit>> fileIterators;
    private final boolean schedulerUsesHostAddresses;
    private final boolean partialAggregationsPushedDown;

    public StoragePartitionLoader(Table table, Optional<Domain> pathDomain, Optional<BucketSplitInfo> tableBucketInfo, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Deque<Iterator<InternalHiveSplit>> fileIterators, boolean recursiveDirWalkerEnabled, boolean schedulerUsesHostAddresses, boolean partialAggregationsPushedDown) {
        Configuration configuration;
        InputFormat<?, ?> inputFormat;
        this.table = Objects.requireNonNull(table, "table is null");
        this.pathDomain = Objects.requireNonNull(pathDomain, "pathDomain is null");
        this.tableBucketInfo = Objects.requireNonNull(tableBucketInfo, "tableBucketInfo is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.namenodeStats = Objects.requireNonNull(namenodeStats, "namenodeStats is null");
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.hdfsContext = new HdfsContext(session, table.getDatabaseName(), table.getTableName(), table.getStorage().getLocation(), false);
        this.fileIterators = Objects.requireNonNull(fileIterators, "fileIterators is null");
        this.schedulerUsesHostAddresses = schedulerUsesHostAddresses;
        this.partialAggregationsPushedDown = partialAggregationsPushedDown;
        Optional<DirectoryLister> directoryListerOverride = Optional.empty();
        if (!Strings.isNullOrEmpty((String)table.getStorage().getLocation()) && HiveUtil.isHudiParquetInputFormat(inputFormat = HiveUtil.getInputFormat(configuration = hdfsEnvironment.getConfiguration(this.hdfsContext, new Path(table.getStorage().getLocation())), table.getStorage().getStorageFormat().getInputFormat(), false))) {
            directoryListerOverride = Optional.of(new HudiDirectoryLister(configuration, session, table));
        }
        this.directoryLister = directoryListerOverride.orElseGet(() -> Objects.requireNonNull(directoryLister, "directoryLister is null"));
    }

    private ListenableFuture<?> handleSymlinkTextInputFormat(ExtendedFileSystem fs, Path path, InputFormat<?, ?> inputFormat, boolean s3SelectPushdownEnabled, Storage storage, List<HivePartitionKey> partitionKeys, String partitionName, int partitionDataColumnCount, boolean stopped, HivePartitionMetadata partition, HiveSplitSource hiveSplitSource) throws IOException {
        if (this.tableBucketInfo.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketed table in SymlinkTextInputFormat is not yet supported");
        }
        ListenableFuture<?> lastResult = COMPLETED_FUTURE;
        for (Path targetPath : StoragePartitionLoader.getTargetPathsFromSymlink(fs, path)) {
            TextInputFormat targetInputFormat = new TextInputFormat();
            ExtendedFileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, targetPath);
            JobConf targetJob = ConfigurationUtils.toJobConf(targetFilesystem.getConf());
            targetJob.setInputFormat(TextInputFormat.class);
            targetInputFormat.configure(targetJob);
            FileInputFormat.setInputPaths((JobConf)targetJob, (Path[])new Path[]{targetPath});
            InputSplit[] targetSplits = targetInputFormat.getSplits(targetJob, 0);
            InternalHiveSplitFactory splitFactory = this.getHiveSplitFactory(fs, inputFormat, s3SelectPushdownEnabled, storage, path, partitionName, partitionKeys, partitionDataColumnCount, partition, Optional.empty());
            lastResult = this.addSplitsToSource(targetSplits, splitFactory, hiveSplitSource, stopped);
            if (!stopped) continue;
            return COMPLETED_FUTURE;
        }
        return lastResult;
    }

    private ListenableFuture<?> handleGetSplitsFromInputFormat(Configuration configuration, Path path, Properties schema, InputFormat<?, ?> inputFormat, boolean stopped, HiveSplitSource hiveSplitSource, InternalHiveSplitFactory splitFactory) throws IOException {
        if (this.tableBucketInfo.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Presto cannot read bucketed partition in an input format with UseFileSplitsFromInputFormat annotation: " + inputFormat.getClass().getSimpleName());
        }
        JobConf jobConf = ConfigurationUtils.toJobConf(configuration);
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
        Maps.fromProperties((Properties)schema).forEach((arg_0, arg_1) -> ((JobConf)jobConf).set(arg_0, arg_1));
        InputSplit[] splits = inputFormat.getSplits(jobConf, 0);
        return this.addSplitsToSource(splits, splitFactory, hiveSplitSource, stopped);
    }

    private InternalHiveSplitFactory getHiveSplitFactory(ExtendedFileSystem fs, InputFormat<?, ?> inputFormat, boolean s3SelectPushdownEnabled, Storage storage, Path path, String partitionName, List<HivePartitionKey> partitionKeys, int partitionDataColumnCount, HivePartitionMetadata partition, Optional<HiveSplit.BucketConversion> bucketConversion) {
        return new InternalHiveSplitFactory((FileSystem)fs, inputFormat, this.pathDomain, HiveSessionProperties.getNodeSelectionStrategy(this.session), HiveSessionProperties.getMaxInitialSplitSize(this.session), s3SelectPushdownEnabled, new HiveSplitPartitionInfo(storage, path.toUri(), partitionKeys, partitionName, partitionDataColumnCount, partition.getTableToPartitionMapping(), bucketConversion, partition.getRedundantColumnDomains()), this.schedulerUsesHostAddresses, partition.getEncryptionInformation());
    }

    @Override
    public ListenableFuture<?> loadPartition(HivePartitionMetadata partition, HiveSplitSource hiveSplitSource, boolean stopped) throws IOException {
        boolean splittable;
        String partitionName = partition.getHivePartition().getPartitionId();
        Storage storage = partition.getPartition().map(Partition::getStorage).orElse(this.table.getStorage());
        Properties schema = StoragePartitionLoader.getPartitionSchema(this.table, partition.getPartition());
        String inputFormatName = storage.getStorageFormat().getInputFormat();
        int partitionDataColumnCount = partition.getPartition().map(p -> p.getColumns().size()).orElse(this.table.getDataColumns().size());
        List<HivePartitionKey> partitionKeys = this.getPartitionKeys(this.table, partition.getPartition(), partitionName);
        String location = MetastoreUtil.getPartitionLocation((Table)this.table, partition.getPartition());
        if (location.isEmpty()) {
            Preconditions.checkState((!HiveMetadata.shouldCreateFilesForMissingBuckets(this.table, this.session) ? 1 : 0) != 0, (Object)"Empty location is only allowed for empty temporary table when zero-row file is not created");
            return COMPLETED_FUTURE;
        }
        Path path = new Path(location);
        Configuration configuration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, path);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, inputFormatName, false);
        ExtendedFileSystem fs = this.hdfsEnvironment.getFileSystem(this.hdfsContext.getIdentity().getUser(), path, configuration);
        boolean s3SelectPushdownEnabled = S3SelectPushdown.shouldEnablePushdownForTable(this.session, this.table, path.toString(), partition.getPartition());
        if (inputFormat instanceof SymlinkTextInputFormat) {
            return this.handleSymlinkTextInputFormat(fs, path, inputFormat, s3SelectPushdownEnabled, storage, partitionKeys, partitionName, partitionDataColumnCount, stopped, partition, hiveSplitSource);
        }
        Optional<HiveSplit.BucketConversion> bucketConversion = Optional.empty();
        boolean bucketConversionRequiresWorkerParticipation = false;
        if (partition.getPartition().isPresent()) {
            int partitionBucketCount;
            int tableBucketCount;
            Optional partitionBucketProperty = partition.getPartition().get().getStorage().getBucketProperty();
            if (this.tableBucketInfo.isPresent() && partitionBucketProperty.isPresent() && (tableBucketCount = this.tableBucketInfo.get().getTableBucketCount()) != (partitionBucketCount = ((HiveBucketProperty)partitionBucketProperty.get()).getBucketCount())) {
                bucketConversion = Optional.of(new HiveSplit.BucketConversion(tableBucketCount, partitionBucketCount, this.tableBucketInfo.get().getBucketColumns()));
                if (tableBucketCount > partitionBucketCount) {
                    bucketConversionRequiresWorkerParticipation = true;
                }
            }
        }
        InternalHiveSplitFactory splitFactory = this.getHiveSplitFactory(fs, inputFormat, s3SelectPushdownEnabled, storage, path, partitionName, partitionKeys, partitionDataColumnCount, partition, bucketConversionRequiresWorkerParticipation ? bucketConversion : Optional.empty());
        if (HiveUtil.shouldUseFileSplitsFromInputFormat(inputFormat, this.directoryLister)) {
            return this.handleGetSplitsFromInputFormat(configuration, path, schema, inputFormat, stopped, hiveSplitSource, splitFactory);
        }
        boolean bl = splittable = HiveSessionProperties.isFileSplittable(this.session) && !HiveSessionProperties.isOrderBasedExecutionEnabled(this.session) && !s3SelectPushdownEnabled && !this.partialAggregationsPushedDown && HiveUtil.getFooterCount(schema) == 0 && HiveUtil.getHeaderCount(schema) <= 1;
        if (this.tableBucketInfo.isPresent()) {
            if (this.tableBucketInfo.get().isVirtuallyBucketed()) {
                Preconditions.checkState((!bucketConversion.isPresent() ? 1 : 0) != 0, (Object)"Virtually bucketed table must not have partitions that are physically bucketed");
                Preconditions.checkState((this.tableBucketInfo.get().getTableBucketCount() == this.tableBucketInfo.get().getReadBucketCount() ? 1 : 0) != 0, (Object)"Table and read bucket count should be the same for virtual bucket");
                return hiveSplitSource.addToQueue(this.getVirtuallyBucketedSplits(path, fs, splitFactory, this.tableBucketInfo.get().getReadBucketCount(), partition.getPartition(), splittable));
            }
            return hiveSplitSource.addToQueue(this.getBucketedSplits(path, fs, splitFactory, this.tableBucketInfo.get(), bucketConversion, partitionName, partition.getPartition(), splittable));
        }
        this.fileIterators.addLast(this.createInternalHiveSplitIterator(path, fs, splitFactory, splittable, partition.getPartition()));
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<?> addSplitsToSource(InputSplit[] targetSplits, InternalHiveSplitFactory splitFactory, HiveSplitSource hiveSplitSource, boolean stopped) throws IOException {
        ListenableFuture<?> lastResult = COMPLETED_FUTURE;
        for (InputSplit inputSplit : targetSplits) {
            Optional<InternalHiveSplit> internalHiveSplit = splitFactory.createInternalHiveSplit((FileSplit)inputSplit);
            if (internalHiveSplit.isPresent()) {
                lastResult = hiveSplitSource.addToQueue(internalHiveSplit.get());
            }
            if (!stopped) continue;
            return COMPLETED_FUTURE;
        }
        return lastResult;
    }

    private Iterator<InternalHiveSplit> createInternalHiveSplitIterator(Path path, ExtendedFileSystem fileSystem, InternalHiveSplitFactory splitFactory, boolean splittable, Optional<Partition> partition) {
        boolean cacheable = HiveSessionProperties.isUseListDirectoryCache(this.session);
        if (partition.isPresent()) {
            cacheable &= partition.get().isSealedPartition();
        }
        HiveDirectoryContext hiveDirectoryContext = new HiveDirectoryContext(this.recursiveDirWalkerEnabled ? NestedDirectoryPolicy.RECURSE : NestedDirectoryPolicy.IGNORED, cacheable, HiveUtil.buildDirectoryContextProperties(this.session));
        return Streams.stream(this.directoryLister.list(fileSystem, this.table, path, partition, this.namenodeStats, hiveDirectoryContext)).map(status -> splitFactory.createInternalHiveSplit((HiveFileInfo)status, splittable)).filter(Optional::isPresent).map(Optional::get).iterator();
    }

    private List<InternalHiveSplit> getBucketedSplits(Path path, ExtendedFileSystem fileSystem, InternalHiveSplitFactory splitFactory, BucketSplitInfo bucketSplitInfo, Optional<HiveSplit.BucketConversion> bucketConversion, String partitionName, Optional<Partition> partition, boolean splittable) {
        int readBucketCount = bucketSplitInfo.getReadBucketCount();
        int tableBucketCount = bucketSplitInfo.getTableBucketCount();
        int partitionBucketCount = bucketConversion.map(HiveSplit.BucketConversion::getPartitionBucketCount).orElse(tableBucketCount);
        Preconditions.checkState((readBucketCount <= tableBucketCount ? 1 : 0) != 0, (String)"readBucketCount(%s) should be less than or equal to tableBucketCount(%s)", (int)readBucketCount, (int)tableBucketCount);
        ArrayList<HiveFileInfo> fileInfos = new ArrayList<HiveFileInfo>(partitionBucketCount);
        try {
            Iterators.addAll(fileInfos, this.directoryLister.list(fileSystem, this.table, path, partition, this.namenodeStats, new HiveDirectoryContext(NestedDirectoryPolicy.FAIL, HiveSessionProperties.isUseListDirectoryCache(this.session), HiveUtil.buildDirectoryContextProperties(this.session))));
        }
        catch (HiveFileIterator.NestedDirectoryNotAllowedException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. Found sub-directory in bucket directory for partition: %s", this.table.getSchemaTableName(), partitionName));
        }
        ListMultimap<Integer, HiveFileInfo> bucketToFileInfo = this.computeBucketToFileInfoMapping(fileInfos, partitionBucketCount, partitionName);
        return this.convertFilesToInternalSplits(bucketSplitInfo, bucketConversion, bucketToFileInfo, splitFactory, splittable);
    }

    private ListMultimap<Integer, HiveFileInfo> computeBucketToFileInfoMapping(List<HiveFileInfo> fileInfos, int partitionBucketCount, String partitionName) {
        ArrayListMultimap bucketToFileInfo = ArrayListMultimap.create();
        if (!HiveMetadata.shouldCreateFilesForMissingBuckets(this.table, this.session)) {
            fileInfos.stream().forEach(arg_0 -> StoragePartitionLoader.lambda$computeBucketToFileInfoMapping$3((ListMultimap)bucketToFileInfo, arg_0));
        } else {
            for (HiveFileInfo file : fileInfos) {
                String fileName = file.getPath().getName();
                OptionalInt bucket = HiveWriterFactory.getBucketNumber(fileName);
                if (bucket.isPresent()) {
                    bucketToFileInfo.put((Object)bucket.getAsInt(), (Object)file);
                    continue;
                }
                if (fileInfos.size() != partitionBucketCount) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. File '%s' does not match the standard naming pattern, and the number of files in the directory (%s) does not match the declared bucket count (%s) for partition: %s", this.table.getSchemaTableName(), fileName, fileInfos.size(), partitionBucketCount, partitionName));
                }
                if (fileInfos.get(0).getPath().getName().matches("\\d+")) {
                    try {
                        fileInfos.sort(Comparator.comparingInt(fileInfo -> Integer.parseInt(fileInfo.getPath().getName())));
                    }
                    catch (NumberFormatException e) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_FILE_NAMES, String.format("Hive table '%s' is corrupt. Some of the filenames in the partition: %s are not integers", new SchemaTableName(this.table.getDatabaseName(), this.table.getTableName()), partitionName));
                    }
                } else {
                    fileInfos.sort(null);
                }
                bucketToFileInfo.clear();
                for (int i = 0; i < fileInfos.size(); ++i) {
                    bucketToFileInfo.put((Object)i, (Object)fileInfos.get(i));
                }
            }
        }
        return bucketToFileInfo;
    }

    private List<InternalHiveSplit> convertFilesToInternalSplits(BucketSplitInfo bucketSplitInfo, Optional<HiveSplit.BucketConversion> bucketConversion, ListMultimap<Integer, HiveFileInfo> bucketToFileInfo, InternalHiveSplitFactory splitFactory, boolean splittable) {
        int readBucketCount = bucketSplitInfo.getReadBucketCount();
        int tableBucketCount = bucketSplitInfo.getTableBucketCount();
        int partitionBucketCount = bucketConversion.map(HiveSplit.BucketConversion::getPartitionBucketCount).orElse(tableBucketCount);
        int bucketCount = Math.max(readBucketCount, partitionBucketCount);
        ArrayList<InternalHiveSplit> splitList = new ArrayList<InternalHiveSplit>();
        for (int bucketNumber = 0; bucketNumber < bucketCount; ++bucketNumber) {
            int partitionBucketNumber = bucketNumber % partitionBucketCount;
            if (!bucketToFileInfo.containsKey((Object)partitionBucketNumber)) continue;
            int readBucketNumber = bucketNumber % readBucketCount;
            boolean containsIneligibleTableBucket = false;
            ArrayList<Integer> eligibleTableBucketNumbers = new ArrayList<Integer>();
            for (int tableBucketNumber2 = bucketNumber % tableBucketCount; tableBucketNumber2 < tableBucketCount; tableBucketNumber2 += bucketCount) {
                if (bucketSplitInfo.isTableBucketEnabled(tableBucketNumber2)) {
                    eligibleTableBucketNumbers.add(tableBucketNumber2);
                    continue;
                }
                containsIneligibleTableBucket = true;
            }
            if (!eligibleTableBucketNumbers.isEmpty() && containsIneligibleTableBucket) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The bucket filter cannot be satisfied. There are restrictions on the bucket filter when all the following is true: 1. a table has a different buckets count as at least one of its partitions that is read in this query; 2. the table has a different but compatible bucket number with another table in the query; 3. some buckets of the table is filtered out from the query, most likely using a filter on \"$bucket\". (table name: " + this.table.getTableName() + ", table bucket count: " + tableBucketCount + ", partition bucket count: " + partitionBucketCount + ", effective reading bucket count: " + readBucketCount + ")");
            }
            if (eligibleTableBucketNumbers.isEmpty()) continue;
            for (HiveFileInfo fileInfo : bucketToFileInfo.get((Object)partitionBucketNumber)) {
                eligibleTableBucketNumbers.stream().map(tableBucketNumber -> splitFactory.createInternalHiveSplit(fileInfo, readBucketNumber, (int)tableBucketNumber, splittable)).forEach(optionalSplit -> optionalSplit.ifPresent(splitList::add));
            }
        }
        return splitList;
    }

    private List<InternalHiveSplit> getVirtuallyBucketedSplits(Path path, ExtendedFileSystem fileSystem, InternalHiveSplitFactory splitFactory, int bucketCount, Optional<Partition> partition, boolean splittable) {
        HiveDirectoryContext hiveDirectoryContext = new HiveDirectoryContext(this.recursiveDirWalkerEnabled ? NestedDirectoryPolicy.RECURSE : NestedDirectoryPolicy.IGNORED, HiveSessionProperties.isUseListDirectoryCache(this.session), HiveUtil.buildDirectoryContextProperties(this.session));
        return (List)Streams.stream(this.directoryLister.list(fileSystem, this.table, path, partition, this.namenodeStats, hiveDirectoryContext)).map(fileInfo -> {
            int virtualBucketNumber = HiveBucketing.getVirtualBucketNumber(bucketCount, fileInfo.getPath());
            return splitFactory.createInternalHiveSplit((HiveFileInfo)fileInfo, virtualBucketNumber, virtualBucketNumber, splittable);
        }).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }

    private static List<Path> getTargetPathsFromSymlink(ExtendedFileSystem fileSystem, Path symlinkDir) {
        try {
            FileStatus[] symlinks = fileSystem.listStatus(symlinkDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            ArrayList<Path> targets = new ArrayList<Path>();
            for (FileStatus symlink : symlinks) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath()), StandardCharsets.UTF_8));){
                    CharStreams.readLines((Readable)reader).stream().map(Path::new).forEach(targets::add);
                }
            }
            return targets;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Error parsing symlinks from: " + symlinkDir, (Throwable)e);
        }
    }

    private static Properties getPartitionSchema(Table table, Optional<Partition> partition) {
        return partition.map(value -> MetastoreUtil.getHiveSchema((Partition)value, (Table)table)).orElseGet(() -> MetastoreUtil.getHiveSchema((Table)table));
    }

    private static /* synthetic */ void lambda$computeBucketToFileInfoMapping$3(ListMultimap bucketToFileInfo, HiveFileInfo fileInfo) {
        String fileName = fileInfo.getPath().getName();
        OptionalInt bucket = HiveWriterFactory.getBucketNumber(fileName);
        if (!bucket.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("invalid hive bucket file name: %s", fileName));
        }
        bucketToFileInfo.put((Object)bucket.getAsInt(), (Object)fileInfo);
    }

    public static class BucketSplitInfo {
        private final List<HiveColumnHandle> bucketColumns;
        private final int tableBucketCount;
        private final int readBucketCount;
        private final IntPredicate bucketFilter;

        public static Optional<BucketSplitInfo> createBucketSplitInfo(Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
            Objects.requireNonNull(bucketHandle, "bucketHandle is null");
            Objects.requireNonNull(bucketFilter, "buckets is null");
            if (!bucketHandle.isPresent()) {
                Preconditions.checkArgument((!bucketFilter.isPresent() ? 1 : 0) != 0, (Object)"bucketHandle must be present if bucketFilter is present");
                return Optional.empty();
            }
            int tableBucketCount = bucketHandle.get().getTableBucketCount();
            int readBucketCount = bucketHandle.get().getReadBucketCount();
            List<HiveColumnHandle> bucketColumns = bucketHandle.get().getColumns();
            IntPredicate predicate = bucketFilter.map(filter -> filter.getBucketsToKeep()::contains).orElse(bucket -> true);
            return Optional.of(new BucketSplitInfo(bucketColumns, tableBucketCount, readBucketCount, predicate));
        }

        private BucketSplitInfo(List<HiveColumnHandle> bucketColumns, int tableBucketCount, int readBucketCount, IntPredicate bucketFilter) {
            this.bucketColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumns, "bucketColumns is null"));
            this.tableBucketCount = tableBucketCount;
            this.readBucketCount = readBucketCount;
            this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        }

        public List<HiveColumnHandle> getBucketColumns() {
            return this.bucketColumns;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getReadBucketCount() {
            return this.readBucketCount;
        }

        public boolean isVirtuallyBucketed() {
            return this.bucketColumns.size() == 1 && this.bucketColumns.get(0).equals(HiveColumnHandle.pathColumnHandle());
        }

        public boolean isTableBucketEnabled(int tableBucketNumber) {
            return this.bucketFilter.test(tableBucketNumber);
        }
    }
}

