/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.parquet.AggregatedParquetPageSource;
import com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import com.facebook.presto.hive.parquet.ParquetPageSource;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.PredicateUtils;
import com.facebook.presto.parquet.reader.ColumnIndexFilterUtils;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.security.AccessControlException;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.crypto.DecryptionPropertiesFactory;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.HiddenColumnChunkMetaData;
import org.apache.parquet.crypto.HiddenColumnException;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOConverter;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

public class ParquetPageSourceFactory
implements HiveBatchPageSourceFactory {
    public static final HiveColumnHandle PARQUET_ROW_INDEX_COLUMN = new HiveColumnHandle("$parquet$row_index", HiveType.HIVE_LONG, HiveType.HIVE_LONG.getTypeSignature(), -1, HiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty(), Optional.empty());
    private static final Set<String> PARQUET_SERDE_CLASS_NAMES = ImmutableSet.builder().add((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").add((Object)"parquet.hive.serde.ParquetHiveSerDe").build();
    private final TypeManager typeManager;
    private final StandardFunctionResolution functionResolution;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;
    private final ParquetMetadataSource parquetMetadataSource;

    @Inject
    public ParquetPageSourceFactory(TypeManager typeManager, StandardFunctionResolution functionResolution, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats, ParquetMetadataSource parquetMetadataSource) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.parquetMetadataSource = Objects.requireNonNull(parquetMetadataSource, "parquetMetadataSource is null");
    }

    public static ConnectorPageSource createParquetPageSource(HdfsEnvironment hdfsEnvironment, ConnectorSession session, Configuration configuration, Path path, long start, long length, long fileSize, List<HiveColumnHandle> columns, SchemaTableName tableName, TypeManager typeManager, StandardFunctionResolution functionResolution, TupleDomain<HiveColumnHandle> effectivePredicate, FileFormatDataSourceStats stats, HiveFileContext hiveFileContext, ParquetMetadataSource parquetMetadataSource) {
        AggregatedMemoryContext systemMemoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        String user = session.getUser();
        boolean useParquetColumnNames = HiveSessionProperties.isUseParquetColumnNames(session);
        boolean columnIndexFilterEnabled = HiveSessionProperties.columnIndexFilterEnabled(session);
        boolean readMaskedValue = HiveSessionProperties.getReadNullMaskedParquetEncryptedValue(session);
        HdfsParquetDataSource dataSource = null;
        try {
            HdfsParquetDataSource parquetDataSource;
            FSDataInputStream inputStream = hdfsEnvironment.getFileSystem(user, path, configuration).openFile(path, hiveFileContext);
            dataSource = parquetDataSource = HdfsParquetDataSource.buildHdfsParquetDataSource(inputStream, path, stats);
            Optional<InternalFileDecryptor> fileDecryptor = ParquetPageSourceFactory.createDecryptor(configuration, path);
            ParquetMetadata parquetMetadata = (ParquetMetadata)hdfsEnvironment.doAs(user, () -> ParquetPageSourceFactory.lambda$createParquetPageSource$0(parquetMetadataSource, (ParquetDataSource)parquetDataSource, fileSize, hiveFileContext, fileDecryptor, readMaskedValue));
            if (!columns.isEmpty() && columns.stream().allMatch(hiveColumnHandle -> hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.AGGREGATED)) {
                return new AggregatedParquetPageSource(columns, parquetMetadata, typeManager, functionResolution);
            }
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            Optional<MessageType> message = columns.stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR || HiveColumnHandle.isPushedDownSubfield(column)).map(column -> ParquetPageSourceFactory.getColumnType(typeManager.getType(column.getTypeSignature()), fileSchema, useParquetColumnNames, column, tableName, path)).filter(Optional::isPresent).map(Optional::get).map(type -> new MessageType(fileSchema.getName(), new Type[]{type})).reduce(MessageType::union);
            MessageType requestedSchema = message.orElse(new MessageType(fileSchema.getName(), (List)ImmutableList.of()));
            ImmutableList.Builder footerBlocks = ImmutableList.builder();
            for (BlockMetaData block : parquetMetadata.getBlocks()) {
                long firstDataPage;
                Optional<Integer> firstIndex = ParquetPageSourceFactory.findFirstNonHiddenColumnId(block);
                if (!firstIndex.isPresent() || (firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(firstIndex.get())).getFirstDataPageOffset()) < start || firstDataPage >= start + length) continue;
                footerBlocks.add((Object)block);
            }
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            TupleDomain<ColumnDescriptor> parquetTupleDomain = ParquetPageSourceFactory.getParquetTupleDomain(descriptorsByPath, effectivePredicate);
            Predicate parquetPredicate = PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath);
            HdfsParquetDataSource finalDataSource = dataSource;
            ImmutableList.Builder blocks = ImmutableList.builder();
            ArrayList<Object> blockIndexStores = new ArrayList<Object>();
            long nextStart = 0L;
            ImmutableList.Builder blockStarts = ImmutableList.builder();
            for (BlockMetaData block : footerBlocks.build()) {
                Optional columnIndexStore;
                if (PredicateUtils.predicateMatches((Predicate)parquetPredicate, (BlockMetaData)block, (ParquetDataSource)finalDataSource, (Map)descriptorsByPath, parquetTupleDomain, (Optional)(columnIndexStore = ColumnIndexFilterUtils.getColumnIndexStore((Predicate)parquetPredicate, (ParquetDataSource)finalDataSource, (BlockMetaData)block, (Map)descriptorsByPath, (boolean)columnIndexFilterEnabled)), (boolean)columnIndexFilterEnabled, Optional.of(session.getWarningCollector()))) {
                    blocks.add((Object)block);
                    blockStarts.add((Object)nextStart);
                    blockIndexStores.add(columnIndexStore.orElse(null));
                    hiveFileContext.incrementCounter("parquet.blocksRead", RuntimeUnit.NONE, 1L);
                    hiveFileContext.incrementCounter("parquet.rowsRead", RuntimeUnit.NONE, block.getRowCount());
                    hiveFileContext.incrementCounter("parquet.totalBytesRead", RuntimeUnit.BYTE, block.getTotalByteSize());
                } else {
                    hiveFileContext.incrementCounter("parquet.blocksSkipped", RuntimeUnit.NONE, 1L);
                    hiveFileContext.incrementCounter("parquet.rowsSkipped", RuntimeUnit.NONE, block.getRowCount());
                    hiveFileContext.incrementCounter("parquet.totalBytesSkipped", RuntimeUnit.BYTE, block.getTotalByteSize());
                }
                nextStart += block.getRowCount();
            }
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            ParquetReader parquetReader = new ParquetReader(messageColumnIO, (List)blocks.build(), Optional.of(blockStarts.build()), (ParquetDataSource)dataSource, systemMemoryContext, HiveSessionProperties.getParquetMaxReadBlockSize(session), HiveSessionProperties.isParquetBatchReadsEnabled(session), HiveSessionProperties.isParquetBatchReaderVerificationEnabled(session), parquetPredicate, blockIndexStores, columnIndexFilterEnabled, fileDecryptor);
            ImmutableList.Builder namesBuilder = ImmutableList.builder();
            ImmutableList.Builder typesBuilder = ImmutableList.builder();
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            ImmutableList.Builder rowIndexColumns = ImmutableList.builder();
            for (HiveColumnHandle column2 : columns) {
                Preconditions.checkArgument((column2 == PARQUET_ROW_INDEX_COLUMN || column2.getColumnType() == HiveColumnHandle.ColumnType.REGULAR || column2.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0, (String)"column type must be REGULAR: %s", (Object)column2);
                String name = column2.getName();
                com.facebook.presto.common.type.Type type2 = typeManager.getType(column2.getTypeSignature());
                namesBuilder.add((Object)name);
                typesBuilder.add((Object)type2);
                rowIndexColumns.add((Object)(column2 == PARQUET_ROW_INDEX_COLUMN ? 1 : 0));
                if (column2.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED) {
                    if (column2 == PARQUET_ROW_INDEX_COLUMN) {
                        fieldsBuilder.add(Optional.empty());
                        continue;
                    }
                    Subfield pushedDownSubfield = HiveColumnHandle.getPushedDownSubfield(column2);
                    List nestedColumnPath = ParquetTypeUtils.nestedColumnPath((Subfield)pushedDownSubfield);
                    Optional columnIO = ColumnIOConverter.findNestedColumnIO((ColumnIO)ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumnIO, (String)pushedDownSubfield.getRootName()), (List)nestedColumnPath);
                    if (columnIO.isPresent()) {
                        fieldsBuilder.add((Object)ColumnIOConverter.constructField((com.facebook.presto.common.type.Type)type2, (ColumnIO)((ColumnIO)columnIO.get())));
                        continue;
                    }
                    fieldsBuilder.add(Optional.empty());
                    continue;
                }
                if (ParquetPageSourceFactory.getParquetType(type2, fileSchema, useParquetColumnNames, column2, tableName, path).isPresent()) {
                    String columnName = useParquetColumnNames ? name : ((Type)fileSchema.getFields().get(column2.getHiveColumnIndex())).getName();
                    fieldsBuilder.add((Object)ColumnIOConverter.constructField((com.facebook.presto.common.type.Type)type2, (ColumnIO)ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumnIO, (String)columnName)));
                    continue;
                }
                fieldsBuilder.add(Optional.empty());
            }
            return new ParquetPageSource(parquetReader, (List<com.facebook.presto.common.type.Type>)typesBuilder.build(), (List<Optional<Field>>)fieldsBuilder.build(), (List<Boolean>)rowIndexColumns.build(), (List<String>)namesBuilder.build(), hiveFileContext.getStats());
        }
        catch (Exception e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException parquetDataSource) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)((Object)e);
            }
            if (e instanceof ParquetCorruptionException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            if (e instanceof AccessControlException) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, e.getMessage(), (Throwable)e);
            }
            if (Strings.nullToEmpty((String)e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            if (e instanceof HiddenColumnException) {
                message = String.format("User does not have access to encryption key for encrypted column = %s. If returning 'null' for encrypted columns is acceptable to your query, please add 'set session hive.read_null_masked_parquet_encrypted_value_enabled=true' before your query", ((HiddenColumnException)e).getColumn());
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    public static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<HiveColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)effectivePredicate.getDomains().get()).entrySet()) {
            RichColumnDescriptor descriptor;
            HiveColumnHandle columnHandle = (HiveColumnHandle)entry.getKey();
            if (!columnHandle.getHiveType().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) continue;
            if (HiveColumnHandle.isPushedDownSubfield(columnHandle)) {
                Subfield pushedDownSubfield = HiveColumnHandle.getPushedDownSubfield(columnHandle);
                List subfieldPath = ParquetTypeUtils.columnPathFromSubfield((Subfield)pushedDownSubfield);
                descriptor = descriptorsByPath.get(subfieldPath);
            } else {
                descriptor = descriptorsByPath.get(ImmutableList.of((Object)columnHandle.getName()));
            }
            if (descriptor == null) continue;
            predicate.put((Object)descriptor, entry.getValue());
        }
        return TupleDomain.withColumnDomains((Map)predicate.build());
    }

    public static Optional<Type> getParquetType(com.facebook.presto.common.type.Type prestoType, MessageType messageType, boolean useParquetColumnNames, HiveColumnHandle column, SchemaTableName tableName, Path path) {
        Type type = null;
        if (useParquetColumnNames) {
            type = ParquetTypeUtils.getParquetTypeByName((String)column.getName(), (GroupType)messageType);
        } else if (column.getHiveColumnIndex() < messageType.getFieldCount()) {
            type = messageType.getType(column.getHiveColumnIndex());
        }
        if (type == null) {
            return Optional.empty();
        }
        if (!ParquetPageSourceFactory.checkSchemaMatch(type, prestoType)) {
            String parquetTypeName;
            if (type.isPrimitive()) {
                parquetTypeName = type.asPrimitiveType().getPrimitiveTypeName().toString();
            } else {
                GroupType group = type.asGroupType();
                StringBuilder builder = new StringBuilder();
                group.writeToStringBuilder(builder, "");
                parquetTypeName = builder.toString();
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("The column %s of table %s is declared as type %s, but the Parquet file (%s) declares the column as type %s", column.getName(), tableName.toString(), column.getHiveType(), path.toString(), parquetTypeName));
        }
        return Optional.of(type);
    }

    public static boolean checkSchemaMatch(Type parquetType, com.facebook.presto.common.type.Type type) {
        String prestoType = type.getTypeSignature().getBase();
        if (parquetType instanceof GroupType) {
            GroupType groupType = parquetType.asGroupType();
            switch (prestoType) {
                case "row": {
                    RowType rowType = (RowType)type;
                    Map<String, com.facebook.presto.common.type.Type> prestoFieldMap = rowType.getFields().stream().collect(Collectors.toMap(field -> ((String)field.getName().get()).toLowerCase(Locale.ENGLISH), field -> field.getType()));
                    for (int i = 0; i < groupType.getFields().size(); ++i) {
                        Type parquetFieldType = (Type)groupType.getFields().get(i);
                        String fieldName = parquetFieldType.getName().toLowerCase(Locale.ENGLISH);
                        com.facebook.presto.common.type.Type prestoFieldType = prestoFieldMap.get(fieldName);
                        if (prestoFieldType == null || ParquetPageSourceFactory.checkSchemaMatch(parquetFieldType, prestoFieldType)) continue;
                        return false;
                    }
                    return true;
                }
                case "map": {
                    if (groupType.getFields().size() != 1) {
                        return false;
                    }
                    Type mapKeyType = (Type)groupType.getFields().get(0);
                    if (mapKeyType instanceof GroupType) {
                        GroupType mapGroupType = mapKeyType.asGroupType();
                        return mapGroupType.getFields().size() == 2 && ParquetPageSourceFactory.checkSchemaMatch((Type)mapGroupType.getFields().get(0), (com.facebook.presto.common.type.Type)type.getTypeParameters().get(0)) && ParquetPageSourceFactory.checkSchemaMatch((Type)mapGroupType.getFields().get(1), (com.facebook.presto.common.type.Type)type.getTypeParameters().get(1));
                    }
                    return false;
                }
                case "array": {
                    if (groupType.getFields().size() != 1) {
                        return false;
                    }
                    Type bagType = (Type)groupType.getFields().get(0);
                    if (bagType.isPrimitive()) {
                        return ParquetPageSourceFactory.checkSchemaMatch((Type)bagType.asPrimitiveType(), (com.facebook.presto.common.type.Type)type.getTypeParameters().get(0));
                    }
                    GroupType bagGroupType = bagType.asGroupType();
                    return ParquetPageSourceFactory.checkSchemaMatch((Type)bagGroupType, (com.facebook.presto.common.type.Type)type.getTypeParameters().get(0)) || bagGroupType.getFields().size() == 1 && ParquetPageSourceFactory.checkSchemaMatch((Type)bagGroupType.getFields().get(0), (com.facebook.presto.common.type.Type)type.getTypeParameters().get(0));
                }
            }
            return false;
        }
        Preconditions.checkArgument((boolean)parquetType.isPrimitive(), (Object)("Unexpected parquet type for column: %s " + parquetType.getName()));
        PrimitiveType.PrimitiveTypeName parquetTypeName = parquetType.asPrimitiveType().getPrimitiveTypeName();
        switch (parquetTypeName) {
            case INT64: {
                return prestoType.equals("bigint") || prestoType.equals("decimal") || prestoType.equals("timestamp");
            }
            case INT32: {
                return prestoType.equals("integer") || prestoType.equals("bigint") || prestoType.equals("smallint") || prestoType.equals("date") || prestoType.equals("decimal") || prestoType.equals("tinyint");
            }
            case BOOLEAN: {
                return prestoType.equals("boolean");
            }
            case FLOAT: {
                return prestoType.equals("real");
            }
            case DOUBLE: {
                return prestoType.equals("double");
            }
            case BINARY: {
                return prestoType.equals("varbinary") || prestoType.equals("varchar") || prestoType.startsWith("char") || prestoType.equals("decimal");
            }
            case INT96: {
                return prestoType.equals("timestamp");
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return prestoType.equals("decimal");
            }
        }
        throw new IllegalArgumentException("Unexpected parquet type name: " + parquetTypeName);
    }

    public static Optional<Type> getColumnType(com.facebook.presto.common.type.Type prestoType, MessageType messageType, boolean useParquetColumnNames, HiveColumnHandle column, SchemaTableName tableName, Path path) {
        if (useParquetColumnNames && HiveColumnHandle.isPushedDownSubfield(column)) {
            Subfield pushedDownSubfield = HiveColumnHandle.getPushedDownSubfield(column);
            return ParquetTypeUtils.getSubfieldType((GroupType)messageType, (String)pushedDownSubfield.getRootName(), (List)ParquetTypeUtils.nestedColumnPath((Subfield)pushedDownSubfield));
        }
        return ParquetPageSourceFactory.getParquetType(prestoType, messageType, useParquetColumnNames, column, tableName, path);
    }

    public static Optional<InternalFileDecryptor> createDecryptor(Configuration configuration, Path path) {
        DecryptionPropertiesFactory cryptoFactory = DecryptionPropertiesFactory.loadFactory((Configuration)configuration);
        FileDecryptionProperties fileDecryptionProperties = cryptoFactory == null ? null : cryptoFactory.getFileDecryptionProperties(configuration, path);
        return fileDecryptionProperties == null ? Optional.empty() : Optional.of(new InternalFileDecryptor(fileDecryptionProperties));
    }

    private static Optional<Integer> findFirstNonHiddenColumnId(BlockMetaData block) {
        List columns = block.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (HiddenColumnChunkMetaData.isHiddenColumn((ColumnChunkMetaData)((ColumnChunkMetaData)columns.get(i)))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Storage storage, SchemaTableName tableName, Map<String, String> tableParameters, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, HiveFileContext hiveFileContext, Optional<EncryptionInformation> encryptionInformation) {
        if (!PARQUET_SERDE_CLASS_NAMES.contains(storage.getStorageFormat().getSerDe())) {
            return Optional.empty();
        }
        return Optional.of(ParquetPageSourceFactory.createParquetPageSource(this.hdfsEnvironment, session, configuration, path, start, length, fileSize, columns, tableName, this.typeManager, this.functionResolution, effectivePredicate, this.stats, hiveFileContext, this.parquetMetadataSource));
    }

    private static /* synthetic */ ParquetMetadata lambda$createParquetPageSource$0(ParquetMetadataSource parquetMetadataSource, ParquetDataSource parquetDataSource, long fileSize, HiveFileContext hiveFileContext, Optional fileDecryptor, boolean readMaskedValue) throws IOException {
        return parquetMetadataSource.getParquetMetadata(parquetDataSource, fileSize, hiveFileContext.isCacheable(), hiveFileContext.getModificationTime(), fileDecryptor, readMaskedValue).getParquetMetadata();
    }
}

