/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rule;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorPlanRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;

public class HiveAddRequestedColumnsToLayout
implements ConnectorPlanOptimizer {
    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(maxSubplan, "maxSubplan is null");
        return ConnectorPlanRewriter.rewriteWith((ConnectorPlanRewriter)new Rewriter(), (PlanNode)maxSubplan);
    }

    private class Rewriter
    extends ConnectorPlanRewriter<Void> {
        public PlanNode visitTableScan(TableScanNode tableScan, ConnectorPlanRewriter.RewriteContext<Void> context) {
            Optional layout = tableScan.getTable().getLayout();
            if (!layout.isPresent()) {
                return tableScan;
            }
            HiveTableLayoutHandle hiveLayout = (HiveTableLayoutHandle)layout.get();
            HiveTableLayoutHandle hiveLayoutWithDesiredColumns = new HiveTableLayoutHandle(hiveLayout.getSchemaTableName(), hiveLayout.getTablePath(), hiveLayout.getPartitionColumns(), hiveLayout.getDataColumns(), hiveLayout.getTableParameters(), hiveLayout.getPartitions().get(), hiveLayout.getDomainPredicate(), hiveLayout.getRemainingPredicate(), hiveLayout.getPredicateColumns(), hiveLayout.getPartitionColumnPredicate(), hiveLayout.getBucketHandle(), hiveLayout.getBucketFilter(), hiveLayout.isPushdownFilterEnabled(), hiveLayout.getLayoutString(), Optional.of(tableScan.getOutputVariables().stream().map(output -> (HiveColumnHandle)tableScan.getAssignments().get(output)).collect(ImmutableSet.toImmutableSet())), hiveLayout.isPartialAggregationsPushedDown(), hiveLayout.isAppendRowNumberEnabled());
            return new TableScanNode(tableScan.getSourceLocation(), tableScan.getId(), new TableHandle(tableScan.getTable().getConnectorId(), tableScan.getTable().getConnectorHandle(), tableScan.getTable().getTransaction(), Optional.of(hiveLayoutWithDesiredColumns)), tableScan.getOutputVariables(), tableScan.getAssignments(), tableScan.getTableConstraints(), tableScan.getCurrentConstraint(), tableScan.getEnforcedConstraint());
        }
    }
}

