/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security.ranger;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.security.ranger.RangerBasedAccessControlConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Strings;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.provider.AuditProviderFactory;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerAuthorizer {
    private static final Logger log = Logger.get(RangerAuthorizer.class);
    private static final String KEY_DATABASE = "database";
    private static final String KEY_TABLE = "table";
    private static final String KEY_COLUMN = "column";
    private static final String CLUSTER_NAME = "Presto";
    private static final String HIVE = "hive";
    private final RangerBasePlugin plugin;
    private final Supplier<ServicePolicies> servicePolicies;
    private final AtomicReference<ServicePolicies> currentServicePolicies = new AtomicReference();

    public RangerAuthorizer(Supplier<ServicePolicies> servicePolicies, RangerBasedAccessControlConfig rangerBasedAccessControlConfig) {
        AuditProviderFactory providerFactory;
        this.servicePolicies = Objects.requireNonNull(servicePolicies, "ServicePolicies is null");
        RangerPolicyEngineOptions rangerPolicyEngineOptions = new RangerPolicyEngineOptions();
        Configuration conf = new Configuration();
        rangerPolicyEngineOptions.configureDefaultRangerAdmin(conf, HIVE);
        RangerPluginConfig rangerPluginConfig = new RangerPluginConfig(HIVE, rangerBasedAccessControlConfig.getRangerHiveServiceName(), HIVE, CLUSTER_NAME, null, rangerPolicyEngineOptions);
        this.plugin = new RangerBasePlugin(rangerPluginConfig);
        String hiveAuditPath = rangerBasedAccessControlConfig.getRangerHiveAuditPath();
        if (!Strings.isNullOrEmpty((String)hiveAuditPath)) {
            try {
                this.plugin.getConfig().addResource(new File(hiveAuditPath).toURI().toURL());
            }
            catch (MalformedURLException e) {
                log.error((Throwable)e, "Invalid audit file is provided ");
            }
        }
        if (!(providerFactory = AuditProviderFactory.getInstance()).isInitDone()) {
            if (this.plugin.getConfig().getProperties() != null) {
                providerFactory.init(this.plugin.getConfig().getProperties(), HIVE);
            } else {
                log.info("Audit subsystem is not initialized correctly. Please check audit configuration. ");
                log.info("No authorization audits will be generated. ");
            }
        }
        this.plugin.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler());
    }

    private void updateRangerPolicies() {
        ServicePolicies existingServicePolicies;
        ServicePolicies newServicePolicies = this.getRangerServicePolicies();
        if (newServicePolicies != (existingServicePolicies = this.currentServicePolicies.get()) && this.currentServicePolicies.compareAndSet(existingServicePolicies, newServicePolicies)) {
            this.plugin.setPolicies(newServicePolicies);
        }
    }

    private ServicePolicies getRangerServicePolicies() {
        try {
            return this.servicePolicies.get();
        }
        catch (Exception ex) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_RANGER_SERVER_ERROR, "Unable to fetch policy information from ranger", (Throwable)ex);
        }
    }

    public boolean authorizeHiveResource(String database, String table, String column, String accessType, String user, Set<String> userGroups, Set<String> userRoles) {
        RangerAccessRequestImpl request;
        RangerAccessResult result;
        this.updateRangerPolicies();
        RangerAccessResourceImpl resource = new RangerAccessResourceImpl();
        if (!Strings.isNullOrEmpty((String)database)) {
            resource.setValue(KEY_DATABASE, (Object)database);
        }
        if (!Strings.isNullOrEmpty((String)table)) {
            resource.setValue(KEY_TABLE, (Object)table);
        }
        if (!Strings.isNullOrEmpty((String)column)) {
            resource.setValue(KEY_COLUMN, (Object)column);
        }
        return (result = this.plugin.isAccessAllowed((RangerAccessRequest)(request = new RangerAccessRequestImpl((RangerAccessResource)resource, accessType.toLowerCase(Locale.ENGLISH), user, userGroups, userRoles)))) != null && result.getIsAllowed();
    }
}

