/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.HiveSplitPartitionInfo;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.S3SelectPushdown;
import com.facebook.presto.hive.util.CustomSplitConversionUtils;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;

public class InternalHiveSplitFactory {
    private final FileSystem fileSystem;
    private final InputFormat<?, ?> inputFormat;
    private final Optional<Domain> pathDomain;
    private final NodeSelectionStrategy nodeSelectionStrategy;
    private final boolean s3SelectPushdownEnabled;
    private final HiveSplitPartitionInfo partitionInfo;
    private final boolean schedulerUsesHostAddresses;
    private final Optional<EncryptionInformation> encryptionInformation;
    private final long minimumTargetSplitSizeInBytes;

    public InternalHiveSplitFactory(FileSystem fileSystem, InputFormat<?, ?> inputFormat, Optional<Domain> pathDomain, NodeSelectionStrategy nodeSelectionStrategy, DataSize minimumTargetSplitSize, boolean s3SelectPushdownEnabled, HiveSplitPartitionInfo partitionInfo, boolean schedulerUsesHostAddresses, Optional<EncryptionInformation> encryptionInformation) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.inputFormat = Objects.requireNonNull(inputFormat, "inputFormat is null");
        this.pathDomain = Objects.requireNonNull(pathDomain, "pathDomain is null");
        this.nodeSelectionStrategy = Objects.requireNonNull(nodeSelectionStrategy, "nodeSelectionStrategy is null");
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        this.partitionInfo = partitionInfo;
        this.schedulerUsesHostAddresses = schedulerUsesHostAddresses;
        this.encryptionInformation = Objects.requireNonNull(encryptionInformation, "encryptionInformation is null");
        this.minimumTargetSplitSizeInBytes = Objects.requireNonNull(minimumTargetSplitSize, "minimumSplittableSize is null").toBytes();
        Preconditions.checkArgument((this.minimumTargetSplitSizeInBytes > 0L ? 1 : 0) != 0, (String)"minimumTargetSplitSize must be > 0, found: %s", (Object)minimumTargetSplitSize);
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(HiveFileInfo fileInfo, boolean splittable) {
        return this.createInternalHiveSplit(fileInfo, OptionalInt.empty(), OptionalInt.empty(), splittable);
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(HiveFileInfo fileInfo, int readBucketNumber, int tableBucketNumber, boolean splittable) {
        return this.createInternalHiveSplit(fileInfo, OptionalInt.of(readBucketNumber), OptionalInt.of(tableBucketNumber), splittable);
    }

    private Optional<InternalHiveSplit> createInternalHiveSplit(HiveFileInfo fileInfo, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable) {
        splittable = splittable && fileInfo.getLength() > this.minimumTargetSplitSizeInBytes && HiveUtil.isSplittable(this.inputFormat, this.fileSystem, fileInfo.getPath());
        return this.createInternalHiveSplit(fileInfo.getPath(), fileInfo.getBlockLocations(), 0L, fileInfo.getLength(), fileInfo.getLength(), fileInfo.getFileModifiedTime(), readBucketNumber, tableBucketNumber, splittable, fileInfo.getExtraFileInfo(), fileInfo.getCustomSplitInfo());
    }

    public Optional<InternalHiveSplit> createInternalHiveSplit(FileSplit split) throws IOException {
        FileStatus file = this.fileSystem.getFileStatus(split.getPath());
        Map<String, String> customSplitInfo = CustomSplitConversionUtils.extractCustomSplitInfo(split);
        return this.createInternalHiveSplit(split.getPath(), this.fileSystem.getFileBlockLocations(file, split.getStart(), split.getLength()), split.getStart(), split.getLength(), file.getLen(), file.getModificationTime(), OptionalInt.empty(), OptionalInt.empty(), false, Optional.empty(), customSplitInfo);
    }

    private Optional<InternalHiveSplit> createInternalHiveSplit(Path path, BlockLocation[] blockLocations, long start, long length, long fileSize, long fileModificationTime, OptionalInt readBucketNumber, OptionalInt tableBucketNumber, boolean splittable, Optional<byte[]> extraFileInfo, Map<String, String> customSplitInfo) {
        boolean forceLocalScheduling;
        String pathString = path.toString();
        if (!InternalHiveSplitFactory.pathMatchesPredicate(this.pathDomain, pathString)) {
            return Optional.empty();
        }
        boolean bl = forceLocalScheduling = this.nodeSelectionStrategy == NodeSelectionStrategy.HARD_AFFINITY;
        if (fileSize == 0L && blockLocations.length == 0) {
            blockLocations = new BlockLocation[]{new BlockLocation()};
            forceLocalScheduling = false;
        }
        ImmutableList.Builder blockBuilder = ImmutableList.builder();
        for (BlockLocation blockLocation : blockLocations) {
            long blockEnd;
            long blockStart = Math.max(start, blockLocation.getOffset());
            if (blockStart > (blockEnd = Math.min(start + length, blockLocation.getOffset() + blockLocation.getLength())) || blockStart == blockEnd && (blockStart != start || blockEnd != start + length)) continue;
            ImmutableList addresses = InternalHiveSplitFactory.getHostAddresses(blockLocation);
            if (!this.needsHostAddresses(forceLocalScheduling, (List<HostAddress>)addresses)) {
                addresses = ImmutableList.of();
            }
            blockBuilder.add((Object)new InternalHiveSplit.InternalHiveBlock(blockEnd, (List<HostAddress>)addresses));
        }
        ImmutableList blocks = blockBuilder.build();
        InternalHiveSplitFactory.checkBlocks((List<InternalHiveSplit.InternalHiveBlock>)blocks, start, length);
        if (!splittable) {
            ImmutableList addresses = ((InternalHiveSplit.InternalHiveBlock)blocks.get(0)).getAddresses();
            if (!this.needsHostAddresses(forceLocalScheduling, (List<HostAddress>)addresses)) {
                addresses = ImmutableList.of();
            }
            blocks = ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(start + length, (List<HostAddress>)addresses));
        }
        URI relativePath = this.partitionInfo.getPath().relativize(path.toUri());
        return Optional.of(new InternalHiveSplit(relativePath.toString(), start, start + length, fileSize, fileModificationTime, (List<InternalHiveSplit.InternalHiveBlock>)blocks, readBucketNumber, tableBucketNumber, splittable, forceLocalScheduling && InternalHiveSplitFactory.allBlocksHaveRealAddress((List<InternalHiveSplit.InternalHiveBlock>)blocks) ? NodeSelectionStrategy.HARD_AFFINITY : this.nodeSelectionStrategy, this.s3SelectPushdownEnabled && S3SelectPushdown.isCompressionCodecSupported(this.inputFormat, path), this.partitionInfo, extraFileInfo, this.encryptionInformation, customSplitInfo));
    }

    private boolean needsHostAddresses(boolean forceLocalScheduling, List<HostAddress> addresses) {
        return this.schedulerUsesHostAddresses || forceLocalScheduling && InternalHiveSplitFactory.hasRealAddress(addresses);
    }

    private static void checkBlocks(List<InternalHiveSplit.InternalHiveBlock> blocks, long start, long length) {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((!blocks.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((start + length == blocks.get(blocks.size() - 1).getEnd() ? 1 : 0) != 0);
    }

    private static boolean allBlocksHaveRealAddress(List<InternalHiveSplit.InternalHiveBlock> blocks) {
        return blocks.stream().map(InternalHiveSplit.InternalHiveBlock::getAddresses).allMatch(InternalHiveSplitFactory::hasRealAddress);
    }

    private static boolean hasRealAddress(List<HostAddress> addresses) {
        return addresses.stream().anyMatch(address -> !address.getHostText().equals("localhost"));
    }

    private static List<HostAddress> getHostAddresses(BlockLocation blockLocation) {
        String[] hosts;
        try {
            hosts = blockLocation.getHosts();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return (List)Arrays.stream(hosts).map(HostAddress::fromString).collect(ImmutableList.toImmutableList());
    }

    private static boolean pathMatchesPredicate(Optional<Domain> pathDomain, String path) {
        if (!pathDomain.isPresent()) {
            return true;
        }
        return pathDomain.get().includesNullableValue((Object)Slices.utf8Slice((String)path));
    }
}

