/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.testing.Closeables;
import com.facebook.presto.hive.containers.HiveMinIODataLake;
import com.facebook.presto.hive.s3.S3HiveQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.facebook.presto.tests.sql.TestTable;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class BaseTestHiveInsertOverwrite
extends AbstractTestQueryFramework {
    private static final String HIVE_TEST_SCHEMA = "hive_insert_overwrite";
    private String bucketName;
    private HiveMinIODataLake dockerizedS3DataLake;
    private final String hiveHadoopImage;

    public BaseTestHiveInsertOverwrite(String hiveHadoopImage) {
        this.hiveHadoopImage = Objects.requireNonNull(hiveHadoopImage, "hiveHadoopImage is null");
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.bucketName = "test-hive-insert-overwrite-" + TestTable.randomTableSuffix();
        this.dockerizedS3DataLake = new HiveMinIODataLake(this.bucketName, (Map<String, String>)ImmutableMap.of(), this.hiveHadoopImage);
        this.dockerizedS3DataLake.start();
        return S3HiveQueryRunner.create(this.dockerizedS3DataLake.getHiveHadoop().getHiveMetastoreEndpoint(), this.dockerizedS3DataLake.getMinio().getMinioApiEndpoint(), "accesskey", "secretkey", (Map<String, String>)ImmutableMap.builder().put((Object)"hive.s3.path-style-access", (Object)"true").put((Object)"hive.insert-existing-partitions-behavior", (Object)"OVERWRITE").put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").build());
    }

    @BeforeClass
    public void setUp() {
        this.computeActual(String.format("CREATE SCHEMA hive.%1$s WITH (location='s3a://%2$s/%1$s')", HIVE_TEST_SCHEMA, this.bucketName));
    }

    @AfterClass(alwaysRun=true)
    public void close() throws Exception {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.dockerizedS3DataLake});
    }

    @Test
    public void testInsertOverwritePartitionedTable() {
        String testTable = this.getTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, "partitioned_by=ARRAY['regionkey']"));
        this.copyTpchNationToTable(testTable);
        this.assertOverwritePartition(testTable);
    }

    @Test
    public void testInsertOverwritePartitionedAndBucketedTable() {
        String testTable = this.getTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, "partitioned_by=ARRAY['regionkey']", "bucketed_by = ARRAY['nationkey']", "bucket_count = 3"));
        this.copyTpchNationToTable(testTable);
        this.assertOverwritePartition(testTable);
    }

    @Test
    public void testInsertOverwritePartitionedAndBucketedExternalTable() {
        String testTable = this.getTestTableName();
        this.computeActual(this.getCreateTableStatement(testTable, "partitioned_by=ARRAY['regionkey']", "bucketed_by = ARRAY['nationkey']", "bucket_count = 3"));
        this.copyTpchNationToTable(testTable);
        String tableName = testTable.substring(testTable.lastIndexOf(46) + 1);
        String externalTableName = testTable + "_ext";
        this.computeActual(this.getCreateTableStatement(externalTableName, "partitioned_by=ARRAY['regionkey']", "bucketed_by = ARRAY['nationkey']", "bucket_count = 3", String.format("external_location = 's3a://%s/%s/%s/'", this.bucketName, HIVE_TEST_SCHEMA, tableName)));
        this.copyTpchNationToTable(testTable);
        this.assertOverwritePartition(externalTableName);
    }

    protected void assertOverwritePartition(String testTable) {
        this.computeActual(String.format("INSERT INTO %s VALUES ('POLAND', 'Test Data', 25, 5), ('CZECH', 'Test Data', 26, 5)", testTable));
        String oldPartitionPath = this.getPartitionPath(testTable);
        this.assertQuery(String.format("SELECT count(*) FROM %s WHERE regionkey = 5", testTable), "SELECT 2");
        this.computeActual(String.format("INSERT INTO %s values('POLAND', 'Overwrite', 25, 5)", testTable));
        String newPartitionPath = this.getPartitionPath(testTable);
        this.assertQuery(String.format("SELECT count(*) FROM %s WHERE regionkey = 5", testTable), "SELECT 1");
        Assert.assertEquals((String)oldPartitionPath, (String)newPartitionPath);
        this.computeActual(String.format("DROP TABLE %s", testTable));
    }

    private String getPartitionPath(String testTable) {
        MaterializedResult result = this.computeActual(String.format("SELECT \"$PATH\" from %s where regionkey = 5", testTable));
        Assert.assertTrue((result.getMaterializedRows().size() > 0 ? 1 : 0) != 0);
        String path = ((MaterializedRow)result.getMaterializedRows().get(0)).getField(0).toString();
        return path.substring(0, path.lastIndexOf("/"));
    }

    protected String getTestTableName() {
        return String.format("hive.%s.%s", HIVE_TEST_SCHEMA, "nation_" + TestTable.randomTableSuffix());
    }

    protected String getCreateTableStatement(String tableName, String ... propertiesEntries) {
        return this.getCreateTableStatement(tableName, Arrays.asList(propertiesEntries));
    }

    protected String getCreateTableStatement(String tableName, List<String> propertiesEntries) {
        return String.format("CREATE TABLE %s (    name varchar(25),     comment varchar(152),      nationkey bigint,     regionkey bigint) " + (propertiesEntries.size() < 1 ? "" : propertiesEntries.stream().collect(Collectors.joining(",", "WITH (", ")"))), tableName);
    }

    protected void copyTpchNationToTable(String testTable) {
        this.computeActual(String.format("INSERT INTO " + testTable + " SELECT name, comment, nationkey, regionkey FROM tpch.tiny.nation", new Object[0]));
    }
}

