/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.benchmark.BenchmarkSuite;
import com.facebook.presto.hive.HiveConnectorFactory;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.TestHiveUtil;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class HiveBenchmarkQueryRunner {
    private HiveBenchmarkQueryRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String outputDirectory = Objects.requireNonNull(System.getProperty("outputDirectory"), "Must specify -DoutputDirectory=...");
        File tempDir = Files.createTempDir();
        try (LocalQueryRunner localQueryRunner = HiveBenchmarkQueryRunner.createLocalQueryRunner(tempDir);){
            new BenchmarkSuite(localQueryRunner, outputDirectory).runAllBenchmarks();
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    public static LocalQueryRunner createLocalQueryRunner(File tempDir) {
        Session session = TestingSession.testSessionBuilder().setCatalog("hive").setSchema("tpch").build();
        LocalQueryRunner localQueryRunner = new LocalQueryRunner(session);
        localQueryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        File hiveDir = new File(tempDir, "hive_data");
        FileHiveMetastore metastore = TestHiveUtil.createTestingFileHiveMetastore(hiveDir);
        metastore.createDatabase(HiveQueryRunner.METASTORE_CONTEXT, Database.builder().setDatabaseName("tpch").setOwnerName("public").setOwnerType(PrincipalType.ROLE).build());
        HiveConnectorFactory hiveConnectorFactory = new HiveConnectorFactory("hive", HiveBenchmarkQueryRunner.class.getClassLoader(), Optional.of(metastore));
        ImmutableMap hiveCatalogConfig = ImmutableMap.builder().put((Object)"hive.max-split-size", (Object)"10GB").build();
        localQueryRunner.createCatalog("hive", (ConnectorFactory)hiveConnectorFactory, (Map)hiveCatalogConfig);
        localQueryRunner.execute("CREATE TABLE orders AS SELECT * FROM tpch.sf1.orders");
        localQueryRunner.execute("CREATE TABLE lineitem AS SELECT * FROM tpch.sf1.lineitem");
        return localQueryRunner;
    }
}

