/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.PartitionNameWithVersion;
import com.facebook.presto.hive.metastore.TestCachingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.thrift.TException;

public class MockHiveMetastore
extends ThriftHiveMetastore {
    private final TestCachingHiveMetastore.MockHiveCluster clientProvider;

    public MockHiveMetastore(TestCachingHiveMetastore.MockHiveCluster mockHiveCluster) {
        super((HiveCluster)mockHiveCluster, new MetastoreClientConfig(), HiveTestUtils.HDFS_ENVIRONMENT);
        this.clientProvider = Objects.requireNonNull(mockHiveCluster, "mockHiveCluster is null");
    }

    public List<PartitionNameWithVersion> getPartitionNamesWithVersionByFilter(MetastoreContext context, String databaseName, String tableName, Map<Column, Domain> partitionPredicates) {
        try {
            return this.clientProvider.createPartitionVersionSupportedMetastoreClient().getPartitionNamesWithVersionByFilter(databaseName, tableName, partitionPredicates);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }
}

