/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomainFilter;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveCoercer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCoercingFilters {
    @Test
    public void testIntegerToVarchar() {
        TupleDomainFilter.BytesRange filter = TupleDomainFilter.BytesRange.of((byte[])"10".getBytes(), (boolean)false, (byte[])"10".getBytes(), (boolean)false, (boolean)false);
        HiveCoercer.IntegerNumberToVarcharCoercer coercer = new HiveCoercer.IntegerNumberToVarcharCoercer((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR);
        TupleDomainFilter coercingFilter = coercer.toCoercingFilter((TupleDomainFilter)filter, new Subfield("c"));
        Assert.assertTrue((boolean)coercingFilter.testLong(10L));
        Assert.assertFalse((boolean)coercingFilter.testLong(25L));
        Assert.assertFalse((boolean)coercingFilter.testNull());
    }

    @Test
    public void testVarcharToInteger() {
        TupleDomainFilter.BigintRange filter = TupleDomainFilter.BigintRange.of((long)100L, (long)Integer.MAX_VALUE, (boolean)false);
        HiveCoercer.VarcharToIntegerNumberCoercer coercer = new HiveCoercer.VarcharToIntegerNumberCoercer((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER);
        TupleDomainFilter coercingFilter = coercer.toCoercingFilter((TupleDomainFilter)filter, new Subfield("c"));
        Assert.assertTrue((boolean)coercingFilter.testLength(1));
        Assert.assertTrue((boolean)coercingFilter.testLength(2));
        Assert.assertTrue((boolean)coercingFilter.testLength(3));
        Assert.assertTrue((boolean)coercingFilter.testBytes("100".getBytes(), 0, 3));
        Assert.assertTrue((boolean)coercingFilter.testBytes("145".getBytes(), 0, 3));
        Assert.assertTrue((boolean)coercingFilter.testBytes("2147483647".getBytes(), 0, 10));
        Assert.assertFalse((boolean)coercingFilter.testBytes("50".getBytes(), 0, 2));
        Assert.assertFalse((boolean)coercingFilter.testBytes("-50".getBytes(), 0, 3));
        Assert.assertFalse((boolean)coercingFilter.testBytes("abc".getBytes(), 0, 3));
        Assert.assertFalse((boolean)coercingFilter.testBytes("2147483648".getBytes(), 0, 10));
        Assert.assertFalse((boolean)coercingFilter.testNull());
    }
}

