/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColumnEncryptionInformation {
    @Test
    public void testFromTablePropertyNullInput() {
        ColumnEncryptionInformation encryptionInformation = ColumnEncryptionInformation.fromTableProperty(null);
        Assert.assertFalse((boolean)encryptionInformation.hasEntries());
    }

    @Test
    public void testFromTablePropertyValidInput() {
        ColumnEncryptionInformation encryptionInformation = ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1: col1, col2", (Object)"key2: col4, col5.a.b"));
        Map keyReferences = encryptionInformation.getColumnToKeyReference();
        ImmutableMap expectedKeyReferences = ImmutableMap.of((Object)ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"col1"), (Object)"key1", (Object)ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"col2"), (Object)"key1", (Object)ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"col4"), (Object)"key2", (Object)ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"col5.a.b"), (Object)"key2");
        Assert.assertEquals((Map)keyReferences, (Map)expectedKeyReferences);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Encrypted columns property cannot have null value")
    public void testFromTablePropertyNullListEntries() {
        ArrayList<Object> entries = new ArrayList<Object>();
        entries.add(null);
        ColumnEncryptionInformation.fromTableProperty(entries);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Column col1 has been assigned 2 key references \\(key2 and key1\\). Only 1 is allowed")
    public void testFromTablePropertyDuplicateKeys() {
        ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:col1", (Object)"key2:col1"));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Encrypted column entry needs to be in the format 'key1:col1,col2'. Received: key1")
    public void testFromTablePropertyNoColumnsSpecified() {
        ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1"));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Encrypted column entry needs to be in the format 'key1:col1,col2'. Received: key1:key2:col1")
    public void testFromTablePropertyMultipleKeys() {
        ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:key2:col1"));
    }

    @Test
    public void testToTableProperty() {
        ImmutableList originalEntries = ImmutableList.of((Object)"key1:col1,col2", (Object)"key2:col3,col4");
        ColumnEncryptionInformation encryptionInformation = ColumnEncryptionInformation.fromTableProperty((Object)originalEntries);
        List tablePropertyFormat = encryptionInformation.toTableProperty();
        ColumnEncryptionInformation encryptionInformationReconstructed = ColumnEncryptionInformation.fromTableProperty((Object)tablePropertyFormat);
        Assert.assertEquals((Map)encryptionInformationReconstructed.getColumnToKeyReference(), (Map)encryptionInformation.getColumnToKeyReference());
    }

    @Test
    public void testFromHivePropertyNullInput() {
        ColumnEncryptionInformation encryptionInformation = ColumnEncryptionInformation.fromHiveProperty(null);
        Assert.assertFalse((boolean)encryptionInformation.hasEntries());
    }

    @Test
    public void testFromHivePropertyValidInput() {
        ColumnEncryptionInformation encryptionInformation = ColumnEncryptionInformation.fromHiveProperty((String)"key1: col1, col2;key2: col4, col5.a.b");
        Map keyReferences = encryptionInformation.getColumnToKeyReference();
        ImmutableMap expectedKeyReferences = ImmutableMap.of((Object)ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"col1"), (Object)"key1", (Object)ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"col2"), (Object)"key1", (Object)ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"col4"), (Object)"key2", (Object)ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"col5.a.b"), (Object)"key2");
        Assert.assertEquals((Map)keyReferences, (Map)expectedKeyReferences);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Column col1 has been assigned 2 key references \\(key2 and key1\\). Only 1 is allowed")
    public void testFromHivePropertyDuplicateKeys() {
        ColumnEncryptionInformation.fromHiveProperty((String)"key1:col1;key2:col1");
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Encrypted column entry needs to be in the format 'key1:col1,col2'. Received: key1")
    public void testFromHivePropertyNoColumnsSpecified() {
        ColumnEncryptionInformation.fromHiveProperty((String)"key1;key2:col1");
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Encrypted column entry needs to be in the format 'key1:col1,col2'. Received: key1:key2:col1")
    public void testFromHivePropertyMultipleKeys() {
        ColumnEncryptionInformation.fromHiveProperty((String)"key1:key2:col1");
    }

    @Test
    public void testToHiveProperty() {
        String originalInput = "key1:col1,col2;key2:col3,col4";
        ColumnEncryptionInformation encryptionInformation = ColumnEncryptionInformation.fromHiveProperty((String)originalInput);
        String hivePropertyFormat = encryptionInformation.toHiveProperty();
        ColumnEncryptionInformation encryptionInformationReconstructed = ColumnEncryptionInformation.fromHiveProperty((String)hivePropertyFormat);
        Assert.assertEquals((Map)encryptionInformationReconstructed.getColumnToKeyReference(), (Map)encryptionInformation.getColumnToKeyReference());
    }

    @Test
    public void testColumnWithStructSubfieldWithNoSubfield() {
        ColumnEncryptionInformation.ColumnWithStructSubfield column = ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"a");
        Assert.assertEquals((String)column.getColumnName(), (String)"a");
        Assert.assertFalse((boolean)column.getSubfieldPath().isPresent());
        Assert.assertFalse((boolean)column.getChildField().isPresent());
    }

    @Test
    public void testColumnWithStructSubfieldWithSubfield() {
        ColumnEncryptionInformation.ColumnWithStructSubfield column = ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"a.b.c.d");
        Assert.assertEquals((String)column.getColumnName(), (String)"a");
        Assert.assertTrue((boolean)column.getSubfieldPath().isPresent());
        Assert.assertEquals((String)((String)column.getSubfieldPath().get()), (String)"b.c.d");
        Assert.assertTrue((boolean)column.getChildField().isPresent());
        Assert.assertEquals(column.getChildField().get(), (Object)ColumnEncryptionInformation.ColumnWithStructSubfield.valueOf((String)"b.c.d"));
    }
}

