/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDomainTranslator {
    private static final VariableReferenceExpression C_BIGINT = new VariableReferenceExpression(Optional.empty(), "c_bigint", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression C_BIGINT_ARRAY = new VariableReferenceExpression(Optional.empty(), "c_bigint_array", (Type)new ArrayType((Type)BigintType.BIGINT));
    private static final VariableReferenceExpression C_BIGINT_TO_BIGINT_MAP = new VariableReferenceExpression(Optional.empty(), "c_bigint_to_bigint_map", (Type)HiveTestUtils.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT));
    private static final VariableReferenceExpression C_VARCHAR_TO_BIGINT_MAP = new VariableReferenceExpression(Optional.empty(), "c_varchar_to_bigint_map", (Type)HiveTestUtils.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT));
    private static final VariableReferenceExpression C_STRUCT = new VariableReferenceExpression(Optional.empty(), "c_struct", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"x", (Type)BigintType.BIGINT)))), (Object)RowType.field((String)"c", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"d", (Type)HiveTestUtils.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"e", (Type)HiveTestUtils.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)))));
    private static final ExpressionOptimizer TEST_EXPRESSION_OPTIMIZER = new ExpressionOptimizer(){

        public RowExpression optimize(RowExpression rowExpression, ExpressionOptimizer.Level level, ConnectorSession session) {
            return rowExpression;
        }

        public Object optimize(RowExpression expression, ExpressionOptimizer.Level level, ConnectorSession session, Function<VariableReferenceExpression, Object> variableResolver) {
            throw new UnsupportedOperationException();
        }
    };
    private Metadata metadata;
    private RowExpressionDomainTranslator domainTranslator;
    private DomainTranslator.ColumnExtractor<Subfield> columnExtractor;

    @BeforeClass
    public void setup() {
        this.metadata = MetadataManager.createTestMetadataManager();
        this.domainTranslator = new RowExpressionDomainTranslator(this.metadata);
        this.columnExtractor = new SubfieldExtractor((StandardFunctionResolution)new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()), TEST_EXPRESSION_OPTIMIZER, (ConnectorSession)new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setRangeFiltersOnSubscriptsEnabled(true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties())).toColumnExtractor();
    }

    @Test
    public void testSubfields() {
        ImmutableMap expressions = ImmutableMap.builder().put((Object)"c_bigint", (Object)C_BIGINT).put((Object)"c_bigint_array[5]", (Object)this.arraySubscript((RowExpression)C_BIGINT_ARRAY, 5)).put((Object)"c_bigint_to_bigint_map[5]", (Object)this.mapSubscript((RowExpression)C_BIGINT_TO_BIGINT_MAP, (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT))).put((Object)"c_varchar_to_bigint_map[\"foo\"]", (Object)this.mapSubscript((RowExpression)C_VARCHAR_TO_BIGINT_MAP, (RowExpression)Expressions.constant((Object)Slices.utf8Slice((String)"foo"), (Type)VarcharType.VARCHAR))).put((Object)"c_struct.a", (Object)this.dereference((RowExpression)C_STRUCT, 0)).put((Object)"c_struct.b.x", (Object)this.dereference(this.dereference((RowExpression)C_STRUCT, 1), 0)).put((Object)"c_struct.c[5]", (Object)this.arraySubscript(this.dereference((RowExpression)C_STRUCT, 2), 5)).put((Object)"c_struct.d[5]", (Object)this.mapSubscript(this.dereference((RowExpression)C_STRUCT, 3), (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT))).put((Object)"c_struct.e[\"foo\"]", (Object)this.mapSubscript(this.dereference((RowExpression)C_STRUCT, 4), (RowExpression)Expressions.constant((Object)Slices.utf8Slice((String)"foo"), (Type)VarcharType.VARCHAR))).build();
        for (Map.Entry entry : expressions.entrySet()) {
            String subfield = (String)entry.getKey();
            RowExpression expression = (RowExpression)entry.getValue();
            this.assertPredicateTranslates(this.greaterThan(expression, this.bigintLiteral(2L)), subfield, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false));
            this.assertPredicateTranslates(this.equal(expression, this.bigintLiteral(2L)), subfield, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false));
            this.assertPredicateTranslates(this.between(expression, this.bigintLiteral(1L), this.bigintLiteral(2L)), subfield, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false));
            this.assertPredicateTranslates(this.bigintIn(expression, (List<Long>)ImmutableList.of((Object)1L)), subfield, Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
            this.assertPredicateTranslates(this.bigintIn(expression, (List<Long>)ImmutableList.of((Object)1L, (Object)2L)), subfield, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false));
        }
        Type arrayType = C_BIGINT_ARRAY.getType();
        this.assertPredicateTranslates(this.isNull((RowExpression)C_BIGINT_ARRAY), C_BIGINT_ARRAY.getName(), Domain.create((ValueSet)ValueSet.none((Type)arrayType), (boolean)true));
        this.assertPredicateTranslates(this.not(this.isNull((RowExpression)C_BIGINT_ARRAY)), C_BIGINT_ARRAY.getName(), Domain.create((ValueSet)ValueSet.all((Type)arrayType), (boolean)false));
        this.assertPredicateDoesNotTranslate(this.equal((RowExpression)C_BIGINT_ARRAY, (RowExpression)ConstantExpression.createConstantExpression((Block)BlockAssertions.createArrayBigintBlock((Iterable)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))), (Type)arrayType)));
        MapType mapType = (MapType)C_BIGINT_TO_BIGINT_MAP.getType();
        this.assertPredicateTranslates(this.isNull((RowExpression)C_BIGINT_TO_BIGINT_MAP), C_BIGINT_TO_BIGINT_MAP.getName(), Domain.create((ValueSet)ValueSet.none((Type)mapType), (boolean)true));
        this.assertPredicateTranslates(this.not(this.isNull((RowExpression)C_BIGINT_TO_BIGINT_MAP)), C_BIGINT_TO_BIGINT_MAP.getName(), Domain.create((ValueSet)ValueSet.all((Type)mapType), (boolean)false));
        this.assertPredicateDoesNotTranslate(this.equal((RowExpression)C_BIGINT_TO_BIGINT_MAP, (RowExpression)ConstantExpression.createConstantExpression((Block)BlockAssertions.createMapBlock((MapType)mapType, (Map)ImmutableMap.of((Object)1, (Object)100)), (Type)mapType)));
    }

    private RowExpression dereference(RowExpression base, int field) {
        Type fieldType = (Type)base.getType().getTypeParameters().get(field);
        return Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.DEREFERENCE, (Type)fieldType, (List)ImmutableList.of((Object)base, (Object)new ConstantExpression((Object)field, (Type)IntegerType.INTEGER)));
    }

    private RowExpression isNull(RowExpression expression) {
        return Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{expression});
    }

    private RowExpression not(RowExpression expression) {
        return Expressions.call((String)"not", (FunctionHandle)new FunctionResolution(this.metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver()).notFunction(), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{expression});
    }

    private RowExpression arraySubscript(RowExpression arrayExpression, int index) {
        ArrayType arrayType = (ArrayType)arrayExpression.getType();
        Type elementType = arrayType.getElementType();
        return Expressions.call((String)OperatorType.SUBSCRIPT.name(), (FunctionHandle)this.operator(OperatorType.SUBSCRIPT, new Type[]{arrayType, elementType}), (Type)elementType, (List)ImmutableList.of((Object)arrayExpression, (Object)Expressions.constant((Object)index, (Type)IntegerType.INTEGER)));
    }

    private RowExpression mapSubscript(RowExpression mapExpression, RowExpression keyExpression) {
        MapType mapType = (MapType)mapExpression.getType();
        return Expressions.call((String)OperatorType.SUBSCRIPT.name(), (FunctionHandle)this.operator(OperatorType.SUBSCRIPT, new Type[]{HiveTestUtils.mapType(mapType.getKeyType(), mapType.getValueType()), mapType.getKeyType()}), (Type)mapType.getValueType(), (List)ImmutableList.of((Object)mapExpression, (Object)keyExpression));
    }

    private FunctionHandle operator(OperatorType operatorType, Type ... types) {
        return this.metadata.getFunctionAndTypeManager().resolveOperator(operatorType, TypeSignatureProvider.fromTypes((Type[])types));
    }

    private void assertPredicateTranslates(RowExpression predicate, String subfield, Domain domain) {
        DomainTranslator.ExtractionResult result = this.domainTranslator.fromPredicate(SessionTestUtils.TEST_SESSION.toConnectorSession(), predicate, this.columnExtractor);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)LogicalRowExpressions.TRUE_CONSTANT);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new Subfield(subfield), (Object)domain)));
    }

    private void assertPredicateDoesNotTranslate(RowExpression predicate) {
        DomainTranslator.ExtractionResult result = this.domainTranslator.fromPredicate(SessionTestUtils.TEST_SESSION.toConnectorSession(), predicate, this.columnExtractor);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.all());
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)predicate);
    }

    private RowExpression greaterThan(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.GREATER_THAN, left, right);
    }

    private RowExpression equal(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.EQUAL, left, right);
    }

    private RowExpression between(RowExpression value, RowExpression min, RowExpression max) {
        return Expressions.call((String)OperatorType.BETWEEN.name(), (FunctionHandle)this.metadata.getFunctionAndTypeManager().resolveOperator(OperatorType.BETWEEN, TypeSignatureProvider.fromTypes((Type[])new Type[]{value.getType(), min.getType(), max.getType()})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{value, min, max});
    }

    private RowExpression bigintIn(RowExpression value, List<Long> inList) {
        List arguments = (List)inList.stream().map(argument -> Expressions.constant((Object)argument, (Type)BigintType.BIGINT)).collect(ImmutableList.toImmutableList());
        return this.in(value, arguments);
    }

    private RowExpression in(RowExpression value, List<RowExpression> inList) {
        return new SpecialFormExpression(SpecialFormExpression.Form.IN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.builder().add((Object)value).addAll(inList).build());
    }

    private RowExpression binaryOperator(OperatorType operatorType, RowExpression left, RowExpression right) {
        return Expressions.call((String)operatorType.name(), (FunctionHandle)this.metadata.getFunctionAndTypeManager().resolveOperator(operatorType, TypeSignatureProvider.fromTypes((Type[])new Type[]{left.getType(), right.getType()})), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{left, right});
    }

    private RowExpression bigintLiteral(long value) {
        return Expressions.constant((Object)value, (Type)BigintType.BIGINT);
    }
}

