/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.DwrfTableEncryptionProperties;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDwrfTableEncryptionProperties {
    @Test
    public void testEncryptTable() {
        DwrfTableEncryptionProperties properties = DwrfTableEncryptionProperties.forTable((String)"abcd", (String)"test_algo", (String)"test_prov");
        Assert.assertEquals((Map)properties.toHiveProperties(), (Map)ImmutableMap.of((Object)"encrypt.table", (Object)"abcd", (Object)"dwrf.encryption.provider", (Object)"test_prov", (Object)"dwrf.encryption.algorithm", (Object)"test_algo"));
        Assert.assertEquals((Map)properties.toTableProperties(), (Map)ImmutableMap.of((Object)"encrypt_table", (Object)"abcd", (Object)"dwrf_encryption_provider", (Object)"test_prov", (Object)"dwrf_encryption_algorithm", (Object)"test_algo"));
    }

    @Test
    public void testEncryptColumns() {
        ColumnEncryptionInformation columnEncryptionInformation = ColumnEncryptionInformation.fromMap((Map)ImmutableMap.of((Object)"c1", (Object)"abcd", (Object)"c2", (Object)"defg"));
        DwrfTableEncryptionProperties properties = DwrfTableEncryptionProperties.forPerColumn((ColumnEncryptionInformation)columnEncryptionInformation, (String)"test_algo", (String)"test_prov");
        Assert.assertEquals((Map)properties.toHiveProperties(), (Map)ImmutableMap.of((Object)"encrypt.columns", (Object)columnEncryptionInformation.toHiveProperty(), (Object)"dwrf.encryption.provider", (Object)"test_prov", (Object)"dwrf.encryption.algorithm", (Object)"test_algo"));
        Assert.assertEquals((Map)properties.toTableProperties(), (Map)ImmutableMap.of((Object)"encrypt_columns", (Object)columnEncryptionInformation, (Object)"dwrf_encryption_provider", (Object)"test_prov", (Object)"dwrf_encryption_algorithm", (Object)"test_algo"));
    }

    @Test
    public void testFromHiveTablePropertiesNonePresent() {
        Optional encryptionProperties = DwrfTableEncryptionProperties.fromHiveTableProperties((Map)ImmutableMap.of());
        Assert.assertFalse((boolean)encryptionProperties.isPresent());
    }

    @Test
    public void testFromHiveTablePropertiesTablePresent() {
        ImmutableMap hiveProperties = ImmutableMap.of((Object)"encrypt.table", (Object)"abcd", (Object)"dwrf.encryption.algorithm", (Object)"test_algo", (Object)"dwrf.encryption.provider", (Object)"test_prov");
        Optional encryptionProperties = DwrfTableEncryptionProperties.fromHiveTableProperties((Map)hiveProperties);
        Assert.assertTrue((boolean)encryptionProperties.isPresent());
        Assert.assertEquals((Map)((DwrfTableEncryptionProperties)encryptionProperties.get()).toHiveProperties(), (Map)hiveProperties);
    }

    @Test
    public void testFromHiveTablePropertiesColumnPresent() {
        ImmutableMap hiveProperties = ImmutableMap.of((Object)"encrypt.columns", (Object)"key1:col1", (Object)"dwrf.encryption.algorithm", (Object)"test_algo", (Object)"dwrf.encryption.provider", (Object)"test_prov");
        Optional encryptionProperties = DwrfTableEncryptionProperties.fromHiveTableProperties((Map)hiveProperties);
        Assert.assertTrue((boolean)encryptionProperties.isPresent());
        Assert.assertEquals((Map)((DwrfTableEncryptionProperties)encryptionProperties.get()).toHiveProperties(), (Map)hiveProperties);
    }
}

