/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.Session;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockJsonSerde;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.type.TestingTypeDeserializer;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.tpch.TpchTable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCanonicalPlanGenerator
extends AbstractTestQueryFramework {
    private ObjectMapper objectMapper;

    public TestHiveCanonicalPlanGenerator() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);
        this.objectMapper = new JsonObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer((TypeManager)typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer((BlockEncodingSerde)blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer((BlockEncodingSerde)blockEncodingSerde))).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.LINE_ITEM));
    }

    @Test
    public void testCanonicalizationStrategies() throws Exception {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_orders WITH (partitioned_by = ARRAY['ds', 'ts']) AS SELECT orderkey, orderpriority, comment, custkey, '2020-09-01' as ds, '00:01' as ts FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, comment, custkey, '2020-09-02' as ds, '00:02' as ts FROM orders WHERE orderkey < 1000");
            this.assertSameCanonicalLeafPlan(this.pushdownFilterEnabled(), "SELECT orderkey from test_orders", "SELECT orderkey from test_orders", PlanCanonicalizationStrategy.CONNECTOR);
            this.assertSameCanonicalLeafPlan(this.pushdownFilterEnabled(), "SELECT orderkey from test_orders where ds > '2020-09-01'", "SELECT orderkey from test_orders where ds = '2020-09-02'", PlanCanonicalizationStrategy.CONNECTOR);
            this.assertDifferentCanonicalLeafPlan(this.pushdownFilterEnabled(), "SELECT orderkey from test_orders where ds = '2020-09-01' AND orderkey < 10", "SELECT orderkey from test_orders where ds = '2020-09-02' AND orderkey < 20", PlanCanonicalizationStrategy.CONNECTOR);
            this.assertDifferentCanonicalLeafPlan(this.pushdownFilterEnabled(), "SELECT orderkey from test_orders where ds = '2020-09-01' AND orderkey < 10", "SELECT orderkey from test_orders where ds = '2020-09-02' AND orderkey < 20", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
            this.assertSameCanonicalLeafPlan(this.pushdownFilterEnabled(), "SELECT orderkey, CAST('1' AS VARCHAR) from test_orders where ds = '2020-09-01' AND orderkey < 10 AND ts >= '00:01'", "SELECT orderkey, CAST('11' AS VARCHAR) from test_orders where ds = '2020-09-02' AND orderkey < 10 AND ts >= '00:02'", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_orders");
        }
    }

    @Test
    public void testColumnPredicates() throws Exception {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_column_predicates WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, comment, custkey, '2020-09-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, comment, custkey, '2020-09-02' as ds FROM orders WHERE orderkey < 1000");
            this.assertDifferentCanonicalLeafSubPlan(this.getSession(), "SELECT * FROM test_column_predicates WHERE ds IN ('2020-09-01', '2020-09-02')", "SELECT * FROM test_column_predicates");
            this.assertSameCanonicalLeafSubPlan(this.pushdownFilterEnabled(), "SELECT * FROM test_column_predicates WHERE ds IN ('2020-09-01', '2020-09-02')", "SELECT * FROM test_column_predicates");
            this.assertSameCanonicalLeafSubPlan(this.pushdownFilterEnabled(), "SELECT * FROM test_column_predicates WHERE ds = '2020-09-01'", "SELECT * FROM test_column_predicates WHERE ds = '2020-09-02'");
            this.assertSameCanonicalLeafSubPlan(this.pushdownFilterEnabled(), "SELECT * FROM test_column_predicates WHERE ds = '2020-09-01' AND regexp_like(comment, '.*foo.*')");
            this.assertDifferentCanonicalLeafSubPlan(this.pushdownFilterEnabled(), "SELECT * FROM test_column_predicates WHERE ds = '2020-09-01' AND regexp_like(comment, '.*foo.*')", "SELECT * FROM test_column_predicates WHERE ds = '2020-09-01' AND regexp_like(comment, '.*bar.*')");
            this.assertDifferentCanonicalLeafSubPlan(this.pushdownFilterEnabled(), "SELECT * FROM test_column_predicates WHERE ds = '2020-09-01' AND orderkey < 50", "SELECT * FROM test_column_predicates WHERE ds = '2020-09-01' AND orderkey < 100");
            this.assertDifferentCanonicalLeafSubPlan(this.pushdownFilterEnabled(), "SELECT * FROM test_column_predicates WHERE ds = '2020-09-01' AND orderkey < 50", "SELECT * FROM test_column_predicates WHERE ds = '2020-09-01' AND custkey < 50");
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_column_predicates");
        }
    }

    @Test
    public void testBucketFilter() throws Exception {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_bucket_filter WITH (partitioned_by = ARRAY['ds'], bucketed_by = ARRAY['orderkey'], bucket_count = 11) AS SELECT orderkey, orderpriority, comment, '2020-09-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, comment, '2020-09-02' as ds FROM orders WHERE orderkey < 1000");
            this.assertSameCanonicalLeafSubPlan(this.pushdownFilterEnabled(), "SELECT * FROM test_bucket_filter WHERE ds = '2020-09-01' AND orderkey = 50");
            this.assertDifferentCanonicalLeafSubPlan(this.pushdownFilterEnabled(), "SELECT * FROM test_bucket_filter WHERE ds = '2020-09-01' AND orderkey = 50", "SELECT * FROM test_bucket_filter WHERE ds = '2020-09-01' AND orderkey = 60");
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_bucket_filter");
        }
    }

    private Session pushdownFilterEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").build();
    }

    private static List<SubPlan> getLeafSubPlans(SubPlan subPlan) {
        if (subPlan.getChildren().isEmpty()) {
            return ImmutableList.of((Object)subPlan);
        }
        return (List)subPlan.getChildren().stream().map(TestHiveCanonicalPlanGenerator::getLeafSubPlans).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private void assertSameCanonicalLeafSubPlan(Session session, String sql) throws Exception {
        this.assertSameCanonicalLeafSubPlan(session, sql, sql);
    }

    private void assertSameCanonicalLeafSubPlan(Session session, String sql2, String sql1) throws Exception {
        SubPlan subplan = this.subplan(String.format("( %s ) UNION ALL ( %s )", sql1, sql2), session);
        List leafCanonicalPlans = TestHiveCanonicalPlanGenerator.getLeafSubPlans(subplan).stream().map(SubPlan::getFragment).map(fragment -> CanonicalPlanGenerator.generateCanonicalPlanFragment((PlanNode)fragment.getRoot(), (PartitioningScheme)fragment.getPartitioningScheme(), (ObjectMapper)this.objectMapper)).map(Optional::get).collect(Collectors.toList());
        Assert.assertEquals((int)leafCanonicalPlans.size(), (int)2);
        String s1 = this.objectMapper.writeValueAsString(leafCanonicalPlans.get(0));
        String s2 = this.objectMapper.writeValueAsString(leafCanonicalPlans.get(1));
        Assert.assertEquals((String)s1, (String)s2);
    }

    private void assertDifferentCanonicalLeafSubPlan(Session session, String sql1, String sql2) throws Exception {
        PlanFragment fragment1 = ((SubPlan)Iterables.getOnlyElement(TestHiveCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql1, session)))).getFragment();
        PlanFragment fragment2 = ((SubPlan)Iterables.getOnlyElement(TestHiveCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql2, session)))).getFragment();
        Optional canonicalPlan1 = CanonicalPlanGenerator.generateCanonicalPlanFragment((PlanNode)fragment1.getRoot(), (PartitioningScheme)fragment1.getPartitioningScheme(), (ObjectMapper)this.objectMapper);
        Optional canonicalPlan2 = CanonicalPlanGenerator.generateCanonicalPlanFragment((PlanNode)fragment2.getRoot(), (PartitioningScheme)fragment2.getPartitioningScheme(), (ObjectMapper)this.objectMapper);
        Assert.assertTrue((boolean)canonicalPlan1.isPresent());
        Assert.assertTrue((boolean)canonicalPlan2.isPresent());
        Assert.assertNotEquals((Object)this.objectMapper.writeValueAsString((Object)canonicalPlan1), (Object)this.objectMapper.writeValueAsString((Object)canonicalPlan2));
    }

    private void assertDifferentCanonicalLeafPlan(Session session, String sql1, String sql2, PlanCanonicalizationStrategy strategy) throws Exception {
        PlanFragment fragment1 = ((SubPlan)Iterables.getOnlyElement(TestHiveCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql1, session)))).getFragment();
        PlanFragment fragment2 = ((SubPlan)Iterables.getOnlyElement(TestHiveCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql2, session)))).getFragment();
        Optional canonicalPlan1 = CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment1.getRoot(), (PlanCanonicalizationStrategy)strategy, (ObjectMapper)this.objectMapper);
        Optional canonicalPlan2 = CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment2.getRoot(), (PlanCanonicalizationStrategy)strategy, (ObjectMapper)this.objectMapper);
        Assert.assertTrue((boolean)canonicalPlan1.isPresent());
        Assert.assertTrue((boolean)canonicalPlan2.isPresent());
        Assert.assertNotEquals((Object)this.objectMapper.writeValueAsString((Object)canonicalPlan1), (Object)this.objectMapper.writeValueAsString((Object)canonicalPlan2));
    }

    private void assertSameCanonicalLeafPlan(Session session, String sql1, String sql2, PlanCanonicalizationStrategy strategy) throws Exception {
        PlanFragment fragment1 = ((SubPlan)Iterables.getOnlyElement(TestHiveCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql1, session)))).getFragment();
        PlanFragment fragment2 = ((SubPlan)Iterables.getOnlyElement(TestHiveCanonicalPlanGenerator.getLeafSubPlans(this.subplan(sql2, session)))).getFragment();
        Optional canonicalPlan1 = CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment1.getRoot(), (PlanCanonicalizationStrategy)strategy, (ObjectMapper)this.objectMapper);
        Optional canonicalPlan2 = CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)fragment2.getRoot(), (PlanCanonicalizationStrategy)strategy, (ObjectMapper)this.objectMapper);
        Assert.assertTrue((boolean)canonicalPlan1.isPresent());
        Assert.assertTrue((boolean)canonicalPlan2.isPresent());
        Assert.assertEquals((String)this.objectMapper.writeValueAsString((Object)canonicalPlan1), (String)this.objectMapper.writeValueAsString((Object)canonicalPlan2));
    }
}

