/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.Session;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockJsonSerde;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.type.TestingTypeDeserializer;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.sql.planner.CanonicalPlanGenerator;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Traverser;
import io.airlift.tpch.TpchTable;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCanonicalPlanHashes
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.LINE_ITEM));
    }

    protected ObjectMapper createObjectMapper() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde(new BlockEncoding[0]);
        return new JsonObjectMapperProvider().get().registerModule((Module)new SimpleModule().addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer((TypeManager)typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer((BlockEncodingSerde)blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer((BlockEncodingSerde)blockEncodingSerde))).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }

    @Test
    public void testCanonicalizationStrategies() throws Exception {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_orders WITH (partitioned_by = ARRAY['ds', 'ts']) AS SELECT orderkey, orderpriority, comment, custkey, '2020-09-01' as ds, '00:01' as ts FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, comment, custkey, '2020-09-02' as ds, '00:02' as ts FROM orders WHERE orderkey < 1000");
            this.assertSamePlanHash("SELECT orderkey from test_orders", "SELECT orderkey from test_orders", PlanCanonicalizationStrategy.CONNECTOR);
            this.assertSamePlanHash("SELECT orderkey from test_orders where ds > '2020-09-01'", "SELECT orderkey from test_orders where ds = '2020-09-02'", PlanCanonicalizationStrategy.CONNECTOR);
            this.assertSamePlanHash("SELECT orderkey from test_orders where ds = '2020-09-01' AND orderkey < 10 AND ts >= '00:01'", "SELECT orderkey from test_orders where ds = '2020-09-02' AND orderkey < 10 AND ts >= '00:02'", PlanCanonicalizationStrategy.CONNECTOR);
            this.assertDifferentPlanHash("SELECT orderkey from test_orders where ds = '2020-09-01' AND orderkey < 10", "SELECT orderkey from test_orders where ds = '2020-09-02' AND orderkey < 20", PlanCanonicalizationStrategy.CONNECTOR);
            this.assertSamePlanHash("SELECT orderkey, CAST(1 AS VARCHAR) from test_orders where ds = '2020-09-01' AND orderkey < 10", "SELECT orderkey, CAST(2 AS VARCHAR) from test_orders where ds = '2020-09-02' AND orderkey < 10", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
            this.assertDifferentPlanHash("SELECT orderkey, CAST(1 AS VARCHAR) from test_orders where ds = '2020-09-01' AND orderkey < 10", "SELECT orderkey, CAST(1 AS VARCHAR) from test_orders where ds = '2020-09-02' AND orderkey < 20", PlanCanonicalizationStrategy.REMOVE_SAFE_CONSTANTS);
            this.assertSamePlanHash("INSERT INTO test_orders select * from test_orders", "INSERT INTO test_orders select * from test_orders", PlanCanonicalizationStrategy.CONNECTOR);
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_orders");
        }
    }

    @Test
    public void testStatsEquivalentNodeMarking() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_orders_2 WITH (partitioned_by = ARRAY['ds', 'ts']) AS SELECT orderkey, orderpriority, comment, custkey, '2020-09-01' as ds, '00:01' as ts FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, comment, custkey, '2020-09-02' as ds, '00:02' as ts FROM orders WHERE orderkey < 1000");
            List<PlanNode> nodes = this.getStatsEquivalentPlanHashes("SELECT COUNT(comment) FROM test_orders_2 WHERE ds = '2020-09-01' and orderkey < 500 GROUP BY custkey");
            Assert.assertTrue((boolean)nodes.stream().anyMatch(node -> node instanceof AggregationNode));
            Assert.assertTrue((boolean)nodes.stream().anyMatch(node -> node instanceof TableScanNode));
            Assert.assertTrue((boolean)nodes.stream().anyMatch(node -> node instanceof ProjectNode));
            Assert.assertTrue((boolean)nodes.stream().noneMatch(node -> node instanceof FilterNode));
            Assert.assertEquals((int)nodes.size(), (int)4);
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_orders_2");
        }
    }

    private void assertSamePlanHash(String sql1, String sql2, PlanCanonicalizationStrategy strategy) throws Exception {
        String hashes1 = this.getPlanHash(sql1, strategy);
        String hashes2 = this.getPlanHash(sql2, strategy);
        Assert.assertEquals((String)hashes1, (String)hashes2);
    }

    private void assertDifferentPlanHash(String sql1, String sql2, PlanCanonicalizationStrategy strategy) throws Exception {
        String hashes1 = this.getPlanHash(sql1, strategy);
        String hashes2 = this.getPlanHash(sql2, strategy);
        Assert.assertNotEquals((Object)hashes1, (Object)hashes2);
    }

    private String getPlanHash(String sql, PlanCanonicalizationStrategy strategy) throws Exception {
        Session session = this.createSession();
        PlanNode plan = this.plan(sql, session).getRoot();
        ObjectMapper objectMapper = this.createObjectMapper();
        Assert.assertTrue((boolean)plan.getStatsEquivalentPlanNode().isPresent());
        return objectMapper.writeValueAsString(CanonicalPlanGenerator.generateCanonicalPlan((PlanNode)((PlanNode)plan.getStatsEquivalentPlanNode().get()), (PlanCanonicalizationStrategy)strategy, (ObjectMapper)objectMapper).get());
    }

    private List<PlanNode> getStatsEquivalentPlanHashes(String sql) {
        Session session = this.createSession();
        PlanNode root = this.plan(sql, session).getRoot();
        Assert.assertTrue((boolean)root.getStatsEquivalentPlanNode().isPresent());
        ImmutableList.Builder result = ImmutableList.builder();
        Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root).forEach(node -> node.getStatsEquivalentPlanNode().ifPresent(arg_0 -> ((ImmutableList.Builder)result).add(arg_0)));
        return result.build();
    }

    private Session createSession() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_history_based_plan_statistics", "true").setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").build();
    }
}

