/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.testing.ConfigAssertions;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.presto.hive.BucketFunctionType;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.TestHiveUtil;
import com.facebook.presto.hive.s3.S3FileSystemType;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestHiveClientConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HiveClientConfig)ConfigAssertions.recordDefaults(HiveClientConfig.class)).setTimeZone(TimeZone.getDefault().getID()).setMaxSplitSize(new DataSize(64.0, DataSize.Unit.MEGABYTE)).setMaxPartitionsPerScan(100000).setMaxOutstandingSplits(1000).setMaxOutstandingSplitsSize(new DataSize(256.0, DataSize.Unit.MEGABYTE)).setMaxSplitIteratorThreads(1000).setAllowCorruptWritesForTesting(false).setMinPartitionBatchSize(10).setMaxPartitionBatchSize(100).setMaxInitialSplits(200).setMaxInitialSplitSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setSplitLoaderConcurrency(4).setDomainCompactionThreshold(100).setWriterSortBufferSize(new DataSize(64.0, DataSize.Unit.MEGABYTE)).setNodeSelectionStrategy(NodeSelectionStrategy.valueOf((String)"NO_PREFERENCE")).setMaxConcurrentFileRenames(20).setMaxConcurrentZeroRowFileCreations(20).setRecursiveDirWalkerEnabled(false).setDfsTimeout(new Duration(60.0, TimeUnit.SECONDS)).setIpcPingInterval(new Duration(10.0, TimeUnit.SECONDS)).setDfsConnectTimeout(new Duration(500.0, TimeUnit.MILLISECONDS)).setDfsConnectMaxRetries(5).setDomainSocketPath(null).setS3FileSystemType(S3FileSystemType.PRESTO).setResourceConfigFiles("").setHiveStorageFormat(HiveStorageFormat.ORC).setCompressionCodec(HiveCompressionCodec.GZIP).setOrcCompressionCodec(HiveCompressionCodec.GZIP).setRespectTableFormat(true).setImmutablePartitions(false).setInsertExistingPartitionsBehavior(HiveClientConfig.InsertExistingPartitionsBehavior.APPEND).setCreateEmptyBucketFiles(true).setInsertOverwriteImmutablePartitionEnabled(false).setFailFastOnInsertIntoImmutablePartitionsEnabled(true).setSortedWritingEnabled(true).setMaxPartitionsPerWriter(100).setMaxOpenSortFiles(50).setWriteValidationThreads(16).setTextMaxLineLength(new DataSize(100.0, DataSize.Unit.MEGABYTE)).setUseParquetColumnNames(false).setParquetMaxReadBlockSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setUseOrcColumnNames(false).setAssumeCanonicalPartitionKeys(false).setOrcBloomFiltersEnabled(false).setOrcDefaultBloomFilterFpp(0.05).setOrcMaxMergeDistance(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setOrcMaxBufferSize(new DataSize(8.0, DataSize.Unit.MEGABYTE)).setOrcStreamBufferSize(new DataSize(8.0, DataSize.Unit.MEGABYTE)).setOrcTinyStripeThreshold(new DataSize(8.0, DataSize.Unit.MEGABYTE)).setOrcMaxReadBlockSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setOrcLazyReadSmallRanges(true).setRcfileOptimizedWriterEnabled(true).setRcfileWriterValidate(false).setOrcOptimizedWriterEnabled(true).setOrcWriterValidationPercentage(0.0).setOrcWriterValidationMode(OrcWriteValidation.OrcWriteValidationMode.BOTH).setHdfsAuthenticationType(HiveClientConfig.HdfsAuthenticationType.NONE).setHdfsImpersonationEnabled(false).setSkipDeletionForAlter(false).setSkipTargetCleanupOnRollback(false).setBucketExecutionEnabled(true).setIgnoreTableBucketing(false).setMinBucketCountToNotIgnoreTableBucketing(0).setMaxBucketsForGroupedExecution(1000000).setSortedWriteToTempPathEnabled(false).setSortedWriteTempPathSubdirectoryCount(10).setFileSystemMaxCacheSize(1000).setTableStatisticsEnabled(true).setOptimizeMismatchedBucketCount(false).setWritesToNonManagedTablesEnabled(false).setCreatesOfNonManagedTablesEnabled(true).setHdfsWireEncryptionEnabled(false).setPartitionStatisticsSampleSize(100).setIgnoreCorruptedStatistics(false).setCollectColumnStatisticsOnWrite(false).setPartitionStatisticsBasedOptimizationEnabled(false).setS3SelectPushdownEnabled(false).setS3SelectPushdownMaxConnections(500).setOrderBasedExecutionEnabled(false).setTemporaryStagingDirectoryEnabled(true).setTemporaryStagingDirectoryPath("/tmp/presto-${USER}").setTemporaryTableSchema("default").setTemporaryTableStorageFormat(HiveStorageFormat.ORC).setTemporaryTableCompressionCodec(HiveCompressionCodec.SNAPPY).setCreateEmptyBucketFilesForTemporaryTable(false).setUsePageFileForHiveUnsupportedType(true).setPushdownFilterEnabled(false).setParquetPushdownFilterEnabled(false).setZstdJniDecompressionEnabled(false).setRangeFiltersOnSubscriptsEnabled(false).setAdaptiveFilterReorderingEnabled(true).setFileStatusCacheExpireAfterWrite(new Duration(0.0, TimeUnit.SECONDS)).setFileStatusCacheMaxSize(0L).setFileStatusCacheTables("").setPageFileStripeMaxSize(new DataSize(24.0, DataSize.Unit.MEGABYTE)).setParquetBatchReaderVerificationEnabled(false).setParquetBatchReadOptimizationEnabled(false).setBucketFunctionTypeForExchange(BucketFunctionType.HIVE_COMPATIBLE).setParquetDereferencePushdownEnabled(false).setIgnoreUnreadablePartition(false).setMaxMetadataUpdaterThreads(100).setPartialAggregationPushdownEnabled(false).setPartialAggregationPushdownForVariableLengthDatatypesEnabled(false).setFileRenamingEnabled(false).setPreferManifestsToListFiles(false).setManifestVerificationEnabled(false).setUndoMetastoreOperationsEnabled(true).setOptimizedPartitionUpdateSerializationEnabled(false).setVerboseRuntimeStatsEnabled(false).setPartitionLeaseDuration(new Duration(0.0, TimeUnit.SECONDS)).setMaterializedViewMissingPartitionsThreshold(100).setLooseMemoryAccountingEnabled(false).setReadColumnIndexFilter(false).setSizeBasedSplitWeightsEnabled(true).setMinimumAssignedSplitWeight(0.05).setUserDefinedTypeEncodingEnabled(false).setUseRecordPageSourceForCustomSplit(true).setFileSplittable(true).setHudiMetadataEnabled(false).setThriftProtocol(Protocol.BINARY).setThriftBufferSize(new DataSize(128.0, DataSize.Unit.BYTE)).setReadNullMaskedParquetEncryptedValue(false).setCopyOnFirstWriteConfigurationEnabled(true).setPartitionFilteringFromMetastoreEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"hive.time-zone", (Object)TestHiveUtil.nonDefaultTimeZone().getID()).put((Object)"hive.max-split-size", (Object)"256MB").put((Object)"hive.max-partitions-per-scan", (Object)"123").put((Object)"hive.max-outstanding-splits", (Object)"10").put((Object)"hive.max-outstanding-splits-size", (Object)"32MB").put((Object)"hive.max-split-iterator-threads", (Object)"10").put((Object)"hive.allow-corrupt-writes-for-testing", (Object)"true").put((Object)"hive.metastore.partition-batch-size.min", (Object)"1").put((Object)"hive.metastore.partition-batch-size.max", (Object)"1000").put((Object)"hive.dfs.ipc-ping-interval", (Object)"34s").put((Object)"hive.dfs-timeout", (Object)"33s").put((Object)"hive.dfs.connect.timeout", (Object)"20s").put((Object)"hive.dfs.connect.max-retries", (Object)"10").put((Object)"hive.dfs.domain-socket-path", (Object)"/foo").put((Object)"hive.s3-file-system-type", (Object)"EMRFS").put((Object)"hive.config.resources", (Object)"/foo.xml,/bar.xml").put((Object)"hive.max-initial-splits", (Object)"10").put((Object)"hive.max-initial-split-size", (Object)"16MB").put((Object)"hive.split-loader-concurrency", (Object)"1").put((Object)"hive.domain-compaction-threshold", (Object)"42").put((Object)"hive.writer-sort-buffer-size", (Object)"13MB").put((Object)"hive.recursive-directories", (Object)"true").put((Object)"hive.storage-format", (Object)"SEQUENCEFILE").put((Object)"hive.compression-codec", (Object)"NONE").put((Object)"hive.orc-compression-codec", (Object)"ZSTD").put((Object)"hive.respect-table-format", (Object)"false").put((Object)"hive.immutable-partitions", (Object)"true").put((Object)"hive.insert-existing-partitions-behavior", (Object)"OVERWRITE").put((Object)"hive.create-empty-bucket-files", (Object)"false").put((Object)"hive.insert-overwrite-immutable-partitions-enabled", (Object)"true").put((Object)"hive.fail-fast-on-insert-into-immutable-partitions-enabled", (Object)"false").put((Object)"hive.max-partitions-per-writers", (Object)"222").put((Object)"hive.max-open-sort-files", (Object)"333").put((Object)"hive.write-validation-threads", (Object)"11").put((Object)"hive.node-selection-strategy", (Object)"HARD_AFFINITY").put((Object)"hive.max-concurrent-file-renames", (Object)"100").put((Object)"hive.max-concurrent-zero-row-file-creations", (Object)"100").put((Object)"hive.assume-canonical-partition-keys", (Object)"true").put((Object)"hive.text.max-line-length", (Object)"13MB").put((Object)"hive.parquet.use-column-names", (Object)"true").put((Object)"hive.parquet.max-read-block-size", (Object)"66kB").put((Object)"hive.orc.use-column-names", (Object)"true").put((Object)"hive.orc.bloom-filters.enabled", (Object)"true").put((Object)"hive.orc.default-bloom-filter-fpp", (Object)"0.96").put((Object)"hive.orc.max-merge-distance", (Object)"22kB").put((Object)"hive.orc.max-buffer-size", (Object)"44kB").put((Object)"hive.orc.stream-buffer-size", (Object)"55kB").put((Object)"hive.orc.tiny-stripe-threshold", (Object)"61kB").put((Object)"hive.orc.max-read-block-size", (Object)"66kB").put((Object)"hive.orc.lazy-read-small-ranges", (Object)"false").put((Object)"hive.rcfile-optimized-writer.enabled", (Object)"false").put((Object)"hive.rcfile.writer.validate", (Object)"true").put((Object)"hive.orc.optimized-writer.enabled", (Object)"false").put((Object)"hive.orc.writer.validation-percentage", (Object)"0.16").put((Object)"hive.orc.writer.validation-mode", (Object)"DETAILED").put((Object)"hive.hdfs.authentication.type", (Object)"KERBEROS").put((Object)"hive.hdfs.impersonation.enabled", (Object)"true").put((Object)"hive.skip-deletion-for-alter", (Object)"true").put((Object)"hive.skip-target-cleanup-on-rollback", (Object)"true").put((Object)"hive.bucket-execution", (Object)"false").put((Object)"hive.sorted-writing", (Object)"false").put((Object)"hive.ignore-table-bucketing", (Object)"true").put((Object)"hive.min-bucket-count-to-not-ignore-table-bucketing", (Object)"1024").put((Object)"hive.max-buckets-for-grouped-execution", (Object)"100").put((Object)"hive.sorted-write-to-temp-path-enabled", (Object)"true").put((Object)"hive.sorted-write-temp-path-subdirectory-count", (Object)"50").put((Object)"hive.fs.cache.max-size", (Object)"1010").put((Object)"hive.table-statistics-enabled", (Object)"false").put((Object)"hive.optimize-mismatched-bucket-count", (Object)"true").put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").put((Object)"hive.non-managed-table-creates-enabled", (Object)"false").put((Object)"hive.hdfs.wire-encryption.enabled", (Object)"true").put((Object)"hive.partition-statistics-sample-size", (Object)"1234").put((Object)"hive.ignore-corrupted-statistics", (Object)"true").put((Object)"hive.collect-column-statistics-on-write", (Object)"true").put((Object)"hive.partition-statistics-based-optimization-enabled", (Object)"true").put((Object)"hive.s3select-pushdown.enabled", (Object)"true").put((Object)"hive.s3select-pushdown.max-connections", (Object)"1234").put((Object)"hive.order-based-execution-enabled", (Object)"true").put((Object)"hive.temporary-staging-directory-enabled", (Object)"false").put((Object)"hive.temporary-staging-directory-path", (Object)"updated").put((Object)"hive.temporary-table-schema", (Object)"other").put((Object)"hive.temporary-table-storage-format", (Object)"DWRF").put((Object)"hive.temporary-table-compression-codec", (Object)"NONE").put((Object)"hive.create-empty-bucket-files-for-temporary-table", (Object)"true").put((Object)"hive.use-pagefile-for-hive-unsupported-type", (Object)"false").put((Object)"hive.pushdown-filter-enabled", (Object)"true").put((Object)"hive.parquet.pushdown-filter-enabled", (Object)"true").put((Object)"hive.range-filters-on-subscripts-enabled", (Object)"true").put((Object)"hive.adaptive-filter-reordering-enabled", (Object)"false").put((Object)"hive.zstd-jni-decompression-enabled", (Object)"true").put((Object)"hive.file-status-cache-tables", (Object)"foo.bar1, foo.bar2").put((Object)"hive.file-status-cache-size", (Object)"1000").put((Object)"hive.file-status-cache-expire-time", (Object)"30m").put((Object)"hive.pagefile.writer.stripe-max-size", (Object)"1kB").put((Object)"hive.parquet-batch-read-optimization-enabled", (Object)"true").put((Object)"hive.enable-parquet-batch-reader-verification", (Object)"true").put((Object)"hive.bucket-function-type-for-exchange", (Object)"PRESTO_NATIVE").put((Object)"hive.enable-parquet-dereference-pushdown", (Object)"true").put((Object)"hive.ignore-unreadable-partition", (Object)"true").put((Object)"hive.max-metadata-updater-threads", (Object)"1000").put((Object)"hive.partial_aggregation_pushdown_enabled", (Object)"true").put((Object)"hive.partial_aggregation_pushdown_for_variable_length_datatypes_enabled", (Object)"true").put((Object)"hive.file_renaming_enabled", (Object)"true").put((Object)"hive.prefer-manifests-to-list-files", (Object)"true").put((Object)"hive.manifest-verification-enabled", (Object)"true").put((Object)"hive.undo-metastore-operations-enabled", (Object)"false").put((Object)"hive.experimental-optimized-partition-update-serialization-enabled", (Object)"true").put((Object)"hive.partition-lease-duration", (Object)"4h").put((Object)"hive.loose-memory-accounting-enabled", (Object)"true").put((Object)"hive.verbose-runtime-stats-enabled", (Object)"true").put((Object)"hive.materialized-view-missing-partitions-threshold", (Object)"50").put((Object)"hive.parquet-column-index-filter-enabled", (Object)"true").put((Object)"hive.size-based-split-weights-enabled", (Object)"false").put((Object)"hive.user-defined-type-encoding-enabled", (Object)"true").put((Object)"hive.minimum-assigned-split-weight", (Object)"1.0").put((Object)"hive.use-record-page-source-for-custom-split", (Object)"false").put((Object)"hive.file-splittable", (Object)"false").put((Object)"hive.hudi-metadata-enabled", (Object)"true").put((Object)"hive.internal-communication.thrift-transport-protocol", (Object)"COMPACT").put((Object)"hive.internal-communication.thrift-transport-buffer-size", (Object)"256B").put((Object)"hive.read-null-masked-parquet-encrypted-value-enabled", (Object)"true").put((Object)"hive.copy-on-first-write-configuration-enabled", (Object)"false").put((Object)"hive.partition-filtering-from-metastore-enabled", (Object)"false").build();
        HiveClientConfig expected = new HiveClientConfig().setTimeZone(TimeZone.getTimeZone(ZoneId.of(TestHiveUtil.nonDefaultTimeZone().getID())).getID()).setMaxSplitSize(new DataSize(256.0, DataSize.Unit.MEGABYTE)).setMaxPartitionsPerScan(123).setMaxOutstandingSplits(10).setMaxOutstandingSplitsSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setMaxSplitIteratorThreads(10).setAllowCorruptWritesForTesting(true).setMinPartitionBatchSize(1).setMaxPartitionBatchSize(1000).setMaxInitialSplits(10).setMaxInitialSplitSize(new DataSize(16.0, DataSize.Unit.MEGABYTE)).setSplitLoaderConcurrency(1).setDomainCompactionThreshold(42).setWriterSortBufferSize(new DataSize(13.0, DataSize.Unit.MEGABYTE)).setNodeSelectionStrategy(NodeSelectionStrategy.HARD_AFFINITY).setMaxConcurrentFileRenames(100).setMaxConcurrentZeroRowFileCreations(100).setRecursiveDirWalkerEnabled(true).setIpcPingInterval(new Duration(34.0, TimeUnit.SECONDS)).setDfsTimeout(new Duration(33.0, TimeUnit.SECONDS)).setDfsConnectTimeout(new Duration(20.0, TimeUnit.SECONDS)).setDfsConnectMaxRetries(10).setResourceConfigFiles((List)ImmutableList.of((Object)"/foo.xml", (Object)"/bar.xml")).setHiveStorageFormat(HiveStorageFormat.SEQUENCEFILE).setCompressionCodec(HiveCompressionCodec.NONE).setOrcCompressionCodec(HiveCompressionCodec.ZSTD).setRespectTableFormat(false).setImmutablePartitions(true).setCreateEmptyBucketFiles(false).setInsertOverwriteImmutablePartitionEnabled(true).setFailFastOnInsertIntoImmutablePartitionsEnabled(false).setMaxPartitionsPerWriter(222).setMaxOpenSortFiles(333).setWriteValidationThreads(11).setDomainSocketPath("/foo").setS3FileSystemType(S3FileSystemType.EMRFS).setTextMaxLineLength(new DataSize(13.0, DataSize.Unit.MEGABYTE)).setUseParquetColumnNames(true).setParquetMaxReadBlockSize(new DataSize(66.0, DataSize.Unit.KILOBYTE)).setUseOrcColumnNames(true).setAssumeCanonicalPartitionKeys(true).setOrcBloomFiltersEnabled(true).setOrcDefaultBloomFilterFpp(0.96).setOrcMaxMergeDistance(new DataSize(22.0, DataSize.Unit.KILOBYTE)).setOrcMaxBufferSize(new DataSize(44.0, DataSize.Unit.KILOBYTE)).setOrcStreamBufferSize(new DataSize(55.0, DataSize.Unit.KILOBYTE)).setOrcTinyStripeThreshold(new DataSize(61.0, DataSize.Unit.KILOBYTE)).setOrcMaxReadBlockSize(new DataSize(66.0, DataSize.Unit.KILOBYTE)).setOrcLazyReadSmallRanges(false).setRcfileOptimizedWriterEnabled(false).setRcfileWriterValidate(true).setOrcOptimizedWriterEnabled(false).setOrcWriterValidationPercentage(0.16).setOrcWriterValidationMode(OrcWriteValidation.OrcWriteValidationMode.DETAILED).setHdfsAuthenticationType(HiveClientConfig.HdfsAuthenticationType.KERBEROS).setHdfsImpersonationEnabled(true).setSkipDeletionForAlter(true).setSkipTargetCleanupOnRollback(true).setBucketExecutionEnabled(false).setSortedWritingEnabled(false).setIgnoreTableBucketing(true).setMaxBucketsForGroupedExecution(100).setSortedWriteToTempPathEnabled(true).setSortedWriteTempPathSubdirectoryCount(50).setFileSystemMaxCacheSize(1010).setTableStatisticsEnabled(false).setOptimizeMismatchedBucketCount(true).setWritesToNonManagedTablesEnabled(true).setCreatesOfNonManagedTablesEnabled(false).setHdfsWireEncryptionEnabled(true).setPartitionStatisticsSampleSize(1234).setIgnoreCorruptedStatistics(true).setMinBucketCountToNotIgnoreTableBucketing(1024).setCollectColumnStatisticsOnWrite(true).setPartitionStatisticsBasedOptimizationEnabled(true).setS3SelectPushdownEnabled(true).setS3SelectPushdownMaxConnections(1234).setOrderBasedExecutionEnabled(true).setTemporaryStagingDirectoryEnabled(false).setTemporaryStagingDirectoryPath("updated").setTemporaryTableSchema("other").setTemporaryTableStorageFormat(HiveStorageFormat.DWRF).setTemporaryTableCompressionCodec(HiveCompressionCodec.NONE).setCreateEmptyBucketFilesForTemporaryTable(true).setUsePageFileForHiveUnsupportedType(false).setPushdownFilterEnabled(true).setParquetPushdownFilterEnabled(true).setZstdJniDecompressionEnabled(true).setRangeFiltersOnSubscriptsEnabled(true).setAdaptiveFilterReorderingEnabled(false).setFileStatusCacheTables("foo.bar1,foo.bar2").setFileStatusCacheMaxSize(1000L).setFileStatusCacheExpireAfterWrite(new Duration(30.0, TimeUnit.MINUTES)).setPageFileStripeMaxSize(new DataSize(1.0, DataSize.Unit.KILOBYTE)).setParquetBatchReaderVerificationEnabled(true).setParquetBatchReadOptimizationEnabled(true).setBucketFunctionTypeForExchange(BucketFunctionType.PRESTO_NATIVE).setParquetDereferencePushdownEnabled(true).setIgnoreUnreadablePartition(true).setMaxMetadataUpdaterThreads(1000).setPartialAggregationPushdownEnabled(true).setPartialAggregationPushdownForVariableLengthDatatypesEnabled(true).setFileRenamingEnabled(true).setPreferManifestsToListFiles(true).setManifestVerificationEnabled(true).setUndoMetastoreOperationsEnabled(false).setOptimizedPartitionUpdateSerializationEnabled(true).setVerboseRuntimeStatsEnabled(true).setPartitionLeaseDuration(new Duration(4.0, TimeUnit.HOURS)).setMaterializedViewMissingPartitionsThreshold(50).setLooseMemoryAccountingEnabled(true).setReadColumnIndexFilter(true).setSizeBasedSplitWeightsEnabled(false).setMinimumAssignedSplitWeight(1.0).setUserDefinedTypeEncodingEnabled(true).setUseRecordPageSourceForCustomSplit(false).setFileSplittable(false).setHudiMetadataEnabled(true).setThriftProtocol(Protocol.COMPACT).setThriftBufferSize(new DataSize(256.0, DataSize.Unit.BYTE)).setReadNullMaskedParquetEncryptedValue(true).setCopyOnFirstWriteConfigurationEnabled(false).setPartitionFilteringFromMetastoreEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

