/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveEncryptionInformationProvider;
import com.facebook.presto.hive.HiveFileRenamer;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveLocationService;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionObjectBuilder;
import com.facebook.presto.hive.HivePartitionStats;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStagingFileCommitter;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveZeroRowFileCreator;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.PartitionObjectBuilder;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ZeroRowFileCreator;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.datasink.OutputStreamDataSinkFactory;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.MetastoreOperationResult;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.UnimplementedHiveMetastore;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorCommitHandle;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCommitHandleOutput {
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final Map<String, Object> testTableProperties;
    private static ConnectorTableMetadata testTableMetadata;

    @Test
    public void testCommitOutputForTable() {
        TestingExtendedHiveMetastore metastore = new TestingExtendedHiveMetastore();
        HiveClientConfig hiveClientConfig = new HiveClientConfig().setPartitionStatisticsBasedOptimizationEnabled(true);
        ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10, Threads.daemonThreadsNamed((String)"test-hive-commit-handle-%s")));
        TestingConnectorSession connectorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setPartitionStatisticsBasedOptimizationEnabled(true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        HiveMetadata hiveMeta = this.getHiveMetadata(metastore, hiveClientConfig, listeningExecutor);
        hiveMeta.createTable((ConnectorSession)connectorSession, testTableMetadata, false);
        ConnectorCommitHandle handle = hiveMeta.commit();
        Assert.assertEquals((String)handle.getSerializedCommitOutputForRead(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (String)"");
        Assert.assertFalse((boolean)handle.getSerializedCommitOutputForWrite(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)).isEmpty());
        hiveMeta = this.getHiveMetadata(metastore, hiveClientConfig, listeningExecutor);
        HiveTableHandle hiveTableHandle = new HiveTableHandle(TEST_SCHEMA, TEST_TABLE, Optional.empty());
        hiveMeta.getTableMetadata((ConnectorSession)connectorSession, (ConnectorTableHandle)hiveTableHandle);
        handle = hiveMeta.commit();
        Assert.assertEquals((String)handle.getSerializedCommitOutputForRead(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (String)"");
        Assert.assertEquals((String)handle.getSerializedCommitOutputForWrite(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (String)"");
    }

    @Test
    public void testCommitOutputForPartitions() {
        TestingExtendedHiveMetastore metastore = new TestingExtendedHiveMetastore();
        HiveClientConfig hiveClientConfig = new HiveClientConfig().setPartitionStatisticsBasedOptimizationEnabled(true);
        ListeningExecutorService listeningExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10, Threads.daemonThreadsNamed((String)"test-hive-commit-handle-%s")));
        HiveMetadata hiveMeta = this.getHiveMetadata(metastore, hiveClientConfig, listeningExecutor);
        TestingConnectorSession connectorSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setPartitionStatisticsBasedOptimizationEnabled(true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        hiveMeta.createTable((ConnectorSession)connectorSession, testTableMetadata, false);
        ConnectorCommitHandle handle = hiveMeta.commit();
        Assert.assertEquals((String)handle.getSerializedCommitOutputForRead(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (String)"");
        Assert.assertFalse((boolean)handle.getSerializedCommitOutputForWrite(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)).isEmpty());
        hiveMeta = this.getHiveMetadata(metastore, hiveClientConfig, listeningExecutor);
        String partitionName = "a=1";
        hiveMeta.getMetastore().addPartition((ConnectorSession)connectorSession, TEST_SCHEMA, TEST_TABLE, "random_table_path", false, this.createPartition(partitionName, "location1"), new Path("/test_table"), PartitionStatistics.empty());
        handle = hiveMeta.commit();
        Assert.assertEquals((String)handle.getSerializedCommitOutputForRead(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (String)"");
        Assert.assertFalse((boolean)handle.getSerializedCommitOutputForWrite(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)).isEmpty());
        String serializedCommitOutput = handle.getSerializedCommitOutputForWrite(new SchemaTableName(TEST_SCHEMA, TEST_TABLE));
        hiveMeta = this.getHiveMetadata(metastore, hiveClientConfig, listeningExecutor);
        Map partitions = hiveMeta.getMetastore().getPartitionsByNames(new MetastoreContext(connectorSession.getUser(), connectorSession.getQueryId(), Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER), TEST_SCHEMA, TEST_TABLE, (List)ImmutableList.of((Object)partitionName));
        handle = hiveMeta.commit();
        Optional partition = (Optional)partitions.get(partitionName);
        Assert.assertTrue((boolean)partition.isPresent());
        Assert.assertEquals((String)handle.getSerializedCommitOutputForRead(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (String)Long.toString(((Partition)partition.get()).getLastDataCommitTime()));
        Assert.assertEquals((String)handle.getSerializedCommitOutputForRead(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (String)serializedCommitOutput);
        Assert.assertTrue((boolean)handle.getSerializedCommitOutputForWrite(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)).isEmpty());
        hiveMeta = this.getHiveMetadata(metastore, hiveClientConfig, listeningExecutor);
        hiveMeta.getMetastore().addPartition((ConnectorSession)connectorSession, TEST_SCHEMA, TEST_TABLE, "random_table_path", false, this.createPartition(partitionName, "location2"), new Path("/test_table"), PartitionStatistics.empty());
        handle = hiveMeta.commit();
        Assert.assertEquals((String)handle.getSerializedCommitOutputForRead(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)), (String)"");
        Assert.assertFalse((boolean)handle.getSerializedCommitOutputForWrite(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)).isEmpty());
        Assert.assertTrue((boolean)handle.getSerializedCommitOutputForWrite(new SchemaTableName(TEST_SCHEMA, TEST_TABLE)).equals(serializedCommitOutput));
    }

    private HiveMetadata getHiveMetadata(TestingExtendedHiveMetastore metastore, HiveClientConfig hiveClientConfig, ListeningExecutorService listeningExecutor) {
        TestingHdfsEnvironment hdfsEnvironment = new TestingHdfsEnvironment((List<LocatedFileStatus>)ImmutableList.of());
        HiveMetadataFactory hiveMetadataFactory = new HiveMetadataFactory((ExtendedHiveMetastore)metastore, (HdfsEnvironment)hdfsEnvironment, new HivePartitionManager((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, hiveClientConfig), DateTimeZone.forOffsetHours((int)1), true, false, false, false, true, true, hiveClientConfig.getMaxPartitionBatchSize(), (long)hiveClientConfig.getMaxPartitionsPerScan(), false, 10000, (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, (LocationService)new HiveLocationService((HdfsEnvironment)hdfsEnvironment), HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.ROW_EXPRESSION_SERVICE, HiveTestUtils.FILTER_STATS_CALCULATOR_SERVICE, new TableParameterCodec(), HiveTestUtils.PARTITION_UPDATE_CODEC, HiveTestUtils.PARTITION_UPDATE_SMILE_CODEC, listeningExecutor, (TypeTranslator)new HiveTypeTranslator(), (StagingFileCommitter)new HiveStagingFileCommitter((HdfsEnvironment)hdfsEnvironment, listeningExecutor), (ZeroRowFileCreator)new HiveZeroRowFileCreator((HdfsEnvironment)hdfsEnvironment, (DataSinkFactory)new OutputStreamDataSinkFactory(), listeningExecutor), "test_version", (PartitionObjectBuilder)new HivePartitionObjectBuilder(), new HiveEncryptionInformationProvider((List)ImmutableList.of()), new HivePartitionStats(), new HiveFileRenamer(), (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        return hiveMetadataFactory.get();
    }

    private Partition createPartition(String partitionName, String partitionLocation) {
        Partition.Builder partitionBuilder = Partition.builder().setDatabaseName(TEST_SCHEMA).setTableName(TEST_TABLE).setColumns((List)ImmutableList.of()).setValues(MetastoreUtil.toPartitionValues((String)partitionName)).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC)).setLocation(new Path("/test_table/" + partitionLocation, partitionName).toString())).setEligibleToIgnore(true).setSealedPartition(true).setParameters((Map)ImmutableMap.of((Object)"presto_query_id", (Object)"random_query_id"));
        return partitionBuilder.build();
    }

    static {
        try {
            URI tempUri = Files.createTempDirectory("test", new FileAttribute[0]).toUri();
            testTableProperties = ImmutableMap.builder().put((Object)"bucket_count", (Object)0).put((Object)"bucketed_by", (Object)ImmutableList.of()).put((Object)"sorted_by", (Object)ImmutableList.of()).put((Object)"format", (Object)HiveStorageFormat.ORC).put((Object)"external_location", (Object)tempUri.toASCIIString()).put((Object)"partitioned_by", (Object)ImmutableList.of((Object)"a")).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        testTableMetadata = new ConnectorTableMetadata(new SchemaTableName(TEST_SCHEMA, TEST_TABLE), (List)ImmutableList.of((Object)new ColumnMetadata("b", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("a", (Type)BigintType.BIGINT)), testTableProperties);
    }

    private static class TestingHdfsFileSystem
    extends ExtendedFileSystem {
        private final List<LocatedFileStatus> files;

        public TestingHdfsFileSystem(List<LocatedFileStatus> files) {
            this.files = ImmutableList.copyOf(files);
        }

        public boolean delete(Path f, boolean recursive) {
            throw new UnsupportedOperationException();
        }

        public boolean rename(Path src, Path dst) {
            throw new UnsupportedOperationException();
        }

        public void setWorkingDirectory(Path dir) {
            throw new UnsupportedOperationException();
        }

        public FileStatus[] listStatus(Path f) {
            throw new UnsupportedOperationException();
        }

        public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) {
            return new RemoteIterator<LocatedFileStatus>(){
                private final Iterator<LocatedFileStatus> iterator;
                {
                    this.iterator = files.iterator();
                }

                public boolean hasNext() throws IOException {
                    return this.iterator.hasNext();
                }

                public LocatedFileStatus next() throws IOException {
                    return this.iterator.next();
                }
            };
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            throw new UnsupportedOperationException();
        }

        public boolean mkdirs(Path f, FsPermission permission) {
            return true;
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
            throw new UnsupportedOperationException();
        }

        public FSDataInputStream open(Path f, int bufferSize) {
            throw new UnsupportedOperationException();
        }

        public FileStatus getFileStatus(Path f) {
            return new FileStatus(0L, true, 0, 0L, 0L, 0L, null, null, null, f);
        }

        public Path getWorkingDirectory() {
            throw new UnsupportedOperationException();
        }

        public URI getUri() {
            throw new UnsupportedOperationException();
        }

        public boolean exists(Path f) {
            return false;
        }
    }

    private static class TestingHdfsEnvironment
    extends HdfsEnvironment {
        private final List<LocatedFileStatus> files;

        public TestingHdfsEnvironment(List<LocatedFileStatus> files) {
            super((HdfsConfiguration)new HiveHdfsConfiguration(new HdfsConfigurationInitializer(new HiveClientConfig(), new MetastoreClientConfig()), (Set)ImmutableSet.of(), new HiveClientConfig()), new MetastoreClientConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
            this.files = ImmutableList.copyOf(files);
        }

        public ExtendedFileSystem getFileSystem(String user, Path path, Configuration configuration) {
            return new TestingHdfsFileSystem(this.files);
        }
    }

    private static class TestingExtendedHiveMetastore
    extends UnimplementedHiveMetastore {
        private final Map<String, Long> lastDataCommitTimes = new HashMap<String, Long>();
        private final Map<String, Table> tables = new HashMap<String, Table>();
        private final Map<String, Partition> partitions = new HashMap<String, Partition>();

        private TestingExtendedHiveMetastore() {
        }

        public List<String> getAllDatabases(MetastoreContext metastoreContext) {
            return ImmutableList.of((Object)"hive_test");
        }

        public Optional<Database> getDatabase(MetastoreContext metastoreContext, String databaseName) {
            return Optional.of(new Database(databaseName, Optional.of("/"), "test_owner", PrincipalType.USER, Optional.empty(), (Map)ImmutableMap.of()));
        }

        public MetastoreOperationResult createTable(MetastoreContext metastoreContext, Table table, PrincipalPrivileges principalPrivileges) {
            String tableKey = this.createTableKey(table.getDatabaseName(), table.getTableName());
            this.tables.put(tableKey, table);
            long currentTime = System.currentTimeMillis() / 1000L;
            this.lastDataCommitTimes.put(tableKey, currentTime);
            return new MetastoreOperationResult((List)ImmutableList.of((Object)currentTime));
        }

        public Optional<Table> getTable(MetastoreContext metastoreContext, String databaseName, String tableName) {
            String tableKey = this.createTableKey(databaseName, tableName);
            return Optional.ofNullable(this.tables.get(tableKey));
        }

        public void dropTable(MetastoreContext metastoreContext, String databaseName, String tableName, boolean deleteData) {
            String tableKey = this.createTableKey(databaseName, tableName);
            this.lastDataCommitTimes.remove(tableKey);
            this.tables.remove(tableKey);
        }

        public void updateTableStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        }

        public MetastoreOperationResult addPartitions(MetastoreContext metastoreContext, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
            ArrayList<Long> times = new ArrayList<Long>();
            for (PartitionWithStatistics partition : partitions) {
                String partitionKey = this.createPartitionKey(databaseName, tableName, partition.getPartitionName());
                Partition oldPartition = this.partitions.put(partitionKey, partition.getPartition());
                if (oldPartition != null) {
                    String newLocation;
                    String oldLocation = oldPartition.getStorage().getLocation();
                    if (oldLocation.equals(newLocation = partition.getPartition().getStorage().getLocation())) {
                        times.add(this.lastDataCommitTimes.get(partitionKey));
                        continue;
                    }
                    long currentTime = System.currentTimeMillis() / 1000L;
                    this.lastDataCommitTimes.put(partitionKey, currentTime);
                    times.add(currentTime);
                    continue;
                }
                long currentTime = System.currentTimeMillis() / 1000L;
                this.lastDataCommitTimes.put(partitionKey, currentTime);
                times.add(currentTime);
            }
            return new MetastoreOperationResult(times);
        }

        public MetastoreOperationResult alterPartition(MetastoreContext metastoreContext, String databaseName, String tableName, PartitionWithStatistics partition) {
            String partitionKey = this.createPartitionKey(databaseName, tableName, partition.getPartitionName());
            Partition oldPartition = this.partitions.get(partitionKey);
            this.partitions.put(partitionKey, partition.getPartition());
            if (oldPartition != null && oldPartition.getStorage().getLocation().equals(partition.getPartition().getStorage().getLocation())) {
                this.lastDataCommitTimes.put(partitionKey, System.currentTimeMillis() / 1000L);
            }
            if (!this.lastDataCommitTimes.containsKey(partitionKey)) {
                return new MetastoreOperationResult((List)ImmutableList.of());
            }
            return new MetastoreOperationResult((List)ImmutableList.of((Object)this.lastDataCommitTimes.get(partitionKey)));
        }

        public Optional<Partition> getPartition(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionValues) {
            String partitionKey = this.createPartitionKey(databaseName, tableName, partitionValues);
            long time = this.lastDataCommitTimes.getOrDefault(partitionKey, 0L);
            Partition partition = this.partitions.get(partitionKey);
            if (partition != null) {
                Partition.Builder builder = Partition.builder((Partition)partition).setLastDataCommitTime(time);
                return Optional.ofNullable(builder.build());
            }
            return Optional.empty();
        }

        public Map<String, Optional<Partition>> getPartitionsByNames(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionNames) {
            HashMap<String, Optional<Partition>> result = new HashMap<String, Optional<Partition>>();
            for (String partitionName : partitionNames) {
                List partitionValues = MetastoreUtil.toPartitionValues((String)partitionName);
                String partitionKey = this.createPartitionKey(databaseName, tableName, partitionValues);
                long time = this.lastDataCommitTimes.getOrDefault(partitionKey, 0L);
                Partition partition = this.partitions.get(partitionKey);
                if (partition != null) {
                    Partition.Builder builder = Partition.builder((Partition)partition).setLastDataCommitTime(time);
                    result.put(partitionName, Optional.of(builder.build()));
                    continue;
                }
                result.put(partitionName, Optional.empty());
            }
            return result;
        }

        private String createPartitionKey(String databaseName, String tableName, String partitionName) {
            List partitionValues = MetastoreUtil.toPartitionValues((String)partitionName);
            return String.join((CharSequence)".", databaseName, tableName, partitionValues.toString());
        }

        private String createPartitionKey(String databaseName, String tableName, List<String> partitionValues) {
            return String.join((CharSequence)".", databaseName, tableName, partitionValues.toString());
        }

        private String createTableKey(String databaseName, String tableName) {
            return String.join((CharSequence)".", databaseName, tableName);
        }
    }
}

