/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.TestHiveEventListenerPlugin;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestDistributedQueries;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.tpch.TpchTable;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestHiveDistributedQueries
extends AbstractTestDistributedQueries {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(TpchTable.getTables());
    }

    protected boolean supportsNotNullColumns() {
        return false;
    }

    @AfterClass(alwaysRun=true)
    public void close() throws Exception {
        Optional eventListener = this.getQueryRunner().getEventListener();
        Assert.assertTrue((boolean)eventListener.isPresent());
        Assert.assertTrue((boolean)(eventListener.get() instanceof TestHiveEventListenerPlugin.TestingHiveEventListener), (String)((EventListener)eventListener.get()).getClass().getName());
        Set<QueryId> runningQueryIds = ((TestHiveEventListenerPlugin.TestingHiveEventListener)eventListener.get()).getRunningQueries();
        if (!runningQueryIds.isEmpty()) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals(runningQueryIds, (Set)ImmutableSet.of(), (String)String.format("Query completion events not sent for %d queries: %s", runningQueryIds.size(), runningQueryIds.stream().map(QueryId::getId).collect(Collectors.joining(", "))));
        super.close();
    }

    public void testDelete() {
    }

    @Test
    public void testExplainOfCreateTableAs() {
        String query = "CREATE TABLE copy_orders AS SELECT * FROM orders";
        MaterializedResult result = this.computeActual("EXPLAIN " + query);
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet()), (Object)this.getExplainPlan("EXPLAIN ", query, ExplainType.Type.LOGICAL));
    }
}

