/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.eventlistener.QueryCompletedEvent;
import com.facebook.presto.spi.eventlistener.QueryCreatedEvent;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TestHiveEventListenerPlugin {

    static class TestingHiveEventListener
    implements EventListener {
        private final Set<QueryId> runningQueries;

        public TestingHiveEventListener(Set<QueryId> runningQueries) {
            this.runningQueries = runningQueries;
        }

        public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
            this.runningQueries.add(QueryId.valueOf((String)queryCreatedEvent.getMetadata().getQueryId()));
        }

        public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
            QueryId queryId = QueryId.valueOf((String)queryCompletedEvent.getMetadata().getQueryId());
            if (!this.runningQueries.contains(queryId)) {
                throw new RuntimeException("Missing create event for query " + queryId);
            }
            this.runningQueries.remove(queryId);
        }

        public Set<QueryId> getRunningQueries() {
            return this.runningQueries;
        }
    }

    private static class TestingHiveEventListenerFactory
    implements EventListenerFactory {
        private final Set<QueryId> runningQueries;

        public TestingHiveEventListenerFactory(Set<QueryId> runningQueries) {
            this.runningQueries = runningQueries;
        }

        public String getName() {
            return "test";
        }

        public EventListener create(Map<String, String> config) {
            return new TestingHiveEventListener(this.runningQueries);
        }
    }

    static class TestingHiveEventListenerPlugin
    implements Plugin {
        private final Set<QueryId> runningQueries = Collections.newSetFromMap(new ConcurrentHashMap());

        TestingHiveEventListenerPlugin() {
        }

        public Iterable<EventListenerFactory> getEventListenerFactories() {
            return ImmutableList.of((Object)new TestingHiveEventListenerFactory(this.runningQueries));
        }
    }
}

