/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.AbstractTestHiveFileFormats;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveDwrfEncryptionProvider;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveFileWriterFactory;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.NodeVersion;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.OrcFileWriterFactory;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.RcFileFileWriterFactory;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.datasink.OutputStreamDataSinkFactory;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.orc.DwrfBatchPageSourceFactory;
import com.facebook.presto.hive.orc.OrcBatchPageSourceFactory;
import com.facebook.presto.hive.parquet.ParquetFileWriterFactory;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.tests.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.compress.lzo.LzoCodec;
import io.airlift.compress.lzo.LzopCodec;
import io.airlift.slice.Slices;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileSplit;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestHiveFileFormats
extends AbstractTestHiveFileFormats {
    private static final FileFormatDataSourceStats STATS = new FileFormatDataSourceStats();
    private static final MetadataReader METADATA_READER = new MetadataReader();
    private static TestingConnectorSession parquetPageSourceSession = new TestingConnectorSession(new HiveSessionProperties(TestHiveFileFormats.createParquetHiveClientConfig(false), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
    private static TestingConnectorSession parquetPageSourceSessionUseName = new TestingConnectorSession(new HiveSessionProperties(TestHiveFileFormats.createParquetHiveClientConfig(true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
    private static final DateTimeZone HIVE_STORAGE_TIME_ZONE = DateTimeZone.forID((String)"America/Bahia_Banderas");

    @DataProvider(name="rowCount")
    public static Object[][] rowCountProvider() {
        return new Object[][]{{0}, {1000}};
    }

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        Assert.assertEquals((String)TimeZone.getDefault().getID(), (String)"America/Bahia_Banderas", (String)"Timezone not configured correctly. Add -Duser.timezone=America/Bahia_Banderas to your JVM arguments");
    }

    @Test(dataProvider="rowCount")
    public void testTextFile(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withColumns(testColumns).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testCsvFile(int rowCount) throws Exception {
        List testColumns = (List)TEST_COLUMNS.stream().filter(column -> column.isPartitionKey() || "string".equals(column.getType()) && !column.getName().contains("_null_")).collect(ImmutableList.toImmutableList());
        Assert.assertTrue((testColumns.size() > 5 ? 1 : 0) != 0);
        this.assertThatFileFormat(HiveStorageFormat.CSV).withColumns(testColumns).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test
    public void testCsvFileWithNullAndValue() throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.CSV).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)new AbstractTestHiveFileFormats.TestColumn("t_null_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, null, Slices.utf8Slice((String)"")), (Object)new AbstractTestHiveFileFormats.TestColumn("t_string", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "test", Slices.utf8Slice((String)"test")))).withRowsCount(2).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testJson(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(column -> !column.getName().equals("t_binary")).filter(column -> !column.getName().equals("t_map_tinyint")).filter(column -> !column.getName().equals("t_map_smallint")).filter(column -> !column.getName().equals("t_map_int")).filter(column -> !column.getName().equals("t_map_bigint")).filter(column -> !column.getName().equals("t_map_float")).filter(column -> !column.getName().equals("t_map_double")).filter(column -> !column.getName().equals("t_map_null_key")).filter(column -> !column.getName().equals("t_map_null_key_complex_key_value")).filter(column -> !column.getName().equals("t_map_null_key_complex_value")).filter(column -> !column.getName().equals("t_decimal_precision_38")).filter(column -> !column.getName().equals("t_map_decimal_precision_38")).filter(column -> !column.getName().equals("t_array_decimal_precision_38")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.JSON).withColumns(testColumns).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testRCText(int rowCount) throws Exception {
        ImmutableList testColumns = ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)TEST_COLUMNS, testColumn -> !testColumn.getName().equals("t_struct_null") && !testColumn.getName().equals("t_map_null_key_complex_key_value")));
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)testColumns).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testRcTextPageSource(int rowCount) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(TEST_COLUMNS).withRowsCount(rowCount).isReadableByPageSource((HiveBatchPageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testRcTextOptimizedWriter(int rowCount) throws Exception {
        List testColumns = (List)TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(ImmutableList.toImmutableList());
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setRcfileOptimizedWriterEnabled(true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HiveBatchPageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testRCBinary(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> {
            String name = testColumn.getName();
            return !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_empty_varchar");
        }).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryPageSource(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).isReadableByPageSource((HiveBatchPageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryOptimizedWriter(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_empty_varchar")).filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setRcfileOptimizedWriterEnabled(true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileWriterFactory((HiveFileWriterFactory)new RcFileFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HiveBatchPageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS));
    }

    @Test(dataProvider="rowCount")
    public void testOrc(int rowCount) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(TEST_COLUMNS).withRowsCount(rowCount).isReadableByPageSource((HiveBatchPageSourceFactory)new OrcBatchPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS, 100, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource())));
    }

    @Test(dataProvider="rowCount")
    public void testOrcOptimizedWriter(int rowCount) throws Exception {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setOrcOptimizedWriterEnabled(true).setOrcWriterValidationPercentage(100.0), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_map_null_key") && !testColumn.getName().equals("t_map_null_key_complex_value") && !testColumn.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileWriterFactory((HiveFileWriterFactory)new OrcFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, (DataSinkFactory)new OutputStreamDataSinkFactory(), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS, new OrcFileWriterConfig(), HiveDwrfEncryptionProvider.NO_ENCRYPTION)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HiveBatchPageSourceFactory)new OrcBatchPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS, 100, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource())));
    }

    @Test(dataProvider="rowCount")
    public void testOptimizedParquetWriter(int rowCount) throws Exception {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setOrcOptimizedWriterEnabled(true).setOrcWriterValidationPercentage(100.0), new OrcFileWriterConfig(), new ParquetFileWriterConfig().setParquetOptimizedWriterEnabled(true), new CacheConfig()).getSessionProperties());
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.getName().equals("t_map_null_key") && !testColumn.getName().equals("t_map_null_key_complex_value") && !testColumn.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withSession((ConnectorSession)session).withColumns(testColumns).withRowsCount(rowCount).withFileWriterFactory((HiveFileWriterFactory)new ParquetFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE)).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
    }

    @Test(dataProvider="rowCount")
    public void testOrcUseColumnNames(int rowCount) throws Exception {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns(TEST_COLUMNS).withRowsCount(rowCount).withReadColumns(Lists.reverse((List)TEST_COLUMNS)).withSession((ConnectorSession)session).isReadableByPageSource((HiveBatchPageSourceFactory)new OrcBatchPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, true, HiveTestUtils.HDFS_ENVIRONMENT, STATS, 100, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource())));
    }

    @Test(dataProvider="rowCount")
    public void testAvro(int rowCount) throws Exception {
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withColumns(TestHiveFileFormats.getTestColumnsSupportedByAvro()).withRowsCount(rowCount).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    private static List<AbstractTestHiveFileFormats.TestColumn> getTestColumnsSupportedByAvro() {
        return TEST_COLUMNS.stream().filter(column -> !column.getName().startsWith("t_map_") || column.getName().equals("t_map_string")).filter(column -> !column.getName().endsWith("_smallint")).filter(column -> !column.getName().endsWith("_tinyint")).collect(Collectors.toList());
    }

    @Test(dataProvider="rowCount")
    public void testParquetPageSource(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession((ConnectorSession)parquetPageSourceSession).withRowsCount(rowCount).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
    }

    @Test(dataProvider="rowCount")
    public void testParquetPageSourceGzip(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession((ConnectorSession)parquetPageSourceSession).withCompressionCodec(HiveCompressionCodec.GZIP).withRowsCount(rowCount).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
    }

    @Test(dataProvider="rowCount")
    public void testParquetPageSourceSchemaEvolution(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> writeColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        List readColumns = writeColumns.stream().map(column -> new AbstractTestHiveFileFormats.TestColumn(column.getName() + "_new", column.getObjectInspector(), column.getWriteValue(), column.getExpectedValue(), column.isPartitionKey())).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withSession((ConnectorSession)parquetPageSourceSession).withRowsCount(rowCount).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
        readColumns = Lists.reverse(writeColumns);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns(readColumns).withSession((ConnectorSession)parquetPageSourceSessionUseName).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
    }

    private static List<AbstractTestHiveFileFormats.TestColumn> getTestColumnsSupportedByParquet() {
        return TEST_COLUMNS.stream().filter(column -> !ImmutableSet.of((Object)"t_null_array_int", (Object)"t_array_empty", (Object)"t_map_null_key", (Object)"t_map_null_key_complex_value", (Object)"t_map_null_key_complex_key_value").contains((Object)column.getName())).filter(column -> column.isPartitionKey() || !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.DATE) && !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.SHORT) && !TestHiveFileFormats.hasType(column.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.BYTE)).collect(Collectors.toList());
    }

    @Test(dataProvider="rowCount")
    public void testDwrf(int rowCount) throws Exception {
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !TestHiveFileFormats.hasType(testColumn.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.DATE, PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, PrimitiveObjectInspector.PrimitiveCategory.CHAR, PrimitiveObjectInspector.PrimitiveCategory.DECIMAL)).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.DWRF).withColumns(testColumns).withRowsCount(rowCount).isReadableByPageSource((HiveBatchPageSourceFactory)new DwrfBatchPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HIVE_CLIENT_CONFIG, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()), HiveDwrfEncryptionProvider.NO_ENCRYPTION));
    }

    @Test(dataProvider="rowCount")
    public void testDwrfOptimizedWriter(int rowCount) throws Exception {
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setOrcOptimizedWriterEnabled(true).setOrcWriterValidationPercentage(100.0), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        List<AbstractTestHiveFileFormats.TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !TestHiveFileFormats.hasType(testColumn.getObjectInspector(), PrimitiveObjectInspector.PrimitiveCategory.DATE, PrimitiveObjectInspector.PrimitiveCategory.VARCHAR, PrimitiveObjectInspector.PrimitiveCategory.CHAR, PrimitiveObjectInspector.PrimitiveCategory.DECIMAL)).filter(testColumn -> !testColumn.getName().equals("t_map_null_key") && !testColumn.getName().equals("t_map_null_key_complex_value") && !testColumn.getName().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        this.assertThatFileFormat(HiveStorageFormat.DWRF).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileWriterFactory((HiveFileWriterFactory)new OrcFileWriterFactory(HiveTestUtils.HDFS_ENVIRONMENT, (DataSinkFactory)new OutputStreamDataSinkFactory(), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE, STATS, new OrcFileWriterConfig(), HiveDwrfEncryptionProvider.NO_ENCRYPTION)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT)).isReadableByPageSource((HiveBatchPageSourceFactory)new DwrfBatchPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HIVE_CLIENT_CONFIG, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()), HiveDwrfEncryptionProvider.NO_ENCRYPTION));
    }

    @Test
    public void testTruncateVarcharColumn() throws Exception {
        AbstractTestHiveFileFormats.TestColumn writeColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(4)), new HiveVarchar("test", 4), Slices.utf8Slice((String)"test"));
        AbstractTestHiveFileFormats.TestColumn readColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HiveBatchPageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HiveBatchPageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource((HiveBatchPageSourceFactory)new OrcBatchPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS, 100, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource())));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withSession((ConnectorSession)parquetPageSourceSession).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
        this.assertThatFileFormat(HiveStorageFormat.AVRO).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT));
    }

    @Test
    public void testFailForLongVarcharPartitionColumn() throws Exception {
        AbstractTestHiveFileFormats.TestColumn partitionColumn = new AbstractTestHiveFileFormats.TestColumn("partition_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), "test", Slices.utf8Slice((String)"tes"), true);
        AbstractTestHiveFileFormats.TestColumn varcharColumn = new AbstractTestHiveFileFormats.TestColumn("varchar_column", (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(3)), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        ImmutableList columns = ImmutableList.of((Object)partitionColumn, (Object)varcharColumn);
        HiveErrorCode expectedErrorCode = HiveErrorCode.HIVE_INVALID_PARTITION_VALUE;
        String expectedMessage = "Invalid partition value 'test' for varchar\\(3\\) partition key: partition_column";
        this.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HiveBatchPageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS), (ErrorCodeSupplier)expectedErrorCode, expectedMessage).isFailingForRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), (ErrorCodeSupplier)expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HiveBatchPageSourceFactory)new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.HDFS_ENVIRONMENT, STATS), (ErrorCodeSupplier)expectedErrorCode, expectedMessage).isFailingForRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), (ErrorCodeSupplier)expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.ORC).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForPageSource((HiveBatchPageSourceFactory)new OrcBatchPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, false, HiveTestUtils.HDFS_ENVIRONMENT, STATS, 100, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource())), (ErrorCodeSupplier)expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), (ErrorCodeSupplier)expectedErrorCode, expectedMessage);
        this.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withColumns((List<AbstractTestHiveFileFormats.TestColumn>)columns).isFailingForRecordCursor((HiveRecordCursorProvider)new GenericHiveRecordCursorProvider(HiveTestUtils.HDFS_ENVIRONMENT), (ErrorCodeSupplier)expectedErrorCode, expectedMessage);
    }

    @Test
    public void testSchemaMismatch() throws Exception {
        AbstractTestHiveFileFormats.TestColumn floatColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, Float.valueOf(5.1f), Float.valueOf(5.1f));
        AbstractTestHiveFileFormats.TestColumn doubleColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, 5.1, 5.1);
        AbstractTestHiveFileFormats.TestColumn booleanColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, true, true);
        AbstractTestHiveFileFormats.TestColumn stringColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, "test", Slices.utf8Slice((String)"test"));
        AbstractTestHiveFileFormats.TestColumn intColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, 3, 3);
        AbstractTestHiveFileFormats.TestColumn longColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, 4L, 4L);
        AbstractTestHiveFileFormats.TestColumn longStoredAsIntColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, 4, 4);
        AbstractTestHiveFileFormats.TestColumn timestampColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, 4L, 4L);
        AbstractTestHiveFileFormats.TestColumn mapLongColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector), ImmutableMap.of((Object)4L, (Object)4L), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Object)4L, (Object)4L));
        AbstractTestHiveFileFormats.TestColumn mapDoubleColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector), ImmutableMap.of((Object)5.1, (Object)5.2), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, (Object)5.1, (Object)5.2));
        AbstractTestHiveFileFormats.TestColumn arrayStringColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ImmutableList.of((Object)"test"), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"test"}));
        AbstractTestHiveFileFormats.TestColumn arrayBooleanColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector), ImmutableList.of((Object)true), StructuralTestUtil.arrayBlockOf((Type)BooleanType.BOOLEAN, (Object[])new Object[]{true}));
        AbstractTestHiveFileFormats.TestColumn rowLongColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_bigint"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaLongObjectInspector)), new Long[]{1L}, StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)BigintType.BIGINT), (Object[])new Object[]{1}));
        AbstractTestHiveFileFormats.TestColumn nestColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_int"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector)))), ImmutableMap.of((Object)"test", (Object)ImmutableList.of((Object)new Integer[]{1})), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER))), (Object)"test", (Object)StructuralTestUtil.arrayBlockOf((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER)), (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER), (Object[])new Object[]{1L})})));
        HiveErrorCode expectedErrorCode = HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH;
        String expectedMessageFloatDouble = "The column column_name of table schema.table is declared as type double, but the Parquet file ((.*?)) declares the column as type FLOAT";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)longColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)timestampColumn)).withSession((ConnectorSession)parquetPageSourceSession).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)longStoredAsIntColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)longColumn)).withSession((ConnectorSession)parquetPageSourceSession).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)floatColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)doubleColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageFloatDouble);
        String expectedMessageDoubleLong = "The column column_name of table schema.table is declared as type bigint, but the Parquet file ((.*?)) declares the column as type DOUBLE";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)doubleColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)longColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageDoubleLong);
        String expectedMessageFloatInt = "The column column_name of table schema.table is declared as type int, but the Parquet file ((.*?)) declares the column as type FLOAT";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)floatColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)intColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageFloatInt);
        String expectedMessageIntBoolean = "The column column_name of table schema.table is declared as type boolean, but the Parquet file ((.*?)) declares the column as type INT32";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)intColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)booleanColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageIntBoolean);
        String expectedMessageStringLong = "The column column_name of table schema.table is declared as type string, but the Parquet file ((.*?)) declares the column as type INT64";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)longColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)stringColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageStringLong);
        String expectedMessageIntString = "The column column_name of table schema.table is declared as type int, but the Parquet file ((.*?)) declares the column as type BINARY";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)stringColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)intColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageIntString);
        String expectedMessageMapLongLong = "The column column_name of table schema.table is declared as type map<bigint,bigint>, but the Parquet file ((.*?)) declares the column as type INT64";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)longColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)mapLongColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageMapLongLong);
        String expectedMessageMapLongMapDouble = "The column column_name of table schema.table is declared as type map<bigint,bigint>, but the Parquet file ((.*?)) declares the column as type optional group column_name \\(MAP\\) \\{\n  repeated group key_value \\(MAP_KEY_VALUE\\) \\{\n    required double key;\n    optional double value;\n  \\}\n\\}";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)mapDoubleColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)mapLongColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageMapLongMapDouble);
        String expectedMessageArrayStringArrayBoolean = "The column column_name of table schema.table is declared as type array<string>, but the Parquet file ((.*?)) declares the column as type optional group column_name \\(LIST\\) \\{\n  repeated group bag \\{\n    optional boolean array_element;\n  \\}\n\\}";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)arrayBooleanColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)arrayStringColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageArrayStringArrayBoolean);
        String expectedMessageBooleanArrayBoolean = "The column column_name of table schema.table is declared as type array<boolean>, but the Parquet file ((.*?)) declares the column as type BOOLEAN";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)booleanColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)arrayBooleanColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageBooleanArrayBoolean);
        String expectedMessageRowLongLong = "The column column_name of table schema.table is declared as type bigint, but the Parquet file ((.*?)) declares the column as type optional group column_name \\{\n  optional int64 s_bigint;\n\\}";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)rowLongColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)longColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageRowLongLong);
        AbstractTestHiveFileFormats.TestColumn rowLongColumnReadOnMap = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_bigint"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaLongObjectInspector)), new Long[]{1L}, null);
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)mapLongColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)rowLongColumnReadOnMap)).withSession((ConnectorSession)parquetPageSourceSession).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
        String expectedMessageRowLongNest = "The column column_name of table schema.table is declared as type map<string,array<struct<s_int:int>>>, but the Parquet file ((.*?)) declares the column as type optional group column_name \\{\n  optional int64 s_bigint;\n\\}";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)rowLongColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)nestColumn)).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageRowLongNest);
    }

    @Test
    public void testSchemaMismatchOnNestedStruct() throws Exception {
        AbstractTestHiveFileFormats.TestColumn writeColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_int", (Object)"s_double"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector))), ImmutableMap.of((Object)"test", Arrays.asList(1, 5.0)), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE)), (Object)"test", (Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)DoubleType.DOUBLE), (Object[])new Object[]{1L, 5.0})));
        AbstractTestHiveFileFormats.TestColumn readColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_double", (Object)"s_int"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), ImmutableMap.of((Object)"test", Arrays.asList(5.0, 1)), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)RowType.anonymous((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)IntegerType.INTEGER)), (Object)"test", (Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)IntegerType.INTEGER), (Object[])new Object[]{5.0, 1L})));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withRowsCount(1).withSession((ConnectorSession)parquetPageSourceSession).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
        readColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_int", (Object)"s_int_new"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), ImmutableMap.of((Object)"test", Arrays.asList(1, 5.0)), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (Object)"test", (Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER), (Object[])new Object[]{1L, null})));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withRowsCount(1).withSession((ConnectorSession)parquetPageSourceSession).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
        readColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_DOUBLE", (Object)"s_INT"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), ImmutableMap.of((Object)"test", Arrays.asList(5.0, 1)), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)RowType.anonymous((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)IntegerType.INTEGER)), (Object)"test", (Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)IntegerType.INTEGER), (Object[])new Object[]{5.0, 1L})));
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withRowsCount(1).withSession((ConnectorSession)parquetPageSourceSession).isReadableByPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER));
        readColumn = new AbstractTestHiveFileFormats.TestColumn("column_name", (ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"s_double", (Object)"s_int"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), ImmutableMap.of((Object)"test", Arrays.asList(5, 1)), StructuralTestUtil.mapBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER)), (Object)"test", (Object)StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER), (Object[])new Object[]{5L, 1L})));
        HiveErrorCode expectedErrorCode = HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH;
        String expectedMessageRowLongNest = "The column column_name of table schema.table is declared as type map<string,struct<s_double:int,s_int:int>>, but the Parquet file ((.*?)) declares the column as type optional group column_name \\(MAP\\) \\{\n  repeated group key_value \\(MAP_KEY_VALUE\\) \\{\n    required binary key \\(STRING\\);\n    optional group value \\{\n      optional int32 s_int;\n      optional double s_double;\n    \\}\n  \\}\n\\}";
        this.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<AbstractTestHiveFileFormats.TestColumn>)ImmutableList.of((Object)readColumn)).withRowsCount(1).withSession((ConnectorSession)parquetPageSourceSession).isFailingForPageSource((HiveBatchPageSourceFactory)new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HDFS_ENVIRONMENT, STATS, (ParquetMetadataSource)METADATA_READER), (ErrorCodeSupplier)expectedErrorCode, expectedMessageRowLongNest);
    }

    private void testCursorProvider(HiveRecordCursorProvider cursorProvider, FileSplit split, HiveStorageFormat storageFormat, List<AbstractTestHiveFileFormats.TestColumn> testColumns, ConnectorSession session, int rowCount) {
        List partitionKeys = testColumns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).map(AbstractTestHiveFileFormats.TestColumn::toHivePartitionKey).collect(Collectors.toList());
        List<HiveColumnHandle> partitionKeyColumnHandles = this.getColumnHandles((List)testColumns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).collect(ImmutableList.toImmutableList()));
        List tableDataColumns = (List)testColumns.stream().filter(column -> !column.isPartitionKey()).map(column -> new Column(column.getName(), HiveType.valueOf((String)column.getType()), Optional.empty(), Optional.empty())).collect(ImmutableList.toImmutableList());
        HiveFileSplit hiveFileSplit = new HiveFileSplit(split.getPath().toString(), split.getStart(), split.getLength(), split.getLength(), Instant.now().toEpochMilli(), Optional.empty(), (Map)ImmutableMap.of());
        Configuration configuration = new Configuration();
        configuration.set("io.compression.codecs", LzoCodec.class.getName() + "," + LzopCodec.class.getName());
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)cursorProvider), (Set)ImmutableSet.of(), (Configuration)configuration, (ConnectorSession)session, (HiveFileSplit)hiveFileSplit, (OptionalInt)OptionalInt.empty(), (Storage)new Storage(StorageFormat.create((String)storageFormat.getSerDe(), (String)storageFormat.getInputFormat(), (String)storageFormat.getOutputFormat()), "location", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (TupleDomain)TupleDomain.all(), this.getColumnHandles(testColumns), (Map)ImmutableMap.of(), partitionKeys, (DateTimeZone)DateTimeZone.getDefault(), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, (SchemaTableName)new SchemaTableName("schema", "table"), partitionKeyColumnHandles, (List)tableDataColumns, (Map)ImmutableMap.of(), (int)tableDataColumns.size(), (TableToPartitionMapping)TableToPartitionMapping.empty(), Optional.empty(), (boolean)false, (HiveFileContext)HiveFileContext.DEFAULT_HIVE_FILE_CONTEXT, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (boolean)false, (RowExpressionService)HiveTestUtils.ROW_EXPRESSION_SERVICE, Optional.empty());
        RecordCursor cursor = ((RecordPageSource)pageSource.get()).getCursor();
        this.checkCursor(cursor, testColumns, rowCount);
    }

    private void testPageSourceFactory(HiveBatchPageSourceFactory sourceFactory, FileSplit split, HiveStorageFormat storageFormat, List<AbstractTestHiveFileFormats.TestColumn> testColumns, ConnectorSession session, int rowCount) throws IOException {
        List partitionKeys = testColumns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).map(AbstractTestHiveFileFormats.TestColumn::toHivePartitionKey).collect(Collectors.toList());
        List<HiveColumnHandle> partitionKeyColumnHandles = this.getColumnHandles((List)testColumns.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).collect(ImmutableList.toImmutableList()));
        List tableDataColumns = (List)testColumns.stream().filter(column -> !column.isPartitionKey()).map(column -> new Column(column.getName(), HiveType.valueOf((String)column.getType()), Optional.empty(), Optional.empty())).collect(ImmutableList.toImmutableList());
        List<HiveColumnHandle> columnHandles = this.getColumnHandles(testColumns);
        HiveFileSplit hiveFileSplit = new HiveFileSplit(split.getPath().toString(), split.getStart(), split.getLength(), split.getLength(), Instant.now().toEpochMilli(), Optional.empty(), (Map)ImmutableMap.of());
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)sourceFactory), (Configuration)new Configuration(), (ConnectorSession)session, (HiveFileSplit)hiveFileSplit, (OptionalInt)OptionalInt.empty(), (Storage)new Storage(StorageFormat.create((String)storageFormat.getSerDe(), (String)storageFormat.getInputFormat(), (String)storageFormat.getOutputFormat()), "location", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (TupleDomain)TupleDomain.all(), columnHandles, (Map)ImmutableMap.of(), partitionKeys, (DateTimeZone)DateTimeZone.getDefault(), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, (SchemaTableName)new SchemaTableName("schema", "table"), partitionKeyColumnHandles, (List)tableDataColumns, (Map)ImmutableMap.of(), (int)tableDataColumns.size(), (TableToPartitionMapping)TableToPartitionMapping.empty(), Optional.empty(), (boolean)false, (HiveFileContext)HiveFileContext.DEFAULT_HIVE_FILE_CONTEXT, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, (boolean)false, (RowExpressionService)HiveTestUtils.ROW_EXPRESSION_SERVICE, Optional.empty());
        Assert.assertTrue((boolean)pageSource.isPresent());
        this.checkPageSource((ConnectorPageSource)pageSource.get(), testColumns, HiveTestUtils.getTypes(columnHandles), rowCount);
    }

    public static boolean hasType(ObjectInspector objectInspector, PrimitiveObjectInspector.PrimitiveCategory ... types) {
        if (objectInspector instanceof PrimitiveObjectInspector) {
            PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)objectInspector;
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveInspector.getPrimitiveCategory();
            for (PrimitiveObjectInspector.PrimitiveCategory type : types) {
                if (primitiveCategory != type) continue;
                return true;
            }
            return false;
        }
        if (objectInspector instanceof ListObjectInspector) {
            ListObjectInspector listInspector = (ListObjectInspector)objectInspector;
            return TestHiveFileFormats.hasType(listInspector.getListElementObjectInspector(), types);
        }
        if (objectInspector instanceof MapObjectInspector) {
            MapObjectInspector mapInspector = (MapObjectInspector)objectInspector;
            return TestHiveFileFormats.hasType(mapInspector.getMapKeyObjectInspector(), types) || TestHiveFileFormats.hasType(mapInspector.getMapValueObjectInspector(), types);
        }
        if (objectInspector instanceof StructObjectInspector) {
            for (StructField field : ((StructObjectInspector)objectInspector).getAllStructFieldRefs()) {
                if (!TestHiveFileFormats.hasType(field.getFieldObjectInspector(), types)) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Unknown object inspector type " + objectInspector);
    }

    private static boolean withoutNullMapKeyTests(AbstractTestHiveFileFormats.TestColumn testColumn) {
        String name = testColumn.getName();
        return !name.equals("t_map_null_key") && !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_map_null_key_complex_value");
    }

    private FileFormatAssertion assertThatFileFormat(HiveStorageFormat hiveStorageFormat) {
        return new FileFormatAssertion(hiveStorageFormat.name()).withStorageFormat(hiveStorageFormat);
    }

    private static HiveClientConfig createParquetHiveClientConfig(boolean useParquetColumnNames) {
        HiveClientConfig config = new HiveClientConfig();
        config.setUseParquetColumnNames(useParquetColumnNames);
        return config;
    }

    private class FileFormatAssertion {
        private final String formatName;
        private HiveStorageFormat storageFormat;
        private HiveCompressionCodec compressionCodec = HiveCompressionCodec.NONE;
        private List<AbstractTestHiveFileFormats.TestColumn> writeColumns;
        private List<AbstractTestHiveFileFormats.TestColumn> readColumns;
        private ConnectorSession session = HiveTestUtils.SESSION;
        private int rowsCount = 1000;
        private HiveFileWriterFactory fileWriterFactory;

        private FileFormatAssertion(String formatName) {
            this.formatName = Objects.requireNonNull(formatName, "formatName is null");
        }

        public FileFormatAssertion withStorageFormat(HiveStorageFormat storageFormat) {
            this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
            return this;
        }

        public FileFormatAssertion withCompressionCodec(HiveCompressionCodec compressionCodec) {
            this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
            return this;
        }

        public FileFormatAssertion withFileWriterFactory(HiveFileWriterFactory fileWriterFactory) {
            this.fileWriterFactory = Objects.requireNonNull(fileWriterFactory, "fileWriterFactory is null");
            return this;
        }

        public FileFormatAssertion withColumns(List<AbstractTestHiveFileFormats.TestColumn> inputColumns) {
            this.withWriteColumns(inputColumns);
            this.withReadColumns(inputColumns);
            return this;
        }

        public FileFormatAssertion withWriteColumns(List<AbstractTestHiveFileFormats.TestColumn> writeColumns) {
            this.writeColumns = Objects.requireNonNull(writeColumns, "writeColumns is null");
            return this;
        }

        public FileFormatAssertion withReadColumns(List<AbstractTestHiveFileFormats.TestColumn> readColumns) {
            this.readColumns = Objects.requireNonNull(readColumns, "readColumns is null");
            return this;
        }

        public FileFormatAssertion withRowsCount(int rowsCount) {
            this.rowsCount = rowsCount;
            return this;
        }

        public FileFormatAssertion withSession(ConnectorSession session) {
            this.session = Objects.requireNonNull(session, "session is null");
            return this;
        }

        public FileFormatAssertion isReadableByPageSource(HiveBatchPageSourceFactory pageSourceFactory) throws Exception {
            this.assertRead(Optional.of(pageSourceFactory), Optional.empty());
            return this;
        }

        public FileFormatAssertion isReadableByRecordCursor(HiveRecordCursorProvider cursorProvider) throws Exception {
            this.assertRead(Optional.empty(), Optional.of(cursorProvider));
            return this;
        }

        public FileFormatAssertion isFailingForPageSource(HiveBatchPageSourceFactory pageSourceFactory, ErrorCodeSupplier expectedErrorCode, String expectedMessage) throws Exception {
            this.assertFailure(Optional.of(pageSourceFactory), Optional.empty(), expectedErrorCode, expectedMessage);
            return this;
        }

        public FileFormatAssertion isFailingForRecordCursor(HiveRecordCursorProvider cursorProvider, ErrorCodeSupplier expectedErrorCode, String expectedMessage) throws Exception {
            this.assertFailure(Optional.empty(), Optional.of(cursorProvider), expectedErrorCode, expectedMessage);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void assertRead(Optional<HiveBatchPageSourceFactory> pageSourceFactory, Optional<HiveRecordCursorProvider> cursorProvider) throws Exception {
            Assert.assertNotNull((Object)this.storageFormat, (String)"storageFormat must be specified");
            Assert.assertNotNull(this.writeColumns, (String)"writeColumns must be specified");
            Assert.assertNotNull(this.readColumns, (String)"readColumns must be specified");
            Assert.assertNotNull((Object)this.session, (String)"session must be specified");
            Assert.assertTrue((this.rowsCount >= 0 ? 1 : 0) != 0, (String)"rowsCount must be greater than zero");
            String compressionSuffix = this.compressionCodec.getCodec().map(codec -> {
                try {
                    return ((CompressionCodec)codec.getConstructor(new Class[0]).newInstance(new Object[0])).getDefaultExtension();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).orElse("");
            File file = File.createTempFile("presto_test", this.formatName + compressionSuffix);
            file.delete();
            try {
                FileSplit split = this.fileWriterFactory != null ? AbstractTestHiveFileFormats.createTestFile(file.getAbsolutePath(), this.storageFormat, this.compressionCodec, this.writeColumns, this.session, this.rowsCount, this.fileWriterFactory) : AbstractTestHiveFileFormats.createTestFile(file.getAbsolutePath(), this.storageFormat, this.compressionCodec, this.writeColumns, this.rowsCount);
                if (pageSourceFactory.isPresent()) {
                    TestHiveFileFormats.this.testPageSourceFactory(pageSourceFactory.get(), split, this.storageFormat, this.readColumns, this.session, this.rowsCount);
                }
                if (cursorProvider.isPresent()) {
                    TestHiveFileFormats.this.testCursorProvider(cursorProvider.get(), split, this.storageFormat, this.readColumns, this.session, this.rowsCount);
                }
            }
            finally {
                file.delete();
            }
        }

        private void assertFailure(Optional<HiveBatchPageSourceFactory> pageSourceFactory, Optional<HiveRecordCursorProvider> cursorProvider, ErrorCodeSupplier expectedErrorCode, String expectedMessage) throws Exception {
            try {
                this.assertRead(pageSourceFactory, cursorProvider);
                Assert.fail((String)"failure is expected");
            }
            catch (PrestoException prestoException) {
                Assert.assertEquals((Object)prestoException.getErrorCode(), (Object)expectedErrorCode.toErrorCode());
                Assert.assertTrue((boolean)prestoException.getMessage().matches(expectedMessage));
            }
        }
    }
}

