/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveInsertTableHandle;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.spi.plan.MarkDistinctNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.planPrinter.IOPlanPrinter;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.testing.ExpectedQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestIntegrationSmokeTest;
import com.facebook.presto.tests.DistributedQueryRunner;
import com.facebook.presto.tests.QueryAssertions;
import com.facebook.presto.tests.ResultWithQueryId;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.tpch.TpchTable;
import java.io.File;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public class TestHiveIntegrationSmokeTest
extends AbstractTestIntegrationSmokeTest {
    private final String catalog;
    private final Session bucketedSession;
    private final Session materializeExchangesSession;
    private final TypeTranslator typeTranslator;

    public TestHiveIntegrationSmokeTest() {
        this(HiveQueryRunner.createBucketedSession(Optional.of(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin")))), HiveQueryRunner.createMaterializeExchangesSession(Optional.of(new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin")))), "hive", (TypeTranslator)new HiveTypeTranslator());
    }

    protected TestHiveIntegrationSmokeTest(Session bucketedSession, Session materializeExchangesSession, String catalog, TypeTranslator typeTranslator) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.bucketedSession = Objects.requireNonNull(bucketedSession, "bucketSession is null");
        this.materializeExchangesSession = Objects.requireNonNull(materializeExchangesSession, "materializeExchangesSession is null");
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(TpchTable.ORDERS, TpchTable.CUSTOMER, TpchTable.LINE_ITEM, TpchTable.PART_SUPPLIER, TpchTable.NATION);
    }

    private List<?> getPartitions(HiveTableLayoutHandle tableLayoutHandle) {
        return (List)tableLayoutHandle.getPartitions().get();
    }

    @Test
    public void testSchemaOperations() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("hive", Optional.empty(), (Map)ImmutableMap.of((Object)"hive", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).build();
        this.assertUpdate(admin, "CREATE SCHEMA new_schema");
        this.assertUpdate(admin, "CREATE TABLE new_schema.test (x bigint)");
        this.assertQueryFails(admin, "DROP SCHEMA new_schema", "Schema not empty: new_schema");
        this.assertUpdate(admin, "DROP TABLE new_schema.test");
        this.assertUpdate(admin, "DROP SCHEMA new_schema");
    }

    @Test
    public void testArrayPredicate() {
        Session admin = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setIdentity(new Identity("hive", Optional.empty(), (Map)ImmutableMap.of((Object)"hive", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("admin"))), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty())).build();
        this.assertUpdate(admin, "CREATE SCHEMA new_schema");
        this.assertUpdate(admin, "CREATE TABLE new_schema.test (a array<varchar>)");
        this.assertUpdate(admin, "INSERT INTO new_schema.test (values array['hi'])", 1L);
        this.assertQuery(admin, "SELECT * FROM new_schema.test where a <> array[]", "SELECT 'hi'");
        this.assertUpdate(admin, "DROP TABLE new_schema.test");
        this.assertUpdate(admin, "DROP SCHEMA new_schema");
    }

    @Test
    public void testCreateTableWithInvalidProperties() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 bigint) WITH (format = 'ORC', csv_separator = 'S')")).hasMessageMatching("Cannot specify csv_separator table property for storage format: ORC");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 varchar) WITH (format = 'CSV', csv_separator = 'SS')")).hasMessageMatching("csv_separator must be a single character string, but was: 'SS'");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 bigint) WITH (format = 'ORC', csv_quote = 'Q')")).hasMessageMatching("Cannot specify csv_quote table property for storage format: ORC");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 varchar) WITH (format = 'CSV', csv_quote = 'QQ')")).hasMessageMatching("csv_quote must be a single character string, but was: 'QQ'");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 varchar) WITH (format = 'ORC', csv_escape = 'E')")).hasMessageMatching("Cannot specify csv_escape table property for storage format: ORC");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE invalid_table (col1 varchar) WITH (format = 'CSV', csv_escape = 'EE')")).hasMessageMatching("csv_escape must be a single character string, but was: 'EE'");
    }

    @Test
    public void testIOExplain() {
        this.computeActual("CREATE TABLE test_orders WITH (partitioned_by = ARRAY['orderkey', 'processing']) AS SELECT custkey, orderkey, orderstatus = 'P' processing FROM orders WHERE orderkey < 3");
        MaterializedResult result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) INSERT INTO test_orders SELECT custkey, orderkey, processing FROM test_orders where custkey <= 10");
        ImmutableSet.Builder expectedConstraints = ImmutableSet.builder();
        expectedConstraints.add((Object)new IOPlanPrinter.ColumnConstraint("orderkey", BigintType.BIGINT.getTypeSignature(), new IOPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IOPlanPrinter.FormattedRange(new IOPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY), new IOPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY)), (Object)new IOPlanPrinter.FormattedRange(new IOPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY), new IOPlanPrinter.FormattedMarker(Optional.of("2"), Marker.Bound.EXACTLY))))));
        expectedConstraints.add((Object)new IOPlanPrinter.ColumnConstraint("processing", BooleanType.BOOLEAN.getTypeSignature(), new IOPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IOPlanPrinter.FormattedRange(new IOPlanPrinter.FormattedMarker(Optional.of("false"), Marker.Bound.EXACTLY), new IOPlanPrinter.FormattedMarker(Optional.of("false"), Marker.Bound.EXACTLY))))));
        Assert.assertEquals((Object)JsonCodec.jsonCodec(IOPlanPrinter.IOPlan.class).fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IOPlanPrinter.IOPlan((Set)ImmutableSet.of((Object)new IOPlanPrinter.IOPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "test_orders"), (Set)expectedConstraints.build())), Optional.of(new CatalogSchemaTableName(this.catalog, "tpch", "test_orders"))));
        this.assertUpdate("DROP TABLE test_orders");
        this.computeActual("CREATE TABLE test_orders WITH (partitioned_by = ARRAY['orderkey']) AS select custkey, orderkey FROM orders where orderkey < 200");
        expectedConstraints = ImmutableSet.builder();
        expectedConstraints.add((Object)new IOPlanPrinter.ColumnConstraint("orderkey", BigintType.BIGINT.getTypeSignature(), new IOPlanPrinter.FormattedDomain(false, (Set)ImmutableSet.of((Object)new IOPlanPrinter.FormattedRange(new IOPlanPrinter.FormattedMarker(Optional.of("1"), Marker.Bound.EXACTLY), new IOPlanPrinter.FormattedMarker(Optional.of("199"), Marker.Bound.EXACTLY))))));
        result = this.computeActual("EXPLAIN (TYPE IO, FORMAT JSON) INSERT INTO test_orders SELECT custkey, orderkey + 10 FROM test_orders where custkey <= 10");
        Assert.assertEquals((Object)JsonCodec.jsonCodec(IOPlanPrinter.IOPlan.class).fromJson((String)Iterables.getOnlyElement((Iterable)result.getOnlyColumnAsSet())), (Object)new IOPlanPrinter.IOPlan((Set)ImmutableSet.of((Object)new IOPlanPrinter.IOPlan.TableColumnInfo(new CatalogSchemaTableName(this.catalog, "tpch", "test_orders"), (Set)expectedConstraints.build())), Optional.of(new CatalogSchemaTableName(this.catalog, "tpch", "test_orders"))));
        this.assertUpdate("DROP TABLE test_orders");
    }

    @Test
    public void testReadNoColumns() {
        this.testWithAllStorageFormats(this::testReadNoColumns);
    }

    private void testReadNoColumns(Session session, HiveStorageFormat storageFormat) {
        if (!this.insertOperationsSupported(storageFormat)) {
            return;
        }
        this.assertUpdate(session, String.format("CREATE TABLE test_read_no_columns WITH (format = '%s') AS SELECT 0 x", storageFormat), 1L);
        this.assertQuery(session, "SELECT count(*) FROM test_read_no_columns", "SELECT 1");
        this.assertUpdate(session, "DROP TABLE test_read_no_columns");
    }

    @Test
    public void createTableWithEveryType() {
        String query = "CREATE TABLE test_types_table AS SELECT 'foo' _varchar, cast('bar' as varbinary) _varbinary, cast(1 as bigint) _bigint, 2 _integer, CAST('3.14' AS DOUBLE) _double, true _boolean, DATE '1980-05-07' _date, TIMESTAMP '1980-05-07 11:22:33.456' _timestamp, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long, CAST('bar' AS CHAR(10)) _char";
        this.assertUpdate(query, 1L);
        MaterializedResult results = this.getQueryRunner().execute(this.getSession(), "SELECT * FROM test_types_table").toTestTypes();
        Assert.assertEquals((int)results.getRowCount(), (int)1);
        MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(0);
        Assert.assertEquals((Object)row.getField(0), (Object)"foo");
        Assert.assertEquals((Object)row.getField(1), (Object)"bar".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((Object)row.getField(2), (Object)1L);
        Assert.assertEquals((Object)row.getField(3), (Object)2);
        Assert.assertEquals((Object)row.getField(4), (Object)3.14);
        Assert.assertEquals((Object)row.getField(5), (Object)true);
        Assert.assertEquals((Object)row.getField(6), (Object)LocalDate.of(1980, 5, 7));
        Assert.assertEquals((Object)row.getField(7), (Object)LocalDateTime.of(1980, 5, 7, 11, 22, 33, 456000000));
        Assert.assertEquals((Object)row.getField(8), (Object)new BigDecimal("3.14"));
        Assert.assertEquals((Object)row.getField(9), (Object)new BigDecimal("12345678901234567890.0123456789"));
        Assert.assertEquals((Object)row.getField(10), (Object)"bar       ");
        this.assertUpdate("DROP TABLE test_types_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_types_table"));
    }

    @Test
    public void testCreatePartitionedTable() {
        this.testWithAllStorageFormats(this::testCreatePartitionedTable);
    }

    private void testCreatePartitionedTable(Session session, HiveStorageFormat storageFormat) {
        if (!this.insertOperationsSupported(storageFormat)) {
            return;
        }
        String createTable = "CREATE TABLE test_partitioned_table (  _string VARCHAR,  _varchar VARCHAR(65535), _char CHAR(10), _bigint BIGINT, _integer INTEGER, _smallint SMALLINT, _tinyint TINYINT, _real REAL, _double DOUBLE, _boolean BOOLEAN, _decimal_short DECIMAL(3,2), _decimal_long DECIMAL(30,10), _partition_string VARCHAR, _partition_varchar VARCHAR(65535), _partition_char CHAR(10), _partition_tinyint TINYINT, _partition_smallint SMALLINT, _partition_integer INTEGER, _partition_bigint BIGINT, _partition_boolean BOOLEAN, _partition_decimal_short DECIMAL(3,2), _partition_decimal_long DECIMAL(30,10), _partition_date DATE, _partition_timestamp TIMESTAMP) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ '_partition_string', '_partition_varchar', '_partition_char', '_partition_tinyint', '_partition_smallint', '_partition_integer', '_partition_bigint', '_partition_boolean', '_partition_decimal_short', '_partition_decimal_long', '_partition_date', '_partition_timestamp']) ";
        if (storageFormat == HiveStorageFormat.AVRO) {
            createTable = createTable.replace(" _smallint SMALLINT,", " _smallint INTEGER,");
            createTable = createTable.replace(" _tinyint TINYINT,", " _tinyint INTEGER,");
        }
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        ImmutableList partitionedBy = ImmutableList.of((Object)"_partition_string", (Object)"_partition_varchar", (Object)"_partition_char", (Object)"_partition_tinyint", (Object)"_partition_smallint", (Object)"_partition_integer", (Object)"_partition_bigint", (Object)"_partition_boolean", (Object)"_partition_decimal_short", (Object)"_partition_decimal_long", (Object)"_partition_date", (Object)"_partition_timestamp", (Object[])new String[0]);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)partitionedBy);
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            boolean partitionKey = partitionedBy.contains(columnMetadata.getName());
            Assert.assertEquals((String)columnMetadata.getExtraInfo(), (String)HiveUtil.columnExtraInfo((boolean)partitionKey));
        }
        this.assertColumnType(tableMetadata, "_string", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "_varchar", (Type)VarcharType.createVarcharType((int)65535));
        this.assertColumnType(tableMetadata, "_char", (Type)CharType.createCharType((long)10L));
        this.assertColumnType(tableMetadata, "_partition_string", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "_partition_varchar", (Type)VarcharType.createVarcharType((int)65535));
        MaterializedResult result = this.computeActual("SELECT * from test_partitioned_table");
        Assert.assertEquals((int)result.getRowCount(), (int)0);
        String select = "SELECT 'foo' _string, 'bar' _varchar, CAST('boo' AS CHAR(10)) _char, CAST(1 AS BIGINT) _bigint, 2 _integer, CAST (3 AS SMALLINT) _smallint, CAST (4 AS TINYINT) _tinyint, CAST('123.45' AS REAL) _real, CAST('3.14' AS DOUBLE) _double, true _boolean, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long, 'foo' _partition_string, 'bar' _partition_varchar, CAST('boo' AS CHAR(10)) _partition_char, CAST(1 AS TINYINT) _partition_tinyint, CAST(1 AS SMALLINT) _partition_smallint, 1 _partition_integer, CAST (1 AS BIGINT) _partition_bigint, true _partition_boolean, CAST('3.14' AS DECIMAL(3,2)) _partition_decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _partition_decimal_long, CAST('2017-05-01' AS DATE) _partition_date, CAST('2017-05-01 10:12:34' AS TIMESTAMP) _partition_timestamp";
        if (storageFormat == HiveStorageFormat.AVRO) {
            select = select.replace(" CAST (3 AS SMALLINT) _smallint,", " 3 _smallint,");
            select = select.replace(" CAST (4 AS TINYINT) _tinyint,", " 4 _tinyint,");
        }
        this.assertUpdate(session, "INSERT INTO test_partitioned_table " + select, 1L);
        this.assertQuery(session, "SELECT * from test_partitioned_table", select);
        this.assertQuery(session, "SELECT * from test_partitioned_table WHERE 'foo' = _partition_string AND 'bar' = _partition_varchar AND CAST('boo' AS CHAR(10)) = _partition_char AND CAST(1 AS TINYINT) = _partition_tinyint AND CAST(1 AS SMALLINT) = _partition_smallint AND 1 = _partition_integer AND CAST(1 AS BIGINT) = _partition_bigint AND true = _partition_boolean AND CAST('3.14' AS DECIMAL(3,2)) = _partition_decimal_short AND CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) = _partition_decimal_long AND CAST('2017-05-01' AS DATE) = _partition_date AND CAST('2017-05-01 10:12:34' AS TIMESTAMP) = _partition_timestamp", select);
        this.assertUpdate(session, "DROP TABLE test_partitioned_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_partitioned_table"));
    }

    @Test
    public void createTableLike() {
        this.createTableLike("", false);
        this.createTableLike("EXCLUDING PROPERTIES", false);
        this.createTableLike("INCLUDING PROPERTIES", true);
    }

    private void createTableLike(String likeSuffix, boolean hasPartition) {
        String createTable = "CREATE TABLE test_table_original (  tinyint_col tinyint , smallint_col smallint)";
        this.assertUpdate(createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_table_original");
        this.assertColumnType(tableMetadata, "tinyint_col", (Type)TinyintType.TINYINT);
        this.assertColumnType(tableMetadata, "smallint_col", (Type)SmallintType.SMALLINT);
        String createPartitionedTable = "CREATE TABLE test_partitioned_table_original (  string_col VARCHAR, decimal_long_col DECIMAL(30,10), partition_bigint BIGINT, partition_decimal_long DECIMAL(30,10)) WITH (partitioned_by = ARRAY['partition_bigint', 'partition_decimal_long'])";
        this.assertUpdate(createPartitionedTable);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_original");
        ImmutableList partitionedBy = ImmutableList.of((Object)"partition_bigint", (Object)"partition_decimal_long");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)partitionedBy);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        String createTableSingleLike = "CREATE TABLE test_partitioned_table_single_like (LIKE test_partitioned_table_original " + likeSuffix + ")";
        this.assertUpdate(createTableSingleLike);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_single_like");
        this.verifyPartition(hasPartition, tableMetadata, (List<String>)partitionedBy);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        String createTableLikeExtra = "CREATE TABLE test_partitioned_table_like_extra (  bigint_col BIGINT, double_col DOUBLE, LIKE test_partitioned_table_single_like " + likeSuffix + ")";
        this.assertUpdate(createTableLikeExtra);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_like_extra");
        this.verifyPartition(hasPartition, tableMetadata, (List<String>)partitionedBy);
        this.assertColumnType(tableMetadata, "bigint_col", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "double_col", (Type)DoubleType.DOUBLE);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        String createTableDoubleLike = "CREATE TABLE test_partitioned_table_double_like (  LIKE test_table_original , LIKE test_partitioned_table_like_extra " + likeSuffix + ")";
        this.assertUpdate(createTableDoubleLike);
        tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_partitioned_table_double_like");
        this.verifyPartition(hasPartition, tableMetadata, (List<String>)partitionedBy);
        this.assertColumnType(tableMetadata, "tinyint_col", (Type)TinyintType.TINYINT);
        this.assertColumnType(tableMetadata, "smallint_col", (Type)SmallintType.SMALLINT);
        this.assertColumnType(tableMetadata, "string_col", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "partition_bigint", (Type)BigintType.BIGINT);
        this.assertColumnType(tableMetadata, "partition_decimal_long", (Type)DecimalType.createDecimalType((int)30, (int)10));
        this.assertUpdate("DROP TABLE test_table_original");
        this.assertUpdate("DROP TABLE test_partitioned_table_original");
        this.assertUpdate("DROP TABLE test_partitioned_table_single_like");
        this.assertUpdate("DROP TABLE test_partitioned_table_like_extra");
        this.assertUpdate("DROP TABLE test_partitioned_table_double_like");
    }

    @Test
    public void testCreateTableAs() {
        this.testWithAllStorageFormats(this::testCreateTableAs);
    }

    private void testCreateTableAs(Session session, HiveStorageFormat storageFormat) {
        if (!this.insertOperationsSupported(storageFormat)) {
            return;
        }
        String select = "SELECT 'foo' _varchar, CAST('bar' AS CHAR(10)) _char, CAST (1 AS BIGINT) _bigint, 2 _integer, CAST (3 AS SMALLINT) _smallint, CAST (4 AS TINYINT) _tinyint, CAST ('123.45' as REAL) _real, CAST('3.14' AS DOUBLE) _double, true _boolean, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long";
        if (storageFormat == HiveStorageFormat.AVRO) {
            select = select.replace(" CAST (3 AS SMALLINT) _smallint,", " 3 _smallint,");
            select = select.replace(" CAST (4 AS TINYINT) _tinyint,", " 4 _tinyint,");
        }
        String createTableAs = String.format("CREATE TABLE test_format_table WITH (format = '%s') AS %s", storageFormat, select);
        this.assertUpdate(session, createTableAs, 1L);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_format_table");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        this.assertColumnType(tableMetadata, "_varchar", (Type)VarcharType.createVarcharType((int)3));
        this.assertColumnType(tableMetadata, "_char", (Type)CharType.createCharType((long)10L));
        this.assertQuery(session, "SELECT _integer, _varchar, _integer from test_format_table", "SELECT 2, 'foo', 2");
        this.assertQuery(session, "SELECT * from test_format_table", select);
        this.assertUpdate(session, "DROP TABLE test_format_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_format_table"));
    }

    @Test
    public void testCreatePartitionedTableAs() {
        this.testWithAllStorageFormats(this::testCreatePartitionedTableAs);
    }

    private void testCreatePartitionedTableAs(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_create_partitioned_table_as WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'SHIP_PRIORITY', 'ORDER_STATUS' ]) AS SELECT orderkey AS order_key, shippriority AS ship_priority, orderstatus AS order_status FROM tpch.tiny.orders";
        this.assertUpdate(session, createTable, "SELECT count(*) from orders");
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_create_partitioned_table_as");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"ship_priority", (Object)"order_status"));
        List<?> partitions = this.getPartitions("test_create_partitioned_table_as");
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * from test_create_partitioned_table_as", "SELECT orderkey, shippriority, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE test_create_partitioned_table_as");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_create_partitioned_table_as"));
    }

    @Test
    public void testInlineRecursiveSqlFunctions() {
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("inline_sql_functions", "false").build();
        String createTable = "create table if not exists test_array_temp as select sequence(1, 10) x";
        String queryTable = "SELECT\n\"array_sum\"(\"transform\"(x, (y) -> \"cardinality\"(x)))\n, \"array_sum\"(\"transform\"(x, (y) -> \"array_sum\"(\"transform\"(x, (check) -> IF((NOT random(10) > 10), 1, 0)))))\nFROM\ntest_array_temp";
        this.assertUpdate(session, createTable, 1L);
        this.assertQuerySucceeds(session, queryTable);
    }

    @Test
    public void testCreatePartitionedTableAsShuffleOnPartitionColumns() {
        this.testCreatePartitionedTableAsShuffleOnPartitionColumns(Session.builder((Session)this.getSession()).setSystemProperty("task_writer_count", "1").setCatalogSessionProperty(this.catalog, "shuffle_partitioned_columns_for_table_write", "true").build(), HiveStorageFormat.ORC);
    }

    public void testCreatePartitionedTableAsShuffleOnPartitionColumns(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_create_partitioned_table_as_shuffle_on_partition_columns WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'SHIP_PRIORITY', 'ORDER_STATUS' ]) AS SELECT orderkey AS order_key, shippriority AS ship_priority, orderstatus AS order_status FROM tpch.tiny.orders";
        this.assertUpdate(session, createTable, "SELECT count(*) from orders");
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_create_partitioned_table_as_shuffle_on_partition_columns");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"ship_priority", (Object)"order_status"));
        List<?> partitions = this.getPartitions("test_create_partitioned_table_as_shuffle_on_partition_columns");
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT count(distinct \"$path\") from test_create_partitioned_table_as_shuffle_on_partition_columns", "SELECT 3");
        this.assertQuery(session, "SELECT * from test_create_partitioned_table_as_shuffle_on_partition_columns", "SELECT orderkey, shippriority, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE test_create_partitioned_table_as_shuffle_on_partition_columns");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_create_partitioned_table_as_shuffle_on_partition_columns"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Partition keys must be the last columns in the table and in the same order as the table properties.*")
    public void testCreatePartitionedTableInvalidColumnOrdering() {
        this.assertUpdate("CREATE TABLE test_create_table_invalid_column_ordering\n(grape bigint, apple varchar, orange bigint, pear varchar)\nWITH (partitioned_by = ARRAY['apple'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Partition keys must be the last columns in the table and in the same order as the table properties.*")
    public void testCreatePartitionedTableAsInvalidColumnOrdering() {
        this.assertUpdate("CREATE TABLE test_create_table_as_invalid_column_ordering WITH (partitioned_by = ARRAY['SHIP_PRIORITY', 'ORDER_STATUS']) AS SELECT shippriority AS ship_priority, orderkey AS order_key, orderstatus AS order_status FROM tpch.tiny.orders");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Table contains only partition columns")
    public void testCreateTableOnlyPartitionColumns() {
        this.assertUpdate("CREATE TABLE test_create_table_only_partition_columns\n(grape bigint, apple varchar, orange bigint, pear varchar)\nWITH (partitioned_by = ARRAY['grape', 'apple', 'orange', 'pear'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Partition columns .* not present in schema")
    public void testCreateTableNonExistentPartitionColumns() {
        this.assertUpdate("CREATE TABLE test_create_table_nonexistent_partition_columns\n(grape bigint, apple varchar, orange bigint, pear varchar)\nWITH (partitioned_by = ARRAY['dragonfruit'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Unsupported type .* for partition: .*")
    public void testCreateTableUnsupportedPartitionType() {
        this.assertUpdate("CREATE TABLE test_create_table_unsupported_partition_type (foo bigint, bar ARRAY(varchar)) WITH (partitioned_by = ARRAY['bar'])");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Unsupported type .* for partition: a")
    public void testCreateTableUnsupportedPartitionTypeAs() {
        this.assertUpdate("CREATE TABLE test_create_table_unsupported_partition_type_as WITH (partitioned_by = ARRAY['a']) AS SELECT 123 x, ARRAY ['foo'] a");
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="Unsupported Hive type: varchar\\(65536\\)\\. Supported VARCHAR types: VARCHAR\\(<=65535\\), VARCHAR\\.")
    public void testCreateTableNonSupportedVarcharColumn() {
        this.assertUpdate("CREATE TABLE test_create_table_non_supported_varchar_column (apple varchar(65536))");
    }

    @Test
    public void testCreatePartitionedBucketedTableAsFewRows() {
        this.testWithAllStorageFormats((session, format) -> this.testCreatePartitionedBucketedTableAsFewRows((Session)session, (HiveStorageFormat)format, false, false));
        this.testWithAllStorageFormats((session, format) -> this.testCreatePartitionedBucketedTableAsFewRows((Session)session, (HiveStorageFormat)format, false, true));
        this.testWithAllStorageFormats((session, format) -> this.testCreatePartitionedBucketedTableAsFewRows((Session)session, (HiveStorageFormat)format, true, false));
        this.testWithAllStorageFormats((session, format) -> this.testCreatePartitionedBucketedTableAsFewRows((Session)session, (HiveStorageFormat)format, true, true));
    }

    private void testCreatePartitionedBucketedTableAsFewRows(Session session, HiveStorageFormat storageFormat, boolean optimizedPartitionUpdateSerializationEnabled, boolean createEmpty) {
        String tableName = "test_create_partitioned_bucketed_table_as_few_rows";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'partition_key' ], bucketed_by = ARRAY[ 'bucket_key' ], bucket_count = 11 ) AS SELECT * FROM (VALUES   (VARCHAR 'a', VARCHAR 'b', VARCHAR 'c'),   ('aa', 'bb', 'cc'),   ('aaa', 'bbb', 'ccc')) t(bucket_key, col, partition_key)";
        this.assertUpdate(Session.builder((Session)this.getTableWriteTestingSession(optimizedPartitionUpdateSerializationEnabled)).setCatalogSessionProperty(this.catalog, "create_empty_bucket_files", String.valueOf(createEmpty)).build(), createTable, 3L);
        this.verifyPartitionedBucketedTableAsFewRows(storageFormat, tableName);
        Assertions.assertThatThrownBy(() -> this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES ('a0', 'b0', 'c')", 1L)).hasMessage(TestHiveIntegrationSmokeTest.getExpectedErrorMessageForInsertExistingBucketedTable(HiveSessionProperties.getInsertExistingPartitionsBehavior((ConnectorSession)TestHiveIntegrationSmokeTest.getConnectorSession(session)), "partition_key=c"));
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testCreatePartitionedBucketedTableAs() {
        this.testCreatePartitionedBucketedTableAs(HiveStorageFormat.RCBINARY, false);
        this.testCreatePartitionedBucketedTableAs(HiveStorageFormat.RCBINARY, true);
    }

    private void testCreatePartitionedBucketedTableAs(HiveStorageFormat storageFormat, boolean optimizedPartitionUpdateSerializationEnabled) {
        String tableName = "test_create_partitioned_bucketed_table_as";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11 ) AS SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders";
        this.assertUpdate(this.getTableWriteTestingSession(optimizedPartitionUpdateSerializationEnabled), createTable, "SELECT count(*) from orders");
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testCreatePartitionedBucketedTableAsWithUnionAll() {
        this.testCreatePartitionedBucketedTableAsWithUnionAll(HiveStorageFormat.RCBINARY, false);
        this.testCreatePartitionedBucketedTableAsWithUnionAll(HiveStorageFormat.RCBINARY, true);
    }

    private void testCreatePartitionedBucketedTableAsWithUnionAll(HiveStorageFormat storageFormat, boolean optimizedPartitionUpdateSerializationEnabled) {
        String tableName = "test_create_partitioned_bucketed_table_as_with_union_all";
        String createTable = "CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11 ) AS SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE length(comment) % 2 = 0 UNION ALL SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE length(comment) % 2 = 1";
        this.assertUpdate(this.getTableWriteTestingSession(optimizedPartitionUpdateSerializationEnabled), createTable, "SELECT count(*) from orders");
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    private void verifyPartitionedBucketedTable(HiveStorageFormat storageFormat, String tableName) {
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"orderstatus"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"custkey", (Object)"custkey2"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        List<?> partitions = this.getPartitions(tableName);
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery("SELECT * from " + tableName, "SELECT custkey, custkey, comment, orderstatus FROM orders");
        for (int i = 1; i <= 30; ++i) {
            this.assertQuery(String.format("SELECT * from " + tableName + " where custkey = %d and custkey2 = %d", i, i), String.format("SELECT custkey, custkey, comment, orderstatus FROM orders where custkey = %d", i));
        }
        Assertions.assertThatThrownBy(() -> this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 1, 'comment', 'O')", 1L)).hasMessage(TestHiveIntegrationSmokeTest.getExpectedErrorMessageForInsertExistingBucketedTable(HiveSessionProperties.getInsertExistingPartitionsBehavior((ConnectorSession)TestHiveIntegrationSmokeTest.getConnectorSession(this.getSession())), "orderstatus=O"));
    }

    @Test
    public void testCreateInvalidBucketedTable() {
        this.testCreateInvalidBucketedTable(HiveStorageFormat.RCBINARY);
    }

    private void testCreateInvalidBucketedTable(HiveStorageFormat storageFormat) {
        String tableName = "test_create_invalid_bucketed_table";
        try {
            this.computeActual("CREATE TABLE " + tableName + " (  a BIGINT,  b DOUBLE,  p VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'p' ], bucketed_by = ARRAY[ 'a', 'c' ], bucket_count = 11 )");
            org.testng.Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Bucketing columns [c] not present in schema");
        }
        try {
            this.computeActual("CREATE TABLE " + tableName + " WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey3' ], bucket_count = 11 ) AS SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders");
            org.testng.Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Bucketing columns [custkey3] not present in schema");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testCreatePartitionedUnionAll() {
        this.assertUpdate("CREATE TABLE test_create_partitioned_union_all (a varchar, ds varchar) WITH (partitioned_by = ARRAY['ds'])");
        this.assertUpdate("INSERT INTO test_create_partitioned_union_all SELECT 'a', '2013-05-17' UNION ALL SELECT 'b', '2013-05-17'", 2L);
        this.assertUpdate("DROP TABLE test_create_partitioned_union_all");
    }

    @Test
    public void testInsertPartitionedBucketedTableFewRows() {
        this.testWithAllStorageFormats((session, format) -> this.testInsertPartitionedBucketedTableFewRows((Session)session, (HiveStorageFormat)format, false));
        this.testWithAllStorageFormats((session, format) -> this.testInsertPartitionedBucketedTableFewRows((Session)session, (HiveStorageFormat)format, true));
    }

    private void testInsertPartitionedBucketedTableFewRows(Session session, HiveStorageFormat storageFormat, boolean optimizedPartitionUpdateSerializationEnabled) {
        String tableName = "test_insert_partitioned_bucketed_table_few_rows";
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (  bucket_key varchar,  col varchar,  partition_key varchar)WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'partition_key' ], bucketed_by = ARRAY[ 'bucket_key' ], bucket_count = 11)");
        this.assertUpdate(this.getTableWriteTestingSession(optimizedPartitionUpdateSerializationEnabled), "INSERT INTO " + tableName + " VALUES   (VARCHAR 'a', VARCHAR 'b', VARCHAR 'c'),   ('aa', 'bb', 'cc'),   ('aaa', 'bbb', 'ccc')", 3L);
        this.verifyPartitionedBucketedTableAsFewRows(storageFormat, tableName);
        Assertions.assertThatThrownBy(() -> this.assertUpdate(session, "INSERT INTO test_insert_partitioned_bucketed_table_few_rows VALUES ('a0', 'b0', 'c')", 1L)).hasMessage(TestHiveIntegrationSmokeTest.getExpectedErrorMessageForInsertExistingBucketedTable(HiveSessionProperties.getInsertExistingPartitionsBehavior((ConnectorSession)TestHiveIntegrationSmokeTest.getConnectorSession(session)), "partition_key=c"));
        this.assertUpdate(session, "DROP TABLE test_insert_partitioned_bucketed_table_few_rows");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    private void verifyPartitionedBucketedTableAsFewRows(HiveStorageFormat storageFormat, String tableName) {
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"partition_key"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"bucket_key"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        List<?> partitions = this.getPartitions(tableName);
        Assert.assertEquals((int)partitions.size(), (int)3);
        MaterializedResult actual = this.computeActual("SELECT * from " + tableName);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{this.canonicalizeType((Type)VarcharType.createUnboundedVarcharType()), this.canonicalizeType((Type)VarcharType.createUnboundedVarcharType()), this.canonicalizeType((Type)VarcharType.createUnboundedVarcharType())}).row(new Object[]{"a", "b", "c"}).row(new Object[]{"aa", "bb", "cc"}).row(new Object[]{"aaa", "bbb", "ccc"}).build();
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual.getMaterializedRows(), (Iterable)expected.getMaterializedRows());
    }

    @Test
    public void testCastNullToColumnTypes() {
        String tableName = "test_cast_null_to_column_types";
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "orc_optimized_writer_enabled", "true").build();
        this.assertUpdate(session, "CREATE TABLE " + tableName + " (  col1 bigint,  col2 map(bigint, bigint),  partition_key varchar)WITH (  format = 'ORC',   partitioned_by = ARRAY[ 'partition_key' ] )");
        this.assertUpdate(session, String.format("INSERT INTO %s (col1) VALUES (1), (2), (3)", tableName), 3L);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateEmptyNonBucketedPartition() {
        this.testCreateEmptyNonBucketedPartition(false);
        this.testCreateEmptyNonBucketedPartition(true);
    }

    public void testCreateEmptyNonBucketedPartition(boolean optimizedPartitionUpdateSerializationEnabled) {
        String tableName = "test_insert_empty_partitioned_unbucketed_table";
        this.assertUpdate("CREATE TABLE " + tableName + " (  dummy_col bigint,  part varchar)WITH (  format = 'ORC',   partitioned_by = ARRAY[ 'part' ] )");
        this.assertQuery(String.format("SELECT count(*) FROM \"%s$partitions\"", tableName), "SELECT 0");
        this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "optimized_partition_update_serialization_enabled", optimizedPartitionUpdateSerializationEnabled + "").build(), String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['part'], ARRAY['%s'])", "tpch", tableName, "empty"));
        this.assertQuery(String.format("SELECT count(*) FROM \"%s$partitions\"", tableName), "SELECT 1");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateEmptyUnpartitionedBucketedTable() {
        String tableName = "test_create_empty_bucketed_table";
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (   bucketed_by = ARRAY[ 'custkey' ],    bucket_count = 11 ) AS SELECT custkey, comment FROM customer WHERE custkey < 0", 0L);
        this.assertQuery("SELECT count(*) FROM " + tableName, "SELECT 0");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateEmptyUnpartitionedBucketedTableNoStaging() {
        String tableName = "test_create_empty_bucketed_table_no_staging";
        this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "temporary_staging_directory_enabled", "false").build(), "CREATE TABLE " + tableName + " WITH (   bucketed_by = ARRAY[ 'custkey' ],    bucket_count = 11 ) AS SELECT custkey, comment FROM customer WHERE custkey < 0", 0L);
        this.assertQuery("SELECT count(*) FROM " + tableName, "SELECT 0");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateEmptyBucketedPartition() {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            this.testCreateEmptyBucketedPartition(storageFormat.getFormat(), false);
            this.testCreateEmptyBucketedPartition(storageFormat.getFormat(), true);
        }
    }

    public void testCreateEmptyBucketedPartition(HiveStorageFormat storageFormat, boolean optimizedPartitionUpdateSerializationEnabled) {
        String tableName = "test_insert_empty_partitioned_bucketed_table";
        this.createPartitionedBucketedTable(tableName, storageFormat);
        ImmutableList orderStatusList = ImmutableList.of((Object)"F", (Object)"O", (Object)"P");
        for (int i = 0; i < orderStatusList.size(); ++i) {
            String sql = String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['orderstatus'], ARRAY['%s'])", "tpch", tableName, orderStatusList.get(i));
            this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "optimized_partition_update_serialization_enabled", optimizedPartitionUpdateSerializationEnabled + "").build(), sql);
            this.assertQuery(String.format("SELECT count(*) FROM \"%s$partitions\"", tableName), "SELECT " + (i + 1));
            this.assertQueryFails(sql, "Partition already exists.*");
        }
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testInsertPartitionedBucketedTable() {
        this.testInsertPartitionedBucketedTable(HiveStorageFormat.RCBINARY, false);
        this.testInsertPartitionedBucketedTable(HiveStorageFormat.RCBINARY, true);
    }

    private void testInsertPartitionedBucketedTable(HiveStorageFormat storageFormat, boolean optimizedPartitionUpdateSerializationEnabled) {
        String tableName = "test_insert_partitioned_bucketed_table";
        this.createPartitionedBucketedTable(tableName, storageFormat);
        ImmutableList orderStatusList = ImmutableList.of((Object)"F", (Object)"O", (Object)"P");
        for (int i = 0; i < orderStatusList.size(); ++i) {
            String orderStatus = (String)orderStatusList.get(i);
            this.assertUpdate(this.getTableWriteTestingSession(optimizedPartitionUpdateSerializationEnabled), String.format("INSERT INTO " + tableName + " SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE orderstatus = '%s'", orderStatus), String.format("SELECT count(*) from orders where orderstatus = '%s'", orderStatus));
        }
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    private void createPartitionedBucketedTable(String tableName, HiveStorageFormat storageFormat) {
        this.assertUpdate("CREATE TABLE " + tableName + " (  custkey bigint,  custkey2 bigint,  comment varchar,  orderstatus varchar)WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11)");
    }

    @Test
    public void testInsertPartitionedBucketedTableWithUnionAll() {
        this.testInsertPartitionedBucketedTableWithUnionAll(HiveStorageFormat.RCBINARY, false);
        this.testInsertPartitionedBucketedTableWithUnionAll(HiveStorageFormat.RCBINARY, true);
    }

    private void testInsertPartitionedBucketedTableWithUnionAll(HiveStorageFormat storageFormat, boolean optimizedPartitionUpdateSerializationEnabled) {
        String tableName = "test_insert_partitioned_bucketed_table_with_union_all";
        this.assertUpdate("CREATE TABLE " + tableName + " (  custkey bigint,  custkey2 bigint,  comment varchar,  orderstatus varchar)WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'orderstatus' ], bucketed_by = ARRAY[ 'custkey', 'custkey2' ], bucket_count = 11)");
        ImmutableList orderStatusList = ImmutableList.of((Object)"F", (Object)"O", (Object)"P");
        for (int i = 0; i < orderStatusList.size(); ++i) {
            String orderStatus = (String)orderStatusList.get(i);
            this.assertUpdate(this.getTableWriteTestingSession(optimizedPartitionUpdateSerializationEnabled), String.format("INSERT INTO " + tableName + " SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE orderstatus = '%s' and length(comment) %% 2 = 0 UNION ALL SELECT custkey, custkey AS custkey2, comment, orderstatus FROM tpch.tiny.orders WHERE orderstatus = '%s' and length(comment) %% 2 = 1", orderStatus, orderStatus), String.format("SELECT count(*) from orders where orderstatus = '%s'", orderStatus));
        }
        this.verifyPartitionedBucketedTable(storageFormat, tableName);
        this.assertUpdate("DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName));
    }

    @Test
    public void testInsert() {
        this.testWithAllStorageFormats(this::testInsert);
    }

    private void testInsert(Session session, HiveStorageFormat storageFormat) {
        if (!this.insertOperationsSupported(storageFormat)) {
            return;
        }
        String createTable = "CREATE TABLE test_insert_format_table (  _string VARCHAR,  _varchar VARCHAR(65535),  _char CHAR(10),  _bigint BIGINT,  _integer INTEGER,  _smallint SMALLINT,  _tinyint TINYINT,  _real REAL,  _double DOUBLE,  _boolean BOOLEAN,  _decimal_short DECIMAL(3,2),  _decimal_long DECIMAL(30,10)) WITH (format = '" + storageFormat + "') ";
        if (storageFormat == HiveStorageFormat.AVRO) {
            createTable = createTable.replace(" _smallint SMALLINT,", " _smallint INTEGER,");
            createTable = createTable.replace(" _tinyint TINYINT,", " _tinyint INTEGER,");
        }
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_insert_format_table");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        this.assertColumnType(tableMetadata, "_string", (Type)VarcharType.createUnboundedVarcharType());
        this.assertColumnType(tableMetadata, "_varchar", (Type)VarcharType.createVarcharType((int)65535));
        this.assertColumnType(tableMetadata, "_char", (Type)CharType.createCharType((long)10L));
        String select = "SELECT 'foo' _string, 'bar' _varchar, CAST('boo' AS CHAR(10)) _char, 1 _bigint, CAST(42 AS INTEGER) _integer, CAST(43 AS SMALLINT) _smallint, CAST(44 AS TINYINT) _tinyint, CAST('123.45' AS REAL) _real, CAST('3.14' AS DOUBLE) _double, true _boolean, CAST('3.14' AS DECIMAL(3,2)) _decimal_short, CAST('12345678901234567890.0123456789' AS DECIMAL(30,10)) _decimal_long";
        if (storageFormat == HiveStorageFormat.AVRO) {
            select = select.replace(" CAST (43 AS SMALLINT) _smallint,", " 3 _smallint,");
            select = select.replace(" CAST (44 AS TINYINT) _tinyint,", " 4 _tinyint,");
        }
        this.assertUpdate(session, "INSERT INTO test_insert_format_table " + select, 1L);
        this.assertQuery(session, "SELECT * from test_insert_format_table", select);
        this.assertUpdate(session, "INSERT INTO test_insert_format_table (_tinyint, _smallint, _integer, _bigint, _real, _double) SELECT CAST(1 AS TINYINT), CAST(2 AS SMALLINT), 3, 4, cast(14.3E0 as REAL), 14.3E0", 1L);
        this.assertQuery(session, "SELECT * from test_insert_format_table where _bigint = 4", "SELECT null, null, null, 4, 3, 2, 1, 14.3, 14.3, null, null, null");
        this.assertQuery(session, "SELECT * from test_insert_format_table where _real = CAST(14.3 as REAL)", "SELECT null, null, null, 4, 3, 2, 1, 14.3, 14.3, null, null, null");
        this.assertUpdate(session, "INSERT INTO test_insert_format_table (_double, _bigint) SELECT 2.72E0, 3", 1L);
        this.assertQuery(session, "SELECT * from test_insert_format_table where _bigint = 3", "SELECT null, null, null, 3, null, null, null, null, 2.72, null, null, null");
        this.assertUpdate(session, "INSERT INTO test_insert_format_table (_decimal_short, _decimal_long) SELECT DECIMAL '2.72', DECIMAL '98765432101234567890.0123456789'", 1L);
        this.assertQuery(session, "SELECT * from test_insert_format_table where _decimal_long = DECIMAL '98765432101234567890.0123456789'", "SELECT null, null, null, null, null, null, null, null, null, null, 2.72, 98765432101234567890.0123456789");
        this.assertUpdate(session, "DROP TABLE test_insert_format_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_insert_format_table"));
    }

    @Test
    public void testInsertPartitionedTable() {
        this.testWithAllStorageFormats(this::testInsertPartitionedTable);
    }

    private void testInsertPartitionedTable(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_insert_partitioned_table (  ORDER_KEY BIGINT,  SHIP_PRIORITY INTEGER,  ORDER_STATUS VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'SHIP_PRIORITY', 'ORDER_STATUS' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_insert_partitioned_table");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"ship_priority", (Object)"order_status"));
        String partitionsTable = "\"test_insert_partitioned_table$partitions\"";
        this.assertQuery(session, "SELECT * FROM " + partitionsTable, "SELECT shippriority, orderstatus FROM orders LIMIT 0");
        this.assertUpdate(session, "INSERT INTO test_insert_partitioned_table SELECT orderkey, shippriority, orderstatus FROM tpch.tiny.orders", "SELECT count(*) from orders");
        List<?> partitions = this.getPartitions("test_insert_partitioned_table");
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * from test_insert_partitioned_table", "SELECT orderkey, shippriority, orderstatus FROM orders");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable, "SELECT DISTINCT shippriority, orderstatus FROM orders");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " ORDER BY order_status LIMIT 2", "SELECT DISTINCT shippriority, orderstatus FROM orders ORDER BY orderstatus LIMIT 2");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " WHERE order_status = 'O'", "SELECT DISTINCT shippriority, orderstatus FROM orders WHERE orderstatus = 'O'");
        this.assertQueryFails(session, "SELECT * FROM " + partitionsTable + " WHERE no_such_column = 1", "line \\S*: Column 'no_such_column' cannot be resolved");
        this.assertQueryFails(session, "SELECT * FROM " + partitionsTable + " WHERE orderkey = 1", "line \\S*: Column 'orderkey' cannot be resolved");
        this.assertUpdate(session, "DROP TABLE test_insert_partitioned_table");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_insert_partitioned_table"));
    }

    @Test
    public void testInsertPartitionedTableShuffleOnPartitionColumns() {
        this.testInsertPartitionedTableShuffleOnPartitionColumns(Session.builder((Session)this.getSession()).setSystemProperty("task_writer_count", "1").setCatalogSessionProperty(this.catalog, "shuffle_partitioned_columns_for_table_write", "true").build(), HiveStorageFormat.ORC);
    }

    public void testInsertPartitionedTableShuffleOnPartitionColumns(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_table_shuffle_on_partition_columns";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'order_status' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"order_status"));
        this.assertUpdate(session, "INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders", "SELECT count(*) from orders");
        List<?> partitions = this.getPartitions(tableName);
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * from " + tableName, "SELECT orderkey, comment, orderstatus FROM orders");
        this.assertQuery(session, "SELECT count(distinct \"$path\") from " + tableName, "SELECT 3");
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testInsertPartitionedTableExistingPartition() {
        this.testWithAllStorageFormats(this::testInsertPartitionedTableExistingPartition);
    }

    private void testInsertPartitionedTableExistingPartition(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_table_existing_partition";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'order_status' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"order_status"));
        for (int i = 0; i < 3; ++i) {
            this.assertUpdate(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", i), String.format("SELECT count(*) from orders where orderkey %% 3 = %d", i));
        }
        List<?> partitions = this.getPartitions(tableName);
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * from " + tableName, "SELECT orderkey, comment, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testInsertPartitionedTableOverwriteExistingPartition() {
        this.testInsertPartitionedTableOverwriteExistingPartition(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "insert_existing_partitions_behavior", "OVERWRITE").build(), HiveStorageFormat.ORC);
    }

    private void testInsertPartitionedTableOverwriteExistingPartition(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_table_overwrite_existing_partition";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'order_status' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"order_status"));
        for (int i = 0; i < 3; ++i) {
            this.assertUpdate(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", i), String.format("SELECT count(*) from orders where orderkey %% 3 = %d", i));
            List<?> partitions = this.getPartitions(tableName);
            Assert.assertEquals((int)partitions.size(), (int)3);
            this.assertQuery(session, "SELECT * from " + tableName, String.format("SELECT orderkey, comment, orderstatus FROM orders where orderkey %% 3 = %d", i));
        }
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testInsertPartitionedTableImmutableExistingPartition() {
        this.testInsertPartitionedTableImmutableExistingPartition(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "insert_existing_partitions_behavior", "ERROR").build(), HiveStorageFormat.ORC);
        this.testInsertPartitionedTableImmutableExistingPartition(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "insert_existing_partitions_behavior", "ERROR").setCatalogSessionProperty(this.catalog, "temporary_staging_directory_enabled", "false").build(), HiveStorageFormat.ORC);
        this.testInsertPartitionedTableImmutableExistingPartition(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "insert_existing_partitions_behavior", "ERROR").setCatalogSessionProperty(this.catalog, "fail_fast_on_insert_into_immutable_partitions_enabled", "false").build(), HiveStorageFormat.ORC);
    }

    public void testInsertPartitionedTableImmutableExistingPartition(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_partitioned_table_immutable_existing_partition";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'order_status' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"order_status"));
        this.assertUpdate(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", 0), String.format("SELECT count(*) from orders where orderkey %% 3 = %d", 0));
        List<?> partitions = this.getPartitions(tableName);
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * from " + tableName, String.format("SELECT orderkey, comment, orderstatus FROM orders where orderkey %% 3 = %d", 0));
        this.assertQueryFails(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", 0), ".*Cannot insert into an existing partition of Hive table.*");
        partitions = this.getPartitions(tableName);
        Assert.assertEquals((int)partitions.size(), (int)3);
        this.assertQuery(session, "SELECT * from " + tableName, String.format("SELECT orderkey, comment, orderstatus FROM orders where orderkey %% 3 = %d", 0));
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testNullPartitionValues() {
        this.assertUpdate("CREATE TABLE test_null_partition (test VARCHAR, part VARCHAR)\nWITH (partitioned_by = ARRAY['part'])");
        this.assertUpdate("INSERT INTO test_null_partition VALUES ('hello', 'test'), ('world', null)", 2L);
        this.assertQuery("SELECT * FROM test_null_partition", "VALUES ('hello', 'test'), ('world', null)");
        this.assertQuery("SELECT * FROM \"test_null_partition$partitions\"", "VALUES 'test', null");
        this.assertUpdate("DROP TABLE test_null_partition");
    }

    @Test
    public void testPartitionPerScanLimit() {
        this.testPartitionPerScanLimit(this.getSession(), HiveStorageFormat.DWRF);
    }

    private void testPartitionPerScanLimit(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_partition_per_scan_limit";
        String partitionsTable = "\"" + tableName + "$partitions\"";
        String createTable = "CREATE TABLE " + tableName + " (  foo VARCHAR,  part BIGINT) WITH (format = '" + storageFormat + "', partitioned_by = ARRAY[ 'part' ]) ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("partitioned_by"), (Object)ImmutableList.of((Object)"part"));
        for (int i = 0; i < 12; ++i) {
            int partStart = i * 100;
            int partEnd = (i + 1) * 100 - 1;
            String insertPartitions = "INSERT INTO " + tableName + " SELECT 'bar' foo, part FROM UNNEST(SEQUENCE(" + partStart + ", " + partEnd + ")) AS TMP(part)";
            this.assertUpdate(session, insertPartitions, 100L);
        }
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " WHERE part > 490 and part <= 500", "VALUES 491, 492, 493, 494, 495, 496, 497, 498, 499, 500");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable + " WHERE part < 0", "SELECT null WHERE false");
        this.assertQuery(session, "SELECT * FROM " + partitionsTable, "VALUES " + LongStream.range(0L, 1200L).mapToObj(String::valueOf).collect(Collectors.joining(",")));
        this.assertQuery(session, "SELECT count(foo) FROM " + tableName + " WHERE part < 1000", "SELECT 1000");
        this.assertQuery(session, "SELECT count(foo) FROM " + tableName + " WHERE part >= 1000 AND part < 1200", "SELECT 200");
        this.assertQueryFails(session, "SELECT * from " + tableName + " WHERE part < 1001", String.format("Query over table 'tpch.%s' can potentially read more than 1000 partitions", tableName));
        this.assertQueryFails(session, "SELECT * from " + tableName, String.format("Query over table 'tpch.%s' can potentially read more than 1000 partitions", tableName));
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testShowColumnsFromPartitions() {
        String tableName = "test_show_columns_from_partitions";
        String createTable = "CREATE TABLE " + tableName + " (  foo VARCHAR,  part1 BIGINT,  part2 VARCHAR) WITH (partitioned_by = ARRAY[ 'part1', 'part2' ]) ";
        this.assertUpdate(this.getSession(), createTable);
        this.assertQuery(this.getSession(), "SHOW COLUMNS FROM \"" + tableName + "$partitions\"", "VALUES ('part1', 'bigint', '', ''), ('part2', 'varchar', '', '')");
        this.assertQueryFails(this.getSession(), "SHOW COLUMNS FROM \"$partitions\"", ".*Table '.*\\.tpch\\.\\$partitions' does not exist");
        this.assertQueryFails(this.getSession(), "SHOW COLUMNS FROM \"orders$partitions\"", ".*Table '.*\\.tpch\\.orders\\$partitions' does not exist");
        this.assertQueryFails(this.getSession(), "SHOW COLUMNS FROM \"blah$partitions\"", ".*Table '.*\\.tpch\\.blah\\$partitions' does not exist");
    }

    @Test
    public void testPartitionsTableInvalidAccess() {
        String createTable = "CREATE TABLE test_partitions_invalid (  foo VARCHAR,  part1 BIGINT,  part2 VARCHAR) WITH (partitioned_by = ARRAY[ 'part1', 'part2' ]) ";
        this.assertUpdate(this.getSession(), createTable);
        this.assertQueryFails(this.getSession(), "SELECT * FROM \"test_partitions_invalid$partitions$partitions\"", ".*Table .*\\.tpch\\.test_partitions_invalid\\$partitions\\$partitions does not exist");
        this.assertQueryFails(this.getSession(), "SELECT * FROM \"non_existent$partitions\"", ".*Table .*\\.tpch\\.non_existent\\$partitions does not exist");
    }

    @Test
    public void testInsertUnpartitionedTable() {
        this.testWithAllStorageFormats(this::testInsertUnpartitionedTable);
    }

    private void testInsertUnpartitionedTable(Session session, HiveStorageFormat storageFormat) {
        String tableName = "test_insert_unpartitioned_table";
        String createTable = "CREATE TABLE " + tableName + " (  order_key BIGINT,  comment VARCHAR,  order_status VARCHAR) WITH (format = '" + storageFormat + "') ";
        this.assertUpdate(session, createTable);
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", tableName);
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        for (int i = 0; i < 3; ++i) {
            this.assertUpdate(session, String.format("INSERT INTO " + tableName + " SELECT orderkey, comment, orderstatus FROM tpch.tiny.orders WHERE orderkey %% 3 = %d", i), String.format("SELECT count(*) from orders where orderkey %% 3 = %d", i));
        }
        this.assertQuery(session, "SELECT * from " + tableName, "SELECT orderkey, comment, orderstatus FROM orders");
        this.assertUpdate(session, "DROP TABLE " + tableName);
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, tableName));
    }

    @Test
    public void testDeleteFromUnpartitionedTable() {
        this.assertUpdate("CREATE TABLE test_delete_unpartitioned AS SELECT orderstatus FROM tpch.tiny.orders", "SELECT count(*) from orders");
        this.assertUpdate("DELETE FROM test_delete_unpartitioned");
        MaterializedResult result = this.computeActual("SELECT * from test_delete_unpartitioned");
        Assert.assertEquals((int)result.getRowCount(), (int)0);
        this.assertUpdate("DROP TABLE test_delete_unpartitioned");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_delete_unpartitioned"));
    }

    @Test
    public void testMetadataDelete() {
        String createTable = "CREATE TABLE test_metadata_delete (  ORDER_KEY BIGINT,  LINE_NUMBER INTEGER,  LINE_STATUS VARCHAR) WITH (partitioned_by = ARRAY[ 'LINE_NUMBER', 'LINE_STATUS' ]) ";
        this.assertUpdate(createTable);
        this.assertUpdate("INSERT INTO test_metadata_delete SELECT orderkey, linenumber, linestatus FROM tpch.tiny.lineitem", "SELECT count(*) from lineitem");
        this.assertUpdate("DELETE FROM test_metadata_delete WHERE LINE_STATUS='F' and LINE_NUMBER=CAST(3 AS INTEGER)");
        this.assertQuery("SELECT * from test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus<>'F' or linenumber<>3");
        try {
            this.getQueryRunner().execute("DELETE FROM test_metadata_delete WHERE lower(LINE_STATUS)='f' and LINE_NUMBER=CAST(4 AS INTEGER)");
            org.testng.Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"This connector only supports delete where one or more partitions are deleted entirely");
        }
        this.assertUpdate("DELETE FROM test_metadata_delete WHERE LINE_STATUS='O'");
        this.assertQuery("SELECT * from test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus<>'O' and linenumber<>3");
        try {
            this.getQueryRunner().execute("DELETE FROM test_metadata_delete WHERE ORDER_KEY=1");
            org.testng.Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"This connector only supports delete where one or more partitions are deleted entirely");
        }
        this.assertQuery("SELECT * from test_metadata_delete", "SELECT orderkey, linenumber, linestatus FROM lineitem WHERE linestatus<>'O' and linenumber<>3");
        this.assertUpdate("DROP TABLE test_metadata_delete");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_metadata_delete"));
    }

    private TableMetadata getTableMetadata(String catalog, String schema, String tableName) {
        Session session = this.getSession();
        Metadata metadata = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getMetadata();
        return (TableMetadata)TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).readOnly().execute(session, transactionSession -> {
            Optional tableHandle = metadata.getMetadataResolver(transactionSession).getTableHandle(new QualifiedObjectName(catalog, schema, tableName));
            org.testng.Assert.assertTrue((boolean)tableHandle.isPresent());
            return metadata.getTableMetadata(transactionSession, (TableHandle)tableHandle.get());
        });
    }

    private Object getHiveTableProperty(String tableName, Function<HiveTableLayoutHandle, Object> propertyGetter) {
        Session session = this.getSession();
        Metadata metadata = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getMetadata();
        return TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).readOnly().execute(session, transactionSession -> {
            Optional tableHandle = metadata.getMetadataResolver(transactionSession).getTableHandle(new QualifiedObjectName(this.catalog, "tpch", tableName));
            org.testng.Assert.assertTrue((boolean)tableHandle.isPresent());
            TableLayout layout = metadata.getLayout(transactionSession, (TableHandle)tableHandle.get(), Constraint.alwaysTrue(), Optional.empty()).getLayout();
            return propertyGetter.apply((HiveTableLayoutHandle)layout.getNewTableHandle().getLayout().get());
        });
    }

    private List<?> getPartitions(String tableName) {
        return (List)this.getHiveTableProperty(tableName, table -> this.getPartitions((HiveTableLayoutHandle)table));
    }

    private int getBucketCount(String tableName) {
        return (Integer)this.getHiveTableProperty(tableName, table -> ((HiveBucketHandle)table.getBucketHandle().get()).getTableBucketCount());
    }

    @Test
    public void testShowColumnsPartitionKey() {
        this.assertUpdate("CREATE TABLE test_show_columns_partition_key\n(grape bigint, orange bigint, pear varchar(65535), mango integer, lychee smallint, kiwi tinyint, apple varchar, pineapple varchar(65535))\nWITH (partitioned_by = ARRAY['apple', 'pineapple'])");
        MaterializedResult actual = this.computeActual("SHOW COLUMNS FROM test_show_columns_partition_key");
        Type unboundedVarchar = this.canonicalizeType((Type)VarcharType.VARCHAR);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{unboundedVarchar, unboundedVarchar, unboundedVarchar, unboundedVarchar}).row(new Object[]{"grape", this.canonicalizeTypeName("bigint"), "", ""}).row(new Object[]{"orange", this.canonicalizeTypeName("bigint"), "", ""}).row(new Object[]{"pear", this.canonicalizeTypeName("varchar(65535)"), "", ""}).row(new Object[]{"mango", this.canonicalizeTypeName("integer"), "", ""}).row(new Object[]{"lychee", this.canonicalizeTypeName("smallint"), "", ""}).row(new Object[]{"kiwi", this.canonicalizeTypeName("tinyint"), "", ""}).row(new Object[]{"apple", this.canonicalizeTypeName("varchar"), "partition key", ""}).row(new Object[]{"pineapple", this.canonicalizeTypeName("varchar(65535)"), "partition key", ""}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testArrays() {
        this.assertUpdate("CREATE TABLE tmp_array1 AS SELECT ARRAY[1, 2, NULL] AS col", 1L);
        this.assertQuery("SELECT col[2] FROM tmp_array1", "SELECT 2");
        this.assertQuery("SELECT col[3] FROM tmp_array1", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_array2 AS SELECT ARRAY[1.0E0, 2.5E0, 3.5E0] AS col", 1L);
        this.assertQuery("SELECT col[2] FROM tmp_array2", "SELECT 2.5");
        this.assertUpdate("CREATE TABLE tmp_array3 AS SELECT ARRAY['puppies', 'kittens', NULL] AS col", 1L);
        this.assertQuery("SELECT col[2] FROM tmp_array3", "SELECT 'kittens'");
        this.assertQuery("SELECT col[3] FROM tmp_array3", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_array4 AS SELECT ARRAY[TRUE, NULL] AS col", 1L);
        this.assertQuery("SELECT col[1] FROM tmp_array4", "SELECT TRUE");
        this.assertQuery("SELECT col[2] FROM tmp_array4", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_array5 AS SELECT ARRAY[ARRAY[1, 2], NULL, ARRAY[3, 4]] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array5", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array6 AS SELECT ARRAY[ARRAY['\"hi\"'], NULL, ARRAY['puppies']] AS col", 1L);
        this.assertQuery("SELECT col[1][1] FROM tmp_array6", "SELECT '\"hi\"'");
        this.assertQuery("SELECT col[3][1] FROM tmp_array6", "SELECT 'puppies'");
        this.assertUpdate("CREATE TABLE tmp_array7 AS SELECT ARRAY[ARRAY[INTEGER'1', INTEGER'2'], NULL, ARRAY[INTEGER'3', INTEGER'4']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array7", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array8 AS SELECT ARRAY[ARRAY[SMALLINT'1', SMALLINT'2'], NULL, ARRAY[SMALLINT'3', SMALLINT'4']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array8", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array9 AS SELECT ARRAY[ARRAY[TINYINT'1', TINYINT'2'], NULL, ARRAY[TINYINT'3', TINYINT'4']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array9", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_array10 AS SELECT ARRAY[ARRAY[DECIMAL '3.14']] AS col1, ARRAY[ARRAY[DECIMAL '12345678901234567890.0123456789']] AS col2", 1L);
        this.assertQuery("SELECT col1[1][1] FROM tmp_array10", "SELECT 3.14");
        this.assertQuery("SELECT col2[1][1] FROM tmp_array10", "SELECT 12345678901234567890.0123456789");
        this.assertUpdate("CREATE TABLE tmp_array13 AS SELECT ARRAY[ARRAY[REAL'1.234', REAL'2.345'], NULL, ARRAY[REAL'3.456', REAL'4.567']] AS col", 1L);
        this.assertQuery("SELECT col[1][2] FROM tmp_array13", "SELECT 2.345");
    }

    @Test
    public void testTemporalArrays() {
        this.assertUpdate("CREATE TABLE tmp_array11 AS SELECT ARRAY[DATE '2014-09-30'] AS col", 1L);
        this.assertOneNotNullResult("SELECT col[1] FROM tmp_array11");
        this.assertUpdate("CREATE TABLE tmp_array12 AS SELECT ARRAY[TIMESTAMP '2001-08-22 03:04:05.321'] AS col", 1L);
        this.assertOneNotNullResult("SELECT col[1] FROM tmp_array12");
    }

    @Test
    public void testMaps() {
        this.assertUpdate("CREATE TABLE tmp_map1 AS SELECT MAP(ARRAY[0,1], ARRAY[2,NULL]) AS col", 1L);
        this.assertQuery("SELECT col[0] FROM tmp_map1", "SELECT 2");
        this.assertQuery("SELECT col[1] FROM tmp_map1", "SELECT NULL");
        this.assertUpdate("CREATE TABLE tmp_map2 AS SELECT MAP(ARRAY[INTEGER'1'], ARRAY[INTEGER'2']) AS col", 1L);
        this.assertQuery("SELECT col[INTEGER'1'] FROM tmp_map2", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_map3 AS SELECT MAP(ARRAY[SMALLINT'1'], ARRAY[SMALLINT'2']) AS col", 1L);
        this.assertQuery("SELECT col[SMALLINT'1'] FROM tmp_map3", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_map4 AS SELECT MAP(ARRAY[TINYINT'1'], ARRAY[TINYINT'2']) AS col", 1L);
        this.assertQuery("SELECT col[TINYINT'1'] FROM tmp_map4", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_map5 AS SELECT MAP(ARRAY[1.0], ARRAY[2.5]) AS col", 1L);
        this.assertQuery("SELECT col[1.0] FROM tmp_map5", "SELECT 2.5");
        this.assertUpdate("CREATE TABLE tmp_map6 AS SELECT MAP(ARRAY['puppies'], ARRAY['kittens']) AS col", 1L);
        this.assertQuery("SELECT col['puppies'] FROM tmp_map6", "SELECT 'kittens'");
        this.assertUpdate("CREATE TABLE tmp_map7 AS SELECT MAP(ARRAY[TRUE], ARRAY[FALSE]) AS col", 1L);
        this.assertQuery("SELECT col[TRUE] FROM tmp_map7", "SELECT FALSE");
        this.assertUpdate("CREATE TABLE tmp_map8 AS SELECT MAP(ARRAY[DATE '2014-09-30'], ARRAY[DATE '2014-09-29']) AS col", 1L);
        this.assertOneNotNullResult("SELECT col[DATE '2014-09-30'] FROM tmp_map8");
        this.assertUpdate("CREATE TABLE tmp_map9 AS SELECT MAP(ARRAY[TIMESTAMP '2001-08-22 03:04:05.321'], ARRAY[TIMESTAMP '2001-08-22 03:04:05.321']) AS col", 1L);
        this.assertOneNotNullResult("SELECT col[TIMESTAMP '2001-08-22 03:04:05.321'] FROM tmp_map9");
        this.assertUpdate("CREATE TABLE tmp_map10 AS SELECT MAP(ARRAY[DECIMAL '3.14', DECIMAL '12345678901234567890.0123456789'], ARRAY[DECIMAL '12345678901234567890.0123456789', DECIMAL '3.0123456789']) AS col", 1L);
        this.assertQuery("SELECT col[DECIMAL '3.14'], col[DECIMAL '12345678901234567890.0123456789'] FROM tmp_map10", "SELECT 12345678901234567890.0123456789, 3.0123456789");
        this.assertUpdate("CREATE TABLE tmp_map11 AS SELECT MAP(ARRAY[REAL'1.234'], ARRAY[REAL'2.345']) AS col", 1L);
        this.assertQuery("SELECT col[REAL'1.234'] FROM tmp_map11", "SELECT 2.345");
        this.assertUpdate("CREATE TABLE tmp_map12 AS SELECT MAP(ARRAY[1.0E0], ARRAY[ARRAY[1, 2]]) AS col", 1L);
        this.assertQuery("SELECT col[1.0][2] FROM tmp_map12", "SELECT 2");
        this.assertUpdate("CREATE TABLE tmp_map13 AS SELECT MAP(ARRAY['puppies', 'kittens'], ARRAY['corgi', 'norwegianWood']) AS col", 1L);
        this.assertQuery("SELECT col['puppies'] FROM tmp_map13", "SELECT 'corgi'");
        this.assertQuery("SELECT col['kittens'] FROM tmp_map13", "SELECT 'norwegianWood'");
    }

    @Test
    public void testRows() {
        this.assertUpdate("CREATE TABLE tmp_row1 AS SELECT cast(row(CAST(1 as BIGINT), CAST(NULL as BIGINT)) AS row(col0 bigint, col1 bigint)) AS a", 1L);
        this.assertQuery("SELECT a.col0, a.col1 FROM tmp_row1", "SELECT 1, cast(null as bigint)");
    }

    @Test
    public void testComplex() {
        this.assertUpdate("CREATE TABLE tmp_complex1 AS SELECT ARRAY [MAP(ARRAY['a', 'b'], ARRAY[2.0E0, 4.0E0]), MAP(ARRAY['c', 'd'], ARRAY[12.0E0, 14.0E0])] AS a", 1L);
        this.assertQuery("SELECT a[1]['a'], a[2]['d'] FROM tmp_complex1", "SELECT 2.0, 14.0");
    }

    @Test
    public void testBucketedCatalog() {
        this.testBucketedCatalog(this.bucketedSession);
    }

    private void testBucketedCatalog(Session session) {
        String bucketedCatalog = (String)session.getCatalog().get();
        String bucketedSchema = (String)session.getSchema().get();
        TableMetadata ordersTableMetadata = this.getTableMetadata(bucketedCatalog, bucketedSchema, "orders");
        Assert.assertEquals(ordersTableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"custkey"));
        Assert.assertEquals(ordersTableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
        TableMetadata customerTableMetadata = this.getTableMetadata(bucketedCatalog, bucketedSchema, "customer");
        Assert.assertEquals(customerTableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"custkey"));
        Assert.assertEquals(customerTableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)11);
    }

    @Test
    public void testBucketedExecution() {
        this.testBucketedExecution(this.bucketedSession);
    }

    private void testBucketedExecution(Session session) {
        this.assertQuery(session, "select count(*) a from orders t1 join orders t2 on t1.custkey=t2.custkey");
        this.assertQuery(session, "select count(*) a from orders t1 join customer t2 on t1.custkey=t2.custkey", "SELECT count(*) from orders");
        this.assertQuery(session, "select count(distinct custkey) from orders");
        this.assertQuery(Session.builder((Session)session).setSystemProperty("task_writer_count", "1").build(), "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
        this.assertQuery(Session.builder((Session)session).setSystemProperty("task_writer_count", "4").build(), "SELECT custkey, COUNT(*) FROM orders GROUP BY custkey");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBucketPruning() {
        Session session = this.getSession();
        QueryRunner queryRunner = this.getQueryRunner();
        queryRunner.execute("CREATE TABLE orders_bucketed WITH (bucket_count = 11, bucketed_by = ARRAY['orderkey']) AS SELECT * FROM orders");
        try {
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey = 100", "SELECT * FROM orders WHERE orderkey = 100");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey = 100 OR orderkey = 101", "SELECT * FROM orders WHERE orderkey = 100 OR orderkey = 101");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey IN (100, 101, 133)", "SELECT * FROM orders WHERE orderkey IN (100, 101, 133)");
            this.assertQuery(session, "SELECT * FROM orders_bucketed", "SELECT * FROM orders");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey > 100", "SELECT * FROM orders WHERE orderkey > 100");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey != 100", "SELECT * FROM orders WHERE orderkey != 100");
        }
        finally {
            queryRunner.execute("DROP TABLE orders_bucketed");
        }
        queryRunner.execute("CREATE TABLE orders_bucketed WITH (bucket_count = 11, bucketed_by = ARRAY['orderkey', 'custkey']) AS SELECT * FROM orders");
        try {
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey = 101 AND custkey = 280", "SELECT * FROM orders WHERE orderkey = 101 AND custkey = 280");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey IN (101, 71) AND custkey = 280", "SELECT * FROM orders WHERE orderkey IN (101, 71) AND custkey = 280");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey IN (101, 71) AND custkey IN (280, 34)", "SELECT * FROM orders WHERE orderkey IN (101, 71) AND custkey IN (280, 34)");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey = 101 AND custkey = 280 AND orderstatus <> '0'", "SELECT * FROM orders WHERE orderkey = 101 AND custkey = 280 AND orderstatus <> '0'");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey = 101", "SELECT * FROM orders WHERE orderkey = 101");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE custkey = 280", "SELECT * FROM orders WHERE custkey = 280");
            this.assertQuery(session, "SELECT * FROM orders_bucketed WHERE orderkey = 101 AND custkey > 280", "SELECT * FROM orders WHERE orderkey = 101 AND custkey > 280");
        }
        finally {
            queryRunner.execute("DROP TABLE orders_bucketed");
        }
    }

    @Test
    public void testNullBucket() {
        Session session = this.getSession();
        QueryRunner queryRunner = this.getQueryRunner();
        queryRunner.execute("CREATE TABLE table_with_null_buckets WITH (bucket_count=2, bucketed_by = ARRAY['key']) AS SELECT 10 x, CAST(NULL AS INTEGER) AS key UNION ALL SELECT 20 x, 1 key");
        try {
            this.assertQuery(session, "SELECT COUNT() FROM table_with_null_buckets WHERE key IS NULL", "SELECT 1");
            this.assertQuery(session, "SELECT x FROM table_with_null_buckets WHERE key IS NULL", "SELECT 10");
            this.assertQuery(session, "SELECT key FROM table_with_null_buckets WHERE x = 10", "SELECT NULL");
            this.assertQuery(session, "SELECT x FROM table_with_null_buckets WHERE key = 1", "SELECT 20");
            this.assertQuery(session, "SELECT key FROM table_with_null_buckets WHERE key IS NULL AND x = 10", "SELECT NULL");
            this.assertQuery(session, "SELECT COUNT() FROM table_with_null_buckets WHERE key IS NULL AND x = 1", "SELECT 0");
            this.assertQuery(session, "SELECT COUNT() FROM table_with_null_buckets WHERE key = 10", "SELECT 0");
            this.assertQuery(session, "SELECT COUNT() FROM table_with_null_buckets WHERE key IN (NULL, 1)", "SELECT 1");
            this.assertQuery(session, "SELECT COUNT() FROM table_with_null_buckets WHERE key IS NULL OR key = 1", "SELECT 2");
        }
        finally {
            queryRunner.execute("DROP TABLE table_with_null_buckets");
        }
    }

    @Test
    public void testWriteSortedTable() {
        this.testWriteSortedTable(this.getSession());
        this.testWriteSortedTable(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "sorted_write_to_temp_path_enabled", "true").setCatalogSessionProperty(this.catalog, "sorted_write_temp_path_subdirectory_count", "10").build());
    }

    private void testWriteSortedTable(Session session) {
        try {
            this.assertUpdate(session, "CREATE TABLE create_partitioned_sorted_table (orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus)\nWITH (partitioned_by = ARRAY['orderstatus'], bucketed_by = ARRAY['custkey'], bucket_count = 11, sorted_by = ARRAY['orderkey']) AS\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            this.assertQuery(session, "SELECT count(*) FROM create_partitioned_sorted_table", "SELECT count(*) * 100 FROM orders");
            this.assertUpdate(session, "CREATE TABLE create_unpartitioned_sorted_table (orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus)\nWITH (bucketed_by = ARRAY['custkey'], bucket_count = 11, sorted_by = ARRAY['orderkey']) AS\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            this.assertQuery(session, "SELECT count(*) FROM create_unpartitioned_sorted_table", "SELECT count(*) * 100 FROM orders");
            this.assertUpdate(session, "CREATE TABLE insert_partitioned_sorted_table (LIKE create_partitioned_sorted_table) WITH (partitioned_by = ARRAY['orderstatus'], bucketed_by = ARRAY['custkey'], bucket_count = 11, sorted_by = ARRAY['orderkey'])");
            this.assertUpdate(session, "INSERT INTO insert_partitioned_sorted_table\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            this.assertQuery(session, "SELECT count(*) FROM insert_partitioned_sorted_table", "SELECT count(*) * 100 FROM orders");
        }
        finally {
            this.assertUpdate(session, "DROP TABLE IF EXISTS create_partitioned_sorted_table");
            this.assertUpdate(session, "DROP TABLE IF EXISTS create_unpartitioned_sorted_table");
            this.assertUpdate(session, "DROP TABLE IF EXISTS insert_partitioned_sorted_table");
        }
    }

    @Test
    public void testWritePreferredOrderingTable() {
        this.testWritePreferredOrderingTable(this.getSession());
        this.testWritePreferredOrderingTable(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "sorted_write_to_temp_path_enabled", "true").setCatalogSessionProperty(this.catalog, "sorted_write_temp_path_subdirectory_count", "10").build());
    }

    public void testWritePreferredOrderingTable(Session session) {
        try {
            this.assertUpdate(session, "CREATE TABLE create_partitioned_ordering_table (orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus)\nWITH (partitioned_by = ARRAY['orderstatus'], preferred_ordering_columns = ARRAY['orderkey']) AS\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            this.assertQuery(session, "SELECT count(*) FROM create_partitioned_ordering_table", "SELECT count(*) * 100 FROM orders");
            this.assertUpdate(session, "CREATE TABLE create_unpartitioned_ordering_table (orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus)\nWITH (preferred_ordering_columns = ARRAY['orderkey']) AS\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            this.assertQuery(session, "SELECT count(*) FROM create_unpartitioned_ordering_table", "SELECT count(*) * 100 FROM orders");
            this.assertUpdate(session, "CREATE TABLE insert_partitioned_ordering_table (LIKE create_partitioned_ordering_table) WITH (partitioned_by = ARRAY['orderstatus'], preferred_ordering_columns = ARRAY['orderkey'])");
            this.assertUpdate(session, "INSERT INTO insert_partitioned_ordering_table\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            this.assertQuery(session, "SELECT count(*) FROM insert_partitioned_ordering_table", "SELECT count(*) * 100 FROM orders");
            this.assertQueryFails(session, "CREATE TABLE invalid_bucketed_ordering_table (LIKE create_partitioned_ordering_table) WITH (preferred_ordering_columns = ARRAY['orderkey'], bucketed_by = ARRAY['totalprice'], bucket_count = 13)", ".*preferred_ordering_columns must not be specified when bucketed_by is specified.*");
        }
        finally {
            this.assertUpdate(session, "DROP TABLE IF EXISTS create_partitioned_ordering_table");
            this.assertUpdate(session, "DROP TABLE IF EXISTS create_unpartitioned_ordering_table");
            this.assertUpdate(session, "DROP TABLE IF EXISTS insert_partitioned_ordering_table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScaleWriters() {
        try {
            this.assertUpdate(Session.builder((Session)this.getSession()).setSystemProperty("scale_writers", "true").setSystemProperty("writer_min_size", "32MB").setSystemProperty("task_writer_count", "1").build(), "CREATE TABLE scale_writers_small AS SELECT * FROM tpch.tiny.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.tiny.orders").getOnlyValue());
            Assert.assertEquals((Object)this.computeActual("SELECT count(DISTINCT \"$path\") FROM scale_writers_small").getOnlyValue(), (Object)1L);
            this.assertUpdate(Session.builder((Session)this.getSession()).setSystemProperty("scale_writers", "true").setSystemProperty("writer_min_size", "1MB").setSystemProperty("task_writer_count", "1").build(), "CREATE TABLE scale_writers_large WITH (format = 'RCBINARY') AS SELECT * FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            long files = (Long)this.computeScalar("SELECT count(DISTINCT \"$path\") FROM scale_writers_large");
            long workers = (Long)this.computeScalar("SELECT count(*) FROM system.runtime.nodes");
            Assertions.assertThat((long)files).isBetween(Long.valueOf(2L), Long.valueOf(workers));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS scale_writers_large");
            this.assertUpdate("DROP TABLE IF EXISTS scale_writers_small");
        }
    }

    @Test
    public void testPreferManifestsToListFilesForPartitionedTable() {
        try {
            this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "file_renaming_enabled", "true").setCatalogSessionProperty(this.catalog, "prefer_manifests_to_list_files", "true").setSystemProperty("scale_writers", "false").setSystemProperty("writer_min_size", "1MB").setSystemProperty("task_writer_count", "1").build(), "CREATE TABLE partitioned_ordering_table (orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus)\nWITH (partitioned_by = ARRAY['orderstatus'], preferred_ordering_columns = ARRAY['orderkey']) AS\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.tiny.orders where orderstatus = 'O'", (Long)this.computeActual("SELECT count(*) FROM tpch.tiny.orders where orderstatus = 'O'").getOnlyValue());
            this.assertQuery(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "file_renaming_enabled", "true").setCatalogSessionProperty(this.catalog, "prefer_manifests_to_list_files", "true").setCatalogSessionProperty(this.catalog, "manifest_verification_enabled", "true").build(), "SELECT orderkey, custkey, totalprice, orderdate FROM partitioned_ordering_table", "SELECT orderkey, custkey, totalprice, orderdate FROM orders where orderstatus = 'O'");
            this.assertUpdate(Session.builder((Session)this.getSession()).setSystemProperty("scale_writers", "false").setSystemProperty("writer_min_size", "1MB").setSystemProperty("task_writer_count", "1").build(), "INSERT INTO partitioned_ordering_table (orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus)\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.tiny.orders where orderstatus = 'P'", (Long)this.computeActual("SELECT count(*) FROM tpch.tiny.orders where orderstatus = 'P'").getOnlyValue());
            this.assertQuery(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "file_renaming_enabled", "true").setCatalogSessionProperty(this.catalog, "prefer_manifests_to_list_files", "true").setCatalogSessionProperty(this.catalog, "manifest_verification_enabled", "true").build(), "SELECT orderkey, custkey, totalprice, orderdate FROM partitioned_ordering_table", "SELECT orderkey, custkey, totalprice, orderdate FROM orders where orderstatus = 'O' OR orderstatus = 'P'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS partitioned_ordering_table");
        }
    }

    @Test
    public void testPreferManifestsToListFilesForUnPartitionedTable() {
        try {
            this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "file_renaming_enabled", "true").setCatalogSessionProperty(this.catalog, "prefer_manifests_to_list_files", "true").setSystemProperty("scale_writers", "false").setSystemProperty("writer_min_size", "1MB").setSystemProperty("task_writer_count", "1").build(), "CREATE TABLE unpartitioned_ordering_table AS SELECT * FROM tpch.tiny.orders where orderstatus = 'O'", (Long)this.computeActual("SELECT count(*) FROM tpch.tiny.orders where orderstatus = 'O'").getOnlyValue());
            this.assertQuery(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "file_renaming_enabled", "true").setCatalogSessionProperty(this.catalog, "prefer_manifests_to_list_files", "true").setCatalogSessionProperty(this.catalog, "manifest_verification_enabled", "true").build(), "SELECT orderkey, custkey, totalprice, orderdate FROM unpartitioned_ordering_table", "SELECT orderkey, custkey, totalprice, orderdate FROM orders where orderstatus = 'O'");
            this.assertUpdate(Session.builder((Session)this.getSession()).setSystemProperty("scale_writers", "false").setSystemProperty("writer_min_size", "1MB").setSystemProperty("task_writer_count", "1").build(), "INSERT INTO unpartitioned_ordering_table (orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus)\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.tiny.orders where orderstatus = 'P'", (Long)this.computeActual("SELECT count(*) FROM tpch.tiny.orders where orderstatus = 'P'").getOnlyValue());
            this.assertQuery(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "file_renaming_enabled", "true").setCatalogSessionProperty(this.catalog, "prefer_manifests_to_list_files", "true").setCatalogSessionProperty(this.catalog, "manifest_verification_enabled", "true").build(), "SELECT orderkey, custkey, totalprice, orderdate FROM unpartitioned_ordering_table", "SELECT orderkey, custkey, totalprice, orderdate FROM orders where orderstatus = 'O' OR orderstatus = 'P'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS unpartitioned_ordering_table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileRenamingForPartitionedTable() {
        try {
            this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "file_renaming_enabled", "true").setSystemProperty("scale_writers", "false").setSystemProperty("writer_min_size", "1MB").setSystemProperty("task_writer_count", "1").build(), "CREATE TABLE partitioned_ordering_table (orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus)\nWITH (partitioned_by = ARRAY['orderstatus'], preferred_ordering_columns = ARRAY['orderkey']) AS\nSELECT orderkey, custkey, totalprice, orderdate, orderpriority, clerk, shippriority, comment, orderstatus FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            HashMap partitionFileNamesMap = new HashMap();
            MaterializedResult partitionedResults = this.computeActual("SELECT DISTINCT \"$path\" FROM partitioned_ordering_table");
            for (int i = 0; i < partitionedResults.getRowCount(); ++i) {
                MaterializedRow row = (MaterializedRow)partitionedResults.getMaterializedRows().get(i);
                org.apache.hadoop.fs.Path pathName = new org.apache.hadoop.fs.Path((String)row.getField(0));
                String partitionName = pathName.getParent().toString();
                String fileName = pathName.getName();
                partitionFileNamesMap.putIfAbsent(partitionName, new ArrayList());
                ((List)partitionFileNamesMap.get(partitionName)).add(Integer.valueOf(fileName));
            }
            for (String partitionName : partitionFileNamesMap.keySet()) {
                List partitionedTableFileNames = (List)partitionFileNamesMap.get(partitionName);
                org.testng.Assert.assertTrue((partitionedTableFileNames.size() > 0 ? 1 : 0) != 0);
                org.testng.Assert.assertTrue((boolean)this.isIncreasingSequence(partitionedTableFileNames));
            }
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS partitioned_ordering_table");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileRenamingForUnpartitionedTable() {
        try {
            this.assertUpdate(Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "file_renaming_enabled", "true").setSystemProperty("scale_writers", "false").setSystemProperty("writer_min_size", "1MB").setSystemProperty("task_writer_count", "1").build(), "CREATE TABLE unpartitioned_ordering_table AS SELECT * FROM tpch.sf1.orders", (Long)this.computeActual("SELECT count(*) FROM tpch.sf1.orders").getOnlyValue());
            ArrayList<Integer> fileNames = new ArrayList<Integer>();
            MaterializedResult results = this.computeActual("SELECT DISTINCT \"$path\" FROM unpartitioned_ordering_table");
            for (int i = 0; i < results.getRowCount(); ++i) {
                MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
                String pathName = (String)row.getField(0);
                String fileName = new org.apache.hadoop.fs.Path(pathName).getName();
                fileNames.add(Integer.valueOf(fileName));
            }
            org.testng.Assert.assertTrue((fileNames.size() > 0 ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((boolean)this.isIncreasingSequence(fileNames));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS unpartitioned_ordering_table");
        }
    }

    boolean isIncreasingSequence(List<Integer> fileNames) {
        Collections.sort(fileNames);
        int i = 0;
        for (int fileName : fileNames) {
            if (i != fileName) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Test
    public void testShowCreateTable() {
        String createTableFormat = "CREATE TABLE %s.%s.%s (\n   %s bigint,\n   %s double,\n   \"c 3\" varchar,\n   \"c'4\" array(bigint),\n   %s map(bigint, varchar)\n)\nWITH (\n   format = 'RCBINARY'\n)";
        String createTableSql = String.format(createTableFormat, this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "test_show_create_table", "c1", "c2", "c5");
        String expectedShowCreateTable = String.format(createTableFormat, this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "test_show_create_table", "\"c1\"", "\"c2\"", "\"c5\"");
        this.assertUpdate(createTableSql);
        MaterializedResult actualResult = this.computeActual("SHOW CREATE TABLE test_show_create_table");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)expectedShowCreateTable);
        createTableFormat = "CREATE TABLE %s.%s.%s (\n   %s bigint,\n   \"c 2\" varchar,\n   \"c'3\" array(bigint),\n   %s map(bigint, varchar) COMMENT 'comment test4',\n   %s double COMMENT 'comment test5'\n)\nCOMMENT 'test'\nWITH (\n   bucket_count = 5,\n   bucketed_by = ARRAY['c1','c 2'],\n   format = 'ORC',\n   orc_bloom_filter_columns = ARRAY['c1','c2'],\n   orc_bloom_filter_fpp = 7E-1,\n   partitioned_by = ARRAY['c5'],\n   sorted_by = ARRAY['c1','c 2 DESC']\n)";
        createTableSql = String.format(createTableFormat, this.getSession().getCatalog().get(), this.getSession().getSchema().get(), "\"test_show_create_table'2\"", "\"c1\"", "\"c2\"", "\"c5\"");
        this.assertUpdate(createTableSql);
        actualResult = this.computeActual("SHOW CREATE TABLE \"test_show_create_table'2\"");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)createTableSql);
    }

    @Test
    public void testCreateExternalTable() throws Exception {
        File tempDir = Files.createTempDir();
        File dataFile = new File(tempDir, "test.txt");
        Files.write((CharSequence)"hello\nworld\n", (File)dataFile, (Charset)StandardCharsets.UTF_8);
        String createTableSql = String.format("CREATE TABLE %s.%s.test_create_external (\n   \"name\" varchar\n)\nWITH (\n   external_location = '%s',\n   format = 'TEXTFILE'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), new org.apache.hadoop.fs.Path(tempDir.toURI().toASCIIString()).toString());
        this.assertUpdate(createTableSql);
        MaterializedResult actual = this.computeActual("SHOW CREATE TABLE test_create_external");
        Assert.assertEquals((Object)actual.getOnlyValue(), (Object)createTableSql);
        actual = this.computeActual("SELECT name FROM test_create_external");
        Assert.assertEquals((Set)actual.getOnlyColumnAsSet(), (Set)ImmutableSet.of((Object)"hello", (Object)"world"));
        this.assertUpdate("DROP TABLE test_create_external");
        FileAssert.assertFile((File)dataFile);
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testPathHiddenColumn() {
        this.testWithAllStorageFormats(this::testPathHiddenColumn);
    }

    private void testPathHiddenColumn(Session session, HiveStorageFormat storageFormat) {
        String createTable = "CREATE TABLE test_path WITH (format = '" + storageFormat + "',partitioned_by = ARRAY['col1']) AS SELECT * FROM (VALUES (0, 0), (3, 0), (6, 0), (1, 1), (4, 1), (7, 1), (2, 2), (5, 2)  ) t(col0, col1) ";
        this.assertUpdate(session, createTable, 8L);
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_path"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_path");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)storageFormat);
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path", (Object)"$file_size", (Object)"$file_modified_time");
        List columnMetadatas = tableMetadata.getColumns();
        Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$path")) continue;
            org.testng.Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        Assert.assertEquals((int)this.getPartitions("test_path").size(), (int)3);
        MaterializedResult results = this.computeActual(session, String.format("SELECT *, \"%s\" FROM test_path", "$path"));
        HashMap<Integer, String> partitionPathMap = new HashMap<Integer, String>();
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            String pathName = (String)row.getField(2);
            String parentDirectory = new org.apache.hadoop.fs.Path(pathName).getParent().toString();
            org.testng.Assert.assertTrue((pathName.length() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((int)(col0 % 3), (int)col1);
            if (partitionPathMap.containsKey(col1)) {
                Assert.assertEquals((String)((String)partitionPathMap.get(col1)), (String)parentDirectory);
                continue;
            }
            partitionPathMap.put(col1, parentDirectory);
        }
        Assert.assertEquals((int)partitionPathMap.size(), (int)3);
        this.assertUpdate(session, "DROP TABLE test_path");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_path"));
    }

    @Test
    public void testBucketHiddenColumn() {
        String createTable = "CREATE TABLE test_bucket_hidden_column WITH (bucketed_by = ARRAY['col0'],bucket_count = 2) AS SELECT * FROM (VALUES (0, 11), (1, 12), (2, 13), (3, 14), (4, 15), (5, 16), (6, 17), (7, 18), (8, 19) ) t (col0, col1) ";
        this.assertUpdate(createTable, 9L);
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_bucket_hidden_column"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_bucket_hidden_column");
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucketed_by"), (Object)ImmutableList.of((Object)"col0"));
        Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("bucket_count"), (Object)2);
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path", (Object)"$bucket", (Object)"$file_size", (Object)"$file_modified_time");
        List columnMetadatas = tableMetadata.getColumns();
        Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$bucket")) continue;
            org.testng.Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        Assert.assertEquals((int)this.getBucketCount("test_bucket_hidden_column"), (int)2);
        MaterializedResult results = this.computeActual(String.format("SELECT *, \"%1$s\" FROM test_bucket_hidden_column WHERE \"%1$s\" = 1", "$bucket"));
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            int bucket = (Integer)row.getField(2);
            Assert.assertEquals((int)col1, (int)(col0 + 11));
            org.testng.Assert.assertTrue((col1 % 2 == 0 ? 1 : 0) != 0);
            Assert.assertEquals((int)bucket, (int)(col0 % 2));
        }
        Assert.assertEquals((int)results.getRowCount(), (int)4);
        this.assertUpdate("DROP TABLE test_bucket_hidden_column");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_bucket_hidden_column"));
    }

    @Test
    public void testFileSizeHiddenColumn() {
        String createTable = "CREATE TABLE test_file_size AS SELECT * FROM (VALUES (0, 0), (3, 0), (6, 0), (1, 1), (4, 1), (7, 1), (2, 2), (5, 2)  ) t(col0, col1) ";
        this.assertUpdate(createTable, 8L);
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_file_size"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_file_size");
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path", (Object)"$file_size", (Object)"$file_modified_time");
        List columnMetadatas = tableMetadata.getColumns();
        Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$file_size")) continue;
            org.testng.Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        MaterializedResult results = this.computeActual(String.format("SELECT *, \"%s\" FROM test_file_size", "$file_size"));
        HashMap<Integer, Long> fileSizeMap = new HashMap<Integer, Long>();
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            long fileSize = (Long)row.getField(2);
            org.testng.Assert.assertTrue((fileSize > 0L ? 1 : 0) != 0);
            Assert.assertEquals((int)(col0 % 3), (int)col1);
            if (fileSizeMap.containsKey(col1)) {
                Assert.assertEquals((long)((Long)fileSizeMap.get(col1)), (long)fileSize);
                continue;
            }
            fileSizeMap.put(col1, fileSize);
        }
        Assert.assertEquals((int)fileSizeMap.size(), (int)3);
        this.assertUpdate("DROP TABLE test_file_size");
    }

    @Test
    public void testFileModifiedTimeHiddenColumn() {
        long testStartTime = Instant.now().toEpochMilli();
        String createTable = "CREATE TABLE test_file_modified_time WITH (partitioned_by = ARRAY['col1']) AS SELECT * FROM (VALUES (0, 0), (3, 0), (6, 0), (1, 1), (4, 1), (7, 1), (2, 2), (5, 2)  ) t(col0, col1) ";
        this.assertUpdate(createTable, 8L);
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_file_modified_time"));
        TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_file_modified_time");
        ImmutableList columnNames = ImmutableList.of((Object)"col0", (Object)"col1", (Object)"$path", (Object)"$file_size", (Object)"$file_modified_time");
        List columnMetadatas = tableMetadata.getColumns();
        Assert.assertEquals((int)columnMetadatas.size(), (int)columnNames.size());
        for (int i = 0; i < columnMetadatas.size(); ++i) {
            ColumnMetadata columnMetadata = (ColumnMetadata)columnMetadatas.get(i);
            Assert.assertEquals((String)columnMetadata.getName(), (String)((String)columnNames.get(i)));
            if (!columnMetadata.getName().equals("$file_modified_time")) continue;
            org.testng.Assert.assertTrue((boolean)columnMetadata.isHidden());
        }
        Assert.assertEquals((int)this.getPartitions("test_file_modified_time").size(), (int)3);
        MaterializedResult results = this.computeActual(String.format("SELECT *, \"%s\" FROM test_file_modified_time", "$file_modified_time"));
        HashMap<Integer, Long> fileModifiedTimeMap = new HashMap<Integer, Long>();
        for (int i = 0; i < results.getRowCount(); ++i) {
            MaterializedRow row = (MaterializedRow)results.getMaterializedRows().get(i);
            int col0 = (Integer)row.getField(0);
            int col1 = (Integer)row.getField(1);
            long fileModifiedTime = (Long)row.getField(2);
            org.testng.Assert.assertTrue((fileModifiedTime > testStartTime - 2000L ? 1 : 0) != 0);
            Assert.assertEquals((int)(col0 % 3), (int)col1);
            if (fileModifiedTimeMap.containsKey(col1)) {
                Assert.assertEquals((long)((Long)fileModifiedTimeMap.get(col1)), (long)fileModifiedTime);
                continue;
            }
            fileModifiedTimeMap.put(col1, fileModifiedTime);
        }
        Assert.assertEquals((int)fileModifiedTimeMap.size(), (int)3);
        this.assertUpdate("DROP TABLE test_file_modified_time");
    }

    @Test
    public void testDeleteAndInsert() {
        Session session = this.getSession();
        this.assertUpdate(session, "CREATE TABLE tmp_delete_insert WITH (partitioned_by=array ['z']) AS SELECT * from (VALUES (CAST (101 AS BIGINT), CAST (1 AS BIGINT)), (201, 2), (202, 2), (401, 4), (402, 4), (403, 4)) t(a, z)", 6L);
        List expectedBefore = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{201L, 2L}).row(new Object[]{202L, 2L}).row(new Object[]{401L, 4L}).row(new Object[]{402L, 4L}).row(new Object[]{403L, 4L}).build().getMaterializedRows();
        List expectedAfter = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{203L, 2L}).row(new Object[]{204L, 2L}).row(new Object[]{205L, 2L}).row(new Object[]{301L, 2L}).row(new Object[]{302L, 3L}).build().getMaterializedRows();
        try {
            TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
                this.assertUpdate((Session)transactionSession, "DELETE FROM tmp_delete_insert WHERE z >= 2");
                this.assertUpdate((Session)transactionSession, "INSERT INTO tmp_delete_insert VALUES (203, 2), (204, 2), (205, 2), (301, 2), (302, 3)", 5L);
                MaterializedResult actualFromAnotherTransaction = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromAnotherTransaction, (Iterable)expectedBefore);
                MaterializedResult actualFromCurrentTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_delete_insert");
                QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromCurrentTransaction, (Iterable)expectedAfter);
                this.rollback();
            });
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        MaterializedResult actualAfterRollback = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterRollback, (Iterable)expectedBefore);
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
            this.assertUpdate((Session)transactionSession, "DELETE FROM tmp_delete_insert WHERE z >= 2");
            this.assertUpdate((Session)transactionSession, "INSERT INTO tmp_delete_insert VALUES (203, 2), (204, 2), (205, 2), (301, 2), (302, 3)", 5L);
            MaterializedResult actualOutOfTransaction = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualOutOfTransaction, (Iterable)expectedBefore);
            MaterializedResult actualInTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_delete_insert");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualInTransaction, (Iterable)expectedAfter);
        });
        MaterializedResult actualAfterTransaction = this.computeActual(session, "SELECT * FROM tmp_delete_insert");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterTransaction, (Iterable)expectedAfter);
    }

    @Test
    public void testCreateAndInsert() {
        Session session = this.getSession();
        List expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{201L, 2L}).row(new Object[]{202L, 2L}).row(new Object[]{301L, 3L}).row(new Object[]{302L, 3L}).build().getMaterializedRows();
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
            this.assertUpdate((Session)transactionSession, "CREATE TABLE tmp_create_insert WITH (partitioned_by=array ['z']) AS SELECT * from (VALUES (CAST (101 AS BIGINT), CAST (1 AS BIGINT)), (201, 2), (202, 2)) t(a, z)", 3L);
            this.assertUpdate((Session)transactionSession, "INSERT INTO tmp_create_insert VALUES (301, 3), (302, 3)", 2L);
            MaterializedResult actualFromCurrentTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_create_insert");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromCurrentTransaction, (Iterable)expected);
        });
        MaterializedResult actualAfterTransaction = this.computeActual(session, "SELECT * FROM tmp_create_insert");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterTransaction, (Iterable)expected);
    }

    @Test
    public void testCreateUnpartitionedTableAndQuery() {
        Session session = this.getSession();
        List expected = MaterializedResult.resultBuilder((Session)session, (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{101L, 1L}).row(new Object[]{201L, 2L}).row(new Object[]{202L, 2L}).row(new Object[]{301L, 3L}).row(new Object[]{302L, 3L}).build().getMaterializedRows();
        TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
            this.assertUpdate((Session)transactionSession, "CREATE TABLE tmp_create_query AS SELECT * from (VALUES (CAST (101 AS BIGINT), CAST (1 AS BIGINT)), (201, 2), (202, 2), (301, 3), (302, 3)) t(a, z)", 5L);
            MaterializedResult actualFromCurrentTransaction = this.computeActual((Session)transactionSession, "SELECT * FROM tmp_create_query");
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualFromCurrentTransaction, (Iterable)expected);
        });
        MaterializedResult actualAfterTransaction = this.computeActual(session, "SELECT * FROM tmp_create_query");
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)actualAfterTransaction, (Iterable)expected);
    }

    @Test
    public void testAddColumn() {
        this.assertUpdate("CREATE TABLE test_add_column (a bigint COMMENT 'test comment AAA')");
        this.assertUpdate("ALTER TABLE test_add_column ADD COLUMN b bigint COMMENT 'test comment BBB'");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN a varchar", ".* Column 'a' already exists");
        this.assertQueryFails("ALTER TABLE test_add_column ADD COLUMN c bad_type", ".* Unknown type 'bad_type' for column 'c'");
        this.assertQuery("SHOW COLUMNS FROM test_add_column", "VALUES ('a', 'bigint', '', 'test comment AAA'), ('b', 'bigint', '', 'test comment BBB')");
        this.assertUpdate("DROP TABLE test_add_column");
    }

    @Test
    public void testRenameColumn() {
        String createTable = "CREATE TABLE test_rename_column\nWITH (\n  partitioned_by = ARRAY ['orderstatus']\n)\nAS\nSELECT orderkey, orderstatus FROM orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        this.assertUpdate("ALTER TABLE test_rename_column RENAME COLUMN orderkey TO new_orderkey");
        this.assertQuery("SELECT new_orderkey, orderstatus FROM test_rename_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertQueryFails("ALTER TABLE test_rename_column RENAME COLUMN \"$path\" TO test", ".* Cannot rename hidden column");
        this.assertQueryFails("ALTER TABLE test_rename_column RENAME COLUMN orderstatus TO new_orderstatus", "Renaming partition columns is not supported");
        this.assertQuery("SELECT new_orderkey, orderstatus FROM test_rename_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertUpdate("DROP TABLE test_rename_column");
    }

    @Test
    public void testDropColumn() {
        String createTable = "CREATE TABLE test_drop_column\nWITH (\n  partitioned_by = ARRAY ['orderstatus']\n)\nAS\nSELECT custkey, orderkey, orderstatus FROM orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        this.assertQuery("SELECT orderkey, orderstatus FROM test_drop_column", "SELECT orderkey, orderstatus FROM orders");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN \"$path\"", ".* Cannot drop hidden column");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN orderstatus", "Cannot drop partition columns");
        this.assertUpdate("ALTER TABLE test_drop_column DROP COLUMN orderkey");
        this.assertQueryFails("ALTER TABLE test_drop_column DROP COLUMN custkey", "Cannot drop the only non-partition column in a table");
        this.assertQuery("SELECT * FROM test_drop_column", "SELECT custkey, orderstatus FROM orders");
        this.assertUpdate("DROP TABLE test_drop_column");
    }

    @Test
    public void testAvroTypeValidation() {
        this.assertQueryFails("CREATE TABLE test_avro_types (x map(bigint, bigint)) WITH (format = 'AVRO')", "Column x has a non-varchar map key, which is not supported by Avro");
        this.assertQueryFails("CREATE TABLE test_avro_types (x tinyint) WITH (format = 'AVRO')", "Column x is tinyint, which is not supported by Avro. Use integer instead.");
        this.assertQueryFails("CREATE TABLE test_avro_types (x smallint) WITH (format = 'AVRO')", "Column x is smallint, which is not supported by Avro. Use integer instead.");
        this.assertQueryFails("CREATE TABLE test_avro_types WITH (format = 'AVRO') AS SELECT cast(42 AS smallint) z", "Column z is smallint, which is not supported by Avro. Use integer instead.");
    }

    @Test
    public void testOrderByChar() {
        this.assertUpdate("CREATE TABLE char_order_by (c_char char(2))");
        this.assertUpdate("INSERT INTO char_order_by (c_char) VALUES(CAST('a' as CHAR(2))),(CAST('a\u0000' as CHAR(2))),(CAST('a  ' as CHAR(2)))", 3L);
        MaterializedResult actual = this.computeActual(this.getSession(), "SELECT * FROM char_order_by ORDER BY c_char ASC");
        this.assertUpdate("DROP TABLE char_order_by");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{CharType.createCharType((long)2L)}).row(new Object[]{"a\u0000"}).row(new Object[]{"a "}).row(new Object[]{"a "}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPredicatePushDownToTableScan() {
        this.assertUpdate("CREATE TABLE test_table_with_char (a char(20))");
        try {
            this.assertUpdate("INSERT INTO test_table_with_char (a) VALUES(cast('aaa' as char(20))),(cast('bbb' as char(20))),(cast('bbc' as char(20))),(cast('bbd' as char(20)))", 4L);
            this.assertQuery("SELECT a, a <= 'bbc' FROM test_table_with_char", "VALUES (cast('aaa' as char(20)), true), (cast('bbb' as char(20)), true), (cast('bbc' as char(20)), true), (cast('bbd' as char(20)), false)");
            this.assertQuery("SELECT a FROM test_table_with_char WHERE a <= 'bbc'", "VALUES cast('aaa' as char(20)), cast('bbb' as char(20)), cast('bbc' as char(20))");
        }
        finally {
            this.assertUpdate("DROP TABLE test_table_with_char");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMismatchedBucketWithBucketPredicate() {
        try {
            this.assertUpdate("CREATE TABLE test_mismatch_bucketing_with_predicate_8\nWITH (bucket_count = 8, bucketed_by = ARRAY['key8']) AS\nSELECT custkey key8, comment value8 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_mismatch_bucketing_with_predicate_32\nWITH (bucket_count = 32, bucketed_by = ARRAY['key32']) AS\nSELECT custkey key32, comment value32 FROM orders", 15000L);
            Session withMismatchOptimization = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setCatalogSessionProperty(this.catalog, "optimize_mismatched_bucket_count", "true").build();
            Session withoutMismatchOptimization = Session.builder((Session)this.getSession()).setSystemProperty("colocated_join", "true").setCatalogSessionProperty(this.catalog, "optimize_mismatched_bucket_count", "false").build();
            String query = "SELECT count(*) AS count\nFROM (\n  SELECT key32\n  FROM test_mismatch_bucketing_with_predicate_32\n  WHERE \"$bucket\" between 16 AND 31\n) a\nJOIN test_mismatch_bucketing_with_predicate_8 b\nON a.key32 = b.key8";
            this.assertQuery(withMismatchOptimization, query, "SELECT 130361");
            this.assertQuery(withoutMismatchOptimization, query, "SELECT 130361");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_mismatch_bucketing_with_predicate_8");
            this.assertUpdate("DROP TABLE IF EXISTS test_mismatch_bucketing_with_predicate_32");
        }
    }

    @Test
    public void testMismatchedBucketing() {
        this.testMismatchedBucketing(this.getSession());
        this.testMismatchedBucketing(this.materializeExchangesSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMismatchedBucketing(Session session) {
        try {
            this.assertUpdate(session, "CREATE TABLE test_mismatch_bucketing16\nWITH (bucket_count = 16, bucketed_by = ARRAY['key16']) AS\nSELECT orderkey key16, comment value16 FROM orders", 15000L);
            this.assertUpdate(session, "CREATE TABLE test_mismatch_bucketing32\nWITH (bucket_count = 32, bucketed_by = ARRAY['key32']) AS\nSELECT orderkey key32, comment value32 FROM orders", 15000L);
            this.assertUpdate(session, "CREATE TABLE test_mismatch_bucketingN AS\nSELECT orderkey keyN, comment valueN FROM orders", 15000L);
            Session withMismatchOptimization = Session.builder((Session)session).setSystemProperty("colocated_join", "true").setCatalogSessionProperty(this.catalog, "optimize_mismatched_bucket_count", "true").build();
            Session withoutMismatchOptimization = Session.builder((Session)session).setSystemProperty("colocated_join", "true").setCatalogSessionProperty(this.catalog, "optimize_mismatched_bucket_count", "false").build();
            String writeToTableWithMoreBuckets = "CREATE TABLE test_mismatch_bucketing_out32\nWITH (bucket_count = 32, bucketed_by = ARRAY['key16'])\nAS\nSELECT key16, value16, key32, value32, keyN, valueN\nFROM\n  test_mismatch_bucketing16\nJOIN\n  test_mismatch_bucketing32\nON key16=key32\nJOIN\n  test_mismatch_bucketingN\nON key16=keyN";
            String writeToTableWithFewerBuckets = "CREATE TABLE test_mismatch_bucketing_out8\nWITH (bucket_count = 8, bucketed_by = ARRAY['key16'])\nAS\nSELECT key16, value16, key32, value32, keyN, valueN\nFROM\n  test_mismatch_bucketing16\nJOIN\n  test_mismatch_bucketing32\nON key16=key32\nJOIN\n  test_mismatch_bucketingN\nON key16=keyN";
            this.assertUpdate(withoutMismatchOptimization, writeToTableWithMoreBuckets, 15000L, this.assertRemoteExchangesCount(3));
            this.assertQuery(withoutMismatchOptimization, "SELECT * FROM test_mismatch_bucketing_out32", "SELECT orderkey, comment, orderkey, comment, orderkey, comment from orders");
            this.assertUpdate(withoutMismatchOptimization, "DROP TABLE IF EXISTS test_mismatch_bucketing_out32");
            this.assertUpdate(withMismatchOptimization, writeToTableWithMoreBuckets, 15000L, this.assertRemoteExchangesCount(2));
            this.assertQuery(withMismatchOptimization, "SELECT * FROM test_mismatch_bucketing_out32", "SELECT orderkey, comment, orderkey, comment, orderkey, comment from orders");
            this.assertUpdate(withMismatchOptimization, writeToTableWithFewerBuckets, 15000L, this.assertRemoteExchangesCount(2));
            this.assertQuery(withMismatchOptimization, "SELECT * FROM test_mismatch_bucketing_out8", "SELECT orderkey, comment, orderkey, comment, orderkey, comment from orders");
        }
        finally {
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_mismatch_bucketing16");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_mismatch_bucketing32");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_mismatch_bucketingN");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_mismatch_bucketing_out32");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_mismatch_bucketing_out8");
        }
    }

    private Session noReorderJoins(Session session) {
        return Session.builder((Session)session).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).build();
    }

    @Test
    public void testPartialMergePushdown() {
        this.testPartialMergePushdown(this.noReorderJoins(this.getSession()));
        this.testPartialMergePushdown(this.noReorderJoins(this.materializeExchangesSession));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPartialMergePushdown(Session session) {
        try {
            this.assertUpdate("CREATE TABLE test_partial_merge_pushdown_16buckets\nWITH (bucket_count = 16, bucketed_by = ARRAY['key16']) AS\nSELECT orderkey key16, comment value16 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_partial_merge_pushdown_32buckets\nWITH (bucket_count = 32, bucketed_by = ARRAY['key32']) AS\nSELECT orderkey key32, comment value32 FROM orders", 15000L);
            this.assertUpdate("CREATE TABLE test_partial_merge_pushdown_nobucket AS\nSELECT orderkey key_nobucket, comment value_nobucket FROM orders", 15000L);
            Session withPartialMergePushdownOptimization = Session.builder((Session)session).setSystemProperty("colocated_join", "true").setSystemProperty("partial_merge_pushdown_strategy", FeaturesConfig.PartialMergePushdownStrategy.PUSH_THROUGH_LOW_MEMORY_OPERATORS.name()).build();
            Session withoutPartialMergePushdownOptimization = Session.builder((Session)session).setSystemProperty("colocated_join", "true").setSystemProperty("partial_merge_pushdown_strategy", FeaturesConfig.PartialMergePushdownStrategy.NONE.name()).build();
            String joinAndWriteToTableWithSameBuckets = "CREATE TABLE test_partial_merge_pushdown_out16\nWITH (bucket_count = 16, bucketed_by = ARRAY['key16'])\nAS\nSELECT key16, value16, key32, value32, key_nobucket, value_nobucket\nFROM\n  test_partial_merge_pushdown_16buckets\nJOIN\n  test_partial_merge_pushdown_32buckets\nON key16=key32\nJOIN\n  test_partial_merge_pushdown_nobucket\nON key16=key_nobucket";
            String joinAndWriteToTableWithFewerBuckets = "CREATE TABLE test_partial_merge_pushdown_out8\nWITH (bucket_count = 8, bucketed_by = ARRAY['key16'])\nAS\nSELECT key16, value16, key32, value32, key_nobucket, value_nobucket\nFROM\n  test_partial_merge_pushdown_16buckets\nJOIN\n  test_partial_merge_pushdown_32buckets\nON key16=key32\nJOIN\n  test_partial_merge_pushdown_nobucket\nON key16=key_nobucket";
            this.assertUpdate(withoutPartialMergePushdownOptimization, joinAndWriteToTableWithSameBuckets, 15000L, this.assertRemoteExchangesCount(3));
            this.assertQuery("SELECT * FROM test_partial_merge_pushdown_out16", "SELECT orderkey, comment, orderkey, comment, orderkey, comment from orders");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_out16");
            this.assertUpdate(withPartialMergePushdownOptimization, joinAndWriteToTableWithSameBuckets, 15000L, this.assertRemoteExchangesCount(2));
            this.assertQuery("SELECT * FROM test_partial_merge_pushdown_out16", "SELECT orderkey, comment, orderkey, comment, orderkey, comment from orders");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_out16");
            this.assertUpdate(withoutPartialMergePushdownOptimization, joinAndWriteToTableWithFewerBuckets, 15000L, this.assertRemoteExchangesCount(4));
            this.assertQuery("SELECT * FROM test_partial_merge_pushdown_out8", "SELECT orderkey, comment, orderkey, comment, orderkey, comment from orders");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_out8");
            this.assertUpdate(withPartialMergePushdownOptimization, joinAndWriteToTableWithFewerBuckets, 15000L, this.assertRemoteExchangesCount(3));
            this.assertQuery("SELECT * FROM test_partial_merge_pushdown_out8", "SELECT orderkey, comment, orderkey, comment, orderkey, comment from orders");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_out8");
            String readAndWriteToTableWithFewerBuckets = "CREATE TABLE test_partial_merge_pushdown_out8\nWITH (bucket_count = 8, bucketed_by = ARRAY['key16'])\nAS\nSELECT key16, value16\nFROM\n  test_partial_merge_pushdown_16buckets";
            this.assertUpdate(withoutPartialMergePushdownOptimization, readAndWriteToTableWithFewerBuckets, 15000L, this.assertRemoteExchangesCount(2));
            this.assertQuery("SELECT * FROM test_partial_merge_pushdown_out8", "SELECT orderkey, comment from orders");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_out8");
            this.assertUpdate(withPartialMergePushdownOptimization, readAndWriteToTableWithFewerBuckets, 15000L, this.assertRemoteExchangesCount(1));
            this.assertQuery("SELECT * FROM test_partial_merge_pushdown_out8", "SELECT orderkey, comment from orders");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_out8");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_16buckets");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_32buckets");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_nobucket");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_out16");
            this.assertUpdate("DROP TABLE IF EXISTS test_partial_merge_pushdown_out8");
        }
    }

    @Test
    public void testMaterializedPartitioning() {
        this.testMaterializedPartitioning(Session.builder((Session)this.materializeExchangesSession).setSystemProperty("max_concurrent_materializations", "1").build());
        this.testMaterializedPartitioning(Session.builder((Session)this.materializeExchangesSession).setSystemProperty("max_concurrent_materializations", "2").build());
        this.testMaterializedPartitioning(this.materializeExchangesSession);
        Session materializeAllDefaultPartitioningProvider = Session.builder((Session)this.getSession()).setSystemProperty("exchange_materialization_strategy", "ALL").build();
        this.assertQueryFails(materializeAllDefaultPartitioningProvider, "SELECT orderkey, COUNT(*) lines FROM lineitem GROUP BY orderkey", "The \"partitioning_provider_catalog\" session property must be set to enable the exchanges materialization\\. The catalog must support providing a custom partitioning and storing temporary tables\\.");
        Session materializeAllWrongPartitioningProvider = Session.builder((Session)this.getSession()).setSystemProperty("exchange_materialization_strategy", "ALL").setSystemProperty("partitioning_provider_catalog", "tpch").build();
        this.assertQueryFails(materializeAllWrongPartitioningProvider, "SELECT orderkey, COUNT(*) lines FROM lineitem GROUP BY orderkey", "Catalog \"tpch\" cannot be used as a partitioning provider: This connector does not support custom partitioning");
        Session bucketingIgnored = Session.builder((Session)this.materializeExchangesSession).setCatalogSessionProperty(this.catalog, "ignore_table_bucketing", "true").build();
        this.assertQuery(bucketingIgnored, "SELECT orderkey, COUNT(*) lines FROM lineitem GROUP BY orderkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
        Session bucketingExecutionDisabled = Session.builder((Session)this.materializeExchangesSession).setCatalogSessionProperty(this.catalog, "bucket_execution_enabled", "false").build();
        this.assertQuery(bucketingExecutionDisabled, "SELECT orderkey, COUNT(*) lines FROM lineitem GROUP BY orderkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
    }

    private void testMaterializedPartitioning(Session materializeExchangesSession) {
        this.assertQuery(materializeExchangesSession, "SELECT orderkey, COUNT(*) lines FROM lineitem GROUP BY orderkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
        this.assertQuery(materializeExchangesSession, "SELECT distinct orderkey FROM lineitem", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
        this.assertQuery(materializeExchangesSession, "SELECT custkey, orderstatus, COUNT(DISTINCT orderkey) FROM orders GROUP BY custkey, orderstatus", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(2));
        this.assertQuery(materializeExchangesSession, "SELECT custkey, COUNT(DISTINCT orderstatus), COUNT(DISTINCT orderkey) FROM orders GROUP BY custkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(3).andThen(plan -> org.testng.Assert.assertTrue((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof MarkDistinctNode).matches())));
        this.assertQuery(materializeExchangesSession, "SELECT * FROM (lineitem JOIN orders ON lineitem.orderkey = orders.orderkey) x", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(2));
        try {
            this.assertUpdate("CREATE TABLE test_orders_part1 AS SELECT orderkey, totalprice FROM orders", "SELECT count(*) FROM orders");
            this.assertUpdate("CREATE TABLE test_orders_part2 AS SELECT orderkey, comment FROM orders", "SELECT count(*) FROM orders");
            this.assertQuery(materializeExchangesSession, "SELECT lineitem.orderkey, lineitem.comment, test_orders_part1.totalprice, test_orders_part2.comment ordercomment\nFROM lineitem JOIN test_orders_part1\nON lineitem.orderkey = test_orders_part1.orderkey\nJOIN test_orders_part2\nON lineitem.orderkey = test_orders_part2.orderkey", "SELECT lineitem.orderkey, lineitem.comment, orders.totalprice, orders.comment ordercomment\nFROM lineitem JOIN orders\nON lineitem.orderkey = orders.orderkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(3));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_orders_part1");
            this.assertUpdate("DROP TABLE IF EXISTS test_orders_part2");
        }
        try {
            this.assertUpdate("CREATE TABLE test_bucketed_lineitem1\nWITH (bucket_count = 17, bucketed_by = ARRAY['orderkey']) AS\nSELECT * FROM lineitem", "SELECT count(*) from lineitem");
            this.assertQuery(materializeExchangesSession, "SELECT * FROM test_bucketed_lineitem1 JOIN orders ON test_bucketed_lineitem1.orderkey = orders.orderkey", "SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
            this.assertQuery(materializeExchangesSession, "SELECT * FROM orders JOIN test_bucketed_lineitem1 ON test_bucketed_lineitem1.orderkey = orders.orderkey", "SELECT * FROM orders JOIN lineitem ON lineitem.orderkey = orders.orderkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
            this.assertUpdate("CREATE TABLE test_bucketed_lineitem2\nWITH (bucket_count = 17, bucketed_by = ARRAY['partkey', 'suppkey']) AS\nSELECT * FROM lineitem", "SELECT count(*) from lineitem");
            this.assertQuery(materializeExchangesSession, "SELECT * \nFROM test_bucketed_lineitem2 JOIN partsupp\nON test_bucketed_lineitem2.partkey = partsupp.partkey AND\ntest_bucketed_lineitem2.suppkey = partsupp.suppkey\nWHERE test_bucketed_lineitem2.suppkey = 42", "SELECT * \nFROM lineitem JOIN partsupp\nON lineitem.partkey = partsupp.partkey AND\nlineitem.suppkey = partsupp.suppkey\nWHERE lineitem.suppkey = 42", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
            this.assertQuery(materializeExchangesSession, "SELECT * \nFROM partsupp JOIN test_bucketed_lineitem2\nON test_bucketed_lineitem2.partkey = partsupp.partkey AND\ntest_bucketed_lineitem2.suppkey = partsupp.suppkey\nWHERE test_bucketed_lineitem2.suppkey = 42", "SELECT * \nFROM partsupp JOIN lineitem\nON lineitem.partkey = partsupp.partkey AND\nlineitem.suppkey = partsupp.suppkey\nWHERE lineitem.suppkey = 42", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1));
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_bucketed_lineitem1");
            this.assertUpdate("DROP TABLE IF EXISTS test_bucketed_lineitem2");
        }
        this.assertQuery(materializeExchangesSession, "SELECT sum(rn) FROM (SELECT row_number() OVER(PARTITION BY orderkey ORDER BY linenumber) as rn FROM lineitem) WHERE rn > 5", "SELECT 41137", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1).andThen(plan -> org.testng.Assert.assertTrue((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof WindowNode).matches())));
        this.assertQuery(materializeExchangesSession, "SELECT sum(rn) FROM (SELECT row_number() OVER(PARTITION BY orderkey) as rn FROM lineitem)", "SELECT 180782", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1).andThen(plan -> org.testng.Assert.assertTrue((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof RowNumberNode).matches())));
        this.assertQuery(materializeExchangesSession, "SELECT sum(rn) FROM (SELECT row_number() OVER(PARTITION BY orderkey ORDER BY linenumber) as rn FROM lineitem) WHERE rn < 5", "SELECT 107455", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(1).andThen(plan -> org.testng.Assert.assertTrue((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof TopNRowNumberNode).matches())));
        this.assertQuery(materializeExchangesSession, "SELECT partkey, count(*), sum(cost) FROM (   SELECT partkey, CAST(extendedprice AS BIGINT) cost FROM lineitem   UNION ALL   SELECT partkey, CAST(supplycost AS BIGINT) cost FROM partsupp ) GROUP BY partkey", TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(2));
        Session broadcastJoinMaterializeExchangesSession = Session.builder((Session)materializeExchangesSession).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).build();
        Session broadcastJoinStreamingExchangesSession = Session.builder((Session)this.getSession()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).build();
        this.assertQuery(broadcastJoinMaterializeExchangesSession, "WITH union_of_aggregations as (     SELECT         partkey,         count(*) AS value     FROM lineitem     GROUP BY          1     UNION ALL     SELECT         partkey,         sum(suppkey) AS value     FROM lineitem     GROUP BY          1        ) SELECT     sum(a.value + b.value) FROM union_of_aggregations a, union_of_aggregations b  WHERE a.partkey = b.partkey ", "SELECT 12404708", this.assertRemoteExchangesCount(6).andThen(TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(4)));
        String incompatiblePartitioningQuery = "WITH union_of_aggregations as (     SELECT         partkey,         count(*) as value     FROM lineitem     GROUP BY          1     UNION ALL     SELECT         partkey,         suppkey as value     FROM lineitem     GROUP BY          1, 2        ) SELECT     sum(a.value + b.value) FROM union_of_aggregations a, union_of_aggregations b  WHERE a.partkey = b.partkey ";
        this.assertQuery(broadcastJoinStreamingExchangesSession, incompatiblePartitioningQuery, "SELECT 4639006", this.assertRemoteExchangesCount(6));
        this.assertQuery(broadcastJoinMaterializeExchangesSession, incompatiblePartitioningQuery, "SELECT 4639006", this.assertRemoteExchangesCount(8).andThen(TestHiveIntegrationSmokeTest.assertRemoteMaterializedExchangesCount(4)));
    }

    public static Consumer<Plan> assertRemoteMaterializedExchangesCount(int expectedRemoteExchangesCount) {
        return plan -> {
            int actualRemoteExchangesCount = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope() == ExchangeNode.Scope.REMOTE_MATERIALIZED).findAll().size();
            if (actualRemoteExchangesCount != expectedRemoteExchangesCount) {
                throw new AssertionError((Object)String.format("Expected [%s] materialized exchanges but found [%s] materialized exchanges.", expectedRemoteExchangesCount, actualRemoteExchangesCount));
            }
        };
    }

    @Test
    public void testGroupedExecution() {
        this.testGroupedExecution(this.getSession());
        this.testGroupedExecution(this.materializeExchangesSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGroupedExecution(Session session) {
        try {
            this.assertUpdate(session, "CREATE TABLE test_grouped_join1\nWITH (bucket_count = 13, bucketed_by = ARRAY['key1']) AS\nSELECT orderkey key1, comment value1 FROM orders", 15000L);
            this.assertUpdate(session, "CREATE TABLE test_grouped_join2\nWITH (bucket_count = 13, bucketed_by = ARRAY['key2']) AS\nSELECT orderkey key2, comment value2 FROM orders", 15000L);
            this.assertUpdate(session, "CREATE TABLE test_grouped_join3\nWITH (bucket_count = 13, bucketed_by = ARRAY['key3']) AS\nSELECT orderkey key3, comment value3 FROM orders", 15000L);
            this.assertUpdate(session, "CREATE TABLE test_grouped_join4\nWITH (bucket_count = 13, bucketed_by = ARRAY['key4_bucket']) AS\nSELECT orderkey key4_bucket, orderkey key4_non_bucket, comment value4 FROM orders", 15000L);
            this.assertUpdate(session, "CREATE TABLE test_grouped_joinN AS\nSELECT orderkey keyN, comment valueN FROM orders", 15000L);
            this.assertUpdate(session, "CREATE TABLE test_grouped_joinDual\nWITH (bucket_count = 13, bucketed_by = ARRAY['keyD']) AS\nSELECT orderkey keyD, comment valueD FROM orders CROSS JOIN UNNEST(repeat(NULL, 2))", 30000L);
            this.assertUpdate(session, "CREATE TABLE test_grouped_window\nWITH (bucket_count = 5, bucketed_by = ARRAY['key']) AS\nSELECT custkey key, orderkey value FROM orders WHERE custkey <= 5 ORDER BY orderkey LIMIT 10", 10L);
            Session notColocatedNotGrouped = Session.builder((Session)session).setSystemProperty("colocated_join", "false").setSystemProperty("grouped_execution", "false").build();
            Session colocatedNotGrouped = Session.builder((Session)session).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "false").build();
            Session notColocatedGrouped = Session.builder((Session)session).setSystemProperty("colocated_join", "false").setSystemProperty("grouped_execution", "true").build();
            Session colocatedAllGroupsAtOnce = Session.builder((Session)session).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setSystemProperty("concurrent_lifespans_per_task", "0").build();
            Session colocatedOneGroupAtATime = Session.builder((Session)session).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setSystemProperty("concurrent_lifespans_per_task", "1").build();
            Session broadcastOneGroupAtATime = Session.builder((Session)session).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("colocated_join", "true").setSystemProperty("grouped_execution", "true").setSystemProperty("concurrent_lifespans_per_task", "1").build();
            String joinThreeBucketedTable = "SELECT key1, value1, key2, value2, key3, value3\nFROM test_grouped_join1\nJOIN test_grouped_join2\nON key1 = key2\nJOIN test_grouped_join3\nON key2 = key3";
            String joinThreeMixedTable = "SELECT key1, value1, key2, value2, keyN, valueN\nFROM test_grouped_join1\nJOIN test_grouped_join2\nON key1 = key2\nJOIN test_grouped_joinN\nON key2 = keyN";
            String expectedJoinQuery = "SELECT orderkey, comment, orderkey, comment, orderkey, comment from orders";
            String leftJoinBucketedTable = "SELECT key1, value1, key2, value2\nFROM test_grouped_join1\nLEFT JOIN (SELECT * FROM test_grouped_join2 WHERE key2 % 2 = 0)\nON key1 = key2";
            String rightJoinBucketedTable = "SELECT key1, value1, key2, value2\nFROM (SELECT * FROM test_grouped_join2 WHERE key2 % 2 = 0)\nRIGHT JOIN test_grouped_join1\nON key1 = key2";
            String expectedOuterJoinQuery = "SELECT orderkey, comment, CASE mod(orderkey, 2) WHEN 0 THEN orderkey END, CASE mod(orderkey, 2) WHEN 0 THEN comment END from orders";
            this.assertQuery(notColocatedNotGrouped, joinThreeBucketedTable, expectedJoinQuery);
            this.assertQuery(notColocatedNotGrouped, leftJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(notColocatedNotGrouped, rightJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(notColocatedGrouped, joinThreeBucketedTable, expectedJoinQuery);
            this.assertQuery(notColocatedGrouped, leftJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(notColocatedGrouped, rightJoinBucketedTable, expectedOuterJoinQuery);
            this.assertQuery(colocatedNotGrouped, joinThreeBucketedTable, expectedJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedNotGrouped, joinThreeMixedTable, expectedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnce, joinThreeBucketedTable, expectedJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, joinThreeMixedTable, expectedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, joinThreeBucketedTable, expectedJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, joinThreeMixedTable, expectedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedNotGrouped, leftJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedNotGrouped, rightJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, leftJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, rightJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, leftJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, rightJoinBucketedTable, expectedOuterJoinQuery, this.assertRemoteExchangesCount(1));
            String crossJoin = "SELECT key1, value1, key2, value2, key3, value3\nFROM test_grouped_join1\nJOIN test_grouped_join2\nON key1 = key2\nCROSS JOIN (SELECT * FROM test_grouped_join3 WHERE key3 <= 3)";
            String expectedCrossJoinQuery = "SELECT key1, value1, key1, value1, key3, value3\nFROM\n  (SELECT orderkey key1, comment value1 FROM orders)\nCROSS JOIN\n  (SELECT orderkey key3, comment value3 FROM orders where orderkey <= 3)";
            this.assertQuery(notColocatedNotGrouped, crossJoin, expectedCrossJoinQuery);
            this.assertQuery(notColocatedGrouped, crossJoin, expectedCrossJoinQuery);
            this.assertQuery(colocatedNotGrouped, crossJoin, expectedCrossJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnce, crossJoin, expectedCrossJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, crossJoin, expectedCrossJoinQuery, this.assertRemoteExchangesCount(2));
            String bucketedAndUnbucketedJoin = "SELECT key1, value1, keyN, valueN, key2, value2, key3, value3\nFROM\n  test_grouped_join1\nJOIN (\n  SELECT *\n  FROM test_grouped_joinN\n  JOIN test_grouped_join2\n  ON keyN = key2\n)\nON key1 = keyN\nJOIN test_grouped_join3\nON key1 = key3";
            String expectedBucketedAndUnbucketedJoinQuery = "SELECT orderkey, comment, orderkey, comment, orderkey, comment, orderkey, comment from orders";
            this.assertQuery(notColocatedNotGrouped, bucketedAndUnbucketedJoin, expectedBucketedAndUnbucketedJoinQuery);
            this.assertQuery(notColocatedGrouped, bucketedAndUnbucketedJoin, expectedBucketedAndUnbucketedJoinQuery);
            this.assertQuery(colocatedNotGrouped, bucketedAndUnbucketedJoin, expectedBucketedAndUnbucketedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnce, bucketedAndUnbucketedJoin, expectedBucketedAndUnbucketedJoinQuery, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, bucketedAndUnbucketedJoin, expectedBucketedAndUnbucketedJoinQuery, this.assertRemoteExchangesCount(2));
            String groupBySingleBucketed = "SELECT\n  keyD,\n  count(valueD)\nFROM\n  test_grouped_joinDual\nGROUP BY keyD";
            String expectedSingleGroupByQuery = "SELECT orderkey, 2 from orders";
            String groupByOfUnionBucketed = "SELECT\n  key\n, arbitrary(value1)\n, arbitrary(value2)\n, arbitrary(value3)\nFROM (\n  SELECT key1 key, value1, NULL value2, NULL value3\n  FROM test_grouped_join1\nUNION ALL\n  SELECT key2 key, NULL value1, value2, NULL value3\n  FROM test_grouped_join2\n  WHERE key2 % 2 = 0\nUNION ALL\n  SELECT key3 key, NULL value1, NULL value2, value3\n  FROM test_grouped_join3\n  WHERE key3 % 3 = 0\n)\nGROUP BY key";
            String groupByOfUnionMixed = "SELECT\n  key\n, arbitrary(value1)\n, arbitrary(value2)\n, arbitrary(valueN)\nFROM (\n  SELECT key1 key, value1, NULL value2, NULL valueN\n  FROM test_grouped_join1\nUNION ALL\n  SELECT key2 key, NULL value1, value2, NULL valueN\n  FROM test_grouped_join2\n  WHERE key2 % 2 = 0\nUNION ALL\n  SELECT keyN key, NULL value1, NULL value2, valueN\n  FROM test_grouped_joinN\n  WHERE keyN % 3 = 0\n)\nGROUP BY key";
            String expectedGroupByOfUnion = "SELECT orderkey, comment, CASE mod(orderkey, 2) WHEN 0 THEN comment END, CASE mod(orderkey, 3) WHEN 0 THEN comment END from orders";
            String groupByOfUnionOfGroupByMixed = "SELECT\n  key, sum(cnt) cnt\nFROM (\n  SELECT keyD key, count(valueD) cnt\n  FROM test_grouped_joinDual\n  GROUP BY keyD\nUNION ALL\n  SELECT keyN key, 1 cnt\n  FROM test_grouped_joinN\n)\ngroup by key";
            String expectedGroupByOfUnionOfGroupBy = "SELECT orderkey, 3 from orders";
            this.assertQuery(notColocatedGrouped, groupBySingleBucketed, expectedSingleGroupByQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, groupBySingleBucketed, expectedSingleGroupByQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, groupBySingleBucketed, expectedSingleGroupByQuery, this.assertRemoteExchangesCount(1));
            this.assertQuery(notColocatedGrouped, groupByOfUnionBucketed, expectedGroupByOfUnion, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, groupByOfUnionBucketed, expectedGroupByOfUnion, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, groupByOfUnionBucketed, expectedGroupByOfUnion, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, groupByOfUnionMixed, expectedGroupByOfUnion, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, groupByOfUnionOfGroupByMixed, expectedGroupByOfUnionOfGroupBy, this.assertRemoteExchangesCount(2));
            String joinGroupedWithGrouped = "SELECT key1, count1, count2\nFROM (\n  SELECT keyD key1, count(valueD) count1\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n) JOIN (\n  SELECT keyD key2, count(valueD) count2\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n)\nON key1 = key2";
            String expectedJoinGroupedWithGrouped = "SELECT orderkey, 2, 2 from orders";
            String joinGroupedWithUngrouped = "SELECT keyD, countD, valueN\nFROM (\n  SELECT keyD, count(valueD) countD\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n) JOIN (\n  SELECT keyN, valueN\n  FROM test_grouped_joinN\n)\nON keyD = keyN";
            String expectedJoinGroupedWithUngrouped = "SELECT orderkey, 2, comment from orders";
            String joinUngroupedWithGrouped = "SELECT keyN, valueN, countD\nFROM (\n  SELECT keyN, valueN\n  FROM test_grouped_joinN\n) JOIN (\n  SELECT keyD, count(valueD) countD\n  FROM test_grouped_joinDual\n  GROUP BY keyD\n)\nON keyN = keyD";
            String expectedJoinUngroupedWithGrouped = "SELECT orderkey, comment, 2 from orders";
            String groupOnJoinResult = "SELECT keyD, count(valueD), count(valueN)\nFROM\n  test_grouped_joinDual\nJOIN\n  test_grouped_joinN\nON keyD=keyN\nGROUP BY keyD";
            String expectedGroupOnJoinResult = "SELECT orderkey, 2, 2 from orders";
            String groupOnUngroupedJoinResult = "SELECT key4_bucket, count(value4), count(valueN)\nFROM\n  test_grouped_join4\nJOIN\n  test_grouped_joinN\nON key4_non_bucket=keyN\nGROUP BY key4_bucket";
            String expectedGroupOnUngroupedJoinResult = "SELECT orderkey, count(*), count(*) from orders group by orderkey";
            this.assertQuery(notColocatedGrouped, joinGroupedWithGrouped, expectedJoinGroupedWithGrouped, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnce, joinGroupedWithGrouped, expectedJoinGroupedWithGrouped, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, joinGroupedWithGrouped, expectedJoinGroupedWithGrouped, this.assertRemoteExchangesCount(1));
            this.assertQuery(notColocatedGrouped, joinGroupedWithUngrouped, expectedJoinGroupedWithUngrouped, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnce, joinGroupedWithUngrouped, expectedJoinGroupedWithUngrouped, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, joinGroupedWithUngrouped, expectedJoinGroupedWithUngrouped, this.assertRemoteExchangesCount(2));
            this.assertQuery(notColocatedGrouped, groupOnJoinResult, expectedGroupOnJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnce, groupOnJoinResult, expectedGroupOnJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, groupOnJoinResult, expectedGroupOnJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(broadcastOneGroupAtATime, groupOnUngroupedJoinResult, expectedGroupOnUngroupedJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, joinUngroupedWithGrouped, expectedJoinUngroupedWithGrouped, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, groupOnUngroupedJoinResult, expectedGroupOnUngroupedJoinResult, this.assertRemoteExchangesCount(4));
            String chainedOuterJoin = "SELECT key1, value1, key2, value2, key3, value3\nFROM\n  (SELECT * FROM test_grouped_join1 where mod(key1, 2) = 0)\nRIGHT JOIN\n  (SELECT * FROM test_grouped_join2 where mod(key2, 3) = 0)\nON key1 = key2\nFULL JOIN\n  (SELECT * FROM test_grouped_join3 where mod(key3, 5) = 0)\nON key2 = key3";
            String sharedBuildOuterJoin = "SELECT key1, value1, keyN, valueN\nFROM\n  (SELECT key1, arbitrary(value1) value1 FROM test_grouped_join1 where mod(key1, 2) = 0 group by key1)\nRIGHT JOIN\n  (SELECT * FROM test_grouped_joinN where mod(keyN, 3) = 0)\nON key1 = keyN";
            String chainedSharedBuildOuterJoin = "SELECT key1, value1, keyN, valueN, key3, value3\nFROM\n  (SELECT key1, arbitrary(value1) value1 FROM test_grouped_join1 where mod(key1, 2) = 0 group by key1)\nRIGHT JOIN\n  (SELECT * FROM test_grouped_joinN where mod(keyN, 3) = 0)\nON key1 = keyN\nFULL JOIN\n  (SELECT * FROM test_grouped_join3 where mod(key3, 5) = 0)\nON keyN = key3";
            String expectedChainedOuterJoinResult = "SELECT\n  CASE WHEN mod(orderkey, 2 * 3) = 0 THEN orderkey END,\n  CASE WHEN mod(orderkey, 2 * 3) = 0 THEN comment END,\n  CASE WHEN mod(orderkey, 3) = 0 THEN orderkey END,\n  CASE WHEN mod(orderkey, 3) = 0 THEN comment END,\n  CASE WHEN mod(orderkey, 5) = 0 THEN orderkey END,\n  CASE WHEN mod(orderkey, 5) = 0 THEN comment END\nFROM ORDERS\nWHERE mod(orderkey, 3) = 0 OR mod(orderkey, 5) = 0";
            String expectedSharedBuildOuterJoinResult = "SELECT\n  CASE WHEN mod(orderkey, 2) = 0 THEN orderkey END,\n  CASE WHEN mod(orderkey, 2) = 0 THEN comment END,\n  orderkey,\n  comment\nFROM ORDERS\nWHERE mod(orderkey, 3) = 0";
            this.assertQuery(notColocatedNotGrouped, chainedOuterJoin, expectedChainedOuterJoinResult);
            this.assertQuery(notColocatedGrouped, chainedOuterJoin, expectedChainedOuterJoinResult);
            this.assertQuery(colocatedNotGrouped, chainedOuterJoin, expectedChainedOuterJoinResult, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, chainedOuterJoin, expectedChainedOuterJoinResult, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, chainedOuterJoin, expectedChainedOuterJoinResult, this.assertRemoteExchangesCount(1));
            this.assertQuery(notColocatedNotGrouped, sharedBuildOuterJoin, expectedSharedBuildOuterJoinResult);
            this.assertQuery(notColocatedGrouped, sharedBuildOuterJoin, expectedSharedBuildOuterJoinResult);
            this.assertQuery(colocatedNotGrouped, sharedBuildOuterJoin, expectedSharedBuildOuterJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedAllGroupsAtOnce, sharedBuildOuterJoin, expectedSharedBuildOuterJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, sharedBuildOuterJoin, expectedSharedBuildOuterJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, chainedSharedBuildOuterJoin, expectedChainedOuterJoinResult, this.assertRemoteExchangesCount(2));
            this.assertQuery(colocatedOneGroupAtATime, "SELECT key, count(*) OVER (PARTITION BY key ORDER BY value) FROM test_grouped_window", "VALUES\n(1, 1),\n(2, 1),\n(2, 2),\n(4, 1),\n(4, 2),\n(4, 3),\n(4, 4),\n(4, 5),\n(5, 1),\n(5, 2)", this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, "SELECT key, row_number() OVER (PARTITION BY key ORDER BY value) FROM test_grouped_window", "VALUES\n(1, 1),\n(2, 1),\n(2, 2),\n(4, 1),\n(4, 2),\n(4, 3),\n(4, 4),\n(4, 5),\n(5, 1),\n(5, 2)", this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, "SELECT key, n FROM (SELECT key, row_number() OVER (PARTITION BY key ORDER BY value) AS n FROM test_grouped_window) WHERE n <= 2", "VALUES\n(1, 1),\n(2, 1),\n(2, 2),\n(4, 1),\n(4, 2),\n(5, 1),\n(5, 2)", this.assertRemoteExchangesCount(1));
            String noSplits = "SELECT key1, arbitrary(value1)\nFROM test_grouped_join1\nWHERE \"$bucket\" < 0\nGROUP BY key1";
            String joinMismatchedBuckets = "SELECT key1, value1, key2, value2\nFROM (\n  SELECT *\n  FROM test_grouped_join1\n  WHERE \"$bucket\"=1\n)\nFULL OUTER JOIN (\n  SELECT *\n  FROM test_grouped_join2\n  WHERE \"$bucket\"=11\n)\nON key1=key2";
            String expectedNoSplits = "SELECT 1, 'a' WHERE FALSE";
            String expectedJoinMismatchedBuckets = "SELECT\n  CASE WHEN mod(orderkey, 13) = 1 THEN orderkey END,\n  CASE WHEN mod(orderkey, 13) = 1 THEN comment END,\n  CASE WHEN mod(orderkey, 13) = 11 THEN orderkey END,\n  CASE WHEN mod(orderkey, 13) = 11 THEN comment END\nFROM ORDERS\nWHERE mod(orderkey, 13) IN (1, 11)";
            this.assertQuery(notColocatedNotGrouped, noSplits, expectedNoSplits);
            this.assertQuery(notColocatedGrouped, noSplits, expectedNoSplits);
            this.assertQuery(colocatedNotGrouped, noSplits, expectedNoSplits, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, noSplits, expectedNoSplits, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, noSplits, expectedNoSplits, this.assertRemoteExchangesCount(1));
            this.assertQuery(notColocatedNotGrouped, joinMismatchedBuckets, expectedJoinMismatchedBuckets);
            this.assertQuery(notColocatedGrouped, joinMismatchedBuckets, expectedJoinMismatchedBuckets);
            this.assertQuery(colocatedNotGrouped, joinMismatchedBuckets, expectedJoinMismatchedBuckets, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedAllGroupsAtOnce, joinMismatchedBuckets, expectedJoinMismatchedBuckets, this.assertRemoteExchangesCount(1));
            this.assertQuery(colocatedOneGroupAtATime, joinMismatchedBuckets, expectedJoinMismatchedBuckets, this.assertRemoteExchangesCount(1));
        }
        finally {
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_grouped_join1");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_grouped_join2");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_grouped_join3");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_grouped_join4");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_grouped_joinN");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_grouped_joinDual");
            this.assertUpdate(session, "DROP TABLE IF EXISTS test_grouped_window");
        }
    }

    private Consumer<Plan> assertRemoteExchangesCount(int expectedRemoteExchangesCount) {
        return TestHiveIntegrationSmokeTest.assertRemoteExchangesCount(expectedRemoteExchangesCount, this.getSession(), (DistributedQueryRunner)this.getQueryRunner());
    }

    public static Consumer<Plan> assertRemoteExchangesCount(int expectedRemoteExchangesCount, Session session, DistributedQueryRunner queryRunner) {
        return plan -> {
            int actualRemoteExchangesCount = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof ExchangeNode && ((ExchangeNode)node).getScope().isRemote()).findAll().size();
            if (actualRemoteExchangesCount != expectedRemoteExchangesCount) {
                Metadata metadata = queryRunner.getCoordinator().getMetadata();
                String formattedPlan = PlanPrinter.textLogicalPlan((PlanNode)plan.getRoot(), (TypeProvider)plan.getTypes(), (StatsAndCosts)StatsAndCosts.empty(), (FunctionAndTypeManager)metadata.getFunctionAndTypeManager(), (Session)session, (int)0);
                throw new AssertionError((Object)String.format("Expected [\n%s\n] remote exchanges but found [\n%s\n] remote exchanges. Actual plan is [\n\n%s\n]", expectedRemoteExchangesCount, actualRemoteExchangesCount, formattedPlan));
            }
        };
    }

    @Test
    public void testRcTextCharDecoding() {
        this.testRcTextCharDecoding(false);
        this.testRcTextCharDecoding(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRcTextCharDecoding(boolean rcFileOptimizedWriterEnabled) {
        String catalog = (String)this.getSession().getCatalog().get();
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "rcfile_optimized_writer_enabled", Boolean.toString(rcFileOptimizedWriterEnabled)).build();
        this.assertUpdate(session, "CREATE TABLE test_table_with_char_rc WITH (format = 'RCTEXT') AS SELECT CAST('khaki' AS CHAR(7)) char_column", 1L);
        try {
            this.assertQuery(session, "SELECT * FROM test_table_with_char_rc WHERE char_column = 'khaki  '", "VALUES (CAST('khaki' AS CHAR(7)))");
        }
        finally {
            this.assertUpdate(session, "DROP TABLE test_table_with_char_rc");
        }
    }

    @Test
    public void testInvalidPartitionValue() {
        this.assertUpdate("CREATE TABLE invalid_partition_value (a int, b varchar) WITH (partitioned_by = ARRAY['b'])");
        this.assertQueryFails("INSERT INTO invalid_partition_value VALUES (4, 'test' || chr(13))", "\\QHive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: 74 65 73 74 0D\\E");
        this.assertUpdate("DROP TABLE invalid_partition_value");
        this.assertQueryFails("CREATE TABLE invalid_partition_value (a, b) WITH (partitioned_by = ARRAY['b']) AS SELECT 4, chr(9731)", "\\QHive partition keys can only contain printable ASCII characters (0x20 - 0x7E). Invalid value: E2 98 83\\E");
    }

    @Test
    public void testCurrentUserInView() {
        Preconditions.checkState((boolean)this.getSession().getCatalog().isPresent(), (Object)"catalog is not set");
        Preconditions.checkState((boolean)this.getSession().getSchema().isPresent(), (Object)"schema is not set");
        String testAccountsUnqualifiedName = "test_accounts";
        String testAccountsViewUnqualifiedName = "test_accounts_view";
        String testAccountsViewFullyQualifiedName = String.format("%s.%s.%s", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), testAccountsViewUnqualifiedName);
        this.assertUpdate(String.format("CREATE TABLE %s AS SELECT user_name, account_name  FROM (VALUES ('user1', 'account1'), ('user2', 'account2'))  t (user_name, account_name)", testAccountsUnqualifiedName), 2L);
        this.assertUpdate(String.format("CREATE VIEW %s AS SELECT account_name FROM test_accounts WHERE user_name = CURRENT_USER", testAccountsViewUnqualifiedName));
        this.assertUpdate(String.format("GRANT SELECT ON %s TO user1", testAccountsViewFullyQualifiedName));
        this.assertUpdate(String.format("GRANT SELECT ON %s TO user2", testAccountsViewFullyQualifiedName));
        Session user1 = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).setIdentity(new Identity("user1", this.getSession().getIdentity().getPrincipal())).build();
        Session user2 = TestingSession.testSessionBuilder().setCatalog((String)this.getSession().getCatalog().get()).setSchema((String)this.getSession().getSchema().get()).setIdentity(new Identity("user2", this.getSession().getIdentity().getPrincipal())).build();
        this.assertQuery(user1, "SELECT account_name FROM test_accounts_view", "VALUES 'account1'");
        this.assertQuery(user2, "SELECT account_name FROM test_accounts_view", "VALUES 'account2'");
        this.assertUpdate("DROP VIEW test_accounts_view");
        this.assertUpdate("DROP TABLE test_accounts");
    }

    @Test
    public void testCreateViewWithNonHiveType() {
        String testTable = "test_create_view_table";
        String testView = "test_view_with_hll";
        this.assertUpdate(String.format("CREATE TABLE %s AS SELECT user_name, account_name  FROM (VALUES ('user1', 'account1'), ('user2', 'account2'))  t (user_name, account_name)", testTable), 2L);
        this.assertUpdate(String.format("CREATE VIEW %s AS SELECT approx_set(account_name) as hll FROM %s", testView, testTable));
        this.assertQuery(String.format("SELECT cardinality(hll) from %s", testView), "VALUES '2'");
    }

    @Test
    public void testCollectColumnStatisticsOnCreateTable() {
        String tableName = "test_collect_column_statistics_on_create_table";
        this.assertUpdate(String.format("CREATE TABLE %s WITH (    partitioned_by = ARRAY['p_varchar'] ) AS SELECT c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, c_array, p_varchar FROM (   VALUES     (null, null, null, null, null, null, null, 'p1'),     (null, null, null, null, null, null, null, 'p1'),     (true, BIGINT '1', DOUBLE '2.2', TIMESTAMP '2012-08-08 01:00', CAST('abc1' AS VARCHAR), CAST('bcd1' AS VARBINARY), sequence(0, 10), 'p1'),    (false, BIGINT '0', DOUBLE '1.2', TIMESTAMP '2012-08-08 00:00', CAST('abc2' AS VARCHAR), CAST('bcd2' AS VARBINARY), sequence(10, 20), 'p1'),    (null, null, null, null, null, null, null, 'p2'),     (null, null, null, null, null, null, null, 'p2'),     (true, BIGINT '2', DOUBLE '3.3', TIMESTAMP '2012-09-09 01:00', CAST('cba1' AS VARCHAR), CAST('dcb1' AS VARBINARY), sequence(20, 25), 'p2'),     (false, BIGINT '1', DOUBLE '2.3', TIMESTAMP '2012-09-09 00:00', CAST('cba2' AS VARCHAR), CAST('dcb2' AS VARBINARY), sequence(30, 35), 'p2') ) AS x (c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, c_array, p_varchar)", tableName), 8L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0E0, 0.5E0, null, null, null), ('c_bigint', null, 2.0E0, 0.5E0, null, '0', '1'), ('c_double', null, 2.0E0, 0.5E0, null, '1.2', '2.2'), ('c_timestamp', null, 2.0E0, 0.5E0, null, null, null), ('c_varchar', 8.0E0, 2.0E0, 0.5E0, null, null, null), ('c_varbinary', 8.0E0, null, 0.5E0, null, null, null), ('c_array', 176.0E0, null, 0.5, null, null, null), ('p_varchar', 8.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 4.0E0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0E0, 0.5E0, null, null, null), ('c_bigint', null, 2.0E0, 0.5E0, null, '1', '2'), ('c_double', null, 2.0E0, 0.5E0, null, '2.3', '3.3'), ('c_timestamp', null, 2.0E0, 0.5E0, null, null, null), ('c_varchar', 8.0E0, 2.0E0, 0.5E0, null, null, null), ('c_varbinary', 8.0E0, null, 0.5E0, null, null, null), ('c_array', 96.0E0, null, 0.5, null, null, null), ('p_varchar', 8.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 4.0E0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 0E0, 0E0, null, null, null), ('c_bigint', null, 0E0, 0E0, null, null, null), ('c_double', null, 0E0, 0E0, null, null, null), ('c_timestamp', null, 0E0, 0E0, null, null, null), ('c_varchar', 0E0, 0E0, 0E0, null, null, null), ('c_varbinary', null, 0E0, 0E0, null, null, null), ('c_array', null, 0E0, 0E0, null, null, null), ('p_varchar', 0E0, 0E0, 0E0, null, null, null), (null, null, null, null, 0E0, null, null)");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testCollectColumnStatisticsOnInsert() {
        String tableName = "test_collect_column_statistics_on_insert";
        this.assertUpdate(String.format("CREATE TABLE %s (    c_boolean BOOLEAN,    c_bigint BIGINT,    c_double DOUBLE,    c_timestamp TIMESTAMP,    c_varchar VARCHAR,    c_varbinary VARBINARY,    c_array ARRAY(BIGINT),    p_varchar VARCHAR ) WITH (    partitioned_by = ARRAY['p_varchar'] )", tableName));
        this.assertUpdate(String.format("INSERT INTO %s SELECT c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, c_array, p_varchar FROM (   VALUES     (null, null, null, null, null, null, null, 'p1'),     (null, null, null, null, null, null, null, 'p1'),     (true, BIGINT '1', DOUBLE '2.2', TIMESTAMP '2012-08-08 01:00', CAST('abc1' AS VARCHAR), CAST('bcd1' AS VARBINARY), sequence(0, 10), 'p1'),    (false, BIGINT '0', DOUBLE '1.2', TIMESTAMP '2012-08-08 00:00', CAST('abc2' AS VARCHAR), CAST('bcd2' AS VARBINARY), sequence(10, 20), 'p1'),    (null, null, null, null, null, null, null, 'p2'),     (null, null, null, null, null, null, null, 'p2'),     (true, BIGINT '2', DOUBLE '3.3', TIMESTAMP '2012-09-09 01:00', CAST('cba1' AS VARCHAR), CAST('dcb1' AS VARBINARY), sequence(20, 25), 'p2'),     (false, BIGINT '1', DOUBLE '2.3', TIMESTAMP '2012-09-09 00:00', CAST('cba2' AS VARCHAR), CAST('dcb2' AS VARBINARY), sequence(30, 35), 'p2') ) AS x (c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, c_array, p_varchar)", tableName), 8L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0E0, 0.5E0, null, null, null), ('c_bigint', null, 2.0E0, 0.5E0, null, '0', '1'), ('c_double', null, 2.0E0, 0.5E0, null, '1.2', '2.2'), ('c_timestamp', null, 2.0E0, 0.5E0, null, null, null), ('c_varchar', 8.0E0, 2.0E0, 0.5E0, null, null, null), ('c_varbinary', 8.0E0, null, 0.5E0, null, null, null), ('c_array', 176.0E0, null, 0.5E0, null, null, null), ('p_varchar', 8.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 4.0E0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0E0, 0.5E0, null, null, null), ('c_bigint', null, 2.0E0, 0.5E0, null, '1', '2'), ('c_double', null, 2.0E0, 0.5E0, null, '2.3', '3.3'), ('c_timestamp', null, 2.0E0, 0.5E0, null, null, null), ('c_varchar', 8.0E0, 2.0E0, 0.5E0, null, null, null), ('c_varbinary', 8.0E0, null, 0.5E0, null, null, null), ('c_array', 96.0E0, null, 0.5E0, null, null, null), ('p_varchar', 8.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 4.0E0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3')", tableName), "SELECT * FROM VALUES ('c_boolean', null, 0E0, 0E0, null, null, null), ('c_bigint', null, 0E0, 0E0, null, null, null), ('c_double', null, 0E0, 0E0, null, null, null), ('c_timestamp', null, 0E0, 0E0, null, null, null), ('c_varchar', 0E0, 0E0, 0E0, null, null, null), ('c_varbinary', null, 0E0, 0E0, null, null, null), ('c_array', null, 0E0, 0E0, null, null, null), ('p_varchar', 0E0, 0E0, 0E0, null, null, null), (null, null, null, null, 0E0, null, null)");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testAnalyzePropertiesSystemTable() {
        this.assertQuery("SELECT * FROM system.metadata.analyze_properties WHERE catalog_name = 'hive'", "SELECT 'hive', 'partitions', '', 'array(array(varchar))', 'Partitions to be analyzed'");
    }

    @Test
    public void testAnalyzeEmptyTable() {
        String tableName = "test_analyze_empty_table";
        this.assertUpdate(String.format("CREATE TABLE %s (c_bigint BIGINT, c_varchar VARCHAR(2))", tableName));
        this.assertUpdate("ANALYZE " + tableName, 0L);
    }

    @Test
    public void testInvalidAnalyzePartitionedTable() {
        String tableName = "test_invalid_analyze_partitioned_table";
        this.assertQueryFails("ANALYZE " + tableName, String.format(".*Table 'hive.tpch.%s' does not exist.*", tableName));
        this.createPartitionedTableForAnalyzeTest(tableName);
        this.assertQueryFails(String.format("ANALYZE %s WITH (error = 1)", tableName), ".*'hive' does not support analyze property 'error'.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = 1)", tableName), ".*Cannot convert '1' to \\Qarray(array(varchar))\\E.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = NULL)", tableName), ".*Invalid null value for analyze property.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[NULL])", tableName), ".*Invalid null value in analyze partitions property.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p4', '10']])", tableName), ".*Partition no longer exists.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p4']])", tableName), ".*Partition value count does not match the partition column count.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p4', '10', 'error']])", tableName), ".*Partition value count does not match the partition column count.*");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testInvalidAnalyzeUnpartitionedTable() {
        String tableName = "test_invalid_analyze_unpartitioned_table";
        this.assertQueryFails("ANALYZE " + tableName, ".*Table.*does not exist.*");
        this.createUnpartitionedTableForAnalyzeTest(tableName);
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[])", tableName), ".*Only partitioned table can be analyzed with a partition list.*");
        this.assertQueryFails(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p1']])", tableName), ".*Only partitioned table can be analyzed with a partition list.*");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testAnalyzePartitionedTable() {
        String tableName = "test_analyze_partitioned_table";
        this.createPartitionedTableForAnalyzeTest(tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('c_array', null, null, null, null, null, null), ('p_varchar', 24.0, 3.0, 0.25, null, null, null), ('p_bigint', null, 2.0, 0.25, null, '7', '8'), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate(String.format("ANALYZE %s WITH (partitions = ARRAY[])", tableName), 0L);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('c_array', null, null, null, null, null, null), ('p_varchar', 24.0, 3.0, 0.25, null, null, null), ('p_bigint', null, 2.0, 0.25, null, '7', '8'), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate(String.format("ANALYZE %s WITH (partitions = ARRAY[ARRAY['p1', '7'], ARRAY['p2', '7'], ARRAY['p2', '7'], ARRAY[NULL, NULL]])", tableName), 12L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '0', '1'), ('c_double', null, 2.0, 0.5, null, '1.2', '2.2'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('c_array', 176.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '1', '2'), ('c_double', null, 2.0, 0.5, null, '2.3', '3.3'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('c_array', 96.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar IS NULL AND p_bigint IS NULL)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 1.0, 0.0, null, null, null), ('c_bigint', null, 4.0, 0.0, null, '4', '7'), ('c_double', null, 4.0, 0.0, null, '4.7', '7.7'), ('c_timestamp', null, 4.0, 0.0, null, null, null), ('c_varchar', 16.0, 4.0, 0.0, null, null, null), ('c_varbinary', 8.0, null, 0.0, null, null, null), ('c_array', 192.0, null, 0.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', null, 0.0, 1.0, null, null, null), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3' AND p_bigint = 8)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('c_array', null, null, null, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '8', '8'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e1' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('c_array', null, null, null, null, null, null), ('p_varchar', 0.0, 0.0, 0.0, null, null, null), ('p_bigint', null, 0.0, 0.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e2' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('c_array', null, null, null, null, null, null), ('p_varchar', 0.0, 0.0, 0.0, null, null, null), ('p_bigint', null, 0.0, 0.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate("ANALYZE " + tableName, 16L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p1' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '0', '1'), ('c_double', null, 2.0, 0.5, null, '1.2', '2.2'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('c_array', 176.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p2' AND p_bigint = 7)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '1', '2'), ('c_double', null, 2.0, 0.5, null, '2.3', '3.3'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('c_array', 96.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '7', '7'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar IS NULL AND p_bigint IS NULL)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 1.0, 0.0, null, null, null), ('c_bigint', null, 4.0, 0.0, null, '4', '7'), ('c_double', null, 4.0, 0.0, null, '4.7', '7.7'), ('c_timestamp', null, 4.0, 0.0, null, null, null), ('c_varchar', 16.0, 4.0, 0.0, null, null, null), ('c_varbinary', 8.0, null, 0.0, null, null, null), ('c_array', 192.0, null, 0.0, null, null, null), ('p_varchar', 0.0, 0.0, 1.0, null, null, null), ('p_bigint', null, 0.0, 1.0, null, null, null), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'p3' AND p_bigint = 8)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.5, null, null, null), ('c_bigint', null, 2.0, 0.5, null, '2', '3'), ('c_double', null, 2.0, 0.5, null, '3.4', '4.4'), ('c_timestamp', null, 2.0, 0.5, null, null, null), ('c_varchar', 8.0, 2.0, 0.5, null, null, null), ('c_varbinary', 4.0, null, 0.5, null, null, null), ('c_array', 96.0, null, 0.5, null, null, null), ('p_varchar', 8.0, 1.0, 0.0, null, null, null), ('p_bigint', null, 1.0, 0.0, null, '8', '8'), (null, null, null, null, 4.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e1' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 0.0, 0.0, null, null, null), ('c_bigint', null, 0.0, 0.0, null, null, null), ('c_double', null, 0.0, 0.0, null, null, null), ('c_timestamp', null, 0.0, 0.0, null, null, null), ('c_varchar', 0.0, 0.0, 0.0, null, null, null), ('c_varbinary', 0.0, null, 0.0, null, null, null), ('c_array', 0.0, null, 0.0, null, null, null), ('p_varchar', 0.0, 0.0, 0.0, null, null, null), ('p_bigint', null, 0.0, 0.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar = 'e2' AND p_bigint = 9)", tableName), "SELECT * FROM VALUES ('c_boolean', null, 0.0, 0.0, null, null, null), ('c_bigint', null, 0.0, 0.0, null, null, null), ('c_double', null, 0.0, 0.0, null, null, null), ('c_timestamp', null, 0.0, 0.0, null, null, null), ('c_varchar', 0.0, 0.0, 0.0, null, null, null), ('c_varbinary', 0.0, null, 0.0, null, null, null), ('c_array', 0.0, null, 0.0, null, null, null), ('p_varchar', 0.0, 0.0, 0.0, null, null, null), ('p_bigint', null, 0.0, 0.0, null, null, null), (null, null, null, null, 0.0, null, null)");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    @Test
    public void testAnalyzeUnpartitionedTable() {
        String tableName = "test_analyze_unpartitioned_table";
        this.createUnpartitionedTableForAnalyzeTest(tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, null, null, null, null, null), ('c_bigint', null, null, null, null, null, null), ('c_double', null, null, null, null, null, null), ('c_timestamp', null, null, null, null, null, null), ('c_varchar', null, null, null, null, null, null), ('c_varbinary', null, null, null, null, null, null), ('c_array', null, null, null, null, null, null), ('p_varchar', null, null, null, null, null, null), ('p_bigint', null, null, null, null, null, null), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate("ANALYZE " + tableName, 16L);
        this.assertQuery("SHOW STATS FOR " + tableName, "SELECT * FROM VALUES ('c_boolean', null, 2.0, 0.375, null, null, null), ('c_bigint', null, 8.0, 0.375, null, '0', '7'), ('c_double', null, 10.0, 0.375, null, '1.2', '7.7'), ('c_timestamp', null, 10.0, 0.375, null, null, null), ('c_varchar', 40.0, 10.0, 0.375, null, null, null), ('c_varbinary', 20.0, null, 0.375, null, null, null), ('c_array', 560.0, null, 0.375, null, null, null), ('p_varchar', 24.0, 3.0, 0.25, null, null, null), ('p_bigint', null, 2.0, 0.25, null, '7', '8'), (null, null, null, null, 16.0, null, null)");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    protected void createPartitionedTableForAnalyzeTest(String tableName) {
        this.createTableForAnalyzeTest(tableName, true);
    }

    protected void createUnpartitionedTableForAnalyzeTest(String tableName) {
        this.createTableForAnalyzeTest(tableName, false);
    }

    private void createTableForAnalyzeTest(String tableName, boolean partitioned) {
        Session defaultSession = this.getSession();
        Session disableColumnStatsSession = Session.builder((Session)defaultSession).setCatalogSessionProperty((String)defaultSession.getCatalog().get(), "collect_column_statistics_on_write", "false").build();
        this.assertUpdate(disableColumnStatsSession, "CREATE TABLE " + tableName + (partitioned ? " WITH (partitioned_by = ARRAY['p_varchar', 'p_bigint'])\n" : " ") + "AS SELECT c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, c_array, p_varchar, p_bigint FROM (   VALUES     (null, null, null, null, null, null, null, 'p1', BIGINT '7'),     (null, null, null, null, null, null, null, 'p1', BIGINT '7'),     (true, BIGINT '1', DOUBLE '2.2', TIMESTAMP '2012-08-08 01:00', 'abc1', X'bcd1', sequence(0, 10), 'p1', BIGINT '7'),     (false, BIGINT '0', DOUBLE '1.2', TIMESTAMP '2012-08-08 00:00', 'abc2', X'bcd2', sequence(10, 20), 'p1', BIGINT '7'),     (null, null, null, null, null, null, null, 'p2', BIGINT '7'),     (null, null, null, null, null, null, null, 'p2', BIGINT '7'),     (true, BIGINT '2', DOUBLE '3.3', TIMESTAMP '2012-09-09 01:00', 'cba1', X'dcb1', sequence(20, 25), 'p2', BIGINT '7'),     (false, BIGINT '1', DOUBLE '2.3', TIMESTAMP '2012-09-09 00:00', 'cba2', X'dcb2', sequence(30, 35), 'p2', BIGINT '7'),     (null, null, null, null, null, null, null, 'p3', BIGINT '8'),     (null, null, null, null, null, null, null, 'p3', BIGINT '8'),     (true, BIGINT '3', DOUBLE '4.4', TIMESTAMP '2012-10-10 01:00', 'bca1', X'cdb1', sequence(40, 45), 'p3', BIGINT '8'),     (false, BIGINT '2', DOUBLE '3.4', TIMESTAMP '2012-10-10 00:00', 'bca2', X'cdb2', sequence(50, 55), 'p3', BIGINT '8'),     (false, BIGINT '7', DOUBLE '7.7', TIMESTAMP '1977-07-07 07:07', 'efa1', X'efa1', sequence(60, 65), NULL, NULL),     (false, BIGINT '6', DOUBLE '6.7', TIMESTAMP '1977-07-07 07:06', 'efa2', X'efa2', sequence(70, 75), NULL, NULL),     (false, BIGINT '5', DOUBLE '5.7', TIMESTAMP '1977-07-07 07:05', 'efa3', X'efa3', sequence(80, 85), NULL, NULL),     (false, BIGINT '4', DOUBLE '4.7', TIMESTAMP '1977-07-07 07:04', 'efa4', X'efa4', sequence(90, 95), NULL, NULL) ) AS x (c_boolean, c_bigint, c_double, c_timestamp, c_varchar, c_varbinary, c_array, p_varchar, p_bigint)", 16L);
        if (partitioned) {
            this.assertUpdate(disableColumnStatsSession, String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['p_varchar', 'p_bigint'], ARRAY['%s', '%s'])", "tpch", tableName, "e1", "9"));
            this.assertUpdate(disableColumnStatsSession, String.format("CALL system.create_empty_partition('%s', '%s', ARRAY['p_varchar', 'p_bigint'], ARRAY['%s', '%s'])", "tpch", tableName, "e2", "9"));
        }
    }

    @Test
    public void testInsertMultipleColumnsFromSameChannel() {
        String tableName = "test_insert_multiple_columns_same_channel";
        this.assertUpdate(String.format("CREATE TABLE %s (    c_bigint_1 BIGINT,    c_bigint_2 BIGINT,    p_varchar_1 VARCHAR,    p_varchar_2 VARCHAR ) WITH (    partitioned_by = ARRAY['p_varchar_1', 'p_varchar_2'] )", tableName));
        this.assertUpdate(String.format("INSERT INTO %s SELECT 1 c_bigint_1, 1 c_bigint_2, '2' p_varchar_1, '2' p_varchar_2 ", tableName), 1L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar_1 = '2' AND p_varchar_2 = '2')", tableName), "SELECT * FROM VALUES ('c_bigint_1', null, 1.0E0, 0.0E0, null, '1', '1'), ('c_bigint_2', null, 1.0E0, 0.0E0, null, '1', '1'), ('p_varchar_1', 1.0E0, 1.0E0, 0.0E0, null, null, null), ('p_varchar_2', 1.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 1.0E0, null, null)");
        this.assertUpdate(String.format("INSERT INTO %s (c_bigint_1, c_bigint_2, p_varchar_1, p_varchar_2) SELECT orderkey, orderkey, orderstatus, orderstatus FROM orders WHERE orderstatus='O' AND orderkey = 15008", tableName), 1L);
        this.assertQuery(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE p_varchar_1 = 'O' AND p_varchar_2 = 'O')", tableName), "SELECT * FROM VALUES ('c_bigint_1', null, 1.0E0, 0.0E0, null, '15008', '15008'), ('c_bigint_2', null, 1.0E0, 0.0E0, null, '15008', '15008'), ('p_varchar_1', 1.0E0, 1.0E0, 0.0E0, null, null, null), ('p_varchar_2', 1.0E0, 1.0E0, 0.0E0, null, null, null), (null, null, null, null, 1.0E0, null, null)");
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAvroTableWithSchemaUrl() throws Exception {
        String tableName = "test_create_avro_table_with_schema_url";
        File schemaFile = TestHiveIntegrationSmokeTest.createAvroSchemaFile();
        String createTableSql = this.getAvroCreateTableSql(tableName, schemaFile.getAbsolutePath());
        String expectedShowCreateTable = this.getAvroCreateTableSql(tableName, schemaFile.toURI().toString());
        this.assertUpdate(createTableSql);
        try {
            MaterializedResult actual = this.computeActual(String.format("SHOW CREATE TABLE %s", tableName));
            Assert.assertEquals((Object)actual.getOnlyValue(), (Object)expectedShowCreateTable);
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE %s", tableName));
            Verify.verify((boolean)schemaFile.delete(), (String)"cannot delete temporary file: %s", (Object)schemaFile);
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
        Verify.verify((boolean)schemaFile.delete(), (String)"cannot delete temporary file: %s", (Object)schemaFile);
    }

    @Test
    public void testAlterAvroTableWithSchemaUrl() throws Exception {
        this.testAlterAvroTableWithSchemaUrl(true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testAlterAvroTableWithSchemaUrl(boolean renameColumn, boolean addColumn, boolean dropColumn) throws Exception {
        String tableName = "test_alter_avro_table_with_schema_url";
        File schemaFile = TestHiveIntegrationSmokeTest.createAvroSchemaFile();
        this.assertUpdate(this.getAvroCreateTableSql(tableName, schemaFile.getAbsolutePath()));
        try {
            if (renameColumn) {
                this.assertQueryFails(String.format("ALTER TABLE %s RENAME COLUMN dummy_col TO new_dummy_col", tableName), "ALTER TABLE not supported when Avro schema url is set");
            }
            if (addColumn) {
                this.assertQueryFails(String.format("ALTER TABLE %s ADD COLUMN new_dummy_col VARCHAR", tableName), "ALTER TABLE not supported when Avro schema url is set");
            }
            if (dropColumn) {
                this.assertQueryFails(String.format("ALTER TABLE %s DROP COLUMN dummy_col", tableName), "ALTER TABLE not supported when Avro schema url is set");
            }
        }
        catch (Throwable throwable) {
            this.assertUpdate(String.format("DROP TABLE %s", tableName));
            Verify.verify((boolean)schemaFile.delete(), (String)"cannot delete temporary file: %s", (Object)schemaFile);
            throw throwable;
        }
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
        Verify.verify((boolean)schemaFile.delete(), (String)"cannot delete temporary file: %s", (Object)schemaFile);
    }

    private String getAvroCreateTableSql(String tableName, String schemaFile) {
        return String.format("CREATE TABLE %s.%s.%s (%n   \"dummy_col\" varchar,%n   \"another_dummy_col\" varchar%n)%nWITH (%n   avro_schema_url = '%s',%n   format = 'AVRO'%n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get(), tableName, schemaFile);
    }

    private static File createAvroSchemaFile() throws Exception {
        File schemaFile = File.createTempFile("avro_single_column-", ".avsc");
        String schema = "{\n  \"namespace\": \"com.facebook.test\",\n  \"name\": \"single_column\",\n  \"type\": \"record\",\n  \"fields\": [\n    { \"name\":\"string_col\", \"type\":\"string\" }\n]}";
        Files.asCharSink((File)schemaFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)schema);
        return schemaFile;
    }

    @Test
    public void testCreateOrcTableWithSchemaUrl() throws Exception {
        String createTableSql = String.format("CREATE TABLE %s.%s.test_orc (\n   dummy_col varchar\n)\nWITH (\n   avro_schema_url = 'dummy.avsc',\n   format = 'ORC'\n)", this.getSession().getCatalog().get(), this.getSession().getSchema().get());
        this.assertQueryFails(createTableSql, "Cannot specify avro_schema_url table property for storage format: ORC");
    }

    @Test
    public void testCtasFailsWithAvroSchemaUrl() throws Exception {
        String ctasSqlWithoutData = "CREATE TABLE create_avro\nWITH (avro_schema_url = 'dummy_schema')\nAS SELECT 'dummy_value' as dummy_col WITH NO DATA";
        this.assertQueryFails(ctasSqlWithoutData, "CREATE TABLE AS not supported when Avro schema url is set");
        String ctasSql = "CREATE TABLE create_avro\nWITH (avro_schema_url = 'dummy_schema')\nAS SELECT * FROM (VALUES('a')) t (a)";
        this.assertQueryFails(ctasSql, "CREATE TABLE AS not supported when Avro schema url is set");
    }

    @Test
    public void testBucketedTablesFailWithTooManyBuckets() throws Exception {
        String createSql = "CREATE TABLE t (dummy VARCHAR)\nWITH (bucket_count = 1000001, bucketed_by=ARRAY['dummy'])";
        this.assertQueryFails(createSql, "bucket_count should be no more than 1000000");
    }

    @Test
    public void testBucketedTablesFailWithAvroSchemaUrl() throws Exception {
        String createSql = "CREATE TABLE create_avro (dummy VARCHAR)\nWITH (avro_schema_url = 'dummy_schema',\n      bucket_count = 2, bucketed_by=ARRAY['dummy'])";
        this.assertQueryFails(createSql, "Bucketing/Partitioning columns not supported when Avro schema url is set");
    }

    @Test
    public void testPartitionedTablesFailWithAvroSchemaUrl() throws Exception {
        String createSql = "CREATE TABLE create_avro (dummy VARCHAR)\nWITH (avro_schema_url = 'dummy_schema',\n      partitioned_by=ARRAY['dummy'])";
        this.assertQueryFails(createSql, "Bucketing/Partitioning columns not supported when Avro schema url is set");
    }

    @Test
    public void testPrunePartitionFailure() {
        this.assertUpdate("CREATE TABLE test_prune_failure\nWITH (partitioned_by = ARRAY['p']) AS\nSELECT 123 x, 'abc' p", 1L);
        this.assertQueryReturnsEmptyResult("SELECT * FROM test_prune_failure\nWHERE x < 0 AND cast(p AS int) > 0");
        this.assertQueryFails("SELECT * FROM test_prune_failure\nWHERE x > 0 AND cast(p AS int) > 0", "Cannot cast 'abc' to INT");
        this.assertUpdate("DROP TABLE test_prune_failure");
    }

    @Test
    public void testTemporaryStagingDirectorySessionProperties() {
        String tableName = "test_temporary_staging_directory_session_properties";
        this.assertUpdate(String.format("CREATE TABLE %s(i int)", tableName));
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "temporary_staging_directory_enabled", "false").build();
        HiveInsertTableHandle hiveInsertTableHandle = this.getHiveInsertTableHandle(session, tableName);
        Assert.assertEquals((Object)hiveInsertTableHandle.getLocationHandle().getWritePath(), (Object)hiveInsertTableHandle.getLocationHandle().getTargetPath());
        session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "temporary_staging_directory_enabled", "true").setCatalogSessionProperty(this.catalog, "temporary_staging_directory_path", "/tmp/custom/temporary-${USER}").build();
        hiveInsertTableHandle = this.getHiveInsertTableHandle(session, tableName);
        org.testng.Assert.assertNotEquals((Object)hiveInsertTableHandle.getLocationHandle().getWritePath(), (Object)hiveInsertTableHandle.getLocationHandle().getTargetPath());
        org.testng.Assert.assertTrue((boolean)hiveInsertTableHandle.getLocationHandle().getWritePath().toString().startsWith("file:/tmp/custom/temporary-"));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testLikeSerializesWithPushdownFilter() {
        Session pushdownFilterEnabled = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty(this.catalog, "pushdown_filter_enabled", "true").build();
        this.assertQuerySucceeds(pushdownFilterEnabled, "SELECT comment FROM lineitem WHERE comment LIKE 'abc%'");
    }

    @Test
    public void testGroupByWithUnion() {
        this.assertQuery("SELECT\n      linenumber,\n      'xxx'\n  FROM\n  (\n      (SELECT orderkey, linenumber FROM lineitem)\n      UNION\n      (SELECT orderkey, linenumber FROM lineitem)\n  ) WHERE orderkey = 1 \n  GROUP BY\n      linenumber");
    }

    @Test
    public void testIgnoreTableBucketing() {
        String query = "SELECT count(*) FROM orders WHERE \"$bucket\" = 1";
        this.assertQuery(this.bucketedSession, query, "SELECT 1350");
        Session ignoreBucketingSession = Session.builder((Session)this.bucketedSession).setCatalogSessionProperty((String)this.bucketedSession.getCatalog().get(), "ignore_table_bucketing", "true").build();
        this.assertQueryFails(ignoreBucketingSession, query, "Table bucketing is ignored\\. The virtual \"\\$bucket\" column cannot be referenced\\.");
    }

    @Test
    public void testTableWriterMergeNodeIsPresent() {
        this.assertUpdate(this.getSession(), "CREATE TABLE test_table_writer_merge_operator AS SELECT orderkey FROM orders", 15000L, TestHiveIntegrationSmokeTest.assertTableWriterMergeNodeIsPresent());
    }

    @Test
    public void testPropertiesTable() {
        String createTable = "CREATE TABLE test_show_properties WITH (format = 'orc', partitioned_by = ARRAY['ship_priority', 'order_status'],orc_bloom_filter_columns = ARRAY['ship_priority', 'order_status'],orc_bloom_filter_fpp = 0.5) AS SELECT orderkey AS order_key, shippriority AS ship_priority, orderstatus AS order_status FROM tpch.tiny.orders";
        this.assertUpdate(createTable, "SELECT count(*) FROM orders");
        String queryId = (String)this.computeScalar("SELECT query_id FROM system.runtime.queries WHERE query LIKE 'CREATE TABLE test_show_properties%'");
        String nodeVersion = (String)this.computeScalar("SELECT node_version FROM system.runtime.nodes WHERE coordinator");
        this.assertQuery("SELECT * FROM \"test_show_properties$properties\"", "SELECT 'ship_priority,order_status','0.5','" + queryId + "','" + nodeVersion + "'");
        this.assertUpdate("DROP TABLE test_show_properties");
    }

    @Test
    public void testPageFileFormatSmallStripe() {
        Session smallStripeSession = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty(this.catalog, "pagefile_writer_max_stripe_size", "1B").build();
        this.assertUpdate(smallStripeSession, "CREATE TABLE test_pagefile_small_stripe\nWITH (\nformat = 'PAGEFILE'\n) AS\nSELECT\n*\nFROM tpch.orders", "SELECT count(*) FROM orders");
        this.assertQuery("SELECT count(*) FROM test_pagefile_small_stripe", "SELECT count(*) FROM orders");
        this.assertQuery("SELECT sum(custkey) FROM test_pagefile_small_stripe", "SELECT sum(custkey) FROM orders");
        this.assertUpdate("DROP TABLE test_pagefile_small_stripe");
    }

    @Test
    public void testPageFileFormatSmallSplitSize() {
        Session testSession = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty(this.catalog, "pagefile_writer_max_stripe_size", "100B").setCatalogSessionProperty(this.catalog, "max_split_size", "1kB").setCatalogSessionProperty(this.catalog, "max_initial_split_size", "1kB").build();
        this.assertUpdate(testSession, "CREATE TABLE test_pagefile_small_split\nWITH (\nformat = 'PAGEFILE'\n) AS\nSELECT\n*\nFROM tpch.orders", "SELECT count(*) FROM orders");
        this.assertQuery(testSession, "SELECT count(*) FROM test_pagefile_small_split", "SELECT count(*) FROM orders");
        this.assertQuery(testSession, "SELECT sum(custkey) FROM test_pagefile_small_split", "SELECT sum(custkey) FROM orders");
        this.assertUpdate("DROP TABLE test_pagefile_small_split");
    }

    @Test
    public void testPageFileCompression() {
        for (HiveCompressionCodec compression : HiveCompressionCodec.values()) {
            if (!compression.isSupportedStorageFormat(HiveStorageFormat.PAGEFILE)) continue;
            this.testPageFileCompression(compression.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartialAggregatePushdownORC() {
        String createTable = "CREATE TABLE test_orc_table ( _boolean BOOLEAN, _tinyint TINYINT, _smallint SMALLINT, _integer INTEGER, _bigint BIGINT, _real REAL, _double DOUBLE, _shortdecimal DECIMAL(8,3), _longdecimal DECIMAL(25,2), _string VARCHAR, _varchar VARCHAR(10), _singlechar CHAR, _char CHAR(10), _varbinary VARBINARY, _date DATE, _timestamp TIMESTAMP)WITH (format = 'orc')";
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "partial_aggregation_pushdown_enabled", "true").setCatalogSessionProperty(this.catalog, "partial_aggregation_pushdown_for_variable_length_datatypes_enabled", "true").build();
        try {
            this.assertUpdate(session, createTable);
            TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_orc_table");
            Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)HiveStorageFormat.ORC);
            this.assertUpdate(session, "INSERT INTO test_orc_table VALUES (true, cast(1 as tinyint), cast(2 as smallint), 3, 4, 1.2, 2.3, 4.5, 55555555555555.32, 'abc', 'def', 'g', 'hij', cast('klm' as varbinary), cast('2020-05-01' as date), cast('2020-06-04 16:55:40.777' as timestamp))", 1L);
            this.assertUpdate(session, "INSERT INTO test_orc_table VALUES (false, cast(10 as tinyint), cast(20 as smallint), 30, 40, 10.25, 25.334, 465.523, 88888888555555.91, 'foo', 'bar', 'b', 'baz', cast('qux' as varbinary), cast('2020-06-02' as date), cast('2020-05-01 18:34:23.88' as timestamp))", 1L);
            String rowCount = "SELECT 2";
            this.assertQuery(session, "SELECT COUNT(*) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_boolean) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_tinyint) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_smallint) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_integer) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_bigint) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_real) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_double) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_shortdecimal) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_longdecimal) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_string) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_varchar) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_singlechar) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_char) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_varbinary) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_date) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_timestamp) FROM test_orc_table", rowCount);
            this.assertQuery(session, "SELECT MIN(_boolean), MAX(_boolean) FROM test_orc_table", "select false, true");
            this.assertQuery(session, "SELECT MIN(_tinyint), MAX(_tinyint) FROM test_orc_table", "select 1, 10");
            this.assertQuery(session, "SELECT MIN(_smallint), MAX(_smallint) FROM test_orc_table", "select 2, 20");
            this.assertQuery(session, "SELECT MIN(_integer), MAX(_integer) FROM test_orc_table", "select 3, 30");
            this.assertQuery(session, "SELECT MIN(_bigint), MAX(_bigint) FROM test_orc_table", "select 4, 40");
            this.assertQuery(session, "SELECT MIN(_real), MAX(_real) FROM test_orc_table", "select 1.2, 10.25");
            this.assertQuery(session, "SELECT MIN(_double), MAX(_double) FROM test_orc_table", "select 2.3, 25.334");
            this.assertQuery(session, "SELECT MIN(_shortdecimal), MAX(_shortdecimal) FROM test_orc_table", "select 4.5, 465.523");
            this.assertQuery(session, "SELECT MIN(_longdecimal), MAX(_longdecimal) FROM test_orc_table", "select 55555555555555.32, 88888888555555.91");
            this.assertQuery(session, "SELECT MIN(_string), MAX(_string) FROM test_orc_table", "select 'abc', 'foo'");
            this.assertQuery(session, "SELECT MIN(_varchar), MAX(_varchar) FROM test_orc_table", "select 'bar', 'def'");
            this.assertQuery(session, "SELECT MIN(_singlechar), MAX(_singlechar) FROM test_orc_table", "select 'b', 'g'");
            this.assertQuery(session, "SELECT MIN(_char), MAX(_char) FROM test_orc_table", "select 'baz', 'hij'");
            this.assertQuery(session, "SELECT MIN(_varbinary), MAX(_varbinary) FROM test_orc_table", "select X'6b6c6d', X'717578'");
            this.assertQuery(session, "SELECT MIN(_date), MAX(_date) FROM test_orc_table", "select cast('2020-05-01' as date), cast('2020-06-02' as date)");
            this.assertQuery(session, "SELECT MIN(_timestamp), MAX(_timestamp) FROM test_orc_table", "select cast('2020-05-01 18:34:23.88' as timestamp), cast('2020-06-04 16:55:40.777' as timestamp)");
        }
        finally {
            this.assertUpdate(session, "DROP TABLE test_orc_table");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_orc_table"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartialAggregatePushdownParquet() {
        String createTable = "CREATE TABLE test_parquet_table ( _boolean BOOLEAN, _tinyint TINYINT, _smallint SMALLINT, _integer INTEGER, _bigint BIGINT, _real REAL, _double DOUBLE, _shortdecimal DECIMAL(8,3), _longdecimal DECIMAL(25,2), _string VARCHAR, _varchar VARCHAR(10), _singlechar CHAR, _char CHAR(10), _varbinary VARBINARY, _date DATE, _timestamp TIMESTAMP)WITH (format = 'parquet')";
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(this.catalog, "partial_aggregation_pushdown_enabled", "true").setCatalogSessionProperty(this.catalog, "partial_aggregation_pushdown_for_variable_length_datatypes_enabled", "true").build();
        try {
            this.assertUpdate(session, createTable);
            TableMetadata tableMetadata = this.getTableMetadata(this.catalog, "tpch", "test_parquet_table");
            Assert.assertEquals(tableMetadata.getMetadata().getProperties().get("format"), (Object)HiveStorageFormat.PARQUET);
            this.assertUpdate(session, "INSERT INTO test_parquet_table VALUES (true, cast(1 as tinyint), cast(2 as smallint), 3, 4, 1.2, 2.3, 4.5, 55555555555555.32, 'abc', 'def', 'g', 'hij', cast('klm' as varbinary), cast('2020-05-01' as date), cast('2020-06-04 16:55:40.777' as timestamp))", 1L);
            this.assertUpdate(session, "INSERT INTO test_parquet_table VALUES (false, cast(10 as tinyint), cast(20 as smallint), 30, 40, 10.25, 25.334, 465.523, 88888888555555.91, 'foo', 'bar', 'b', 'baz', cast('qux' as varbinary), cast('2020-06-02' as date), cast('2020-05-01 18:34:23.88' as timestamp))", 1L);
            String rowCount = "SELECT 2";
            this.assertQuery(session, "SELECT COUNT(*) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_boolean) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_tinyint) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_smallint) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_integer) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_bigint) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_real) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_double) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_shortdecimal) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_longdecimal) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_string) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_varchar) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_singlechar) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_char) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_varbinary) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_date) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT COUNT(_timestamp) FROM test_parquet_table", rowCount);
            this.assertQuery(session, "SELECT MIN(_boolean), MAX(_boolean) FROM test_parquet_table", "select false, true");
            this.assertQuery(session, "SELECT MIN(_tinyint), MAX(_tinyint) FROM test_parquet_table", "select 1, 10");
            this.assertQuery(session, "SELECT MIN(_smallint), MAX(_smallint) FROM test_parquet_table", "select 2, 20");
            this.assertQuery(session, "SELECT MIN(_integer), MAX(_integer) FROM test_parquet_table", "select 3, 30");
            this.assertQuery(session, "SELECT MIN(_bigint), MAX(_bigint) FROM test_parquet_table", "select 4, 40");
            this.assertQuery(session, "SELECT MIN(_real), MAX(_real) FROM test_parquet_table", "select 1.2, 10.25");
            this.assertQuery(session, "SELECT MIN(_double), MAX(_double) FROM test_parquet_table", "select 2.3, 25.334");
            this.assertQuery(session, "SELECT MIN(_shortdecimal), MAX(_shortdecimal) FROM test_parquet_table", "select 4.5, 465.523");
            this.assertQuery(session, "SELECT MIN(_longdecimal), MAX(_longdecimal) FROM test_parquet_table", "select 55555555555555.32, 88888888555555.91");
            this.assertQuery(session, "SELECT MIN(_string), MAX(_string) FROM test_parquet_table", "select 'abc', 'foo'");
            this.assertQuery(session, "SELECT MIN(_varchar), MAX(_varchar) FROM test_parquet_table", "select 'bar', 'def'");
            this.assertQuery(session, "SELECT MIN(_singlechar), MAX(_singlechar) FROM test_parquet_table", "select 'b', 'g'");
            this.assertQuery(session, "SELECT MIN(_char), MAX(_char) FROM test_parquet_table", "select 'baz', 'hij'");
            this.assertQuery(session, "SELECT MIN(_varbinary), MAX(_varbinary) FROM test_parquet_table", "select X'6b6c6d', X'717578'");
            this.assertQuery(session, "SELECT MIN(_date), MAX(_date) FROM test_parquet_table", "select cast('2020-05-01' as date), cast('2020-06-02' as date)");
            this.assertQuery(session, "SELECT MIN(_timestamp), MAX(_timestamp) FROM test_parquet_table", "select cast('2020-05-01 18:34:23.88' as timestamp), cast('2020-06-04 16:55:40.777' as timestamp)");
        }
        finally {
            this.assertUpdate(session, "DROP TABLE test_parquet_table");
        }
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(session, "test_parquet_table"));
    }

    @Test
    public void testParquetSelectivePageSourceFails() {
        this.assertUpdate("CREATE TABLE test_parquet_filter_pushdoown (a BIGINT, b BOOLEAN) WITH (format = 'parquet')");
        this.assertUpdate(this.getSession(), "INSERT INTO test_parquet_filter_pushdoown VALUES (1, true)", 1L);
        Session noPushdownSession = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "pushdown_filter_enabled", "false").setCatalogSessionProperty("hive", "parquet_pushdown_filter_enabled", "false").build();
        this.assertQuery(noPushdownSession, "SELECT a FROM test_parquet_filter_pushdoown", "select 1");
        this.assertQuery(noPushdownSession, "SELECT a FROM test_parquet_filter_pushdoown WHERE b = true", "select 1");
        this.assertQueryReturnsEmptyResult(noPushdownSession, "SELECT a FROM test_parquet_filter_pushdoown WHERE b = false");
        Session filterPushdownSession = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").setCatalogSessionProperty("hive", "parquet_pushdown_filter_enabled", "false").build();
        this.assertQuery(filterPushdownSession, "SELECT a FROM test_parquet_filter_pushdoown", "select 1");
        this.assertQuery(filterPushdownSession, "SELECT a FROM test_parquet_filter_pushdoown WHERE b = true", "select 1");
        this.assertQueryReturnsEmptyResult(filterPushdownSession, "SELECT a FROM test_parquet_filter_pushdoown WHERE b = false");
        Session parquetFilterPushdownSession = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "pushdown_filter_enabled", "true").setCatalogSessionProperty("hive", "parquet_pushdown_filter_enabled", "true").build();
        this.assertQueryFails(parquetFilterPushdownSession, "SELECT a FROM test_parquet_filter_pushdoown", "Parquet reader doesn't support filter pushdown yet");
        this.assertQueryFails(parquetFilterPushdownSession, "SELECT a FROM test_parquet_filter_pushdoown WHERE b = true", "Parquet reader doesn't support filter pushdown yet");
        this.assertQueryFails(parquetFilterPushdownSession, "SELECT a FROM test_parquet_filter_pushdoown WHERE b = false", "Parquet reader doesn't support filter pushdown yet");
    }

    private void testPageFileCompression(String compression) {
        Session testSession = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty(this.catalog, "compression_codec", compression).setCatalogSessionProperty(this.catalog, "pagefile_writer_max_stripe_size", "100B").setCatalogSessionProperty(this.catalog, "max_split_size", "1kB").setCatalogSessionProperty(this.catalog, "max_initial_split_size", "1kB").build();
        this.assertUpdate(testSession, "CREATE TABLE test_pagefile_compression\nWITH (\nformat = 'PAGEFILE'\n) AS\nSELECT\n*\nFROM tpch.orders", "SELECT count(*) FROM orders");
        this.assertQuery(testSession, "SELECT count(*) FROM test_pagefile_compression", "SELECT count(*) FROM orders");
        this.assertQuery(testSession, "SELECT sum(custkey) FROM test_pagefile_compression", "SELECT sum(custkey) FROM orders");
        this.assertUpdate("DROP TABLE test_pagefile_compression");
    }

    private static Consumer<Plan> assertTableWriterMergeNodeIsPresent() {
        return plan -> org.testng.Assert.assertTrue((boolean)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof TableWriterMergeNode).findFirst().isPresent());
    }

    private HiveInsertTableHandle getHiveInsertTableHandle(Session session, String tableName) {
        Metadata metadata = ((DistributedQueryRunner)this.getQueryRunner()).getCoordinator().getMetadata();
        return (HiveInsertTableHandle)TransactionBuilder.transaction((TransactionManager)this.getQueryRunner().getTransactionManager(), (AccessControl)this.getQueryRunner().getAccessControl()).execute(session, transactionSession -> {
            QualifiedObjectName objectName = new QualifiedObjectName(this.catalog, "tpch", tableName);
            Optional handle = metadata.getMetadataResolver(transactionSession).getTableHandle(objectName);
            InsertTableHandle insertTableHandle = metadata.beginInsert(transactionSession, (TableHandle)handle.get());
            HiveInsertTableHandle hiveInsertTableHandle = (HiveInsertTableHandle)insertTableHandle.getConnectorHandle();
            metadata.finishInsert(transactionSession, insertTableHandle, (Collection)ImmutableList.of(), (Collection)ImmutableList.of());
            return hiveInsertTableHandle;
        });
    }

    @Test
    public void testUnsupportedCsvTable() {
        this.assertQueryFails("CREATE TABLE create_unsupported_csv(i INT, bound VARCHAR(10), unbound VARCHAR, dummy VARCHAR) WITH (format = 'CSV')", "\\QHive CSV storage format only supports VARCHAR (unbounded). Unsupported columns: i integer, bound varchar(10)\\E");
    }

    @Test
    public void testCreateMaterializedView() {
        this.computeActual("CREATE TABLE test_customer_base WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer LIMIT 10");
        this.computeActual("CREATE TABLE test_customer_base_copy WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer LIMIT 10");
        this.computeActual("CREATE TABLE test_orders_base WITH (partitioned_by = ARRAY['orderstatus']) AS SELECT orderkey, custkey, totalprice, orderstatus FROM orders LIMIT 10");
        this.assertUpdate("CREATE MATERIALIZED VIEW test_customer_view WITH (partitioned_by = ARRAY['nationkey']" + this.retentionDays(30) + ") AS SELECT name, nationkey FROM test_customer_base");
        org.testng.Assert.assertTrue((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_customer_view"));
        this.assertTableColumnNames("test_customer_view", new String[]{"name", "nationkey"});
        this.assertQueryFails("CREATE MATERIALIZED VIEW test_customer_view AS SELECT name FROM test_customer_base", String.format(".* Materialized view '%s.%s.test_customer_view' already exists", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.assertQuerySucceeds("CREATE MATERIALIZED VIEW IF NOT EXISTS test_customer_view AS SELECT name FROM test_customer_base");
        this.assertQueryFails("CREATE MATERIALIZED VIEW test_customer_view_no_partition " + this.withRetentionDays(30) + " AS SELECT name FROM test_customer_base", ".*Unpartitioned materialized view is not supported.");
        this.assertQueryFails("CREATE MATERIALIZED VIEW test_customer_view_no_direct_partition_mapped WITH (partitioned_by = ARRAY['nationkey']" + this.retentionDays(30) + ") AS SELECT name, CAST(nationkey AS BIGINT) AS nationkey FROM test_customer_base", String.format(".*Materialized view %s.test_customer_view_no_direct_partition_mapped must have at least one partition column that exists in.*", this.getSession().getSchema().get()));
        this.assertQueryFails("CREATE MATERIALIZED VIEW test_customer_nested_view WITH (partitioned_by = ARRAY['nationkey']" + this.retentionDays(30) + ") AS SELECT name, nationkey FROM test_customer_view", String.format(".*CreateMaterializedView on a materialized view %s.%s.test_customer_view is not supported.", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.assertUpdate("CREATE MATERIALIZED VIEW test_customer_agg_view WITH (partitioned_by = ARRAY['nationkey']" + this.retentionDays(30) + ") AS SELECT COUNT(DISTINCT name) AS num, nationkey FROM (SELECT name, nationkey FROM test_customer_base GROUP BY 1, 2) a GROUP BY nationkey");
        this.assertUpdate("CREATE MATERIALIZED VIEW test_customer_union_view WITH (partitioned_by = ARRAY['nationkey']" + this.retentionDays(30) + ") AS SELECT name, nationkey FROM ( SELECT name, nationkey FROM test_customer_base WHERE nationkey = 1 UNION ALL SELECT name, nationkey FROM test_customer_base_copy WHERE nationkey = 2)");
        this.assertUpdate("CREATE MATERIALIZED VIEW test_customer_order_join_view WITH (partitioned_by = ARRAY['orderstatus', 'nationkey']" + this.retentionDays(30) + ") AS SELECT orders.totalprice, orders.orderstatus, customer.nationkey FROM test_customer_base customer JOIN test_orders_base orders ON orders.custkey = customer.custkey");
        this.assertQueryFails("CREATE MATERIALIZED VIEW test_customer_order_join_view_no_base_partition_mapped WITH (partitioned_by = ARRAY['custkey']" + this.retentionDays(30) + ") AS SELECT orders.totalprice, customer.nationkey, customer.custkey FROM test_customer_base customer JOIN test_orders_base orders ON orders.custkey = customer.custkey", String.format(".*Materialized view %s.test_customer_order_join_view_no_base_partition_mapped must have at least one partition column that exists in.*", this.getSession().getSchema().get()));
        this.assertQueryFails("CREATE MATERIALIZED VIEW test_customer_order_join_view_no_base_partition_mapped WITH (partitioned_by = ARRAY['nation_order']" + this.retentionDays(30) + ") AS SELECT orders.totalprice, CONCAT(CAST(customer.nationkey AS VARCHAR), orders.orderstatus) AS nation_order FROM test_customer_base customer JOIN test_orders_base orders ON orders.custkey = customer.custkey", String.format(".*Materialized view %s.test_customer_order_join_view_no_base_partition_mapped must have at least one partition column that exists in.*", this.getSession().getSchema().get()));
        this.computeActual("DROP TABLE IF EXISTS test_customer_base");
        this.computeActual("DROP TABLE IF EXISTS test_orders_base");
    }

    @Test
    public void testShowCreateOnMaterializedView() {
        String createMaterializedViewSql = this.formatSqlText(String.format("CREATE MATERIALIZED VIEW %s.%s.test_customer_view_1%nWITH (%n   format = 'ORC',   partitioned_by = ARRAY['nationkey']%n" + this.retentionDays(15) + ") AS SELECT%n  name%n, nationkey%nFROM\n  test_customer_base_1", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.computeActual("CREATE TABLE test_customer_base_1 WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer LIMIT 10");
        this.computeActual(createMaterializedViewSql);
        MaterializedResult actualResult = this.computeActual("SHOW CREATE MATERIALIZED VIEW test_customer_view_1");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)actualResult.getOnlyColumnAsSet()), (Object)createMaterializedViewSql.trim());
        this.assertQueryFails("SHOW CREATE MATERIALIZED VIEW test_customer_base_1", String.format(".*Relation '%s.%s.test_customer_base_1' is a table, not a materialized view", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.assertQueryFails("SHOW CREATE VIEW test_customer_view_1", String.format(".*Relation '%s.%s.test_customer_view_1' is a materialized view, not a view", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.assertQueryFails("SHOW CREATE TABLE test_customer_view_1", String.format(".*Relation '%s.%s.test_customer_view_1' is a materialized view, not a table", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.computeActual("DROP TABLE IF EXISTS test_customer_base_1");
    }

    @Test
    public void testAlterOnMaterializedView() {
        this.computeActual("CREATE TABLE test_customer_base_2 WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer LIMIT 10");
        this.computeActual("CREATE MATERIALIZED VIEW test_customer_view_2 WITH (partitioned_by = ARRAY['nationkey']" + this.retentionDays(30) + ") AS SELECT name, nationkey FROM test_customer_base_2");
        this.assertQueryFails("ALTER TABLE test_customer_view_2 RENAME TO test_customer_view_new", String.format(".*'%s.%s.test_customer_view_2' is a materialized view, and rename is not supported", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.assertQueryFails("ALTER TABLE test_customer_view_2 ADD COLUMN timezone VARCHAR", String.format(".*'%s.%s.test_customer_view_2' is a materialized view, and add column is not supported", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.assertQueryFails("ALTER TABLE test_customer_view_2 DROP COLUMN address", String.format(".*'%s.%s.test_customer_view_2' is a materialized view, and drop column is not supported", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.assertQueryFails("ALTER TABLE test_customer_view_2 RENAME COLUMN name TO custname", String.format(".*'%s.%s.test_customer_view_2' is a materialized view, and rename column is not supported", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.computeActual("DROP TABLE IF EXISTS test_customer_base_2");
    }

    @Test
    public void testInsertDeleteOnMaterializedView() {
        this.computeActual("CREATE TABLE test_customer_base_3 WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer LIMIT 10");
        this.computeActual("CREATE MATERIALIZED VIEW test_customer_view_3 WITH (partitioned_by = ARRAY['nationkey']" + this.retentionDays(30) + ") AS SELECT name, nationkey FROM test_customer_base_3");
        this.assertQueryFails("INSERT INTO test_customer_view_3 SELECT name, nationkey FROM test_customer_base_2", ".*Inserting into materialized views is not supported");
        this.assertQueryFails("DELETE FROM test_customer_view_3", ".*Deleting from materialized views is not supported");
        this.computeActual("DROP TABLE IF EXISTS test_customer_base_3");
    }

    @Test
    public void testDropMaterializedView() {
        this.computeActual("CREATE TABLE test_customer_base_4 WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, address, nationkey FROM customer LIMIT 10");
        this.computeActual("CREATE MATERIALIZED VIEW test_customer_view_4 WITH (partitioned_by = ARRAY['nationkey']" + this.retentionDays(30) + ") AS SELECT name, nationkey FROM test_customer_base_4");
        this.assertQueryFails("DROP TABLE test_customer_view_4", String.format(".*'%s.%s.test_customer_view_4' is a materialized view, not a table. Use DROP MATERIALIZED VIEW to drop.", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.assertQueryFails("DROP VIEW test_customer_view_4", String.format(".*View '%s.%s.test_customer_view_4' does not exist", this.getSession().getCatalog().get(), this.getSession().getSchema().get()));
        this.assertUpdate("DROP MATERIALIZED VIEW test_customer_view_4");
        org.testng.Assert.assertFalse((boolean)this.getQueryRunner().tableExists(this.getSession(), "test_customer_view_4"));
        this.computeActual("DROP TABLE IF EXISTS test_customer_base_4");
    }

    @Test
    public void testRefreshMaterializedViewSimple() {
        Session session = this.getSession();
        QueryRunner queryRunner = this.getQueryRunner();
        this.computeActual("CREATE TABLE orders_partitioned WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, '2020-01-01' as ds FROM orders WHERE orderkey < 1000 UNION ALL SELECT orderkey, orderpriority, '2019-01-02' as ds FROM orders WHERE orderkey > 1000");
        this.computeActual("CREATE MATERIALIZED VIEW test_orders_view WITH (partitioned_by = ARRAY['ds']) AS SELECT orderkey, orderpriority, ds FROM orders_partitioned");
        String refreshSql = "REFRESH MATERIALIZED VIEW test_orders_view WHERE ds='2020-01-01'";
        String expectedInsertQuery = "SELECT orderkey, orderpriority, ds FROM (  SELECT * FROM orders_partitioned WHERE ds='2020-01-01') orders_partitioned";
        QueryAssertions.assertQuery((QueryRunner)queryRunner, (Session)session, (String)refreshSql, (ExpectedQueryRunner)queryRunner, (String)("SELECT COUNT(*) FROM ( " + expectedInsertQuery + " )"), (boolean)false, (boolean)true);
        ResultWithQueryId resultWithQueryId = ((DistributedQueryRunner)queryRunner).executeWithQueryId(session, refreshSql);
        QueryInfo queryInfo = ((DistributedQueryRunner)queryRunner).getQueryInfo(resultWithQueryId.getQueryId());
        Assert.assertEquals((String)((String)queryInfo.getExpandedQuery().get()), (String)"-- Expanded Query: REFRESH MATERIALIZED VIEW test_orders_view WHERE (ds = '2020-01-01')\nINSERT INTO test_orders_view SELECT\n  orderkey\n, orderpriority\n, ds\nFROM\n  orders_partitioned\n");
        this.computeActual("DROP TABLE orders_partitioned");
        this.computeActual("DROP MATERIALIZED VIEW test_orders_view");
    }

    @Test
    public void testRefreshMaterializedView() {
        Session session = this.getSession();
        QueryRunner queryRunner = this.getQueryRunner();
        this.computeActual("CREATE TABLE test_nation_base_5 WITH (partitioned_by = ARRAY['nationkey', 'regionkey']) AS SELECT name, nationkey, regionkey FROM nation");
        this.computeActual("CREATE TABLE test_customer_base_5 WITH (partitioned_by = ARRAY['nationkey']) AS SELECT custkey, name, mktsegment, nationkey FROM customer");
        this.computeActual("CREATE MATERIALIZED VIEW test_customer_view_5 WITH (partitioned_by = ARRAY['marketsegment', 'nationkey', 'regionkey']" + this.retentionDays(30) + ") AS SELECT test_nation_base_5.name AS nationname, customer.custkey, customer.name AS customername, UPPER(customer.mktsegment) AS marketsegment, customer.nationkey, regionkey FROM test_nation_base_5 JOIN test_customer_base_5 customer ON (test_nation_base_5.nationkey = customer.nationkey)");
        String refreshSql = "REFRESH MATERIALIZED VIEW test_customer_view_5 WHERE marketsegment = 'AUTOMOBILE' AND nationkey = 24 AND regionkey = 1";
        String expectedInsertQuery = "SELECT *FROM (  SELECT nation.name AS nationname, customer.custkey, customer.name AS customername, UPPER(customer.mktsegment) AS marketsegment, customer.nationkey, regionkey   FROM (    SELECT * FROM test_nation_base_5 WHERE regionkey = 1  ) nation JOIN (    SELECT * FROM test_customer_base_5 WHERE nationkey = 24  ) customer ON (nation.nationkey = customer.nationkey)) WHERE marketsegment = 'AUTOMOBILE'";
        QueryAssertions.assertQuery((QueryRunner)queryRunner, (Session)session, (String)refreshSql, (ExpectedQueryRunner)queryRunner, (String)("SELECT COUNT(*) FROM ( " + expectedInsertQuery + " )"), (boolean)false, (boolean)true);
        refreshSql = "REFRESH MATERIALIZED VIEW test_customer_view_5 WHERE marketsegment = 'AUTOMOBILE' AND nationkey = 24";
        expectedInsertQuery = "SELECT *FROM (  SELECT nation.name AS nationname, customer.custkey, customer.name AS customername, UPPER(customer.mktsegment) AS marketsegment, customer.nationkey, regionkey   FROM test_nation_base_5 nation JOIN (    SELECT * FROM test_customer_base_5 WHERE nationkey = 24  ) customer ON (nation.nationkey = customer.nationkey)) WHERE marketsegment = 'AUTOMOBILE'";
        QueryAssertions.assertQuery((QueryRunner)queryRunner, (Session)session, (String)refreshSql, (ExpectedQueryRunner)queryRunner, (String)("SELECT COUNT(*) FROM ( " + expectedInsertQuery + " )"), (boolean)false, (boolean)true);
        refreshSql = "REFRESH MATERIALIZED VIEW test_customer_view_5 WHERE regionkey = 1";
        expectedInsertQuery = "SELECT nation.name AS nationname, customer.custkey, customer.name AS customername, UPPER(customer.mktsegment) AS marketsegment, customer.nationkey, regionkey FROM (  SELECT * FROM test_nation_base_5 WHERE regionkey = 1) nation JOIN test_customer_base_5 customer ON (nation.nationkey = customer.nationkey)";
        QueryAssertions.assertQuery((QueryRunner)queryRunner, (Session)session, (String)refreshSql, (ExpectedQueryRunner)queryRunner, (String)("SELECT COUNT(*) FROM ( " + expectedInsertQuery + " )"), (boolean)false, (boolean)true);
        this.assertQueryFails("REFRESH MATERIALIZED VIEW test_customer_view_5 WHERE nationname = 'UNITED STATES'", ".*Refresh materialized view by column nationname is not supported.*");
        this.assertQueryFails("REFRESH MATERIALIZED VIEW test_customer_view_5 WHERE regionkey = 1 OR nationkey = 24", ".*Only logical AND is supported in WHERE clause.*");
        this.assertQueryFails("REFRESH MATERIALIZED VIEW test_customer_view_5 WHERE regionkey + nationkey = 25", ".*Only columns specified on literals are supported in WHERE clause.*");
        this.assertQueryFails("REFRESH MATERIALIZED VIEW test_customer_view_5", ".*mismatched input '<EOF>'\\. Expecting: '\\.', 'WHERE'.*");
    }

    @Test
    public void testAlphaFormatDdl() {
        this.assertUpdate("CREATE TABLE test_alpha_ddl_table (col1 bigint) WITH (format = 'ALPHA')");
        this.assertUpdate("ALTER TABLE test_alpha_ddl_table ADD COLUMN col2 bigint");
        this.assertUpdate("ALTER TABLE test_alpha_ddl_table DROP COLUMN col2");
        this.assertUpdate("DROP TABLE test_alpha_ddl_table");
        this.assertUpdate("CREATE TABLE test_alpha_ddl_partitioned_table (col1 bigint, ds VARCHAR) WITH (format = 'ALPHA', partitioned_by = ARRAY['ds'])");
        this.assertUpdate("ALTER TABLE test_alpha_ddl_partitioned_table ADD COLUMN col2 bigint");
        this.assertUpdate("ALTER TABLE test_alpha_ddl_partitioned_table DROP COLUMN col2");
        this.assertUpdate("DROP TABLE test_alpha_ddl_partitioned_table");
    }

    @Test
    public void testAlphaFormatDml() {
        this.assertUpdate("CREATE TABLE test_alpha_dml_partitioned_table (col1 bigint, ds VARCHAR) WITH (format = 'ALPHA', partitioned_by = ARRAY['ds'])");
        this.assertQueryFails("INSERT INTO test_alpha_dml_partitioned_table VALUES (1, '2022-01-01')", "Serializer does not exist: com.facebook.alpha.AlphaSerde");
        this.assertUpdate("DROP TABLE test_alpha_dml_partitioned_table");
    }

    @Test
    public void testInvokedFunctionNamesLog() {
        QueryRunner queryRunner = this.getQueryRunner();
        Session logFunctionNamesEnabledSession = Session.builder((Session)this.getSession()).setSystemProperty("log_invoked_function_names_enabled", "true").build();
        String queryWithScalarFunctions = "SELECT abs(acctbal), round(acctbal), round(acctbal, 1), repeat(custkey, 2), repeat(name, 3),  repeat(mktsegment, 4) FROM customer";
        ResultWithQueryId resultWithQueryId = ((DistributedQueryRunner)queryRunner).executeWithQueryId(logFunctionNamesEnabledSession, queryWithScalarFunctions);
        QueryInfo queryInfo = ((DistributedQueryRunner)queryRunner).getQueryInfo(resultWithQueryId.getQueryId());
        org.testng.Assert.assertEqualsNoOrder((Collection)queryInfo.getScalarFunctions(), (Collection)ImmutableList.of((Object)"presto.default.abs", (Object)"presto.default.round", (Object)"presto.default.repeat"));
        String queryWithAggregateFunctions = "SELECT abs(nationkey), mktsegment, arbitrary(name), arbitrary(comment), approx_percentile(acctbal, 0.1), approx_percentile(acctbal, 0.3, 0.01) FROM customer GROUP BY nationkey, mktsegment";
        resultWithQueryId = ((DistributedQueryRunner)queryRunner).executeWithQueryId(logFunctionNamesEnabledSession, queryWithAggregateFunctions);
        queryInfo = ((DistributedQueryRunner)queryRunner).getQueryInfo(resultWithQueryId.getQueryId());
        org.testng.Assert.assertEqualsNoOrder((Collection)queryInfo.getScalarFunctions(), (Collection)ImmutableList.of((Object)"presto.default.abs"));
        org.testng.Assert.assertEqualsNoOrder((Collection)queryInfo.getAggregateFunctions(), (Collection)ImmutableList.of((Object)"presto.default.arbitrary", (Object)"presto.default.approx_percentile"));
        String queryWithWindowFunctions = "SELECT row_number() OVER(PARTITION BY mktsegment), nth_value(name, 5) OVER(PARTITION BY nationkey) FROM customer";
        resultWithQueryId = ((DistributedQueryRunner)queryRunner).executeWithQueryId(logFunctionNamesEnabledSession, queryWithWindowFunctions);
        queryInfo = ((DistributedQueryRunner)queryRunner).getQueryInfo(resultWithQueryId.getQueryId());
        org.testng.Assert.assertEqualsNoOrder((Collection)queryInfo.getWindowsFunctions(), (Collection)ImmutableList.of((Object)"presto.default.row_number", (Object)"presto.default.nth_value"));
        String queryWithNestedFunctions = "SELECT DISTINCT nationkey FROM customer WHERE mktsegment='BUILDING' AND contains(regexp_split( phone, '-' ), '11' )";
        resultWithQueryId = ((DistributedQueryRunner)queryRunner).executeWithQueryId(logFunctionNamesEnabledSession, queryWithNestedFunctions);
        queryInfo = ((DistributedQueryRunner)queryRunner).getQueryInfo(resultWithQueryId.getQueryId());
        org.testng.Assert.assertEqualsNoOrder((Collection)queryInfo.getScalarFunctions(), (Collection)ImmutableList.of((Object)"presto.default.contains", (Object)"presto.default.regexp_split"));
        String queryWithFunctionsInLambda = "SELECT transform(ARRAY[nationkey, custkey], x -> abs(x)) FROM customer";
        resultWithQueryId = ((DistributedQueryRunner)queryRunner).executeWithQueryId(logFunctionNamesEnabledSession, queryWithFunctionsInLambda);
        queryInfo = ((DistributedQueryRunner)queryRunner).getQueryInfo(resultWithQueryId.getQueryId());
        org.testng.Assert.assertEqualsNoOrder((Collection)queryInfo.getScalarFunctions(), (Collection)ImmutableList.of((Object)"presto.default.transform", (Object)"presto.default.abs"));
    }

    protected String retentionDays(int days) {
        return "";
    }

    protected String withRetentionDays(int days) {
        return "";
    }

    private Session getTableWriteTestingSession(boolean optimizedPartitionUpdateSerializationEnabled) {
        return Session.builder((Session)this.getSession()).setSystemProperty("task_writer_count", "4").setCatalogSessionProperty(this.catalog, "optimized_partition_update_serialization_enabled", optimizedPartitionUpdateSerializationEnabled + "").build();
    }

    private void assertOneNotNullResult(@Language(value="SQL") String query) {
        MaterializedResult results = this.getQueryRunner().execute(this.getSession(), query).toTestTypes();
        Assert.assertEquals((int)results.getRowCount(), (int)1);
        Assert.assertEquals((int)((MaterializedRow)results.getMaterializedRows().get(0)).getFieldCount(), (int)1);
        org.testng.Assert.assertNotNull((Object)((MaterializedRow)results.getMaterializedRows().get(0)).getField(0));
    }

    private boolean insertOperationsSupported(HiveStorageFormat storageFormat) {
        return storageFormat != HiveStorageFormat.DWRF;
    }

    private Type canonicalizeType(Type type) {
        HiveType hiveType = HiveType.toHiveType((TypeTranslator)this.typeTranslator, (Type)type);
        return HiveTestUtils.FUNCTION_AND_TYPE_MANAGER.getType(hiveType.getTypeSignature());
    }

    private String canonicalizeTypeName(String type) {
        TypeSignature typeSignature = TypeSignature.parseTypeSignature((String)type);
        return this.canonicalizeType(HiveTestUtils.FUNCTION_AND_TYPE_MANAGER.getType(typeSignature)).toString();
    }

    private void assertColumnType(TableMetadata tableMetadata, String columnName, Type expectedType) {
        Assert.assertEquals((Object)tableMetadata.getColumn(columnName).getType(), (Object)this.canonicalizeType(expectedType));
    }

    private void verifyPartition(boolean hasPartition, TableMetadata tableMetadata, List<String> partitionKeys) {
        Object partitionByProperty = tableMetadata.getMetadata().getProperties().get("partitioned_by");
        if (hasPartition) {
            Assert.assertEquals(partitionByProperty, partitionKeys);
            for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
                boolean partitionKey = partitionKeys.contains(columnMetadata.getName());
                Assert.assertEquals((String)columnMetadata.getExtraInfo(), (String)HiveUtil.columnExtraInfo((boolean)partitionKey));
            }
        } else {
            org.testng.Assert.assertNull(partitionByProperty);
        }
    }

    private void rollback() {
        throw new RollbackException();
    }

    private static String getExpectedErrorMessageForInsertExistingBucketedTable(HiveClientConfig.InsertExistingPartitionsBehavior behavior, String partitionName) {
        if (behavior == HiveClientConfig.InsertExistingPartitionsBehavior.APPEND) {
            return "Cannot insert into existing partition of bucketed Hive table: " + partitionName;
        }
        if (behavior == HiveClientConfig.InsertExistingPartitionsBehavior.ERROR) {
            return "Cannot insert into an existing partition of Hive table: " + partitionName;
        }
        throw new IllegalArgumentException("Unexpected insertExistingPartitionsBehavior: " + behavior);
    }

    private static ConnectorSession getConnectorSession(Session session) {
        return session.toConnectorSession(new ConnectorId((String)session.getCatalog().get()));
    }

    private void testWithAllStorageFormats(BiConsumer<Session, HiveStorageFormat> test) {
        for (TestingHiveStorageFormat storageFormat : this.getAllTestingHiveStorageFormat()) {
            TestHiveIntegrationSmokeTest.testWithStorageFormat(storageFormat, test);
        }
    }

    private static void testWithStorageFormat(TestingHiveStorageFormat storageFormat, BiConsumer<Session, HiveStorageFormat> test) {
        Objects.requireNonNull(storageFormat, "storageFormat is null");
        Objects.requireNonNull(test, "test is null");
        Session session = storageFormat.getSession();
        try {
            test.accept(session, storageFormat.getFormat());
        }
        catch (AssertionError | Exception e) {
            org.testng.Assert.fail((String)String.format("Failure for format %s with properties %s", storageFormat.getFormat(), session.getConnectorProperties()), (Throwable)e);
        }
    }

    protected List<HiveStorageFormat> getSupportedHiveStorageFormats() {
        return (List)Arrays.stream(HiveStorageFormat.values()).filter(format -> format != HiveStorageFormat.CSV && format != HiveStorageFormat.ALPHA).collect(ImmutableList.toImmutableList());
    }

    private List<TestingHiveStorageFormat> getAllTestingHiveStorageFormat() {
        Session session = this.getSession();
        return (List)this.getSupportedHiveStorageFormats().stream().map(format -> new TestingHiveStorageFormat(session, (HiveStorageFormat)format)).collect(ImmutableList.toImmutableList());
    }

    private static class TestingHiveStorageFormat {
        private final Session session;
        private final HiveStorageFormat format;

        TestingHiveStorageFormat(Session session, HiveStorageFormat format) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.format = Objects.requireNonNull(format, "format is null");
        }

        public Session getSession() {
            return this.session;
        }

        public HiveStorageFormat getFormat() {
            return this.format;
        }
    }

    private static class RollbackException
    extends RuntimeException {
        private RollbackException() {
        }
    }
}

