/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveManifestUtils;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveManifestUtils {
    private static final long FILE_SIZE = 1024L;
    private static final long ROW_COUNT = 100L;

    @Test
    public void testCreateFileStatisticsPage() {
        Page statisticsPage = HiveManifestUtils.createFileStatisticsPage((long)1024L, (long)100L);
        Assert.assertEquals((int)statisticsPage.getPositionCount(), (int)1);
        Assert.assertEquals((int)statisticsPage.getChannelCount(), (int)2);
    }

    @Test
    public void testGetFileSize() {
        Page statisticsPage = this.createTestStatisticsPageWithOneRow((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (List<Object>)ImmutableList.of((Object)1024L, (Object)100L));
        Assert.assertEquals((long)HiveManifestUtils.getFileSize((Page)statisticsPage, (int)0), (long)1024L);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Invalid position: 2 specified for FileStatistics page")
    public void testGetFileSizeOfInvalidStatisticsPage() {
        Page statisticsPage = this.createTestStatisticsPageWithOneRow((List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (List<Object>)ImmutableList.of((Object)1024L, (Object)100L));
        HiveManifestUtils.getFileSize((Page)statisticsPage, (int)2);
    }

    @Test
    public void testCreatePartitionManifest() {
        PartitionUpdate partitionUpdate = new PartitionUpdate("testPartition", PartitionUpdate.UpdateMode.NEW, "/testDir", "/testDir", (List)ImmutableList.of((Object)new PartitionUpdate.FileWriteInfo("testFileName", "testFileName", Optional.of(1024L))), 100L, 1024L, 1024L, false);
        Optional manifestPage = HiveManifestUtils.createPartitionManifest((PartitionUpdate)partitionUpdate);
        Assert.assertTrue((boolean)manifestPage.isPresent());
        Assert.assertEquals((int)((Page)manifestPage.get()).getChannelCount(), (int)2);
        Assert.assertEquals((int)((Page)manifestPage.get()).getPositionCount(), (int)1);
    }

    @Test
    public void testFileNamesCompression() {
        List<String> fileNames = new ArrayList<String>();
        for (int i = 0; i <= 100; ++i) {
            fileNames.add(String.valueOf(i));
        }
        String compressedSequentialFileNames = HiveManifestUtils.compressFileNames(fileNames);
        Assert.assertEquals(fileNames, (Collection)HiveManifestUtils.decompressFileNames((String)compressedSequentialFileNames));
        fileNames.clear();
        for (int i = 0; i <= 100; ++i) {
            if (i % 10 == 0) continue;
            fileNames.add(String.valueOf(i));
        }
        String compressedNonSequentialFileNames = HiveManifestUtils.compressFileNames(fileNames);
        Assert.assertEquals(fileNames, (Collection)HiveManifestUtils.decompressFileNames((String)compressedNonSequentialFileNames));
        Random random = new Random();
        ArrayList<Integer> randomNumbers = new ArrayList<Integer>();
        for (int i = 0; i <= 100; ++i) {
            randomNumbers.add(Math.abs(random.nextInt()));
        }
        Collections.sort(randomNumbers);
        fileNames = (List)randomNumbers.stream().map(String::valueOf).collect(ImmutableList.toImmutableList());
        String randomFileNames = HiveManifestUtils.compressFileNames(fileNames);
        Assert.assertEquals(fileNames, (Collection)HiveManifestUtils.decompressFileNames((String)randomFileNames));
    }

    @Test
    public void testFileSizesCompression() {
        ArrayList<Long> fileSizes = new ArrayList<Long>();
        Random random = new Random();
        for (int i = 0; i <= 100; ++i) {
            fileSizes.add(Math.abs(random.nextLong()));
        }
        String compressedFileSizes = HiveManifestUtils.compressFileSizes(fileSizes);
        Assert.assertEquals(fileSizes, (Collection)HiveManifestUtils.decompressFileSizes((String)compressedFileSizes));
    }

    private Page createTestStatisticsPageWithOneRow(List<Type> types, List<Object> values) {
        Assert.assertEquals((int)types.size(), (int)values.size());
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.copyOf(types));
        pageBuilder.declarePosition();
        block12: for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
            Object value = values.get(i);
            switch (type.getTypeSignature().getBase()) {
                case "boolean": {
                    type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
                    continue block12;
                }
                case "bigint": {
                    type.writeLong(blockBuilder, ((Long)value).longValue());
                    continue block12;
                }
                case "double": {
                    type.writeDouble(blockBuilder, ((Double)value).doubleValue());
                    continue block12;
                }
                case "varchar": {
                    type.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)value)));
                }
            }
        }
        return pageBuilder.build();
    }
}

