/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveMaterializedViewUtils;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.TestingSemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveMaterializedViewUtils {
    private static final String SCHEMA_NAME = "schema";
    private static final String TABLE_NAME = "table";
    private static final String USER_NAME = "user";
    private static final String LOCATION = "test/location";
    private static final String QUERY_ID = "queryId";
    private static final String SQL = "sql";
    private final LiteralEncoder literalEncoder = new LiteralEncoder((BlockEncodingSerde)new TestingBlockEncodingSerde(new BlockEncoding[0]));
    private final MetastoreContext metastoreContext = new MetastoreContext("user", "queryId", Optional.empty(), Optional.empty(), Optional.empty(), false, (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);

    @Test
    public void testMaterializedDataPredicates() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds", (Object)"category");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column categoryColumn = new Column("category", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)categoryColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2020-01-01/category=c1", (Object)"ds=2020-01-01/category=c2", (Object)"ds=2020-01-02/category=c1", (Object)"ds=2020-01-02/category=c2");
        testMetastore.setPartitionNames((List<String>)partitions);
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-01' AS varchar)"), (Object)new TestingPartitionResult("category", (Type)VarcharType.VARCHAR, "CAST('c1' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-01' AS varchar)"), (Object)new TestingPartitionResult("category", (Type)VarcharType.VARCHAR, "CAST('c2' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-02' AS varchar)"), (Object)new TestingPartitionResult("category", (Type)VarcharType.VARCHAR, "CAST('c1' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-02' AS varchar)"), (Object)new TestingPartitionResult("category", (Type)VarcharType.VARCHAR, "CAST('c2' AS varchar)")));
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        this.comparePredicates(materializedDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testMaterializedDataPredicatesWithNullPartitions() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds", (Object)"category");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column categoryColumn = new Column("category", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)categoryColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2020-01-01/category=c1", (Object)"ds=2020-01-01/category=__HIVE_DEFAULT_PARTITION__", (Object)"ds=2020-01-02/category=c1", (Object)"ds=__HIVE_DEFAULT_PARTITION__/category=c2");
        testMetastore.setPartitionNames((List<String>)partitions);
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-01' AS varchar)"), (Object)new TestingPartitionResult("category", (Type)VarcharType.VARCHAR, "CAST('c1' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-01' AS varchar)"), (Object)new TestingPartitionResult("category", (Type)VarcharType.VARCHAR, "CAST(null AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-02' AS varchar)"), (Object)new TestingPartitionResult("category", (Type)VarcharType.VARCHAR, "CAST('c1' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST(null AS varchar)"), (Object)new TestingPartitionResult("category", (Type)VarcharType.VARCHAR, "CAST('c2' AS varchar)")));
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        this.comparePredicates(materializedDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testMaterializedDataPredicatesWithEmptyPartitions() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds", (Object)"category");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column categoryColumn = new Column("category", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)categoryColumn);
        ImmutableList partitions = ImmutableList.of();
        testMetastore.setPartitionNames((List<String>)partitions);
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        this.comparePredicates(materializedDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testMaterializedDataPredicatesWithIntPartitionType() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds", (Object)"code");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column codeColumn = new Column("code", HiveType.HIVE_INT, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)codeColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2021-01-01/code=1", (Object)"ds=2021-01-01/code=2", (Object)"ds=2021-01-02/code=1", (Object)"ds=2021-01-02/code=2");
        testMetastore.setPartitionNames((List<String>)partitions);
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2021-01-01' AS varchar)"), (Object)new TestingPartitionResult("code", (Type)IntegerType.INTEGER, "1")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2021-01-01' AS varchar)"), (Object)new TestingPartitionResult("code", (Type)IntegerType.INTEGER, "2")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2021-01-02' AS varchar)"), (Object)new TestingPartitionResult("code", (Type)IntegerType.INTEGER, "1")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2021-01-02' AS varchar)"), (Object)new TestingPartitionResult("code", (Type)IntegerType.INTEGER, "2")));
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        this.comparePredicates(materializedDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testDifferenceDataPredicates() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2020-01-01", (Object)"ds=2020-01-02", (Object)"ds=2020-01-03", (Object)"ds=2020-01-04", (Object)"ds=2020-01-05", (Object)"ds=2020-01-06");
        testMetastore.setPartitionNames((List<String>)partitions);
        MaterializedViewStatus.MaterializedDataPredicates baseDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        ImmutableList viewPartitions = ImmutableList.of((Object)"ds=2020-01-02", (Object)"ds=2020-01-03", (Object)"ds=2020-01-05");
        testMetastore.setPartitionNames((List<String>)viewPartitions);
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        ImmutableMap materializedViewToBaseColumnMap = ImmutableMap.of((Object)"ds", (Object)"ds");
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-01' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-04' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-06' AS varchar)")));
        MaterializedViewStatus.MaterializedDataPredicates diffDataPredicates = HiveMaterializedViewUtils.differenceDataPredicates((MaterializedViewStatus.MaterializedDataPredicates)baseDataPredicates, (MaterializedViewStatus.MaterializedDataPredicates)materializedDataPredicates, (Map)materializedViewToBaseColumnMap);
        this.comparePredicates(diffDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testDifferenceDataOuterJoin() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2020-01-01", (Object)"ds=2020-01-02", (Object)"ds=2020-01-03", (Object)"ds=2020-01-04", (Object)"ds=2020-01-05", (Object)"ds=2020-01-06");
        testMetastore.setPartitionNames((List<String>)partitions);
        MaterializedViewStatus.MaterializedDataPredicates baseDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        ImmutableList viewPartitions = ImmutableList.of((Object)"ds1=2020-01-02/ds2=2020-01-02", (Object)"ds1=2020-01-03/ds2=null", (Object)"ds1=2020-01-05/ds2=null", (Object)"ds1=2020-01-05/ds2=2020-01-05");
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)new Column("ds1", HiveType.HIVE_STRING, Optional.empty(), Optional.empty()), (Object)new Column("ds2", HiveType.HIVE_STRING, Optional.empty(), Optional.empty()));
        testMetastore.setPartitionNames((List<String>)viewPartitions);
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (DateTimeZone)DateTimeZone.UTC);
        ImmutableMap materializedViewToBaseColumnMap = ImmutableMap.of((Object)"ds2", (Object)"ds");
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-01' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-04' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-06' AS varchar)")));
        MaterializedViewStatus.MaterializedDataPredicates diffDataPredicates = HiveMaterializedViewUtils.differenceDataPredicates((MaterializedViewStatus.MaterializedDataPredicates)baseDataPredicates, (MaterializedViewStatus.MaterializedDataPredicates)materializedDataPredicates, (Map)materializedViewToBaseColumnMap, (Map)ImmutableMap.of((Object)"ds1", (Object)"ds"));
        this.comparePredicates(diffDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testDifferenceDataPredicatesWithAlias() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds", (Object)"shipmode");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)shipmodeColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2020-01-01/shipmode=air", (Object)"ds=2020-01-01/shipmode=road", (Object)"ds=2020-01-02/shipmode=air", (Object)"ds=2020-01-02/shipmode=road");
        testMetastore.setPartitionNames((List<String>)partitions);
        MaterializedViewStatus.MaterializedDataPredicates baseDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        Column viewShipModeColumn = new Column("view_shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)dsColumn, (Object)viewShipModeColumn);
        ImmutableList viewPartitions = ImmutableList.of((Object)"ds=2020-01-01/view_shipmode=air", (Object)"ds=2020-01-01/view_shipmode=road");
        testMetastore.setPartitionNames((List<String>)viewPartitions);
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (DateTimeZone)DateTimeZone.UTC);
        ImmutableMap materializedViewToBaseColumnMap = ImmutableMap.of((Object)"ds", (Object)"ds", (Object)"view_shipmode", (Object)"shipmode");
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-02' AS varchar)"), (Object)new TestingPartitionResult("shipmode", (Type)VarcharType.VARCHAR, "CAST('air' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-02' AS varchar)"), (Object)new TestingPartitionResult("shipmode", (Type)VarcharType.VARCHAR, "CAST('road' AS varchar)")));
        MaterializedViewStatus.MaterializedDataPredicates diffDataPredicates = HiveMaterializedViewUtils.differenceDataPredicates((MaterializedViewStatus.MaterializedDataPredicates)baseDataPredicates, (MaterializedViewStatus.MaterializedDataPredicates)materializedDataPredicates, (Map)materializedViewToBaseColumnMap);
        this.comparePredicates(diffDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testDifferenceDataPredicatesWithDifferentExtraPartitions() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds", (Object)"shipmode");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)shipmodeColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2020-01-01/shipmode=air", (Object)"ds=2020-01-01/shipmode=road", (Object)"ds=2020-01-02/shipmode=air", (Object)"ds=2020-01-02/shipmode=road");
        testMetastore.setPartitionNames((List<String>)partitions);
        MaterializedViewStatus.MaterializedDataPredicates baseDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        Column viewShipModeColumn = new Column("view_shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)dsColumn, (Object)viewShipModeColumn);
        ImmutableList viewPartitions = ImmutableList.of((Object)"ds=2020-01-01/view_shipmode=air", (Object)"ds=2020-01-01/view_shipmode=road");
        testMetastore.setPartitionNames((List<String>)viewPartitions);
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (DateTimeZone)DateTimeZone.UTC);
        ImmutableMap materializedViewToBaseColumnMap = ImmutableMap.of((Object)"ds", (Object)"ds");
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-02' AS varchar)"), (Object)new TestingPartitionResult("shipmode", (Type)VarcharType.VARCHAR, "CAST('air' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-02' AS varchar)"), (Object)new TestingPartitionResult("shipmode", (Type)VarcharType.VARCHAR, "CAST('road' AS varchar)")));
        MaterializedViewStatus.MaterializedDataPredicates diffDataPredicates = HiveMaterializedViewUtils.differenceDataPredicates((MaterializedViewStatus.MaterializedDataPredicates)baseDataPredicates, (MaterializedViewStatus.MaterializedDataPredicates)materializedDataPredicates, (Map)materializedViewToBaseColumnMap);
        this.comparePredicates(diffDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testDifferenceDataPredicatesFullyMaterialized() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds", (Object)"shipmode");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)shipmodeColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2020-01-01/shipmode=air", (Object)"ds=2020-01-01/shipmode=road", (Object)"ds=2020-01-02/shipmode=air", (Object)"ds=2020-01-02/shipmode=road");
        testMetastore.setPartitionNames((List<String>)partitions);
        MaterializedViewStatus.MaterializedDataPredicates baseDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        Column viewShipModeColumn = new Column("view_shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)dsColumn, (Object)viewShipModeColumn);
        ImmutableList viewPartitions = ImmutableList.of((Object)"ds=2020-01-01/view_shipmode=air", (Object)"ds=2020-01-01/view_shipmode=road", (Object)"ds=2020-01-02/view_shipmode=air", (Object)"ds=2020-01-02/view_shipmode=road");
        testMetastore.setPartitionNames((List<String>)viewPartitions);
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (DateTimeZone)DateTimeZone.UTC);
        ImmutableMap materializedViewToBaseColumnMap = ImmutableMap.of((Object)"ds", (Object)"ds", (Object)"view_shipmode", (Object)"shipmode");
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        MaterializedViewStatus.MaterializedDataPredicates diffDataPredicates = HiveMaterializedViewUtils.differenceDataPredicates((MaterializedViewStatus.MaterializedDataPredicates)baseDataPredicates, (MaterializedViewStatus.MaterializedDataPredicates)materializedDataPredicates, (Map)materializedViewToBaseColumnMap);
        this.comparePredicates(diffDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testDifferenceDataPredicatesNotMaterialized() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        ImmutableList keys = ImmutableList.of((Object)"ds", (Object)"shipmode");
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)shipmodeColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2020-01-01/shipmode=air", (Object)"ds=2020-01-01/shipmode=road", (Object)"ds=2020-01-02/shipmode=air", (Object)"ds=2020-01-02/shipmode=road");
        testMetastore.setPartitionNames((List<String>)partitions);
        MaterializedViewStatus.MaterializedDataPredicates baseDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        Column viewShipModeColumn = new Column("view_shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)dsColumn, (Object)viewShipModeColumn);
        ImmutableList viewPartitions = ImmutableList.of();
        testMetastore.setPartitionNames((List<String>)viewPartitions);
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (DateTimeZone)DateTimeZone.UTC);
        ImmutableMap materializedViewToBaseColumnMap = ImmutableMap.of((Object)"ds", (Object)"ds", (Object)"view_shipmode", (Object)"shipmode");
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-01' AS varchar)"), (Object)new TestingPartitionResult("shipmode", (Type)VarcharType.VARCHAR, "CAST('air' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-01' AS varchar)"), (Object)new TestingPartitionResult("shipmode", (Type)VarcharType.VARCHAR, "CAST('road' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-02' AS varchar)"), (Object)new TestingPartitionResult("shipmode", (Type)VarcharType.VARCHAR, "CAST('air' AS varchar)")));
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-02' AS varchar)"), (Object)new TestingPartitionResult("shipmode", (Type)VarcharType.VARCHAR, "CAST('road' AS varchar)")));
        MaterializedViewStatus.MaterializedDataPredicates diffDataPredicates = HiveMaterializedViewUtils.differenceDataPredicates((MaterializedViewStatus.MaterializedDataPredicates)baseDataPredicates, (MaterializedViewStatus.MaterializedDataPredicates)materializedDataPredicates, (Map)materializedViewToBaseColumnMap);
        this.comparePredicates(diffDataPredicates, (List<String>)keys, (ImmutableList<List<TestingPartitionResult>>)partitionResults.build());
    }

    @Test
    public void testDifferenceDataPredicatesEmptyDataPredicates() {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)shipmodeColumn);
        ImmutableList partitions = ImmutableList.of((Object)"ds=2020-01-01/shipmode=air", (Object)"ds=2020-01-01/shipmode=road");
        testMetastore.setPartitionNames((List<String>)partitions);
        MaterializedViewStatus.MaterializedDataPredicates baseDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (DateTimeZone)DateTimeZone.UTC);
        Column viewShipModeColumn = new Column("view_shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)dsColumn, (Object)viewShipModeColumn);
        ImmutableList viewPartitions = ImmutableList.of();
        testMetastore.setPartitionNames((List<String>)viewPartitions);
        MaterializedViewStatus.MaterializedDataPredicates materializedDataPredicates = HiveMaterializedViewUtils.getMaterializedDataPredicates((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (TypeManager)typeManager, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (DateTimeZone)DateTimeZone.UTC);
        ImmutableMap materializedViewToBaseColumnMap = ImmutableMap.of();
        ImmutableList.Builder partitionResults = ImmutableList.builder();
        partitionResults.add((Object)ImmutableList.of((Object)new TestingPartitionResult("ds", (Type)VarcharType.VARCHAR, "CAST('2020-01-01' AS varchar)"), (Object)new TestingPartitionResult("shipmode", (Type)VarcharType.VARCHAR, "CAST('air' AS varchar)")));
        MaterializedViewStatus.MaterializedDataPredicates diffDataPredicates = HiveMaterializedViewUtils.differenceDataPredicates((MaterializedViewStatus.MaterializedDataPredicates)baseDataPredicates, (MaterializedViewStatus.MaterializedDataPredicates)materializedDataPredicates, (Map)materializedViewToBaseColumnMap);
        Assert.assertEquals((Object)diffDataPredicates, (Object)HiveMaterializedViewUtils.getEmptyMaterializedViewDataPredicates());
    }

    @Test
    public void testValidateMaterializedViewPartitionColumnsOneColumnMatch() {
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)shipmodeColumn);
        SchemaTableName tableName = new SchemaTableName(SCHEMA_NAME, TABLE_NAME);
        ImmutableMap originalColumnMapping = ImmutableMap.of((Object)dsColumn.getName(), (Object)ImmutableMap.of((Object)tableName, (Object)dsColumn.getName()));
        testMetastore.addTable(SCHEMA_NAME, TABLE_NAME, TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (List<String>)ImmutableList.of());
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)dsColumn);
        HiveMaterializedViewUtils.validateMaterializedViewPartitionColumns((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (MaterializedViewDefinition)TestHiveMaterializedViewUtils.getConnectorMaterializedViewDefinition((List<SchemaTableName>)ImmutableList.of((Object)tableName), (Map<String, Map<SchemaTableName, String>>)originalColumnMapping));
    }

    @Test
    public void testValidateMaterializedViewPartitionColumnsTwoColumnMatchDifferentTable() {
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        SchemaTableName tableName1 = new SchemaTableName(SCHEMA_NAME, TABLE_NAME);
        testMetastore.addTable(SCHEMA_NAME, TABLE_NAME, TestHiveMaterializedViewUtils.getTable((List<Column>)ImmutableList.of((Object)dsColumn)), (List<String>)ImmutableList.of());
        String table2 = "table2";
        SchemaTableName tableName2 = new SchemaTableName(SCHEMA_NAME, table2);
        testMetastore.addTable(SCHEMA_NAME, table2, TestHiveMaterializedViewUtils.getTable(table2, (List<Column>)ImmutableList.of((Object)shipmodeColumn)), (List<String>)ImmutableList.of());
        ImmutableMap originalColumnMapping = ImmutableMap.of((Object)dsColumn.getName(), (Object)ImmutableMap.of((Object)tableName1, (Object)dsColumn.getName()), (Object)shipmodeColumn.getName(), (Object)ImmutableMap.of((Object)tableName2, (Object)shipmodeColumn.getName()));
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)dsColumn, (Object)shipmodeColumn);
        HiveMaterializedViewUtils.validateMaterializedViewPartitionColumns((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (MaterializedViewDefinition)TestHiveMaterializedViewUtils.getConnectorMaterializedViewDefinition((List<SchemaTableName>)ImmutableList.of((Object)tableName1, (Object)tableName2), (Map<String, Map<SchemaTableName, String>>)originalColumnMapping));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Materialized view schema.table must have at least one column directly defined by a base table column.")
    public void testValidateMaterializedViewPartitionColumnsEmptyBaseColumnMap() {
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)shipmodeColumn);
        SchemaTableName tableName = new SchemaTableName(SCHEMA_NAME, TABLE_NAME);
        ImmutableMap originalColumnMapping = ImmutableMap.of();
        testMetastore.addTable(SCHEMA_NAME, TABLE_NAME, TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (List<String>)ImmutableList.of());
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)dsColumn);
        HiveMaterializedViewUtils.validateMaterializedViewPartitionColumns((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (MaterializedViewDefinition)TestHiveMaterializedViewUtils.getConnectorMaterializedViewDefinition((List<SchemaTableName>)ImmutableList.of((Object)tableName), (Map<String, Map<SchemaTableName, String>>)originalColumnMapping));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Unpartitioned materialized view is not supported.")
    public void testValidateMaterializedViewPartitionColumnsEmptyViewPartition() {
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dsColumn, (Object)shipmodeColumn);
        SchemaTableName tableName = new SchemaTableName(SCHEMA_NAME, TABLE_NAME);
        ImmutableMap originalColumnMapping = ImmutableMap.of((Object)dsColumn.getName(), (Object)ImmutableMap.of((Object)tableName, (Object)dsColumn.getName()));
        testMetastore.addTable(SCHEMA_NAME, TABLE_NAME, TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (List<String>)ImmutableList.of());
        ImmutableList viewPartitionColumns = ImmutableList.of();
        HiveMaterializedViewUtils.validateMaterializedViewPartitionColumns((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (MaterializedViewDefinition)TestHiveMaterializedViewUtils.getConnectorMaterializedViewDefinition((List<SchemaTableName>)ImmutableList.of((Object)tableName), (Map<String, Map<SchemaTableName, String>>)originalColumnMapping));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Materialized view schema.table must have at least one partition column that exists in table as well")
    public void testValidateMaterializedViewPartitionColumnsNoneCommonPartition() {
        TestingSemiTransactionalHiveMetastore testMetastore = TestingSemiTransactionalHiveMetastore.create();
        Column dsColumn = new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        Column shipmodeColumn = new Column("shipmode", HiveType.HIVE_STRING, Optional.empty(), Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)shipmodeColumn);
        SchemaTableName tableName = new SchemaTableName(SCHEMA_NAME, TABLE_NAME);
        ImmutableMap originalColumnMapping = ImmutableMap.of((Object)dsColumn.getName(), (Object)ImmutableMap.of((Object)tableName, (Object)dsColumn.getName()));
        testMetastore.addTable(SCHEMA_NAME, TABLE_NAME, TestHiveMaterializedViewUtils.getTable((List<Column>)partitionColumns), (List<String>)ImmutableList.of());
        ImmutableList viewPartitionColumns = ImmutableList.of((Object)dsColumn);
        HiveMaterializedViewUtils.validateMaterializedViewPartitionColumns((SemiTransactionalHiveMetastore)testMetastore, (MetastoreContext)this.metastoreContext, (Table)TestHiveMaterializedViewUtils.getTable((List<Column>)viewPartitionColumns), (MaterializedViewDefinition)TestHiveMaterializedViewUtils.getConnectorMaterializedViewDefinition((List<SchemaTableName>)ImmutableList.of((Object)tableName), (Map<String, Map<SchemaTableName, String>>)originalColumnMapping));
    }

    private void comparePredicates(MaterializedViewStatus.MaterializedDataPredicates dataPredicates, List<String> keys, ImmutableList<List<TestingPartitionResult>> results) {
        List columnNames = dataPredicates.getColumnNames();
        Assert.assertEquals(keys, (Collection)columnNames);
        List predicates = dataPredicates.getPredicateDisjuncts();
        Assert.assertEquals((int)predicates.size(), (int)results.size());
        UnmodifiableListIterator resultIterator = results.listIterator();
        predicates.forEach(arg_0 -> this.lambda$comparePredicates$2((Iterator)resultIterator, arg_0));
    }

    private void comparePartitionValueExpression(NullableValue nullableValue, TestingPartitionResult partitionResult) {
        Expression expression = this.literalEncoder.toExpression(nullableValue.getValue(), nullableValue.getType(), false);
        Assert.assertEquals((Object)nullableValue.getType(), (Object)partitionResult.type);
        Assert.assertEquals((String)expression.toString(), (String)partitionResult.partitionValue);
    }

    private static Table getTable(List<Column> partitionColumns) {
        return TestHiveMaterializedViewUtils.getTable(TABLE_NAME, partitionColumns);
    }

    private static Table getTable(String tableName, List<Column> partitionColumns) {
        return new Table(SCHEMA_NAME, tableName, USER_NAME, PrestoTableType.MANAGED_TABLE, new Storage(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC), LOCATION, Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of(), partitionColumns, (Map)ImmutableMap.of(), Optional.empty(), Optional.empty());
    }

    private static MaterializedViewDefinition getConnectorMaterializedViewDefinition(List<SchemaTableName> tables, Map<String, Map<SchemaTableName, String>> originalColumnMapping) {
        return new MaterializedViewDefinition(SQL, SCHEMA_NAME, TABLE_NAME, tables, Optional.empty(), originalColumnMapping, originalColumnMapping, (List)ImmutableList.of(), Optional.empty());
    }

    private /* synthetic */ void lambda$comparePredicates$2(Iterator resultIterator, TupleDomain predicate) {
        Optional nullableValues = TupleDomain.extractFixedValues((TupleDomain)predicate);
        List result = (List)resultIterator.next();
        Map nullableValueMap = (Map)nullableValues.orElseThrow(() -> new IllegalStateException("nullableValues is not present"));
        Assert.assertEquals((int)nullableValueMap.size(), (int)result.size());
        Iterator partitionResultIterator = result.iterator();
        nullableValueMap.forEach((key, value) -> {
            TestingPartitionResult partitionResult = (TestingPartitionResult)partitionResultIterator.next();
            Assert.assertEquals((String)key, (String)partitionResult.columnName);
            this.comparePartitionValueExpression((NullableValue)value, partitionResult);
        });
    }

    private static class TestingPartitionResult {
        private final String columnName;
        private final Type type;
        private final String partitionValue;

        public TestingPartitionResult(String columnName, Type type, String partitionValue) {
            this.columnName = columnName;
            this.type = type;
            this.partitionValue = partitionValue;
        }
    }
}

