/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.ColumnEncryptionInformation;
import com.facebook.presto.hive.DwrfEncryptionMetadata;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.EncryptionMetadata;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveEncryptionInformationProvider;
import com.facebook.presto.hive.HiveFileRenamer;
import com.facebook.presto.hive.HiveInsertTableHandle;
import com.facebook.presto.hive.HiveLocationService;
import com.facebook.presto.hive.HiveMetadata;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionObjectBuilder;
import com.facebook.presto.hive.HivePartitionStats;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveStagingFileCommitter;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveZeroRowFileCreator;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.PartitionObjectBuilder;
import com.facebook.presto.hive.PartitionUpdate;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TestDwrfEncryptionInformationSource;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ZeroRowFileCreator;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.datasink.OutputStreamDataSinkFactory;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.InMemoryHiveMetastore;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.PrincipalType;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.Slices;
import java.io.File;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHiveMetadataFileFormatEncryptionSettings {
    private static final String TEST_SERVER_VERSION = "test_version";
    private static final String TEST_DB_NAME = "test_db";
    private static final JsonCodec<PartitionUpdate> PARTITION_CODEC = JsonCodec.jsonCodec(PartitionUpdate.class);
    private static final ConnectorSession SESSION = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig(), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties(), (Map)ImmutableMap.of((Object)"new_partition_user_supplied_parameter", (Object)"{}"));
    private HiveMetadataFactory metadataFactory;
    private HiveTransactionManager transactionManager;
    private ExtendedHiveMetastore metastore;
    private ExecutorService executor;
    private File baseDirectory;

    @BeforeClass
    public void setup() {
        this.baseDirectory = new File(Files.createTempDir(), "metastore");
        this.metastore = new BridgingHiveMetastore((HiveMetastore)new InMemoryHiveMetastore(this.baseDirectory), (PartitionMutator)new HivePartitionMutator());
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hive-encryption-test-%s"));
        this.transactionManager = new HiveTransactionManager();
        this.metadataFactory = new HiveMetadataFactory(this.metastore, HiveTestUtils.HDFS_ENVIRONMENT, new HivePartitionManager((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.HIVE_CLIENT_CONFIG), DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(ZoneId.of(HiveTestUtils.HIVE_CLIENT_CONFIG.getTimeZone()))), true, false, false, false, true, true, HiveTestUtils.HIVE_CLIENT_CONFIG.getMaxPartitionBatchSize(), (long)HiveTestUtils.HIVE_CLIENT_CONFIG.getMaxPartitionsPerScan(), false, 10000, (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, (LocationService)new HiveLocationService(HiveTestUtils.HDFS_ENVIRONMENT), HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.ROW_EXPRESSION_SERVICE, HiveTestUtils.FILTER_STATS_CALCULATOR_SERVICE, new TableParameterCodec(), HiveTestUtils.PARTITION_UPDATE_CODEC, HiveTestUtils.PARTITION_UPDATE_SMILE_CODEC, MoreExecutors.listeningDecorator((ExecutorService)this.executor), (TypeTranslator)new HiveTypeTranslator(), (StagingFileCommitter)new HiveStagingFileCommitter(HiveTestUtils.HDFS_ENVIRONMENT, MoreExecutors.listeningDecorator((ExecutorService)this.executor)), (ZeroRowFileCreator)new HiveZeroRowFileCreator(HiveTestUtils.HDFS_ENVIRONMENT, (DataSinkFactory)new OutputStreamDataSinkFactory(), MoreExecutors.listeningDecorator((ExecutorService)this.executor)), TEST_SERVER_VERSION, (PartitionObjectBuilder)new HivePartitionObjectBuilder(), new HiveEncryptionInformationProvider((List)ImmutableList.of((Object)((Object)new TestDwrfEncryptionInformationSource()))), new HivePartitionStats(), new HiveFileRenamer(), (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        this.metastore.createDatabase(HiveQueryRunner.METASTORE_CONTEXT, Database.builder().setDatabaseName(TEST_DB_NAME).setOwnerName("public").setOwnerType(PrincipalType.ROLE).build());
    }

    @AfterClass
    public void tearDown() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    private static ConnectorTableMetadata getConnectorTableMetadata(String tableName, Map<String, Object> tableProperties, boolean isPartitioned) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"bucket_count", (Object)0);
        properties.put((Object)"bucketed_by", (Object)ImmutableList.of());
        properties.put((Object)"sorted_by", (Object)ImmutableList.of());
        if (isPartitioned) {
            properties.put((Object)"partitioned_by", (Object)ImmutableList.of((Object)"ds"));
        }
        properties.put((Object)"format", (Object)HiveStorageFormat.DWRF);
        properties.putAll(tableProperties);
        return new ConnectorTableMetadata(new SchemaTableName(TEST_DB_NAME, tableName), (List)ImmutableList.of((Object)new ColumnMetadata("t_varchar", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("t_bigint", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("t_struct", (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("char"), (Type)VarcharType.VARCHAR), (Object)new RowType.Field(Optional.of("str"), (Type)RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("a"), (Type)VarcharType.VARCHAR), (Object)new RowType.Field(Optional.of("b"), (Type)BigintType.BIGINT))))))), (Object)new ColumnMetadata("ds", (Type)VarcharType.VARCHAR)), (Map)properties.build());
    }

    private void dropTable(String tableName) {
        try {
            this.metadataFactory.get().dropTable(SESSION, (ConnectorTableHandle)new HiveTableHandle(TEST_DB_NAME, tableName));
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreationWithTableKeyReference() {
        String tableName = "test_enc_with_table_key";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_table", (Object)"keyReference1", (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            HiveMetadata metadata = this.metadataFactory.get();
            metadata.createTable(SESSION, table, false);
            ConnectorTableMetadata receivedMetadata = metadata.getTableMetadata(SESSION, (ConnectorTableHandle)new HiveTableHandle(TEST_DB_NAME, tableName));
            Assert.assertEquals(receivedMetadata.getProperties().get("encrypt_table"), table.getProperties().get("encrypt_table"));
            Assert.assertEquals(receivedMetadata.getProperties().get("dwrf_encryption_algorithm"), table.getProperties().get("dwrf_encryption_algorithm"));
            Assert.assertEquals(receivedMetadata.getProperties().get("dwrf_encryption_provider"), table.getProperties().get("dwrf_encryption_provider"));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableCreationWithColumnKeyReference() {
        String tableName = "test_enc_with_column_key";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:t_varchar,t_bigint", (Object)"key2: t_struct.char,t_struct.str.a")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            HiveMetadata metadata = this.metadataFactory.get();
            metadata.createTable(SESSION, table, false);
            ConnectorTableMetadata receivedMetadata = metadata.getTableMetadata(SESSION, (ConnectorTableHandle)new HiveTableHandle(TEST_DB_NAME, tableName));
            Assert.assertEquals(receivedMetadata.getProperties().get("encrypt_columns"), table.getProperties().get("encrypt_columns"));
            Assert.assertEquals(receivedMetadata.getProperties().get("dwrf_encryption_algorithm"), table.getProperties().get("dwrf_encryption_algorithm"));
            Assert.assertEquals(receivedMetadata.getProperties().get("dwrf_encryption_provider"), table.getProperties().get("dwrf_encryption_provider"));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="This also tests that NEW_PARTITION_USER_SUPPLIED_PARAMETER also works")
    public void testCreateTableAsSelectWithColumnKeyReference() {
        String tableName = "test_ctas_enc_with_column_key";
        ColumnEncryptionInformation columnEncryptionInformation = ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:t_varchar,t_bigint", (Object)"key2: t_struct.char,t_struct.str.a"));
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)columnEncryptionInformation, (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            HiveMetadata metadata = this.metadataFactory.get();
            HiveOutputTableHandle outputHandle = metadata.beginCreateTable(SESSION, table, Optional.empty());
            Assert.assertTrue((boolean)outputHandle.getEncryptionInformation().isPresent());
            Assert.assertEquals(outputHandle.getEncryptionInformation().get(), (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)((Map)columnEncryptionInformation.getColumnToKeyReference().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((ColumnEncryptionInformation.ColumnWithStructSubfield)entry.getKey()).toString(), entry -> ((String)entry.getValue()).getBytes()))), (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)"test_algo"), (String)"test_algo", (String)"test_provider")));
            ImmutableList partitionUpdates = ImmutableList.of((Object)new PartitionUpdate("ds=2020-06-26", PartitionUpdate.UpdateMode.NEW, "path1", "path1", (List)ImmutableList.of(), 0L, 0L, 0L, false), (Object)new PartitionUpdate("ds=2020-06-27", PartitionUpdate.UpdateMode.NEW, "path2", "path2", (List)ImmutableList.of(), 0L, 0L, 0L, false));
            metadata.finishCreateTable(SESSION, (ConnectorOutputTableHandle)outputHandle, (Collection)partitionUpdates.stream().map(update -> Slices.utf8Slice((String)PARTITION_CODEC.toJson(update))).collect(ImmutableList.toImmutableList()), (Collection)ImmutableList.of());
            ConnectorTableMetadata receivedMetadata = metadata.getTableMetadata(SESSION, (ConnectorTableHandle)new HiveTableHandle(TEST_DB_NAME, tableName));
            Assert.assertEquals(receivedMetadata.getProperties().get("encrypt_columns"), table.getProperties().get("encrypt_columns"));
            Assert.assertEquals(receivedMetadata.getProperties().get("dwrf_encryption_algorithm"), table.getProperties().get("dwrf_encryption_algorithm"));
            Assert.assertEquals(receivedMetadata.getProperties().get("dwrf_encryption_provider"), table.getProperties().get("dwrf_encryption_provider"));
            metadata.commit();
            Map partitions = this.metastore.getPartitionsByNames(HiveQueryRunner.METASTORE_CONTEXT, TEST_DB_NAME, tableName, (List)ImmutableList.of((Object)"ds=2020-06-26", (Object)"ds=2020-06-27"));
            Assert.assertEquals((String)((String)((Partition)((Optional)partitions.get("ds=2020-06-26")).get()).getParameters().get("test.extra.metadata")), (String)"test_algo");
            Assert.assertEquals((String)((String)((Partition)((Optional)partitions.get("ds=2020-06-27")).get()).getParameters().get("test.extra.metadata")), (String)"test_algo");
            Assert.assertEquals((String)((String)((Partition)((Optional)partitions.get("ds=2020-06-27")).get()).getParameters().get("user_supplied")), (String)"{}");
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Only one of encrypt_table or encrypt_columns should be specified")
    public void testTableCreationFailureWithColumnAndTableKeyReference() {
        String tableName = "test_enc_with_table_key_and_column_key";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_table", (Object)"tableKey", (Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:t_varchar,t_bigint", (Object)"key2: t_struct.char,t_struct.str.a")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            this.metadataFactory.get().createTable(SESSION, table, false);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Creating an encrypted table without partitions is not supported.*")
    public void testTableCreationFailureWithEncryptionAndUnpartitionedTable() {
        String tableName = "test_enc_with_unpartitioned_table";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_table", (Object)"tableKey", (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), false);
        try {
            this.metadataFactory.get().createTable(SESSION, table, false);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Partition column \\(ds\\) cannot be used as an encryption column")
    public void testTableCreationFailureWithPartitionColumnEncrypted() {
        String tableName = "test_enc_with_table_key_with_partition_enc";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:ds")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            this.metadataFactory.get().createTable(SESSION, table, false);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="In encrypt_columns unable to find column this_column_does_not_exist")
    public void testTableCreationFailureWithUnknownColumnAsEncrypted() {
        String tableName = "test_enc_with_table_key_with_unknown_col_enc";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:this_column_does_not_exist")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            this.metadataFactory.get().createTable(SESSION, table, false);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="In encrypt_columns subfields declared in t_struct.does_not_exist_subfield, but t_struct has type .*")
    public void testTableCreationFailureWithUnknownSubfieldAsEncrypted() {
        String tableName = "test_enc_with_table_key_with_unknown_col_enc";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:t_struct.does_not_exist_subfield")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            this.metadataFactory.get().createTable(SESSION, table, false);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="For \\(t_struct.str.a\\) found a keyReference at a higher level field \\(t_struct.str\\)")
    public void testTableCreationFailureWithSubfieldAlsoHavingASetting() {
        String tableName = "test_enc_with_table_key_with_subfield_also_having_a_setting";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:t_struct.str", (Object)"key2:t_struct.str.a")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            this.metadataFactory.get().createTable(SESSION, table, false);
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertIntoPartitionedTable() {
        String tableName = "test_enc_with_insert_partitioned_table";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:t_struct.str")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            HiveMetadata createHiveMetadata = this.metadataFactory.get();
            createHiveMetadata.createTable(SESSION, table, false);
            HiveInsertTableHandle insertTableHandle = createHiveMetadata.beginInsert(SESSION, (ConnectorTableHandle)new HiveTableHandle(TEST_DB_NAME, tableName));
            Assert.assertTrue((boolean)insertTableHandle.getEncryptionInformation().isPresent());
            Assert.assertEquals(insertTableHandle.getEncryptionInformation().get(), (Object)EncryptionInformation.fromEncryptionMetadata((EncryptionMetadata)DwrfEncryptionMetadata.forPerField((Map)ImmutableMap.of((Object)"t_struct.str", (Object)"key1".getBytes()), (Map)ImmutableMap.of((Object)"test.extra.metadata", (Object)"test_algo"), (String)"test_algo", (String)"test_provider")));
            ImmutableList partitionUpdates = ImmutableList.of((Object)new PartitionUpdate("ds=2020-06-26", PartitionUpdate.UpdateMode.NEW, "path1", "path1", (List)ImmutableList.of(), 0L, 0L, 0L, false), (Object)new PartitionUpdate("ds=2020-06-27", PartitionUpdate.UpdateMode.NEW, "path2", "path2", (List)ImmutableList.of(), 0L, 0L, 0L, false));
            createHiveMetadata.finishInsert(SESSION, (ConnectorInsertTableHandle)insertTableHandle, (Collection)partitionUpdates.stream().map(update -> Slices.utf8Slice((String)PARTITION_CODEC.toJson(update))).collect(ImmutableList.toImmutableList()), (Collection)ImmutableList.of());
            createHiveMetadata.commit();
            Map partitions = this.metastore.getPartitionsByNames(HiveQueryRunner.METASTORE_CONTEXT, TEST_DB_NAME, tableName, (List)ImmutableList.of((Object)"ds=2020-06-26", (Object)"ds=2020-06-27"));
            Assert.assertEquals((String)((Partition)((Optional)partitions.get("ds=2020-06-26")).get()).getStorage().getLocation(), (String)"path1");
            Assert.assertEquals((String)((String)((Partition)((Optional)partitions.get("ds=2020-06-26")).get()).getParameters().get("test.extra.metadata")), (String)"test_algo");
            Assert.assertEquals((String)((String)((Partition)((Optional)partitions.get("ds=2020-06-27")).get()).getParameters().get("test.extra.metadata")), (String)"test_algo");
            HiveMetadata overrideHiveMetadata = this.metadataFactory.get();
            insertTableHandle = overrideHiveMetadata.beginInsert(SESSION, (ConnectorTableHandle)new HiveTableHandle(TEST_DB_NAME, tableName));
            partitionUpdates = ImmutableList.of((Object)new PartitionUpdate("ds=2020-06-26", PartitionUpdate.UpdateMode.OVERWRITE, "path3", "path3", (List)ImmutableList.of(), 0L, 0L, 0L, false));
            overrideHiveMetadata.finishInsert(SESSION, (ConnectorInsertTableHandle)insertTableHandle, (Collection)partitionUpdates.stream().map(update -> Slices.utf8Slice((String)PARTITION_CODEC.toJson(update))).collect(ImmutableList.toImmutableList()), (Collection)ImmutableList.of());
            overrideHiveMetadata.commit();
            partitions = this.metastore.getPartitionsByNames(HiveQueryRunner.METASTORE_CONTEXT, TEST_DB_NAME, tableName, (List)ImmutableList.of((Object)"ds=2020-06-26"));
            Assert.assertEquals((String)((Partition)((Optional)partitions.get("ds=2020-06-26")).get()).getStorage().getLocation(), (String)"path3");
            Assert.assertEquals((String)((String)((Partition)((Optional)partitions.get("ds=2020-06-26")).get()).getParameters().get("test.extra.metadata")), (String)"test_algo");
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="For encrypted tables, partition format \\(ORC\\) should match table format \\(DWRF\\).*")
    public void testTableCreationWithInsertIntoNonDwrfPartition() {
        String tableName = "test_enc_with_create_partitioned_table_insert_non_dwrf_partition";
        TestingConnectorSession session = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setRespectTableFormat(false).setHiveStorageFormat(HiveStorageFormat.ORC), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:t_struct.str")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            HiveMetadata createHiveMetadata = this.metadataFactory.get();
            createHiveMetadata.beginCreateTable((ConnectorSession)session, table, Optional.empty());
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="For encrypted tables, partition format \\(ORC\\) should match table format \\(DWRF\\).*")
    public void testFailureWithInsertIntoPartitionedTableWithNonDwrfPartition() {
        String tableName = "test_enc_with_insert_partitioned_table_non_dwrf_partition";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:t_struct.str")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            HiveMetadata createHiveMetadata = this.metadataFactory.get();
            createHiveMetadata.createTable(SESSION, table, false);
            createHiveMetadata.commit();
            HiveMetadata insertHiveMetadata = this.metadataFactory.get();
            TestingConnectorSession newSession = new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setRespectTableFormat(false).setHiveStorageFormat(HiveStorageFormat.ORC), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
            insertHiveMetadata.beginInsert((ConnectorSession)newSession, (ConnectorTableHandle)new HiveTableHandle(TEST_DB_NAME, tableName));
        }
        finally {
            this.dropTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Inserting into an existing partition with encryption enabled is not supported yet")
    public void testInsertIntoExistingPartition() {
        String tableName = "test_enc_with_insert_existing_partition";
        ConnectorTableMetadata table = TestHiveMetadataFileFormatEncryptionSettings.getConnectorTableMetadata(tableName, (Map<String, Object>)ImmutableMap.of((Object)"encrypt_columns", (Object)ColumnEncryptionInformation.fromTableProperty((Object)ImmutableList.of((Object)"key1:t_struct.str")), (Object)"dwrf_encryption_algorithm", (Object)"test_algo", (Object)"dwrf_encryption_provider", (Object)"test_provider"), true);
        try {
            HiveMetadata createHiveMetadata = this.metadataFactory.get();
            createHiveMetadata.createTable(SESSION, table, false);
            HiveInsertTableHandle insertTableHandle = createHiveMetadata.beginInsert(SESSION, (ConnectorTableHandle)new HiveTableHandle(TEST_DB_NAME, tableName));
            ImmutableList partitionUpdates = ImmutableList.of((Object)new PartitionUpdate("ds=2020-06-26", PartitionUpdate.UpdateMode.NEW, "path1", "path1", (List)ImmutableList.of(), 0L, 0L, 0L, false));
            createHiveMetadata.finishInsert(SESSION, (ConnectorInsertTableHandle)insertTableHandle, (Collection)partitionUpdates.stream().map(update -> Slices.utf8Slice((String)PARTITION_CODEC.toJson(update))).collect(ImmutableList.toImmutableList()), (Collection)ImmutableList.of());
            createHiveMetadata.commit();
            HiveMetadata appendHiveMetadata = this.metadataFactory.get();
            insertTableHandle = appendHiveMetadata.beginInsert(SESSION, (ConnectorTableHandle)new HiveTableHandle(TEST_DB_NAME, tableName));
            partitionUpdates = ImmutableList.of((Object)new PartitionUpdate("ds=2020-06-26", PartitionUpdate.UpdateMode.APPEND, "path3", "path3", (List)ImmutableList.of(), 0L, 0L, 0L, false));
            appendHiveMetadata.finishInsert(SESSION, (ConnectorInsertTableHandle)insertTableHandle, (Collection)partitionUpdates.stream().map(update -> Slices.utf8Slice((String)PARTITION_CODEC.toJson(update))).collect(ImmutableList.toImmutableList()), (Collection)ImmutableList.of());
        }
        finally {
            this.dropTable(tableName);
        }
    }
}

