/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveMetadataUpdateHandle;
import com.facebook.presto.hive.HiveMetadataUpdater;
import com.facebook.presto.hive.TestHiveMetadataUpdateHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveMetadataUpdater {
    public static final String TEST_FILE_NAME = "fileName";
    private static final int TEST_WRITER_INDEX = 0;
    private static final Executor EXECUTOR = Executors.newFixedThreadPool(5);

    @Test
    public void testEmptyMetadataUpdateRequestQueue() {
        HiveMetadataUpdater hiveMetadataUpdater = new HiveMetadataUpdater(EXECUTOR);
        Assert.assertEquals((int)hiveMetadataUpdater.getPendingMetadataUpdateRequests().size(), (int)0);
    }

    @Test
    public void testAddMetadataUpdateRequest() {
        HiveMetadataUpdater hiveMetadataUpdater = new HiveMetadataUpdater(EXECUTOR);
        hiveMetadataUpdater.addMetadataUpdateRequest("schema", "table", Optional.of("partition_name"), 0);
        List hiveMetadataUpdateRequests = hiveMetadataUpdater.getPendingMetadataUpdateRequests();
        Assert.assertEquals((int)hiveMetadataUpdateRequests.size(), (int)1);
        HiveMetadataUpdateHandle request = (HiveMetadataUpdateHandle)hiveMetadataUpdateRequests.get(0);
        Assert.assertEquals((Object)request.getSchemaTableName(), (Object)TestHiveMetadataUpdateHandle.TEST_SCHEMA_TABLE_NAME);
        Assert.assertEquals((Object)request.getPartitionName(), Optional.of("partition_name"));
    }

    @Test
    public void testSetMetadataUpdateResults() {
        HiveMetadataUpdater hiveMetadataUpdater = new HiveMetadataUpdater(EXECUTOR);
        hiveMetadataUpdater.addMetadataUpdateRequest("schema", "table", Optional.of("partition_name"), 0);
        List hiveMetadataUpdateRequests = hiveMetadataUpdater.getPendingMetadataUpdateRequests();
        Assert.assertEquals((int)hiveMetadataUpdateRequests.size(), (int)1);
        HiveMetadataUpdateHandle request = (HiveMetadataUpdateHandle)hiveMetadataUpdateRequests.get(0);
        HiveMetadataUpdateHandle hiveMetadataUpdateResult = new HiveMetadataUpdateHandle(request.getRequestId(), request.getSchemaTableName(), request.getPartitionName(), Optional.of(TEST_FILE_NAME));
        hiveMetadataUpdater.setMetadataUpdateResults((List)ImmutableList.of((Object)hiveMetadataUpdateResult));
        try {
            String fileName = (String)hiveMetadataUpdater.getMetadataResult(0).get();
            Assert.assertEquals((String)fileName, (String)TEST_FILE_NAME);
            Assert.assertEquals((int)hiveMetadataUpdater.getPendingMetadataUpdateRequests().size(), (int)0);
        }
        catch (InterruptedException | ExecutionException e) {
            Assert.fail((String)"Expected to succeed and get the fileName metadata result");
        }
    }
}

