/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.AbstractTestHiveClient;
import com.facebook.presto.hive.CacheQuotaRequirement;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveEventClient;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveLocationService;
import com.facebook.presto.hive.HiveOutputTableHandle;
import com.facebook.presto.hive.HivePageSinkProvider;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveWriterStats;
import com.facebook.presto.hive.LocationHandle;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.TestHiveUtil;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HivePageSinkMetadata;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.TestingNodeManager;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.slice.Slices;
import io.airlift.tpch.LineItem;
import io.airlift.tpch.LineItemColumn;
import io.airlift.tpch.LineItemGenerator;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchColumnTypes;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.annotations.Test;

public class TestHivePageSink {
    private static final int NUM_ROWS = 1000;
    private static final String CLIENT_ID = "client_id";
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllFormats() throws Exception {
        HiveClientConfig config = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        File tempDir = Files.createTempDir();
        try {
            FileHiveMetastore metastore = TestHiveUtil.createTestingFileHiveMetastore(new File(tempDir, "metastore"));
            for (HiveStorageFormat format : this.getSupportedHiveStorageFormats()) {
                config.setHiveStorageFormat(format);
                config.setCompressionCodec(HiveCompressionCodec.NONE);
                long uncompressedLength = TestHivePageSink.writeTestFile(config, metastoreClientConfig, (ExtendedHiveMetastore)metastore, TestHivePageSink.makeFileName(tempDir, config));
                Assertions.assertGreaterThan((Comparable)Long.valueOf(uncompressedLength), (Comparable)Long.valueOf(0L));
                for (HiveCompressionCodec codec : HiveCompressionCodec.values()) {
                    if (codec == HiveCompressionCodec.NONE || !codec.isSupportedStorageFormat(format)) continue;
                    config.setCompressionCodec(codec);
                    long length = TestHivePageSink.writeTestFile(config, metastoreClientConfig, (ExtendedHiveMetastore)metastore, TestHivePageSink.makeFileName(tempDir, config));
                    org.testng.Assert.assertTrue((uncompressedLength > length ? 1 : 0) != 0, (String)String.format("%s with %s compressed to %s which is not less than %s", format, codec, length, uncompressedLength));
                }
            }
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    protected List<HiveStorageFormat> getSupportedHiveStorageFormats() {
        return (List)Arrays.stream(HiveStorageFormat.values()).filter(format -> format != HiveStorageFormat.CSV && format != HiveStorageFormat.ALPHA).collect(ImmutableList.toImmutableList());
    }

    private static String makeFileName(File tempDir, HiveClientConfig config) {
        return tempDir.getAbsolutePath() + "/" + config.getHiveStorageFormat().name() + "." + config.getCompressionCodec().name();
    }

    private static long writeTestFile(HiveClientConfig config, MetastoreClientConfig metastoreClientConfig, ExtendedHiveMetastore metastore, String outputPath) {
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        HiveWriterStats stats = new HiveWriterStats();
        ConnectorPageSink pageSink = TestHivePageSink.createPageSink(transaction, config, metastoreClientConfig, metastore, new org.apache.hadoop.fs.Path("file:///" + outputPath), stats);
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        List<Type> columnTypes = columns.stream().map(LineItemColumn::getType).map(TestHivePageSink::getHiveType).map(hiveType -> hiveType.getType((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER)).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(columnTypes);
        int rows = 0;
        for (LineItem lineItem : new LineItemGenerator(0.01, 1, 1)) {
            if (++rows >= 1000) break;
            pageBuilder.declarePosition();
            block8: for (int i = 0; i < columns.size(); ++i) {
                LineItemColumn column = columns.get(i);
                BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                switch (column.getType().getBase()) {
                    case IDENTIFIER: {
                        BigintType.BIGINT.writeLong(blockBuilder, column.getIdentifier(lineItem));
                        continue block8;
                    }
                    case INTEGER: {
                        IntegerType.INTEGER.writeLong(blockBuilder, (long)column.getInteger(lineItem));
                        continue block8;
                    }
                    case DATE: {
                        DateType.DATE.writeLong(blockBuilder, (long)column.getDate(lineItem));
                        continue block8;
                    }
                    case DOUBLE: {
                        DoubleType.DOUBLE.writeDouble(blockBuilder, column.getDouble(lineItem));
                        continue block8;
                    }
                    case VARCHAR: {
                        VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)column.getString(lineItem)));
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type " + column.getType());
                    }
                }
            }
        }
        Page page = pageBuilder.build();
        pageSink.appendPage(page);
        MoreFutures.getFutureValue((Future)pageSink.finish());
        File outputDir = new File(outputPath);
        ImmutableList files = ImmutableList.copyOf((Object[])outputDir.listFiles((dir, name) -> !name.endsWith(".crc")));
        File outputFile = (File)Iterables.getOnlyElement((Iterable)files);
        long length = outputFile.length();
        ConnectorPageSource pageSource = TestHivePageSink.createPageSource(transaction, config, metastoreClientConfig, outputFile);
        ArrayList<Page> pages = new ArrayList<Page>();
        while (!pageSource.isFinished()) {
            Page nextPage = pageSource.getNextPage();
            if (nextPage == null) continue;
            pages.add(nextPage.getLoadedPage());
        }
        MaterializedResult expectedResults = TestHivePageSink.toMaterializedResult((ConnectorSession)TestHivePageSink.getSession(config), columnTypes, (List<Page>)ImmutableList.of((Object)page));
        MaterializedResult results = TestHivePageSink.toMaterializedResult((ConnectorSession)TestHivePageSink.getSession(config), columnTypes, pages);
        Assert.assertEquals((Iterable)results, (Iterable)expectedResults);
        Assert.assertEquals((long)stats.getInputPageSizeInBytes().getAllTime().getMax(), (long)page.getRetainedSizeInBytes());
        return length;
    }

    public static MaterializedResult toMaterializedResult(ConnectorSession session, List<Type> types, List<Page> pages) {
        MaterializedResult.Builder resultBuilder = MaterializedResult.resultBuilder((ConnectorSession)session, types);
        for (Page outputPage : pages) {
            resultBuilder.page(outputPage);
        }
        return resultBuilder.build();
    }

    private static ConnectorPageSource createPageSource(HiveTransactionHandle transaction, HiveClientConfig config, MetastoreClientConfig metastoreClientConfig, File outputFile) {
        HiveFileSplit fileSplit = new HiveFileSplit("file:///" + outputFile.getAbsolutePath(), 0L, outputFile.length(), outputFile.length(), outputFile.lastModified(), Optional.empty(), (Map)ImmutableMap.of());
        HiveSplit split = new HiveSplit(fileSplit, "test", "test", "", new Storage(StorageFormat.create((String)config.getHiveStorageFormat().getSerDe(), (String)config.getHiveStorageFormat().getInputFormat(), (String)config.getHiveStorageFormat().getOutputFormat()), "location", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.empty(), OptionalInt.empty(), NodeSelectionStrategy.NO_PREFERENCE, TestHivePageSink.getColumnHandles().size(), TableToPartitionMapping.empty(), Optional.empty(), false, CacheQuotaRequirement.NO_CACHE_REQUIREMENT, Optional.empty(), (Set)ImmutableSet.of(), SplitWeight.standard());
        HiveTableLayoutHandle layoutHandle = new HiveTableLayoutHandle.Builder().setSchemaTableName(new SchemaTableName("test", "test")).setTablePath("path").setPartitionColumns((List)ImmutableList.of()).setDataColumns((List)TestHivePageSink.getColumnHandles().stream().map(column -> new Column(column.getName(), column.getHiveType(), Optional.empty(), Optional.empty())).collect(ImmutableList.toImmutableList())).setTableParameters((Map)ImmutableMap.of()).setDomainPredicate(TupleDomain.all()).setRemainingPredicate((RowExpression)LogicalRowExpressions.TRUE_CONSTANT).setPredicateColumns((Map)ImmutableMap.of()).setPartitionColumnPredicate(TupleDomain.all()).setBucketHandle(Optional.empty()).setBucketFilter(Optional.empty()).setPushdownFilterEnabled(false).setLayoutString("layout").setRequestedColumns(Optional.empty()).setPartialAggregationsPushedDown(false).setAppendRowNumberEnabled(false).setPartitions(Optional.empty()).setHiveTableHandle(Optional.empty()).build();
        TableHandle tableHandle = new TableHandle(new ConnectorId("hive"), (ConnectorTableHandle)new HiveTableHandle("test", "test"), (ConnectorTransactionHandle)transaction, Optional.of(layoutHandle));
        HivePageSourceProvider provider = new HivePageSourceProvider(config, HiveTestUtils.createTestHdfsEnvironment(config, metastoreClientConfig), HiveTestUtils.getDefaultHiveRecordCursorProvider(config, metastoreClientConfig), HiveTestUtils.getDefaultHiveBatchPageSourceFactories(config, metastoreClientConfig), HiveTestUtils.getDefaultHiveSelectivePageSourceFactories(config, metastoreClientConfig), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.ROW_EXPRESSION_SERVICE);
        return provider.createPageSource((ConnectorTransactionHandle)transaction, (ConnectorSession)TestHivePageSink.getSession(config), (ConnectorSplit)split, (ConnectorTableLayoutHandle)tableHandle.getLayout().get(), (List)ImmutableList.copyOf(TestHivePageSink.getColumnHandles()), SplitContext.NON_CACHEABLE);
    }

    private static ConnectorPageSink createPageSink(HiveTransactionHandle transaction, HiveClientConfig config, MetastoreClientConfig metastoreClientConfig, ExtendedHiveMetastore metastore, org.apache.hadoop.fs.Path outputPath, HiveWriterStats stats) {
        LocationHandle locationHandle = new LocationHandle(outputPath, outputPath, Optional.empty(), LocationHandle.TableType.NEW, LocationHandle.WriteMode.DIRECT_TO_TARGET_NEW_DIRECTORY);
        HiveOutputTableHandle handle = new HiveOutputTableHandle("test", "test", TestHivePageSink.getColumnHandles(), new HivePageSinkMetadata(new SchemaTableName("test", "test"), metastore.getTable(HiveQueryRunner.METASTORE_CONTEXT, "test", "test"), (Map)ImmutableMap.of()), locationHandle, config.getHiveStorageFormat(), config.getHiveStorageFormat(), config.getHiveStorageFormat(), config.getCompressionCodec(), (List)ImmutableList.of(), Optional.empty(), (List)ImmutableList.of(), "test", (Map)ImmutableMap.of(), Optional.empty());
        HdfsEnvironment hdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(config, metastoreClientConfig);
        HivePageSinkProvider provider = new HivePageSinkProvider(HiveTestUtils.getDefaultHiveFileWriterFactories(config, metastoreClientConfig), hdfsEnvironment, HiveTestUtils.PAGE_SORTER, metastore, (PageIndexerFactory)new GroupByHashPageIndexerFactory(new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig())), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, config, metastoreClientConfig, (LocationService)new HiveLocationService(hdfsEnvironment), HiveTestUtils.PARTITION_UPDATE_CODEC, HiveTestUtils.PARTITION_UPDATE_SMILE_CODEC, (NodeManager)new TestingNodeManager("fake-environment"), (EventClient)new HiveEventClient(), new HiveSessionProperties(config, new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()), stats, HiveTestUtils.getDefaultOrcFileWriterFactory(config, metastoreClientConfig), (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        return provider.createPageSink((ConnectorTransactionHandle)transaction, (ConnectorSession)TestHivePageSink.getSession(config), (ConnectorOutputTableHandle)handle, AbstractTestHiveClient.TEST_HIVE_PAGE_SINK_CONTEXT);
    }

    private static TestingConnectorSession getSession(HiveClientConfig config) {
        return new TestingConnectorSession(new HiveSessionProperties(config, new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties());
    }

    public static List<HiveColumnHandle> getColumnHandles() {
        ImmutableList.Builder handles = ImmutableList.builder();
        List<LineItemColumn> columns = TestHivePageSink.getTestColumns();
        for (int i = 0; i < columns.size(); ++i) {
            LineItemColumn column = columns.get(i);
            HiveType hiveType = TestHivePageSink.getHiveType(column.getType());
            handles.add((Object)new HiveColumnHandle(column.getColumnName(), hiveType, hiveType.getTypeSignature(), i, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        }
        return handles.build();
    }

    private static List<LineItemColumn> getTestColumns() {
        return Stream.of(LineItemColumn.values()).filter(column -> !column.getType().equals((Object)TpchColumnTypes.DATE)).collect(Collectors.toList());
    }

    private static HiveType getHiveType(TpchColumnType type) {
        switch (type.getBase()) {
            case IDENTIFIER: {
                return HiveType.HIVE_LONG;
            }
            case INTEGER: {
                return HiveType.HIVE_INT;
            }
            case DATE: {
                return HiveType.HIVE_DATE;
            }
            case DOUBLE: {
                return HiveType.HIVE_DOUBLE;
            }
            case VARCHAR: {
                return HiveType.HIVE_STRING;
            }
        }
        throw new UnsupportedOperationException();
    }
}

