/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.TestingTypeManager;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.CacheQuota;
import com.facebook.presto.hive.CacheQuotaRequirement;
import com.facebook.presto.hive.CacheQuotaScope;
import com.facebook.presto.hive.EncryptionInformation;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HivePageSource;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.TestHivePageSink;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public class TestHivePageSourceProvider {
    private static final String SCHEMA_NAME = "schema";
    private static final String TABLE_NAME = "table";
    private static final String PARTITION_NAME = "partition";

    @Test
    public void testGenerateCacheQuota() {
        HiveClientConfig config = new HiveClientConfig();
        HiveFileSplit fileSplit = new HiveFileSplit("file://test", 0L, 10L, 10L, Instant.now().toEpochMilli(), Optional.empty(), (Map)ImmutableMap.of());
        HiveSplit split = new HiveSplit(fileSplit, SCHEMA_NAME, TABLE_NAME, PARTITION_NAME, new Storage(StorageFormat.create((String)config.getHiveStorageFormat().getSerDe(), (String)config.getHiveStorageFormat().getInputFormat(), (String)config.getHiveStorageFormat().getOutputFormat()), "location", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.empty(), OptionalInt.empty(), NodeSelectionStrategy.NO_PREFERENCE, TestHivePageSink.getColumnHandles().size(), TableToPartitionMapping.empty(), Optional.empty(), false, CacheQuotaRequirement.NO_CACHE_REQUIREMENT, Optional.empty(), (Set)ImmutableSet.of(), SplitWeight.standard());
        CacheQuota cacheQuota = HivePageSourceProvider.generateCacheQuota((HiveSplit)split);
        CacheQuota expectedCacheQuota = new CacheQuota(".", Optional.empty());
        Assert.assertEquals((Object)cacheQuota, (Object)expectedCacheQuota);
        split = new HiveSplit(fileSplit, SCHEMA_NAME, TABLE_NAME, PARTITION_NAME, new Storage(StorageFormat.create((String)config.getHiveStorageFormat().getSerDe(), (String)config.getHiveStorageFormat().getInputFormat(), (String)config.getHiveStorageFormat().getOutputFormat()), "location", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (List)ImmutableList.of(), (List)ImmutableList.of(), OptionalInt.empty(), OptionalInt.empty(), NodeSelectionStrategy.NO_PREFERENCE, TestHivePageSink.getColumnHandles().size(), TableToPartitionMapping.empty(), Optional.empty(), false, new CacheQuotaRequirement(CacheQuotaScope.PARTITION, Optional.of(DataSize.succinctDataSize((double)1.0, (DataSize.Unit)DataSize.Unit.MEGABYTE))), Optional.empty(), (Set)ImmutableSet.of(), SplitWeight.standard());
        cacheQuota = HivePageSourceProvider.generateCacheQuota((HiveSplit)split);
        expectedCacheQuota = new CacheQuota("schema.table.partition", Optional.of(DataSize.succinctDataSize((double)1.0, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
        Assert.assertEquals((Object)cacheQuota, (Object)expectedCacheQuota);
    }

    @Test
    public void testUseRecordReaderWithInputFormatAnnotationAndCustomSplit() {
        StorageFormat storageFormat = StorageFormat.create((String)ParquetHiveSerDe.class.getName(), (String)HoodieParquetInputFormat.class.getName(), (String)"");
        Storage storage = new Storage(storageFormat, "test", Optional.empty(), true, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        ImmutableMap customSplitInfo = ImmutableMap.of((Object)"custom_split_class", (Object)HoodieRealtimeFileSplit.class.getName(), (Object)"hudi_basepath", (Object)"/test/file.parquet", (Object)"hudi_delta_filepaths", (Object)"/test/.file_100.log", (Object)"hudi_max_commit_time", (Object)"100");
        MockHiveRecordCursorProvider recordCursorProvider = new MockHiveRecordCursorProvider();
        MockHiveBatchPageSourceFactory hiveBatchPageSourceFactory = new MockHiveBatchPageSourceFactory();
        HiveFileSplit fileSplit = new HiveFileSplit("/test/", 0L, 100L, 200L, Instant.now().toEpochMilli(), Optional.empty(), (Map)customSplitInfo);
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)recordCursorProvider), (Set)ImmutableSet.of((Object)hiveBatchPageSourceFactory), (Configuration)new Configuration(), (ConnectorSession)new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setUseRecordPageSourceForCustomSplit(true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties()), (HiveFileSplit)fileSplit, (OptionalInt)OptionalInt.empty(), (Storage)storage, (TupleDomain)TupleDomain.none(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (DateTimeZone)DateTimeZone.UTC, (TypeManager)new TestingTypeManager(), (SchemaTableName)new SchemaTableName("test", "test"), (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (int)0, (TableToPartitionMapping)TableToPartitionMapping.empty(), Optional.empty(), (boolean)false, null, null, (boolean)false, null, Optional.empty());
        org.testng.Assert.assertTrue((boolean)pageSource.isPresent());
        org.testng.Assert.assertTrue((boolean)(pageSource.get() instanceof RecordPageSource));
    }

    @Test
    public void testNotUseRecordReaderWithInputFormatAnnotationWithoutCustomSplit() {
        StorageFormat storageFormat = StorageFormat.create((String)ParquetHiveSerDe.class.getName(), (String)HoodieParquetInputFormat.class.getName(), (String)"");
        Storage storage = new Storage(storageFormat, "test", Optional.empty(), true, (Map)ImmutableMap.of(), (Map)ImmutableMap.of());
        MockHiveRecordCursorProvider recordCursorProvider = new MockHiveRecordCursorProvider();
        MockHiveBatchPageSourceFactory hiveBatchPageSourceFactory = new MockHiveBatchPageSourceFactory();
        HiveFileSplit fileSplit = new HiveFileSplit("/test/", 0L, 100L, 200L, Instant.now().toEpochMilli(), Optional.empty(), (Map)ImmutableMap.of());
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)recordCursorProvider), (Set)ImmutableSet.of((Object)hiveBatchPageSourceFactory), (Configuration)new Configuration(), (ConnectorSession)new TestingConnectorSession(new HiveSessionProperties(new HiveClientConfig().setUseRecordPageSourceForCustomSplit(true), new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties()), (HiveFileSplit)fileSplit, (OptionalInt)OptionalInt.empty(), (Storage)storage, (TupleDomain)TupleDomain.none(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (List)ImmutableList.of(), (DateTimeZone)DateTimeZone.UTC, (TypeManager)new TestingTypeManager(), (SchemaTableName)new SchemaTableName("test", "test"), (List)ImmutableList.of(), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (int)0, (TableToPartitionMapping)TableToPartitionMapping.empty(), Optional.empty(), (boolean)false, null, null, (boolean)false, null, Optional.empty());
        org.testng.Assert.assertTrue((boolean)pageSource.isPresent());
        org.testng.Assert.assertTrue((boolean)(pageSource.get() instanceof HivePageSource));
    }

    static class MockRecordCursor
    implements RecordCursor {
        MockRecordCursor() {
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return null;
        }

        public boolean advanceNextPosition() {
            return false;
        }

        public boolean getBoolean(int field) {
            return false;
        }

        public long getLong(int field) {
            return 0L;
        }

        public double getDouble(int field) {
            return 0.0;
        }

        public Slice getSlice(int field) {
            return null;
        }

        public Object getObject(int field) {
            return null;
        }

        public boolean isNull(int field) {
            return false;
        }

        public void close() {
        }
    }

    static class MockHiveRecordCursorProvider
    implements HiveRecordCursorProvider {
        MockHiveRecordCursorProvider() {
        }

        public Optional<RecordCursor> createRecordCursor(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, boolean s3SelectPushdownEnabled) {
            return Optional.of(new MockRecordCursor());
        }
    }

    static class MockPageSource
    implements ConnectorPageSource {
        MockPageSource() {
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getCompletedPositions() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public boolean isFinished() {
            return false;
        }

        public Page getNextPage() {
            return null;
        }

        public long getSystemMemoryUsage() {
            return 0L;
        }

        public void close() throws IOException {
        }
    }

    static class MockHiveBatchPageSourceFactory
    implements HiveBatchPageSourceFactory {
        MockHiveBatchPageSourceFactory() {
        }

        public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, HiveFileSplit fileSplit, Storage storage, SchemaTableName tableName, Map<String, String> tableParameters, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone, HiveFileContext hiveFileContext, Optional<EncryptionInformation> encryptionInformation) {
            return Optional.of(new MockPageSource());
        }
    }
}

