/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.testing.assertions.Assert;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import io.airlift.tpch.TpchTable;
import org.testng.annotations.Test;

public class TestHiveSpillingWithExchangeMaterialization
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createMaterializingAndSpillingQueryRunner(TpchTable.getTables());
    }

    @Test
    public void testJoin() {
        this.assertQuery("SELECT orderstatus FROM lineitem JOIN orders on lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testOrderBy() {
        this.assertQueryOrdered("SELECT orderstatus FROM orders ORDER BY orderstatus");
    }

    @Test
    public void testAggregation() {
        this.assertQuery("SELECT custkey, orderpriority, sum(custkey), array_agg(DISTINCT orderpriority ORDER BY orderpriority) FROM orders GROUP BY custkey, orderpriority ORDER BY 1, 2");
    }

    @Test
    public void testWindow() {
        MaterializedResult actual = this.computeActual("SELECT RANK() OVER (PARTITION BY orderdate ORDER BY COUNT(DISTINCT clerk)) rnk FROM orders GROUP BY orderdate, custkey ORDER BY rnk LIMIT 1");
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{BigintType.BIGINT}).row(new Object[]{1L}).build();
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }
}

