/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.SortedRangeSet;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.CacheQuotaRequirementProvider;
import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.ColumnConverterProvider;
import com.facebook.presto.hive.ConfigBasedCacheQuotaRequirementProvider;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveCoercionPolicy;
import com.facebook.presto.hive.HiveColumnConverterProvider;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveDirectoryContext;
import com.facebook.presto.hive.HiveEncryptionInformationProvider;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.HiveFileRenamer;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveLocationService;
import com.facebook.presto.hive.HiveMetadataFactory;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HivePartitionManager;
import com.facebook.presto.hive.HivePartitionObjectBuilder;
import com.facebook.presto.hive.HivePartitionStats;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitManager;
import com.facebook.presto.hive.HiveStagingFileCommitter;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveTransactionHandle;
import com.facebook.presto.hive.HiveTransactionManager;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.HiveZeroRowFileCreator;
import com.facebook.presto.hive.LocationService;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.OrcFileWriterConfig;
import com.facebook.presto.hive.ParquetFileWriterConfig;
import com.facebook.presto.hive.PartitionObjectBuilder;
import com.facebook.presto.hive.StagingFileCommitter;
import com.facebook.presto.hive.TableParameterCodec;
import com.facebook.presto.hive.TransactionalMetadata;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.ZeroRowFileCreator;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.datasink.DataSinkFactory;
import com.facebook.presto.hive.datasink.OutputStreamDataSinkFactory;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.MetastoreContext;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PartitionStatistics;
import com.facebook.presto.hive.metastore.PartitionWithStatistics;
import com.facebook.presto.hive.metastore.PrestoTableType;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.UnimplementedHiveMetastore;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHiveSplitManager {
    private static final int MAX_PARTITION_KEY_COLUMN_INDEX = -13;
    private static final ConnectorSplitManager.SplitSchedulingContext SPLIT_SCHEDULING_CONTEXT = new ConnectorSplitManager.SplitSchedulingContext(ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING, false, WarningCollector.NOOP);
    private static final HiveType LONT_DECIMAL = HiveType.valueOf((String)"decimal(38,10)");
    private static final HiveType SHORT_DECIMAL = HiveType.valueOf((String)"decimal(10,0)");
    private static final List<Column> COLUMNS = ImmutableList.of((Object)new Column("t_tinyint", HiveType.HIVE_BYTE, Optional.empty(), Optional.empty()), (Object)new Column("t_smallint", HiveType.HIVE_SHORT, Optional.empty(), Optional.empty()), (Object)new Column("t_int", HiveType.HIVE_INT, Optional.empty(), Optional.empty()), (Object)new Column("t_bigint", HiveType.HIVE_LONG, Optional.empty(), Optional.empty()), (Object)new Column("t_float", HiveType.HIVE_FLOAT, Optional.empty(), Optional.empty()), (Object)new Column("t_double", HiveType.HIVE_DOUBLE, Optional.empty(), Optional.empty()), (Object)new Column("t_short_decimal", SHORT_DECIMAL, Optional.empty(), Optional.empty()), (Object)new Column("t_long_decimal", LONT_DECIMAL, Optional.empty(), Optional.empty()), (Object)new Column("t_date", HiveType.HIVE_DATE, Optional.empty(), Optional.empty()));
    private static final String PARTITION_VALUE = "2020-01-01";
    private static final String PARTITION_NAME = "ds=2020-01-01";
    private static final Table TEST_TABLE = new Table("test_db", "test_table", "test_owner", PrestoTableType.MANAGED_TABLE, new Storage(StorageFormat.VIEW_STORAGE_FORMAT, "", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), COLUMNS, (List)ImmutableList.of((Object)new Column("ds", HiveType.HIVE_STRING, Optional.empty(), Optional.empty())), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty());
    private ListeningExecutorService executor;

    @BeforeClass
    public void setUp() {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10, Threads.daemonThreadsNamed((String)"test-hive-split-manager-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void shutdown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testPartitionStatsBasedOptimizationForInteger() throws Exception {
        this.testPartitionStatsBasedOptimizationForInteger("t_tinyint", (Type)TinyintType.TINYINT, HiveType.HIVE_BYTE);
        this.testPartitionStatsBasedOptimizationForInteger("t_smallint", (Type)SmallintType.SMALLINT, HiveType.HIVE_SHORT);
        this.testPartitionStatsBasedOptimizationForInteger("t_int", (Type)IntegerType.INTEGER, HiveType.HIVE_INT);
        this.testPartitionStatsBasedOptimizationForInteger("t_bigint", (Type)BigintType.BIGINT, HiveType.HIVE_LONG);
    }

    private void testPartitionStatsBasedOptimizationForInteger(String columnName, Type type, HiveType hiveType) throws Exception {
        HiveColumnHandle columnHandle = new HiveColumnHandle(columnName, hiveType, type.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        Range partitionRange = Range.range((Type)type, (Object)10L, (boolean)true, (Object)20L, (boolean)true);
        this.assertRedundantColumnDomains(partitionRange, PartitionStatistics.empty(), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createIntegerPartitionStatistics(5L, 25L, columnName), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createIntegerPartitionStatistics(1L, 3L, columnName), (List<Set<ColumnHandle>>)ImmutableList.of(), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createIntegerPartitionStatistics(13L, 15L, columnName), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of((Object)columnHandle)), columnHandle);
    }

    private PartitionStatistics createIntegerPartitionStatistics(long min, long max, String columnName) {
        return PartitionStatistics.builder().setColumnStatistics((Map)ImmutableMap.of((Object)columnName, (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(min), (OptionalLong)OptionalLong.of(max), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.of(max - min + 1L)))).build();
    }

    @Test
    public void testPartitionStatsBasedOptimizationForReal() throws Exception {
        RealType type = RealType.REAL;
        Range partitionRange = Range.range((Type)type, (Object)Float.floatToIntBits(10.0f), (boolean)true, (Object)Float.floatToIntBits(20.0f), (boolean)true);
        HiveColumnHandle columnHandle = new HiveColumnHandle("t_real", HiveType.HIVE_FLOAT, type.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        this.assertRedundantColumnDomains(partitionRange, PartitionStatistics.empty(), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDoublePartitionStatistics(5.0, 25.0, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDoublePartitionStatistics(1.0, 3.0, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of(), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDoublePartitionStatistics(13.0, 15.0, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of((Object)columnHandle)), columnHandle);
    }

    @Test
    public void testPartitionStatsBasedOptimizationForDouble() throws Exception {
        DoubleType type = DoubleType.DOUBLE;
        Range partitionRange = Range.range((Type)type, (Object)10.0, (boolean)true, (Object)20.0, (boolean)true);
        HiveColumnHandle columnHandle = new HiveColumnHandle("t_double", HiveType.HIVE_DOUBLE, type.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        this.assertRedundantColumnDomains(partitionRange, PartitionStatistics.empty(), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDoublePartitionStatistics(5.0, 25.0, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDoublePartitionStatistics(1.0, 3.0, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of(), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDoublePartitionStatistics(13.0, 15.0, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of((Object)columnHandle)), columnHandle);
    }

    private PartitionStatistics createDoublePartitionStatistics(double min, double max, String columnName) {
        return PartitionStatistics.builder().setColumnStatistics((Map)ImmutableMap.of((Object)columnName, (Object)HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(min), (OptionalDouble)OptionalDouble.of(max), (OptionalLong)OptionalLong.of(0L), (OptionalLong)OptionalLong.empty()))).build();
    }

    @Test
    public void testPartitionStatsBasedOptimizationForDecimal() throws Exception {
        Type shortDecimal = HiveType.getPrimitiveType((PrimitiveTypeInfo)((PrimitiveTypeInfo)SHORT_DECIMAL.getTypeInfo()));
        this.testPartitionStatsBasedOptimizationForDecimal(Range.range((Type)shortDecimal, (Object)10L, (boolean)true, (Object)20L, (boolean)true), new HiveColumnHandle("t_short_decimal", SHORT_DECIMAL, shortDecimal.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        Type longDecimal = HiveType.getPrimitiveType((PrimitiveTypeInfo)((PrimitiveTypeInfo)LONT_DECIMAL.getTypeInfo()));
        this.testPartitionStatsBasedOptimizationForDecimal(Range.range((Type)longDecimal, (Object)Decimals.encodeScaledValue((BigDecimal)BigDecimal.valueOf(10L)), (boolean)true, (Object)Decimals.encodeScaledValue((BigDecimal)BigDecimal.valueOf(20L)), (boolean)true), new HiveColumnHandle("t_long_decimal", LONT_DECIMAL, longDecimal.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
    }

    private void testPartitionStatsBasedOptimizationForDecimal(Range partitionRange, HiveColumnHandle columnHandle) throws Exception {
        this.assertRedundantColumnDomains(partitionRange, PartitionStatistics.empty(), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDecimalPartitionStatistics(5L, 25L, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDecimalPartitionStatistics(1L, 3L, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of(), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDecimalPartitionStatistics(13L, 15L, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of((Object)columnHandle)), columnHandle);
    }

    private PartitionStatistics createDecimalPartitionStatistics(long min, long max, String columnName) {
        return PartitionStatistics.builder().setColumnStatistics((Map)ImmutableMap.of((Object)columnName, (Object)HiveColumnStatistics.createDecimalColumnStatistics(Optional.of(BigDecimal.valueOf(min)), Optional.of(BigDecimal.valueOf(max)), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build();
    }

    @Test
    public void testPartitionStatsBasedOptimizationForDate() throws Exception {
        DateType type = DateType.DATE;
        Range partitionRange = Range.range((Type)type, (Object)10L, (boolean)true, (Object)20L, (boolean)true);
        HiveColumnHandle columnHandle = new HiveColumnHandle("t_date", HiveType.HIVE_DATE, type.getTypeSignature(), 0, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
        this.assertRedundantColumnDomains(partitionRange, PartitionStatistics.empty(), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDatePartitionStatistics(5L, 25L, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of()), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDatePartitionStatistics(1L, 3L, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of(), columnHandle);
        this.assertRedundantColumnDomains(partitionRange, this.createDatePartitionStatistics(13L, 15L, columnHandle.getName()), (List<Set<ColumnHandle>>)ImmutableList.of((Object)ImmutableSet.of((Object)columnHandle)), columnHandle);
    }

    private PartitionStatistics createDatePartitionStatistics(long min, long max, String columnName) {
        return PartitionStatistics.builder().setColumnStatistics((Map)ImmutableMap.of((Object)columnName, (Object)HiveColumnStatistics.createDateColumnStatistics(Optional.of(LocalDate.ofEpochDay(min)), Optional.of(LocalDate.ofEpochDay(max)), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build();
    }

    private void assertRedundantColumnDomains(Range predicateRange, PartitionStatistics partitionStatistics, List<Set<ColumnHandle>> expectedRedundantColumnDomains, HiveColumnHandle columnHandle) throws Exception {
        TupleDomain queryTupleDomain = TupleDomain.fromColumnDomains(Optional.of(ImmutableList.of((Object)new TupleDomain.ColumnDomain((Object)columnHandle, Domain.create((ValueSet)SortedRangeSet.copyOf((Type)predicateRange.getType(), (List)ImmutableList.of((Object)predicateRange)), (boolean)false)))));
        PartitionWithStatistics partitionWithStatistics = new PartitionWithStatistics(new Partition("test_db", "test_table", (List)ImmutableList.of((Object)PARTITION_VALUE), new Storage(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC), "location", Optional.empty(), true, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), COLUMNS, (Map)ImmutableMap.of(), Optional.empty(), false, true, 0, 0L), PARTITION_NAME, partitionStatistics);
        HiveClientConfig hiveClientConfig = new HiveClientConfig().setPartitionStatisticsBasedOptimizationEnabled(true);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)new HiveHdfsConfiguration(new HdfsConfigurationInitializer(hiveClientConfig, new MetastoreClientConfig()), (Set)ImmutableSet.of(), hiveClientConfig), new MetastoreClientConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
        HiveMetadataFactory metadataFactory = new HiveMetadataFactory((ExtendedHiveMetastore)new TestingExtendedHiveMetastore(TEST_TABLE, partitionWithStatistics), hdfsEnvironment, new HivePartitionManager((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, hiveClientConfig), DateTimeZone.forOffsetHours((int)1), true, false, false, false, true, true, hiveClientConfig.getMaxPartitionBatchSize(), (long)hiveClientConfig.getMaxPartitionsPerScan(), false, 10000, (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, (LocationService)new HiveLocationService(hdfsEnvironment), HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.ROW_EXPRESSION_SERVICE, HiveTestUtils.FILTER_STATS_CALCULATOR_SERVICE, new TableParameterCodec(), HiveTestUtils.PARTITION_UPDATE_CODEC, HiveTestUtils.PARTITION_UPDATE_SMILE_CODEC, this.executor, (TypeTranslator)new HiveTypeTranslator(), (StagingFileCommitter)new HiveStagingFileCommitter(hdfsEnvironment, this.executor), (ZeroRowFileCreator)new HiveZeroRowFileCreator(hdfsEnvironment, (DataSinkFactory)new OutputStreamDataSinkFactory(), this.executor), "test_version", (PartitionObjectBuilder)new HivePartitionObjectBuilder(), new HiveEncryptionInformationProvider((List)ImmutableList.of()), new HivePartitionStats(), new HiveFileRenamer(), (ColumnConverterProvider)HiveColumnConverterProvider.DEFAULT_COLUMN_CONVERTER_PROVIDER);
        HiveSplitManager splitManager = new HiveSplitManager((HiveTransactionManager)new TestingHiveTransactionManager(metadataFactory), new NamenodeStats(), hdfsEnvironment, (DirectoryLister)new TestingDirectoryLister(), MoreExecutors.directExecutor(), (CoercionPolicy)new HiveCoercionPolicy((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER), new CounterStat(), 100, hiveClientConfig.getMaxOutstandingSplitsSize(), hiveClientConfig.getMinPartitionBatchSize(), hiveClientConfig.getMaxPartitionBatchSize(), hiveClientConfig.getSplitLoaderConcurrency(), false, (CacheQuotaRequirementProvider)new ConfigBasedCacheQuotaRequirementProvider(new CacheConfig()), new HiveEncryptionInformationProvider((List)ImmutableList.of()));
        HiveColumnHandle partitionColumn = new HiveColumnHandle("ds", HiveType.HIVE_STRING, TypeSignature.parseTypeSignature((String)"varchar"), -13, HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty(), Optional.empty());
        ImmutableList partitions = ImmutableList.of((Object)new HivePartition(new SchemaTableName("test_schema", "test_table"), PARTITION_NAME, (Map)ImmutableMap.of((Object)partitionColumn, (Object)NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)PARTITION_VALUE)))));
        TupleDomain domainPredicate = queryTupleDomain.transform(HiveColumnHandle.class::cast).transform(column -> new Subfield(column.getName(), (List)ImmutableList.of()));
        SchemaTableName schemaTableName = new SchemaTableName("test_schema", "test_table");
        HiveTableHandle hiveTableHandle = new HiveTableHandle(schemaTableName.getSchemaName(), schemaTableName.getTableName());
        HiveTableLayoutHandle layoutHandle = new HiveTableLayoutHandle.Builder().setSchemaTableName(schemaTableName).setTablePath("test_path").setPartitionColumns((List)ImmutableList.of((Object)partitionColumn)).setDataColumns(COLUMNS).setTableParameters((Map)ImmutableMap.of()).setDomainPredicate(domainPredicate).setRemainingPredicate((RowExpression)LogicalRowExpressions.TRUE_CONSTANT).setPredicateColumns((Map)ImmutableMap.of((Object)partitionColumn.getName(), (Object)partitionColumn, (Object)columnHandle.getName(), (Object)columnHandle)).setPartitionColumnPredicate(queryTupleDomain).setPartitions((List)partitions).setBucketHandle(Optional.empty()).setBucketFilter(Optional.empty()).setPushdownFilterEnabled(false).setLayoutString("layout").setRequestedColumns(Optional.empty()).setPartialAggregationsPushedDown(false).setAppendRowNumberEnabled(false).setHiveTableHandle(hiveTableHandle).build();
        ConnectorSplitSource splitSource = splitManager.getSplits((ConnectorTransactionHandle)new HiveTransactionHandle(), (ConnectorSession)new TestingConnectorSession(new HiveSessionProperties(hiveClientConfig, new OrcFileWriterConfig(), new ParquetFileWriterConfig(), new CacheConfig()).getSessionProperties()), (ConnectorTableLayoutHandle)layoutHandle, SPLIT_SCHEDULING_CONTEXT);
        List actualRedundantColumnDomains = (List)((ConnectorSplitSource.ConnectorSplitBatch)splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, 100).get()).getSplits().stream().map(HiveSplit.class::cast).map(HiveSplit::getRedundantColumnDomains).collect(ImmutableList.toImmutableList());
        Assert.assertEquals((Collection)actualRedundantColumnDomains, expectedRedundantColumnDomains);
    }

    private static class TestingDirectoryLister
    implements DirectoryLister {
        private TestingDirectoryLister() {
        }

        public Iterator<HiveFileInfo> list(ExtendedFileSystem fileSystem, Table table, Path path, Optional<Partition> partition, NamenodeStats namenodeStats, HiveDirectoryContext hiveDirectoryContext) {
            try {
                return ImmutableList.of((Object)HiveFileInfo.createHiveFileInfo((LocatedFileStatus)new LocatedFileStatus(new FileStatus(0L, false, 1, 0L, 0L, path), new BlockLocation[0]), Optional.empty())).iterator();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TestingExtendedHiveMetastore
    extends UnimplementedHiveMetastore {
        private final Table table;
        private final PartitionWithStatistics partitionWithStatistics;

        public TestingExtendedHiveMetastore(Table table, PartitionWithStatistics partitionWithStatistics) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.partitionWithStatistics = Objects.requireNonNull(partitionWithStatistics, "partitionWithStatistics is null");
        }

        public Optional<Table> getTable(MetastoreContext metastoreContext, String databaseName, String tableName) {
            return Optional.of(this.table);
        }

        public Map<String, Optional<Partition>> getPartitionsByNames(MetastoreContext metastoreContext, String databaseName, String tableName, List<String> partitionNames) {
            return ImmutableMap.of((Object)this.partitionWithStatistics.getPartitionName(), Optional.of(this.partitionWithStatistics.getPartition()));
        }

        public Map<String, PartitionStatistics> getPartitionStatistics(MetastoreContext metastoreContext, String databaseName, String tableName, Set<String> partitionNames) {
            return ImmutableMap.of((Object)this.partitionWithStatistics.getPartitionName(), (Object)this.partitionWithStatistics.getStatistics());
        }
    }

    private static class TestingHiveTransactionManager
    extends HiveTransactionManager {
        private final HiveMetadataFactory metadataFactory;

        public TestingHiveTransactionManager(HiveMetadataFactory metadataFactory) {
            this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        }

        public TransactionalMetadata get(ConnectorTransactionHandle transactionHandle) {
            return this.metadataFactory.get();
        }
    }
}

