/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.stats.CounterStat;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.hive.CacheQuotaRequirement;
import com.facebook.presto.hive.CacheQuotaScope;
import com.facebook.presto.hive.HivePartitionHandle;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveSplitPartitionInfo;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.TableToPartitionMapping;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveSplitSource {
    private static final Executor EXECUTOR = Executors.newFixedThreadPool(5);
    private static final Optional<DataSize> DEFAULT_QUOTA_SIZE = Optional.of(DataSize.succinctDataSize((double)2.0, (DataSize.Unit)DataSize.Unit.GIGABYTE));

    @Test
    public void testOutstandingSplitCount() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.TABLE, DEFAULT_QUOTA_SIZE), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        for (int i = 0; i < 10; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).size(), (int)1);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)9);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 4).size(), (int)4);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)5);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 20).size(), (int)5);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)0);
    }

    @Test
    public void testEvenlySizedSplitRemainder() {
        DataSize initialSplitSize = HiveSessionProperties.getMaxInitialSplitSize((ConnectorSession)HiveTestUtils.SESSION);
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.TABLE, DEFAULT_QUOTA_SIZE), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        DataSize fileSize = new DataSize((double)(initialSplitSize.toBytes() + 1L), DataSize.Unit.BYTE);
        long halfOfSize = fileSize.toBytes() / 2L;
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(1, OptionalInt.empty(), fileSize));
        HiveSplit first = (HiveSplit)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).get(0);
        Assert.assertEquals((long)first.getFileSplit().getLength(), (long)halfOfSize);
        HiveSplit second = (HiveSplit)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).get(0);
        Assert.assertEquals((long)second.getFileSplit().getLength(), (long)(fileSize.toBytes() - halfOfSize));
    }

    @Test
    public void testSplitCacheQuota() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.TABLE, DEFAULT_QUOTA_SIZE), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        for (int i = 0; i < 10; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        HiveSplit hiveSplit = (HiveSplit)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).get(0);
        CacheQuotaRequirement cacheQuotaRequirement = new CacheQuotaRequirement(CacheQuotaScope.TABLE, DEFAULT_QUOTA_SIZE);
        Assert.assertEquals((Object)hiveSplit.getCacheQuotaRequirement().getQuota(), (Object)cacheQuotaRequirement.getQuota());
        Assert.assertEquals((Object)hiveSplit.getCacheQuotaRequirement().getCacheQuotaScope(), (Object)cacheQuotaRequirement.getCacheQuotaScope());
        hiveSplitSource = HiveSplitSource.bucketed((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.PARTITION, Optional.empty()), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        for (int i = 0; i < 10; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i, OptionalInt.of(2)));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        hiveSplit = (HiveSplit)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(2), 1).get(0);
        cacheQuotaRequirement = new CacheQuotaRequirement(CacheQuotaScope.PARTITION, Optional.empty());
        Assert.assertEquals((Object)hiveSplit.getCacheQuotaRequirement().getQuota(), (Object)cacheQuotaRequirement.getQuota());
        Assert.assertEquals((Object)hiveSplit.getCacheQuotaRequirement().getCacheQuotaScope(), (Object)cacheQuotaRequirement.getCacheQuotaScope());
    }

    @Test
    public void testFail() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.GLOBAL, Optional.empty()), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        for (int i = 0; i < 5; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1).size(), (int)1);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        hiveSplitSource.fail((Throwable)new RuntimeException("test"));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        try {
            TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"test");
        }
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(99));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        hiveSplitSource.fail((Throwable)new RuntimeException("another failure"));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)4);
        try {
            TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderWaitsForSplits() throws Exception {
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.GLOBAL, Optional.empty()), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        SettableFuture splits = SettableFuture.create();
        CountDownLatch started = new CountDownLatch(1);
        Thread getterThread = new Thread(() -> {
            try {
                started.countDown();
                List<ConnectorSplit> batch = TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, 1);
                Assert.assertEquals((int)batch.size(), (int)1);
                splits.set((Object)batch.get(0));
            }
            catch (Throwable e) {
                splits.setException(e);
            }
        });
        getterThread.start();
        try {
            Assert.assertTrue((boolean)started.await(10L, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(200L);
            Assert.assertTrue((!splits.isDone() ? 1 : 0) != 0);
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(33));
            ConnectorSplit split = (ConnectorSplit)splits.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((int)((HiveSplit)split).getPartitionDataColumnCount(), (int)33);
        }
        finally {
            getterThread.interrupt();
        }
    }

    @Test
    public void testOutstandingSplitSize() {
        int i;
        DataSize maxOutstandingSplitsSize = new DataSize(1.0, DataSize.Unit.MEGABYTE);
        HiveSplitSource hiveSplitSource = HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.GLOBAL, Optional.empty()), (int)10, (int)10000, (DataSize)maxOutstandingSplitsSize, (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        TestSplit testSplit = new TestSplit(0);
        int testSplitSizeInBytes = testSplit.getEstimatedSizeInBytes() + testSplit.getPartitionInfo().getEstimatedSizeInBytes();
        int maxSplitCount = Math.toIntExact(maxOutstandingSplitsSize.toBytes()) / testSplitSizeInBytes;
        for (i = 0; i < maxSplitCount; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, maxSplitCount).size(), (int)maxSplitCount);
        for (i = 0; i < maxSplitCount; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        try {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(0));
            Assert.fail((String)"expect failure");
        }
        catch (PrestoException e) {
            Assertions.assertContains((String)e.getMessage(), (String)"Split buffering for database.table exceeded memory limit");
        }
    }

    @Test(timeOut=10000L)
    public void testEmptyBucket() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.bucketed((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.GLOBAL, Optional.empty()), (int)10, (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(0, OptionalInt.of(2)));
        hiveSplitSource.noMoreSplits();
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(0), 10).size(), (int)0);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(1), 10).size(), (int)0);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(2), 10).size(), (int)1);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(3), 10).size(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreloadSplitsForRewindableSplitSource() throws Exception {
        HiveSplitSource hiveSplitSource = HiveSplitSource.bucketedRewindable((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.GLOBAL, Optional.empty()), (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        for (int i = 0; i < 10; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i, OptionalInt.of(0)));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        SettableFuture splits = SettableFuture.create();
        CountDownLatch started = new CountDownLatch(1);
        Thread getterThread = new Thread(() -> {
            try {
                started.countDown();
                List<ConnectorSplit> batch = TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(0), 10);
                splits.set(batch);
            }
            catch (Throwable e) {
                splits.setException(e);
            }
        });
        getterThread.start();
        try {
            Assert.assertTrue((boolean)started.await(10L, TimeUnit.SECONDS));
            TimeUnit.MILLISECONDS.sleep(200L);
            Assert.assertFalse((boolean)splits.isDone());
            hiveSplitSource.noMoreSplits();
            List<ConnectorSplit> connectorSplits = (List<ConnectorSplit>)splits.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((int)connectorSplits.size(), (int)0);
            Assert.assertFalse((boolean)hiveSplitSource.isFinished());
            connectorSplits = TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(0), 10);
            for (int i = 0; i < 10; ++i) {
                Assert.assertEquals((int)((HiveSplit)connectorSplits.get(i)).getPartitionDataColumnCount(), (int)i);
            }
            Assert.assertTrue((boolean)hiveSplitSource.isFinished());
        }
        finally {
            getterThread.interrupt();
        }
    }

    @Test
    public void testRewindOneBucket() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.bucketedRewindable((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.GLOBAL, Optional.empty()), (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        for (int i = 0; i < 10; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i, OptionalInt.of(0)));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(i + 1));
        }
        hiveSplitSource.noMoreSplits();
        hiveSplitSource.rewind((ConnectorPartitionHandle)new HivePartitionHandle(0));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)10);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(0), 5).size(), (int)5);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)5);
        hiveSplitSource.rewind((ConnectorPartitionHandle)new HivePartitionHandle(0));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)10);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(0), 10).size(), (int)10);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)0);
        hiveSplitSource.rewind((ConnectorPartitionHandle)new HivePartitionHandle(0));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)10);
    }

    @Test
    public void testRewindMultipleBuckets() {
        HiveSplitSource hiveSplitSource = HiveSplitSource.bucketedRewindable((ConnectorSession)HiveTestUtils.SESSION, (String)"database", (String)"table", (CacheQuotaRequirement)new CacheQuotaRequirement(CacheQuotaScope.GLOBAL, Optional.empty()), (int)10, (DataSize)new DataSize(1.0, DataSize.Unit.MEGABYTE), (HiveSplitLoader)new TestingHiveSplitLoader(), (Executor)EXECUTOR, (CounterStat)new CounterStat());
        for (int i = 0; i < 10; ++i) {
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i, OptionalInt.of(1)));
            hiveSplitSource.addToQueue((InternalHiveSplit)new TestSplit(i, OptionalInt.of(2)));
            Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)(2 * (i + 1)));
        }
        hiveSplitSource.noMoreSplits();
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(1), 1).size(), (int)1);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(2), 2).size(), (int)2);
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)17);
        hiveSplitSource.rewind((ConnectorPartitionHandle)new HivePartitionHandle(1));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)18);
        Assert.assertEquals((int)TestHiveSplitSource.getSplits((ConnectorSplitSource)hiveSplitSource, OptionalInt.of(1), 1).size(), (int)1);
        hiveSplitSource.rewind((ConnectorPartitionHandle)new HivePartitionHandle(2));
        Assert.assertEquals((int)hiveSplitSource.getBufferedInternalSplitCount(), (int)19);
    }

    private static List<ConnectorSplit> getSplits(ConnectorSplitSource source, int maxSize) {
        return TestHiveSplitSource.getSplits(source, OptionalInt.empty(), maxSize);
    }

    private static List<ConnectorSplit> getSplits(ConnectorSplitSource source, OptionalInt bucketNumber, int maxSize) {
        if (bucketNumber.isPresent()) {
            return ((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)source.getNextBatch((ConnectorPartitionHandle)new HivePartitionHandle(bucketNumber.getAsInt()), maxSize))).getSplits();
        }
        return ((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)source.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, maxSize))).getSplits();
    }

    private static class TestSplit
    extends InternalHiveSplit {
        private TestSplit(int id) {
            this(id, OptionalInt.empty());
        }

        private TestSplit(int id, OptionalInt bucketNumber) {
            this(id, bucketNumber, new DataSize(100.0, DataSize.Unit.BYTE));
        }

        private TestSplit(int id, OptionalInt bucketNumber, DataSize fileSize) {
            super("path", 0L, fileSize.toBytes(), fileSize.toBytes(), Instant.now().toEpochMilli(), (List)ImmutableList.of((Object)new InternalHiveSplit.InternalHiveBlock(fileSize.toBytes(), (List)ImmutableList.of())), bucketNumber, bucketNumber, true, NodeSelectionStrategy.NO_PREFERENCE, false, new HiveSplitPartitionInfo(new Storage(StorageFormat.create((String)"serde", (String)"input", (String)"output"), "location", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), new Path("path").toUri(), (List)ImmutableList.of(), "partition-name", id, TableToPartitionMapping.empty(), Optional.empty(), (Set)ImmutableSet.of()), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        }
    }

    private static class TestingHiveSplitLoader
    implements HiveSplitLoader {
        private TestingHiveSplitLoader() {
        }

        public void start(HiveSplitSource splitSource) {
        }

        public void stop() {
        }
    }
}

