/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveTableLayoutHandle;
import com.facebook.presto.hive.HiveType;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveTableLayoutHandle {
    @Test
    public void testCanonicalizeDomain() {
        ImmutableMap predicateColumns = ImmutableMap.of((Object)"ds", (Object)this.getColumnHandle("ds", true), (Object)"col", (Object)this.getColumnHandle("col", false));
        TupleDomain domain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new Subfield("ds"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2022-01-01")), (Object)new Subfield("col"), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"id"))));
        TupleDomain newDomain = HiveTableLayoutHandle.canonicalizeDomainPredicate((TupleDomain)domain, (Map)predicateColumns, (PlanCanonicalizationStrategy)PlanCanonicalizationStrategy.CONNECTOR);
        Assert.assertTrue((boolean)newDomain.getDomains().isPresent());
        Assert.assertEquals((int)((Map)newDomain.getDomains().get()).size(), (int)1);
        Assert.assertEquals(((Map)newDomain.getDomains().get()).get(new Subfield("col")), (Object)Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"id")));
    }

    private HiveColumnHandle getColumnHandle(String name, boolean partitioned) {
        return new HiveColumnHandle(name, HiveType.HIVE_STRING, HiveType.HIVE_STRING.getTypeSignature(), 1, partitioned ? HiveColumnHandle.ColumnType.PARTITION_KEY : HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty());
    }
}

