/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationInitializer;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveHdfsConfiguration;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.authentication.HdfsAuthentication;
import com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.metastore.file.FileHiveMetastore;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;
import org.apache.hadoop.hive.serde2.thrift.test.IntString;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveUtil {
    public static FileHiveMetastore createTestingFileHiveMetastore(File catalogDirectory) {
        HiveClientConfig hiveClientConfig = new HiveClientConfig();
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        HiveHdfsConfiguration hdfsConfiguration = new HiveHdfsConfiguration(new HdfsConfigurationInitializer(hiveClientConfig, metastoreClientConfig), (Set)ImmutableSet.of(), hiveClientConfig);
        HdfsEnvironment hdfsEnvironment = new HdfsEnvironment((HdfsConfiguration)hdfsConfiguration, metastoreClientConfig, (HdfsAuthentication)new NoHdfsAuthentication());
        return new FileHiveMetastore(hdfsEnvironment, catalogDirectory.toURI().toString(), "test");
    }

    @Test
    public void testParseHiveTimestamp() {
        DateTime time = new DateTime(2011, 5, 6, 7, 8, 9, 123, TestHiveUtil.nonDefaultTimeZone());
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss"), (long)TestHiveUtil.unixTime(time, 0));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.S"), (long)TestHiveUtil.unixTime(time, 1));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSS"), (long)TestHiveUtil.unixTime(time, 3));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSSSSSS"), (long)TestHiveUtil.unixTime(time, 6));
        Assert.assertEquals((long)TestHiveUtil.parse(time, "yyyy-MM-dd HH:mm:ss.SSSSSSSSS"), (long)TestHiveUtil.unixTime(time, 7));
    }

    @Test
    public void testGetThriftDeserializer() {
        Properties schema = new Properties();
        schema.setProperty("serialization.lib", ThriftDeserializer.class.getName());
        schema.setProperty("serialization.class", IntString.class.getName());
        schema.setProperty("serialization.format", TBinaryProtocol.class.getName());
        Assertions.assertInstanceOf((Object)HiveUtil.getDeserializer((Configuration)new Configuration(false), (Properties)schema), ThriftDeserializer.class);
    }

    @Test
    public void testToPartitionValues() throws MetaException {
        TestHiveUtil.assertToPartitionValues("ds=2015-12-30/event_type=QueryCompletion");
        TestHiveUtil.assertToPartitionValues("ds=2015-12-30");
        TestHiveUtil.assertToPartitionValues("a=1/b=2/c=3");
        TestHiveUtil.assertToPartitionValues("a=1");
        TestHiveUtil.assertToPartitionValues("pk=!@%23$%25%5E&%2A()%2F%3D");
        TestHiveUtil.assertToPartitionValues("pk=__HIVE_DEFAULT_PARTITION__");
    }

    @Test
    public void testToPartitionNamesAndValues() throws MetaException {
        ArrayList<String> expectedKeyList1 = new ArrayList<String>();
        expectedKeyList1.add("ds");
        expectedKeyList1.add("event_type");
        TestHiveUtil.assertToPartitionNamesAndValues("ds=2015-12-30/event_type=QueryCompletion", expectedKeyList1);
        ArrayList<String> expectedKeyList2 = new ArrayList<String>();
        expectedKeyList2.add("a");
        expectedKeyList2.add("b");
        expectedKeyList2.add("c");
        TestHiveUtil.assertToPartitionNamesAndValues("a=1/b=2/c=3", expectedKeyList2);
        ArrayList<String> expectedKeyList3 = new ArrayList<String>();
        expectedKeyList3.add("pk");
        TestHiveUtil.assertToPartitionNamesAndValues("pk=!@%23$%25%5E&%2A()%2F%3D", expectedKeyList3);
        ArrayList<String> expectedKeyList4 = new ArrayList<String>();
        expectedKeyList4.add("pk");
        TestHiveUtil.assertToPartitionNamesAndValues("pk=__HIVE_DEFAULT_PARTITION__", expectedKeyList4);
    }

    @Test
    public void testShouldUseRecordReaderFromInputFormat() {
        StorageFormat hudiStorageFormat = StorageFormat.create((String)"parquet.hive.serde.ParquetHiveSerDe", (String)"org.apache.hudi.hadoop.HoodieParquetInputFormat", (String)"");
        Assert.assertFalse((boolean)HiveUtil.shouldUseRecordReaderFromInputFormat((Configuration)new Configuration(), (Storage)new Storage(hudiStorageFormat, "test", Optional.empty(), true, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (Map)ImmutableMap.of()));
        StorageFormat hudiRealtimeStorageFormat = StorageFormat.create((String)"parquet.hive.serde.ParquetHiveSerDe", (String)"org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat", (String)"");
        ImmutableMap customSplitInfo = ImmutableMap.of((Object)"custom_split_class", (Object)HoodieRealtimeFileSplit.class.getName(), (Object)"hudi_basepath", (Object)"/test/file.parquet", (Object)"hudi_delta_filepaths", (Object)"/test/.file_100.log", (Object)"hudi_max_commit_time", (Object)"100");
        Assert.assertTrue((boolean)HiveUtil.shouldUseRecordReaderFromInputFormat((Configuration)new Configuration(), (Storage)new Storage(hudiRealtimeStorageFormat, "test", Optional.empty(), true, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), (Map)customSplitInfo));
    }

    @Test
    public void testBuildDirectoryContextProperties() {
        Map additionalProperties = HiveUtil.buildDirectoryContextProperties((ConnectorSession)HiveTestUtils.SESSION);
        Assert.assertEquals((String)((String)additionalProperties.get("presto_query_id")), (String)HiveTestUtils.SESSION.getQueryId());
        Assert.assertEquals(Optional.ofNullable(additionalProperties.get("presto_query_source")), (Object)HiveTestUtils.SESSION.getSource());
        Assert.assertEquals(Optional.ofNullable(additionalProperties.get("presto_client_info")), (Object)HiveTestUtils.SESSION.getClientInfo());
        Assert.assertEquals((String)((String)additionalProperties.get("presto_user_name")), (String)HiveTestUtils.SESSION.getUser());
        Assert.assertEquals(Optional.ofNullable(additionalProperties.get("presto_metastore_header")), (Object)MetastoreUtil.getMetastoreHeaders((ConnectorSession)HiveTestUtils.SESSION));
    }

    private static void assertToPartitionValues(String partitionName) throws MetaException {
        List actual = MetastoreUtil.toPartitionValues((String)partitionName);
        ArrayList<Object> expected = new ArrayList<Object>();
        for (String s : actual) {
            ((AbstractList)expected).add(null);
        }
        Warehouse.makeValsFromName((String)partitionName, expected);
        Assert.assertEquals((Collection)actual, expected);
    }

    private static void assertToPartitionNamesAndValues(String partitionName, List<String> expectedKeyList) throws MetaException {
        String key;
        Map actual = MetastoreUtil.toPartitionNamesAndValues((String)partitionName);
        ArrayList expectedValueList = new ArrayList();
        for (String s : expectedKeyList) {
            ((AbstractList)expectedValueList).add(null);
        }
        Warehouse.makeValsFromName((String)partitionName, expectedValueList);
        Preconditions.checkState((actual.keySet().size() == expectedKeyList.size() ? 1 : 0) != 0, (Object)"Keyset size is not same");
        for (int index = 0; index < expectedKeyList.size() && actual.containsKey(key = expectedKeyList.get(index)); ++index) {
            Preconditions.checkState((boolean)actual.containsKey(key), (Object)"Actual result does not contains the key");
            String actualValue = (String)actual.get(key);
            String expectedValue = (String)((AbstractList)expectedValueList).get(index);
            Preconditions.checkState((boolean)actualValue.equals(expectedValue), (Object)"The actual value does not match the expected value");
        }
    }

    private static long parse(DateTime time, String pattern) {
        return HiveUtil.parseHiveTimestamp((String)DateTimeFormat.forPattern((String)pattern).print((ReadableInstant)time), (DateTimeZone)TestHiveUtil.nonDefaultTimeZone());
    }

    private static long unixTime(DateTime time, int factionalDigits) {
        int factor = (int)Math.pow(10.0, Math.max(0, 3 - factionalDigits));
        return time.getMillis() / (long)factor * (long)factor;
    }

    static DateTimeZone nonDefaultTimeZone() {
        String defaultId = DateTimeZone.getDefault().getID();
        for (String id : DateTimeZone.getAvailableIDs()) {
            DateTimeZone zone;
            if (id.equals(defaultId) || (zone = DateTimeZone.forID((String)id)).getStandardOffset(0L) == 0) continue;
            return zone;
        }
        throw new IllegalStateException("no non-default timezone");
    }
}

