/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveWriteUtils;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.io.Files;
import java.io.File;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveWriteUtils {
    private static final HdfsContext CONTEXT = new HdfsContext(HiveTestUtils.SESSION, "test_schema");

    @Test
    public void testIsS3FileSystem() {
        HdfsEnvironment hdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(new HiveClientConfig(), new MetastoreClientConfig());
        Assert.assertTrue((boolean)HiveWriteUtils.isS3FileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)new Path("s3://test-bucket/test-folder")));
        Assert.assertFalse((boolean)HiveWriteUtils.isS3FileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)new Path("/test-dir/test-folder")));
    }

    @Test
    public void testIsViewFileSystem() {
        HdfsEnvironment hdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(new HiveClientConfig(), new MetastoreClientConfig());
        Path viewfsPath = new Path("viewfs://ns-default/");
        Path nonViewfsPath = new Path("hdfs://localhost/test-dir/test-folder");
        hdfsEnvironment.getConfiguration(CONTEXT, viewfsPath).set("fs.viewfs.mounttable.ns-default.link./test-folder", "hdfs://localhost/app");
        Assert.assertTrue((boolean)HiveWriteUtils.isViewFileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)viewfsPath));
        Assert.assertFalse((boolean)HiveWriteUtils.isViewFileSystem((HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)nonViewfsPath));
    }

    @Test
    void testCreateTemporaryPathOnViewFS() {
        HdfsEnvironment hdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(new HiveClientConfig(), new MetastoreClientConfig());
        Path viewfsPath = new Path("viewfs://ns-default/test-dir");
        File storageDir = Files.createTempDir();
        hdfsEnvironment.getConfiguration(CONTEXT, viewfsPath).set("fs.viewfs.mounttable.ns-default.link./test-dir", "file://" + storageDir);
        Path temporaryPath = HiveWriteUtils.createTemporaryPath((ConnectorSession)HiveTestUtils.SESSION, (HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)viewfsPath);
        Assert.assertEquals((String)temporaryPath.getParent().toString(), (String)"viewfs://ns-default/test-dir/.hive-staging");
        try {
            UUID.fromString(temporaryPath.getName());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Expected a UUID folder name ");
        }
        temporaryPath = HiveWriteUtils.createTemporaryPath((ConnectorSession)HiveTestUtils.SESSION, (HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)viewfsPath);
        Assert.assertEquals((String)temporaryPath.getParent().toString(), (String)"viewfs://ns-default/test-dir/.hive-staging");
        try {
            UUID.fromString(temporaryPath.getName());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Expected a UUID folder name ");
        }
        temporaryPath = HiveWriteUtils.createTemporaryPath((ConnectorSession)HiveTestUtils.SESSION, (HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)new Path(viewfsPath, "non-existing"));
        Assert.assertEquals((String)temporaryPath.getParent().toString(), (String)"viewfs://ns-default/test-dir/.hive-staging");
        try {
            UUID.fromString(temporaryPath.getName());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Expected a UUID folder name ");
        }
    }

    @Test
    void testCreateTemporaryPathOnNonViewFS() {
        HdfsEnvironment hdfsEnvironment = HiveTestUtils.createTestHdfsEnvironment(new HiveClientConfig(), new MetastoreClientConfig());
        Path nonViewfsPath = new Path("file://" + Files.createTempDir());
        Path temporaryPath = HiveWriteUtils.createTemporaryPath((ConnectorSession)HiveTestUtils.SESSION, (HdfsContext)CONTEXT, (HdfsEnvironment)hdfsEnvironment, (Path)nonViewfsPath);
        Assert.assertEquals((String)temporaryPath.getParent().toString(), (String)"file:/tmp/presto-user");
        try {
            UUID.fromString(temporaryPath.getName());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Expected a UUID folder name ");
        }
    }
}

