/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestMergeJoinPlan
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.LINE_ITEM, (Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION), (Map<String, String>)ImmutableMap.of(), Optional.empty());
    }

    @Test
    public void testJoinType() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_join_customer_join_type WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.customer LIMIT 1000");
            queryRunner.execute("CREATE TABLE test_join_order_join_type WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.\"orders\" LIMIT 1000");
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer_join_type join test_join_order_join_type on test_join_customer_join_type.custkey = test_join_order_join_type.custkey", this.joinPlan("test_join_customer_join_type", "test_join_order_join_type", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.INNER, true));
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer_join_type left join test_join_order_join_type on test_join_customer_join_type.custkey = test_join_order_join_type.custkey", this.joinPlan("test_join_customer_join_type", "test_join_order_join_type", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.LEFT, false));
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer_join_type right join test_join_order_join_type on test_join_customer_join_type.custkey = test_join_order_join_type.custkey", this.joinPlan("test_join_customer_join_type", "test_join_order_join_type", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.RIGHT, false));
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer_join_type full join test_join_order_join_type on test_join_customer_join_type.custkey = test_join_order_join_type.custkey", this.joinPlan("test_join_customer_join_type", "test_join_order_join_type", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.FULL, false));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_join_customer_join_type");
            queryRunner.execute("DROP TABLE IF EXISTS test_join_order_join_type");
        }
    }

    @Test
    public void testSessionProperty() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_join_customer WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.customer LIMIT 1000");
            queryRunner.execute("CREATE TABLE test_join_order WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.\"orders\" LIMIT 1000");
            this.assertPlan("select * from test_join_customer join test_join_order on test_join_customer.custkey = test_join_order.custkey", this.joinPlan("test_join_customer", "test_join_order", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.INNER, false));
            this.assertPlan("select * from test_join_customer join test_join_order on test_join_customer.custkey = test_join_order.custkey", this.joinPlan("test_join_customer", "test_join_order", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.INNER, false));
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer join test_join_order on test_join_customer.custkey = test_join_order.custkey", this.joinPlan("test_join_customer", "test_join_order", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.INNER, true));
            this.assertPlan(this.groupedExecutionDisabled(), "select * from test_join_customer join test_join_order on test_join_customer.custkey = test_join_order.custkey", this.joinPlan("test_join_customer", "test_join_order", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.INNER, false));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_join_customer");
            queryRunner.execute("DROP TABLE IF EXISTS test_join_order");
        }
    }

    @Test
    public void testDifferentBucketedByKey() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_join_customer2 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['name'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.customer LIMIT 1000");
            queryRunner.execute("CREATE TABLE test_join_order2 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.\"orders\" LIMIT 1000");
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer2 join test_join_order2 on test_join_customer2.custkey = test_join_order2.custkey", this.joinPlan("test_join_customer2", "test_join_order2", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.INNER, false));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_join_customer2");
            queryRunner.execute("DROP TABLE IF EXISTS test_join_order2");
        }
    }

    @Test
    public void testDifferentSortByKey() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_join_customer3 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['name'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.customer LIMIT 1000");
            queryRunner.execute("CREATE TABLE test_join_order3 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.\"orders\" LIMIT 1000");
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer3 join test_join_order3 on test_join_customer3.custkey = test_join_order3.custkey", this.joinPlan("test_join_customer3", "test_join_order3", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.INNER, false));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_join_customer3");
            queryRunner.execute("DROP TABLE IF EXISTS test_join_order3");
        }
    }

    @Test
    public void testMultipleSortByKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_join_customer4 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey', 'name'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.customer LIMIT 1000");
            queryRunner.execute("CREATE TABLE test_join_order4 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.\"orders\" LIMIT 1000");
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer4 join test_join_order4 on test_join_customer4.custkey = test_join_order4.custkey", this.joinPlan("test_join_customer4", "test_join_order4", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.INNER, true));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_join_customer4");
            queryRunner.execute("DROP TABLE IF EXISTS test_join_order4");
        }
    }

    @Test
    public void testMultipleJoinKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_join_customer5( \"custkey\" bigint, \"name\" varchar(25), \"address\" varchar(40), \"orderkey\" bigint, \"phone\" varchar(15),                                \n \"acctbal\" double, \"mktsegment\" varchar(10), \"comment\" varchar(117), \"ds\" varchar(10)) WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey', 'orderkey'], \n  sorted_by = ARRAY['custkey', 'orderkey'], partitioned_by=array['ds'], \n  format = 'DWRF' )");
            queryRunner.execute("INSERT INTO test_join_customer5 \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.customer LIMIT 1000");
            queryRunner.execute("CREATE TABLE test_join_order5( \"orderkey\" bigint, \"custkey\" bigint, \"orderstatus\" varchar(1), \"totalprice\" double, \"orderdate\" date, \"orderpriority\" varchar(15), \"clerk\" varchar(15), \"shippriority\" integer, \"comment\" varchar(79),  \"ds\" varchar(10)) WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey', 'orderkey'], \n  sorted_by = ARRAY['custkey', 'orderkey'], partitioned_by=array['ds'])");
            queryRunner.execute("INSERT INTO test_join_order5 \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.orders LIMIT 1000");
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer5 join test_join_order5 on test_join_customer5.custkey = test_join_order5.custkey and test_join_customer5.orderkey = test_join_order5.orderkey", this.joinPlan("test_join_customer5", "test_join_order5", (List<String>)ImmutableList.of((Object)"custkey", (Object)"orderkey"), (List<String>)ImmutableList.of((Object)"custkey", (Object)"orderkey"), JoinNode.Type.INNER, true));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_join_customer5");
            queryRunner.execute("DROP TABLE IF EXISTS test_join_order5");
        }
    }

    @Test
    public void testMultiplePartitions() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_join_customer_multi_partitions WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.customer LIMIT 1000");
            queryRunner.execute("INSERT INTO test_join_customer_multi_partitions \nSELECT *, '2021-07-12' as ds FROM tpch.sf1.customer LIMIT 1000");
            queryRunner.execute("CREATE TABLE test_join_order_multi_partitions WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds']) AS \nSELECT *, '2021-07-11' as ds FROM tpch.sf1.\"orders\" LIMIT 1000");
            queryRunner.execute("INSERT INTO test_join_order_multi_partitions \nSELECT *, '2021-07-12' as ds FROM tpch.sf1.orders LIMIT 1000");
            this.assertPlan(this.mergeJoinEnabled(), "select * from test_join_customer_multi_partitions join test_join_order_multi_partitions on test_join_customer_multi_partitions.custkey = test_join_order_multi_partitions.custkey", this.joinPlan("test_join_customer_multi_partitions", "test_join_order_multi_partitions", (List<String>)ImmutableList.of((Object)"custkey"), (List<String>)ImmutableList.of((Object)"custkey"), JoinNode.Type.INNER, false));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_join_customer_multi_partitions");
            queryRunner.execute("DROP TABLE IF EXISTS test_join_order_multi_partitions");
        }
    }

    private Session groupedExecutionDisabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("prefer_merge_join", "true").setSystemProperty("grouped_execution", "false").setCatalogSessionProperty("hive", "order_based_execution_enabled", "true").build();
    }

    private Session mergeJoinEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("prefer_merge_join", "true").setSystemProperty("grouped_execution", "true").setCatalogSessionProperty("hive", "order_based_execution_enabled", "true").build();
    }

    private PlanMatchPattern joinPlan(String leftTableName, String rightTableName, List<String> leftJoinKeys, List<String> rightJoinKeys, JoinNode.Type joinType, boolean mergeJoinEnabled) {
        int suffix1 = 0;
        int suffix2 = 1;
        ImmutableMap.Builder leftColumnReferencesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder rightColumnReferencesBuilder = ImmutableMap.builder();
        ImmutableList.Builder joinClauses = ImmutableList.builder();
        for (int i = 0; i < leftJoinKeys.size(); ++i) {
            leftColumnReferencesBuilder.put((Object)(leftJoinKeys.get(i) + suffix1), (Object)leftJoinKeys.get(i));
            rightColumnReferencesBuilder.put((Object)(rightJoinKeys.get(i) + suffix2), (Object)rightJoinKeys.get(i));
            joinClauses.add((Object)PlanMatchPattern.equiJoinClause((String)(leftJoinKeys.get(i) + suffix1), (String)(rightJoinKeys.get(i) + suffix2)));
            suffix1 += 2;
            suffix2 += 2;
        }
        return mergeJoinEnabled ? PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.mergeJoin((JoinNode.Type)joinType, (List)joinClauses.build(), Optional.empty(), (PlanMatchPattern)PlanMatchPattern.tableScan((String)leftTableName, (Map)leftColumnReferencesBuilder.build()), (PlanMatchPattern)PlanMatchPattern.tableScan((String)rightTableName, (Map)rightColumnReferencesBuilder.build()))}) : PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.join((JoinNode.Type)joinType, (List)joinClauses.build(), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)leftTableName, (Map)leftColumnReferencesBuilder.build())}), (PlanMatchPattern)PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((String)rightTableName, (Map)rightColumnReferencesBuilder.build())}))});
    }
}

