/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.Session;
import com.facebook.presto.hive.HiveQueryRunner;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestSegmentedAggregation
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.createQueryRunner(ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.LINE_ITEM, (Object)TpchTable.CUSTOMER, (Object)TpchTable.NATION), (Map<String, String>)ImmutableMap.of((Object)"experimental.pushdown-subfields-enabled", (Object)"true"), Optional.empty());
    }

    @Test
    public void testSortedbyKeysPrefixNotASubsetOfGroupbyKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_segmented_aggregation_customer0 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey'], \n  sorted_by = ARRAY['name', 'custkey'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, count(name) FROM test_segmented_aggregation_customer0 \nWHERE ds = '2021-07-11' GROUP BY 1", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"custkey"}), (Map)ImmutableMap.of(Optional.of("count"), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of((Object)"name"))), (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_segmented_aggregation_customer0", (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"name", (Object)"name")))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_segmented_aggregation_customer0");
        }
    }

    @Test
    public void testAndSortedByKeysArePrefixOfGroupbyKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_segmented_aggregation_customer WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey', 'name'], \n  sorted_by = ARRAY['custkey', 'name'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT custkey, name, nationkey, COUNT(*) FROM test_segmented_aggregation_customer \nWHERE ds = '2021-07-11' GROUP BY 1, 2, 3", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"custkey", "name", "nationkey"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of((Object)"custkey", (Object)"name"), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_segmented_aggregation_customer", (Map)ImmutableMap.of((Object)"custkey", (Object)"custkey", (Object)"name", (Object)"name", (Object)"nationkey", (Object)"nationkey")))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_segmented_aggregation_customer");
        }
    }

    @Test
    public void testSortedByPrefixOfBucketedKeys() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_segmented_aggregation_customer2 WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey', 'name'], \n  sorted_by = ARRAY['custkey'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT name, custkey, COUNT(*) FROM test_segmented_aggregation_customer2 \nWHERE ds = '2021-07-11' GROUP BY 1, 2", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"name", "custkey"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of((Object)"custkey"), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_segmented_aggregation_customer2", (Map)ImmutableMap.of((Object)"name", (Object)"name", (Object)"custkey", (Object)"custkey")))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_segmented_aggregation_customer2");
        }
    }

    @Test
    public void testGroupByKeysShareElementsAsSortedByKeysPrefix() {
        QueryRunner queryRunner = this.getQueryRunner();
        try {
            queryRunner.execute("CREATE TABLE test_segmented_aggregation_customer_share_elements WITH ( \n  bucket_count = 4, bucketed_by = ARRAY['custkey', 'name', 'nationkey'], \n  sorted_by = ARRAY['custkey', 'phone'], partitioned_by=array['ds'], \n  format = 'DWRF' ) AS \nSELECT *, '2021-07-11' as ds FROM customer LIMIT 1000\n");
            this.assertPlan(this.orderBasedExecutionEnabled(), "SELECT name, custkey, nationkey, COUNT(*) FROM test_segmented_aggregation_customer_share_elements \nWHERE ds = '2021-07-11' GROUP BY 1, 2, 3", PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.aggregation((PlanMatchPattern.GroupingSetDescriptor)PlanMatchPattern.singleGroupingSet((String[])new String[]{"name", "custkey", "nationkey"}), (Map)ImmutableMap.of(Optional.empty(), (Object)PlanMatchPattern.functionCall((String)"count", (List)ImmutableList.of())), (List)ImmutableList.of((Object)"custkey"), (Map)ImmutableMap.of(), Optional.empty(), (AggregationNode.Step)AggregationNode.Step.SINGLE, (PlanMatchPattern)PlanMatchPattern.tableScan((String)"test_segmented_aggregation_customer_share_elements", (Map)ImmutableMap.of((Object)"name", (Object)"name", (Object)"custkey", (Object)"custkey", (Object)"nationkey", (Object)"nationkey")))}));
        }
        finally {
            queryRunner.execute("DROP TABLE IF EXISTS test_segmented_aggregation_customer_share_elements");
        }
    }

    private Session orderBasedExecutionEnabled() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("hive", "order_based_execution_enabled", "true").setSystemProperty("segmented_aggregation_enabled", "true").build();
    }
}

