/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowFieldName;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TestingSession;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSubfieldExtractor {
    private static final VariableReferenceExpression C_BIGINT = new VariableReferenceExpression(Optional.empty(), "c_bigint", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression C_BIGINT_ARRAY = new VariableReferenceExpression(Optional.empty(), "c_bigint_array", (Type)new ArrayType((Type)BigintType.BIGINT));
    private static final VariableReferenceExpression C_BIGINT_TO_BIGINT_MAP = new VariableReferenceExpression(Optional.empty(), "c_bigint_to_bigint_map", (Type)HiveTestUtils.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT));
    private static final VariableReferenceExpression C_VARCHAR_TO_BIGINT_MAP = new VariableReferenceExpression(Optional.empty(), "c_varchar_to_bigint_map", (Type)HiveTestUtils.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT));
    private static final VariableReferenceExpression C_STRUCT = new VariableReferenceExpression(Optional.empty(), "c_struct", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"x", (Type)BigintType.BIGINT)))), (Object)RowType.field((String)"c", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)RowType.field((String)"d", (Type)HiveTestUtils.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)), (Object)RowType.field((String)"e", (Type)HiveTestUtils.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)))));
    private static final ExpressionOptimizer TEST_EXPRESSION_OPTIMIZER = new ExpressionOptimizer(){

        public RowExpression optimize(RowExpression rowExpression, ExpressionOptimizer.Level level, ConnectorSession session) {
            return rowExpression;
        }

        public Object optimize(RowExpression expression, ExpressionOptimizer.Level level, ConnectorSession session, Function<VariableReferenceExpression, Object> variableResolver) {
            throw new UnsupportedOperationException();
        }
    };
    private FunctionAndTypeManager functionAndTypeManager;
    private SubfieldExtractor subfieldExtractor;

    @BeforeClass
    public void setup() {
        this.functionAndTypeManager = MetadataManager.createTestMetadataManager().getFunctionAndTypeManager();
        this.subfieldExtractor = new SubfieldExtractor((StandardFunctionResolution)new FunctionResolution(this.functionAndTypeManager.getFunctionAndTypeResolver()), TEST_EXPRESSION_OPTIMIZER, TestingSession.SESSION);
    }

    @Test
    public void test() {
        this.assertSubfieldExtract((RowExpression)C_BIGINT, "c_bigint");
        this.assertSubfieldExtract(this.arraySubscript((RowExpression)C_BIGINT_ARRAY, 5), "c_bigint_array[5]");
        this.assertSubfieldExtract(this.mapSubscript((RowExpression)C_BIGINT_TO_BIGINT_MAP, (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT)), "c_bigint_to_bigint_map[5]");
        this.assertSubfieldExtract(this.mapSubscript((RowExpression)C_VARCHAR_TO_BIGINT_MAP, (RowExpression)Expressions.constant((Object)Slices.utf8Slice((String)"foo"), (Type)VarcharType.VARCHAR)), "c_varchar_to_bigint_map[\"foo\"]");
        this.assertSubfieldExtract(this.dereference((RowExpression)C_STRUCT, 0), "c_struct.a");
        this.assertSubfieldExtract(this.dereference(this.dereference((RowExpression)C_STRUCT, 1), 0), "c_struct.b.x");
        this.assertSubfieldExtract(this.arraySubscript(this.dereference((RowExpression)C_STRUCT, 2), 5), "c_struct.c[5]");
        this.assertSubfieldExtract(this.mapSubscript(this.dereference((RowExpression)C_STRUCT, 3), (RowExpression)Expressions.constant((Object)5L, (Type)BigintType.BIGINT)), "c_struct.d[5]");
        this.assertSubfieldExtract(this.mapSubscript(this.dereference((RowExpression)C_STRUCT, 4), (RowExpression)Expressions.constant((Object)Slices.utf8Slice((String)"foo"), (Type)VarcharType.VARCHAR)), "c_struct.e[\"foo\"]");
        Assert.assertEquals((Object)this.subfieldExtractor.extract((RowExpression)Expressions.constant((Object)2L, (Type)IntegerType.INTEGER)), Optional.empty());
    }

    @Test
    public void testToRowExpression() {
        this.assertToRowExpression("a", (Type)DateType.DATE);
        this.assertToRowExpression("a[1]", (Type)new ArrayType((Type)IntegerType.INTEGER));
        this.assertToRowExpression("a.b", (Type)TestSubfieldExtractor.rowType((Map<String, Type>)ImmutableMap.of((Object)"b", (Object)VarcharType.VARCHAR, (Object)"c", (Object)DoubleType.DOUBLE)));
        this.assertToRowExpression("a[1]", (Type)HiveTestUtils.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE));
        this.assertToRowExpression("a[\"hello\"]", (Type)HiveTestUtils.mapType((Type)VarcharType.VARCHAR, (Type)RealType.REAL));
        this.assertToRowExpression("a[\"hello\"].b", (Type)HiveTestUtils.mapType((Type)VarcharType.VARCHAR, (Type)TestSubfieldExtractor.rowType((Map<String, Type>)ImmutableMap.of((Object)"b", (Object)BigintType.BIGINT))));
        this.assertToRowExpression("a[\"hello\"].b.c", (Type)HiveTestUtils.mapType((Type)VarcharType.VARCHAR, (Type)TestSubfieldExtractor.rowType((Map<String, Type>)ImmutableMap.of((Object)"b", (Object)TestSubfieldExtractor.rowType((Map<String, Type>)ImmutableMap.of((Object)"c", (Object)BigintType.BIGINT))))));
    }

    private void assertToRowExpression(String subfieldPath, Type type) {
        Subfield subfield = new Subfield(subfieldPath);
        Optional recreatedSubfield = this.subfieldExtractor.extract(this.subfieldExtractor.toRowExpression(subfield, type));
        org.testng.Assert.assertTrue((boolean)recreatedSubfield.isPresent());
        Assert.assertEquals(recreatedSubfield.get(), (Object)subfield);
    }

    private static RowType rowType(Map<String, Type> fields) {
        return HiveTestUtils.rowType((List)fields.entrySet().stream().map(entry -> new NamedTypeSignature(Optional.of(new RowFieldName((String)entry.getKey(), false)), ((Type)entry.getValue()).getTypeSignature())).collect(ImmutableList.toImmutableList()));
    }

    private void assertSubfieldExtract(RowExpression expression, String subfield) {
        Assert.assertEquals((Object)this.subfieldExtractor.extract(expression), Optional.of(new Subfield(subfield)));
    }

    private RowExpression dereference(RowExpression base, int field) {
        Type fieldType = (Type)base.getType().getTypeParameters().get(field);
        return Expressions.specialForm((SpecialFormExpression.Form)SpecialFormExpression.Form.DEREFERENCE, (Type)fieldType, (List)ImmutableList.of((Object)base, (Object)new ConstantExpression((Object)field, (Type)IntegerType.INTEGER)));
    }

    private RowExpression arraySubscript(RowExpression arrayExpression, int index) {
        ArrayType arrayType = (ArrayType)arrayExpression.getType();
        Type elementType = arrayType.getElementType();
        return Expressions.call((String)OperatorType.SUBSCRIPT.name(), (FunctionHandle)this.operator(OperatorType.SUBSCRIPT, new Type[]{arrayType, elementType}), (Type)elementType, (List)ImmutableList.of((Object)arrayExpression, (Object)Expressions.constant((Object)index, (Type)IntegerType.INTEGER)));
    }

    private RowExpression mapSubscript(RowExpression mapExpression, RowExpression keyExpression) {
        MapType mapType = (MapType)mapExpression.getType();
        return Expressions.call((String)OperatorType.SUBSCRIPT.name(), (FunctionHandle)this.operator(OperatorType.SUBSCRIPT, new Type[]{HiveTestUtils.mapType(mapType.getKeyType(), mapType.getValueType()), mapType.getKeyType()}), (Type)mapType.getValueType(), (List)ImmutableList.of((Object)mapExpression, (Object)keyExpression));
    }

    private FunctionHandle operator(OperatorType operatorType, Type ... types) {
        return this.functionAndTypeManager.resolveOperator(operatorType, TypeSignatureProvider.fromTypes((Type[])types));
    }
}

