/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.benchmark;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.common.io.OutputStreamDataSink;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.CacheQuota;
import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBatchPageSourceFactory;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.HiveDwrfEncryptionProvider;
import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.HiveFileSplit;
import com.facebook.presto.hive.HiveRecordCursorProvider;
import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.HiveTypeTranslator;
import com.facebook.presto.hive.RecordFileWriter;
import com.facebook.presto.hive.TypeTranslator;
import com.facebook.presto.hive.benchmark.FormatWriter;
import com.facebook.presto.hive.benchmark.HiveFileFormatBenchmark;
import com.facebook.presto.hive.metastore.Storage;
import com.facebook.presto.hive.metastore.StorageFormat;
import com.facebook.presto.hive.orc.DwrfBatchPageSourceFactory;
import com.facebook.presto.hive.orc.OrcBatchPageSourceFactory;
import com.facebook.presto.hive.pagefile.PageFilePageSourceFactory;
import com.facebook.presto.hive.pagefile.PageFileWriterFactory;
import com.facebook.presto.hive.pagefile.PageWriter;
import com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.orc.DwrfEncryptionProvider;
import com.facebook.presto.orc.NoOpOrcWriterStats;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.OrcWriterOptions;
import com.facebook.presto.orc.StorageStripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSource;
import com.facebook.presto.orc.StripeMetadataSourceFactory;
import com.facebook.presto.orc.WriterStats;
import com.facebook.presto.orc.cache.OrcFileTailSource;
import com.facebook.presto.orc.cache.StorageOrcFileTailSource;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.facebook.presto.parquet.writer.ParquetWriter;
import com.facebook.presto.parquet.writer.ParquetWriterOptions;
import com.facebook.presto.rcfile.AircompressorCodecFactory;
import com.facebook.presto.rcfile.HadoopCodecFactory;
import com.facebook.presto.rcfile.RcFileCodecFactory;
import com.facebook.presto.rcfile.RcFileEncoding;
import com.facebook.presto.rcfile.RcFileWriter;
import com.facebook.presto.rcfile.binary.BinaryRcFileEncoding;
import com.facebook.presto.rcfile.text.TextRcFileEncoding;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.page.PagesSerde;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.joda.time.DateTimeZone;

public enum FileFormat {
    PRESTO_RCBINARY{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            RcFilePageSourceFactory pageSourceFactory = new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, hdfsEnvironment, new FileFormatDataSourceStats());
            return 1.createPageSource((HiveBatchPageSourceFactory)pageSourceFactory, session, targetFile, columnNames, columnTypes, HiveStorageFormat.RCBINARY, 0L);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (RcFileEncoding)new BinaryRcFileEncoding(), compressionCodec);
        }
    }
    ,
    PRESTO_RCTEXT{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            RcFilePageSourceFactory pageSourceFactory = new RcFilePageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, hdfsEnvironment, new FileFormatDataSourceStats());
            return 2.createPageSource((HiveBatchPageSourceFactory)pageSourceFactory, session, targetFile, columnNames, columnTypes, HiveStorageFormat.RCTEXT, 0L);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (RcFileEncoding)new TextRcFileEncoding(DateTimeZone.forID((String)session.getSqlFunctionProperties().getTimeZoneKey().getId())), compressionCodec);
        }
    }
    ,
    PRESTO_ORC{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            OrcBatchPageSourceFactory pageSourceFactory = new OrcBatchPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, false, hdfsEnvironment, new FileFormatDataSourceStats(), 100, (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()));
            return 3.createPageSource((HiveBatchPageSourceFactory)pageSourceFactory, session, targetFile, columnNames, columnTypes, HiveStorageFormat.ORC, 0L);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoOrcFormatWriter(targetFile, columnNames, columnTypes, DateTimeZone.forID((String)session.getSqlFunctionProperties().getTimeZoneKey().getId()), compressionCodec);
        }
    }
    ,
    PRESTO_DWRF{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            DwrfBatchPageSourceFactory pageSourceFactory = new DwrfBatchPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, HiveTestUtils.HIVE_CLIENT_CONFIG, hdfsEnvironment, new FileFormatDataSourceStats(), (OrcFileTailSource)new StorageOrcFileTailSource(), StripeMetadataSourceFactory.of((StripeMetadataSource)new StorageStripeMetadataSource()), HiveDwrfEncryptionProvider.NO_ENCRYPTION);
            return 4.createPageSource((HiveBatchPageSourceFactory)pageSourceFactory, session, targetFile, columnNames, columnTypes, HiveStorageFormat.DWRF, 0L);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoDwrfFormatWriter(targetFile, columnNames, columnTypes, DateTimeZone.forID((String)session.getSqlFunctionProperties().getTimeZoneKey().getId()), compressionCodec);
        }

        @Override
        public boolean supportsDate() {
            return false;
        }
    }
    ,
    PRESTO_PAGE{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            PageFilePageSourceFactory pageSourceFactory = new PageFilePageSourceFactory(hdfsEnvironment, (BlockEncodingSerde)new BlockEncodingManager());
            return 5.createPageSource((HiveBatchPageSourceFactory)pageSourceFactory, session, targetFile, columnNames, columnTypes, HiveStorageFormat.PAGEFILE, 0L);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            if (!compressionCodec.isSupportedStorageFormat(HiveStorageFormat.PAGEFILE)) {
                compressionCodec = HiveCompressionCodec.NONE;
            }
            return new PrestoPageFormatWriter(targetFile, compressionCodec);
        }

        @Override
        public boolean supportsDate() {
            return true;
        }
    }
    ,
    PRESTO_PARQUET{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            ParquetPageSourceFactory pageSourceFactory = new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, hdfsEnvironment, new FileFormatDataSourceStats(), (ParquetMetadataSource)new MetadataReader());
            return 6.createPageSource((HiveBatchPageSourceFactory)pageSourceFactory, session, targetFile, columnNames, columnTypes, HiveStorageFormat.PARQUET, 0L);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoParquetFormatWriter(targetFile, columnNames, columnTypes, compressionCodec);
        }
    }
    ,
    HIVE_RCBINARY{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            GenericHiveRecordCursorProvider cursorProvider = new GenericHiveRecordCursorProvider(hdfsEnvironment);
            return 7.createPageSource((HiveRecordCursorProvider)cursorProvider, session, targetFile, columnNames, columnTypes, HiveStorageFormat.RCBINARY);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.RCBINARY, session);
        }
    }
    ,
    HIVE_RCTEXT{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            GenericHiveRecordCursorProvider cursorProvider = new GenericHiveRecordCursorProvider(hdfsEnvironment);
            return 8.createPageSource((HiveRecordCursorProvider)cursorProvider, session, targetFile, columnNames, columnTypes, HiveStorageFormat.RCTEXT);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.RCTEXT, session);
        }
    }
    ,
    HIVE_ORC{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            GenericHiveRecordCursorProvider cursorProvider = new GenericHiveRecordCursorProvider(hdfsEnvironment);
            return 9.createPageSource((HiveRecordCursorProvider)cursorProvider, session, targetFile, columnNames, columnTypes, HiveStorageFormat.ORC);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.ORC, session);
        }
    }
    ,
    HIVE_DWRF{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            GenericHiveRecordCursorProvider cursorProvider = new GenericHiveRecordCursorProvider(hdfsEnvironment);
            return 10.createPageSource((HiveRecordCursorProvider)cursorProvider, session, targetFile, columnNames, columnTypes, HiveStorageFormat.DWRF);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.DWRF, session);
        }

        @Override
        public boolean supportsDate() {
            return false;
        }
    }
    ,
    HIVE_PARQUET{

        @Override
        public ConnectorPageSource createFileFormatReader(ConnectorSession session, HdfsEnvironment hdfsEnvironment, File targetFile, List<String> columnNames, List<Type> columnTypes) {
            ParquetPageSourceFactory pageSourceFactory = new ParquetPageSourceFactory((TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, HiveTestUtils.FUNCTION_RESOLUTION, hdfsEnvironment, new FileFormatDataSourceStats(), (ParquetMetadataSource)new MetadataReader());
            return 11.createPageSource((HiveBatchPageSourceFactory)pageSourceFactory, session, targetFile, columnNames, columnTypes, HiveStorageFormat.PARQUET, 0L);
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.PARQUET, session);
        }
    };

    private static final long MODIFICATION_TIME_NOT_SET = 0L;
    private static final JobConf conf;

    public boolean supportsDate() {
        return true;
    }

    public abstract ConnectorPageSource createFileFormatReader(ConnectorSession var1, HdfsEnvironment var2, File var3, List<String> var4, List<Type> var5);

    public abstract FormatWriter createFileFormatWriter(ConnectorSession var1, File var2, List<String> var3, List<Type> var4, HiveCompressionCodec var5) throws IOException;

    public boolean supports(HiveFileFormatBenchmark.TestData testData) {
        return true;
    }

    public static ConnectorPageSource createPageSource(HiveRecordCursorProvider cursorProvider, ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveStorageFormat format) {
        ArrayList<HiveColumnHandle> columnHandles = new ArrayList<HiveColumnHandle>(columnNames.size());
        HiveTypeTranslator typeTranslator = new HiveTypeTranslator();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            Type columnType = columnTypes.get(i);
            columnHandles.add(new HiveColumnHandle(columnName, HiveType.toHiveType((TypeTranslator)typeTranslator, (Type)columnType), columnType.getTypeSignature(), i, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        }
        HiveFileSplit fileSplit = new HiveFileSplit(targetFile.getAbsolutePath(), 0L, targetFile.length(), targetFile.length(), 0L, Optional.empty(), (Map)ImmutableMap.of());
        RecordCursor recordCursor = (RecordCursor)cursorProvider.createRecordCursor((Configuration)conf, session, fileSplit, FileFormat.createSchema(format, columnNames, columnTypes), columnHandles, TupleDomain.all(), DateTimeZone.forID((String)session.getSqlFunctionProperties().getTimeZoneKey().getId()), (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, false).get();
        return new RecordPageSource(columnTypes, recordCursor);
    }

    public static ConnectorPageSource createPageSource(HiveBatchPageSourceFactory pageSourceFactory, ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveStorageFormat format, long modificationTime) {
        ArrayList<HiveColumnHandle> columnHandles = new ArrayList<HiveColumnHandle>(columnNames.size());
        HiveTypeTranslator typeTranslator = new HiveTypeTranslator();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            Type columnType = columnTypes.get(i);
            columnHandles.add(new HiveColumnHandle(columnName, HiveType.toHiveType((TypeTranslator)typeTranslator, (Type)columnType), columnType.getTypeSignature(), i, HiveColumnHandle.ColumnType.REGULAR, Optional.empty(), Optional.empty()));
        }
        SchemaTableName tableName = new SchemaTableName("hive", "testtable");
        HiveFileSplit fileSplit = new HiveFileSplit(targetFile.getAbsolutePath(), 0L, targetFile.length(), targetFile.length(), 0L, Optional.empty(), (Map)ImmutableMap.of());
        return (ConnectorPageSource)pageSourceFactory.createPageSource((Configuration)conf, session, fileSplit, new Storage(StorageFormat.create((String)format.getSerDe(), (String)format.getInputFormat(), (String)format.getOutputFormat()), "location", Optional.empty(), false, (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), tableName, (Map)ImmutableMap.of(), columnHandles, TupleDomain.all(), DateTimeZone.forID((String)session.getSqlFunctionProperties().getTimeZoneKey().getId()), new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), OptionalLong.of(targetFile.length()), OptionalLong.of(0L), OptionalLong.of(targetFile.length()), modificationTime, false), Optional.empty()).get();
    }

    private static Properties createSchema(HiveStorageFormat format, List<String> columnNames, List<Type> columnTypes) {
        Properties schema = new Properties();
        HiveTypeTranslator typeTranslator = new HiveTypeTranslator();
        schema.setProperty("serialization.lib", format.getSerDe());
        schema.setProperty("file.inputformat", format.getInputFormat());
        schema.setProperty("columns", columnNames.stream().collect(Collectors.joining(",")));
        schema.setProperty("columns.types", columnTypes.stream().map(arg_0 -> FileFormat.lambda$createSchema$0((TypeTranslator)typeTranslator, arg_0)).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
        return schema;
    }

    private static /* synthetic */ HiveType lambda$createSchema$0(TypeTranslator typeTranslator, Type type) {
        return HiveType.toHiveType((TypeTranslator)typeTranslator, (Type)type);
    }

    static {
        conf = new JobConf(new Configuration(false));
        conf.set("fs.file.impl", "org.apache.hadoop.fs.RawLocalFileSystem");
    }

    private static class PrestoPageFormatWriter
    implements FormatWriter {
        private final PageWriter writer;
        private final PagesSerde pagesSerde;

        public PrestoPageFormatWriter(File targetFile, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new PageWriter((DataSink)new OutputStreamDataSink((OutputStream)new FileOutputStream(targetFile)), compressionCodec, new DataSize(10.0, DataSize.Unit.MEGABYTE));
            this.pagesSerde = PageFileWriterFactory.createPagesSerdeForPageFile((BlockEncodingSerde)new BlockEncodingManager(), Optional.of(compressionCodec));
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(this.pagesSerde.serialize(page));
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoParquetFormatWriter
    implements FormatWriter {
        private final ParquetWriter writer;

        public PrestoParquetFormatWriter(File targetFile, List<String> columnNames, List<Type> types, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new ParquetWriter((OutputStream)new FileOutputStream(targetFile), columnNames, types, ParquetWriterOptions.builder().build(), ((CompressionCodecName)compressionCodec.getParquetCompressionCodec().get()).getHadoopCompressionCodecClassName());
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoDwrfFormatWriter
    implements FormatWriter {
        private final OrcWriter writer;

        public PrestoDwrfFormatWriter(File targetFile, List<String> columnNames, List<Type> types, DateTimeZone hiveStorageTimeZone, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new OrcWriter((DataSink)new OutputStreamDataSink((OutputStream)new FileOutputStream(targetFile)), columnNames, types, OrcEncoding.DWRF, compressionCodec.getOrcCompressionKind(), Optional.empty(), DwrfEncryptionProvider.NO_ENCRYPTION, OrcWriterOptions.builder().build(), (Map)ImmutableMap.of(), hiveStorageTimeZone, false, OrcWriteValidation.OrcWriteValidationMode.BOTH, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoOrcFormatWriter
    implements FormatWriter {
        private final OrcWriter writer;

        public PrestoOrcFormatWriter(File targetFile, List<String> columnNames, List<Type> types, DateTimeZone hiveStorageTimeZone, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new OrcWriter((DataSink)new OutputStreamDataSink((OutputStream)new FileOutputStream(targetFile)), columnNames, types, OrcEncoding.ORC, compressionCodec.getOrcCompressionKind(), Optional.empty(), DwrfEncryptionProvider.NO_ENCRYPTION, OrcWriterOptions.builder().build(), (Map)ImmutableMap.of(), hiveStorageTimeZone, false, OrcWriteValidation.OrcWriteValidationMode.BOTH, (WriterStats)NoOpOrcWriterStats.NOOP_WRITER_STATS);
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoRcFileFormatWriter
    implements FormatWriter {
        private final RcFileWriter writer;

        public PrestoRcFileFormatWriter(File targetFile, List<Type> types, RcFileEncoding encoding, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new RcFileWriter((SliceOutput)new OutputStreamSliceOutput((OutputStream)new FileOutputStream(targetFile)), types, encoding, compressionCodec.getCodec().map(Class::getName), (RcFileCodecFactory)new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(this.getClass().getClassLoader())), (Map)ImmutableMap.of(), true);
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class RecordFormatWriter
    implements FormatWriter {
        private final RecordFileWriter recordWriter;

        public RecordFormatWriter(File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec, HiveStorageFormat format, ConnectorSession session) {
            JobConf config = ConfigurationUtils.configureCompression((Configuration)conf, (HiveCompressionCodec)compressionCodec);
            this.recordWriter = new RecordFileWriter(new Path(targetFile.toURI()), columnNames, StorageFormat.fromHiveStorageFormat((HiveStorageFormat)format), FileFormat.createSchema(format, columnNames, columnTypes), format.getEstimatedWriterSystemMemoryUsage(), config, (TypeManager)HiveTestUtils.FUNCTION_AND_TYPE_MANAGER, session);
        }

        @Override
        public void writePage(Page page) {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.recordWriter.appendRow(page, position);
            }
        }

        @Override
        public void close() {
            this.recordWriter.commit();
        }
    }
}

