/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.hudi;

import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HivePlugin;
import com.facebook.presto.hive.hudi.HudiTestUtils;
import com.facebook.presto.hive.hudi.HudiTestingDataGenerator;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.testing.QueryRunner;
import com.facebook.presto.tests.AbstractTestQueryFramework;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.annotations.Test;

public class TestHudiIntegration
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return HudiTestUtils.createQueryRunner((Map<String, String>)ImmutableMap.of(), (Map<String, String>)ImmutableMap.of(), metastore -> new HivePlugin("hive", metastore), "hive", "hive", "testing");
    }

    @Test
    public void testMetadata() {
        this.assertQuery("show tables", "SELECT * FROM VALUES ('stock_ticks_cow'), ('stock_ticks_cown'), ('stock_ticks_mor_ro'), ('stock_ticks_mor_rt'),('stock_ticks_morn_ro'),('stock_ticks_morn_rt'),('stock_ticks_morn_only_log_ro'),('stock_ticks_morn_only_log_rt')");
        FunctionAndTypeManager typeManager = this.getQueryRunner().getMetadata().getFunctionAndTypeManager();
        String sql = TestHudiIntegration.generateDescribeIdenticalQuery((TypeManager)typeManager, HudiTestingDataGenerator.HUDI_META_COLUMNS, HudiTestingDataGenerator.DATA_COLUMNS, HudiTestingDataGenerator.PARTITION_COLUMNS);
        this.assertQuery("DESCRIBE stock_ticks_cow", sql);
        this.assertQuery("DESCRIBE stock_ticks_mor_ro", sql);
        this.assertQuery("DESCRIBE stock_ticks_mor_rt", sql);
        String sql2 = TestHudiIntegration.generateDescribeIdenticalQuery((TypeManager)typeManager, HudiTestingDataGenerator.HUDI_META_COLUMNS, HudiTestingDataGenerator.DATA_COLUMNS, (List<Column>)ImmutableList.of());
        this.assertQuery("DESCRIBE stock_ticks_cown", sql2);
        this.assertQuery("DESCRIBE stock_ticks_morn_ro", sql2);
        this.assertQuery("DESCRIBE stock_ticks_morn_rt", sql2);
    }

    @Test
    public void testDemoQuery1() {
        String sqlTemplate = "SELECT symbol, max(ts) FROM %s GROUP BY symbol HAVING symbol = 'GOOG'";
        String sqlResult = "SELECT 'GOOG', '2018-08-31 10:59:00'";
        String sqlResultReadOptimized = "SELECT 'GOOG', '2018-08-31 10:29:00'";
        String sqlResultEmpty = "SELECT * FROM VALUES ('', '') LIMIT 0";
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_cow"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_cown"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_mor_ro"), sqlResultReadOptimized);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_mor_rt"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_morn_ro"), sqlResultReadOptimized);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_morn_rt"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_morn_only_log_ro"), sqlResultEmpty);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_morn_only_log_rt"), sqlResult);
    }

    @Test
    public void testDemoQuery2() {
        String sqlTemplate = "SELECT \"_hoodie_record_key\", symbol, ts, volume, open, close  FROM %s WHERE symbol = 'GOOG'";
        String sqlResult = "SELECT * FROM VALUES ('GOOG_2018-08-31 09', 'GOOG', '2018-08-31 09:59:00', 6330, 1230.5, 1230.02), ('GOOG_2018-08-31 10', 'GOOG', '2018-08-31 10:59:00', 9021, 1227.1993, 1227.215)";
        String sqlResultReadOptimized = "SELECT * FROM VALUES ('GOOG_2018-08-31 09', 'GOOG', '2018-08-31 09:59:00', 6330, 1230.5, 1230.02), ('GOOG_2018-08-31 10', 'GOOG', '2018-08-31 10:29:00', 3391, 1230.1899, 1230.085)";
        String sqlResultEmpty = "SELECT * FROM VALUES ('', '') LIMIT 0";
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_cow"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_cown"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_mor_ro"), sqlResultReadOptimized);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_mor_rt"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_morn_ro"), sqlResultReadOptimized);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_morn_rt"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_morn_only_log_ro"), sqlResultEmpty);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_morn_only_log_rt"), sqlResult);
    }

    @Test
    public void testQueryWithPartitionColumn() {
        String sqlTemplate = "SELECT symbol, ts, dt FROM %s WHERE symbol = 'GOOG' AND dt = '2018-08-31'";
        String sqlResult = "SELECT * FROM VALUES ('GOOG', '2018-08-31 09:59:00', '2018-08-31'),('GOOG', '2018-08-31 10:59:00', '2018-08-31')";
        String sqlResultReadOptimized = "SELECT * FROM VALUES ('GOOG', '2018-08-31 09:59:00', '2018-08-31'),('GOOG', '2018-08-31 10:29:00', '2018-08-31')";
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_cow"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_mor_ro"), sqlResultReadOptimized);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_mor_rt"), sqlResult);
    }

    @Test
    public void testQueryOnUnavailablePartition() {
        String sqlTemplate = "SELECT symbol, ts, dt FROM %s WHERE symbol = 'GOOG' AND dt = '2018-08-30'";
        String sqlResult = "SELECT * FROM VALUES ('', '', '') LIMIT 0";
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_cow"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_mor_ro"), sqlResult);
        this.assertQuery(String.format(sqlTemplate, "stock_ticks_mor_rt"), sqlResult);
    }

    private static String generateDescribeIdenticalQuery(TypeManager typeManager, List<Column> metaColumns, List<Column> dataColumns, List<Column> partitionColumns) {
        Stream<String> regularRows = Streams.concat((Stream[])new Stream[]{metaColumns.stream(), dataColumns.stream()}).map(column -> String.format("('%s', '%s', '', '')", column.getName(), column.getType().getType(typeManager).getDisplayName()));
        Stream<String> partitionRows = partitionColumns.stream().map(column -> String.format("('%s', '%s', 'partition key', '')", column.getName(), column.getType().getType(typeManager).getDisplayName()));
        String rows = Streams.concat((Stream[])new Stream[]{regularRows, partitionRows}).collect(Collectors.joining(","));
        return "SELECT * FROM VALUES " + rows;
    }
}

