/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.hive.HiveTestUtils;
import com.facebook.presto.hive.MetastoreClientConfig;
import com.facebook.presto.hive.MockHiveMetastore;
import com.facebook.presto.hive.PartitionMutator;
import com.facebook.presto.hive.metastore.CachingHiveMetastore;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveColumnConverter;
import com.facebook.presto.hive.metastore.HivePartitionMutator;
import com.facebook.presto.hive.metastore.MetastoreCacheStats;
import com.facebook.presto.hive.metastore.NoopMetastoreCacheStats;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.thrift.BridgingHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveCluster;
import com.facebook.presto.hive.metastore.thrift.HiveMetastore;
import com.facebook.presto.hive.metastore.thrift.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.MockHiveMetastoreClient;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastore;
import com.facebook.presto.hive.metastore.thrift.ThriftHiveMetastoreStats;
import com.facebook.presto.spi.constraints.PrimaryKeyConstraint;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCachingHiveMetastore {
    private static final ImmutableList<String> EXPECTED_PARTITIONS = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2");
    private MockHiveMetastoreClient mockClient;
    private CachingHiveMetastore metastore;
    private ThriftHiveMetastoreStats stats;

    @BeforeMethod
    public void setUp() {
        this.mockClient = new MockHiveMetastoreClient();
        MockHiveCluster mockHiveCluster = new MockHiveCluster(this.mockClient);
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s")));
        MetastoreClientConfig metastoreClientConfig = new MetastoreClientConfig();
        ThriftHiveMetastore thriftHiveMetastore = new ThriftHiveMetastore((HiveCluster)mockHiveCluster, metastoreClientConfig, HiveTestUtils.HDFS_ENVIRONMENT);
        HivePartitionMutator hivePartitionMutator = new HivePartitionMutator();
        this.metastore = new CachingHiveMetastore((ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)thriftHiveMetastore, (PartitionMutator)hivePartitionMutator), (ExecutorService)executor, false, new Duration(5.0, TimeUnit.MINUTES), new Duration(1.0, TimeUnit.MINUTES), 1000L, false, CachingHiveMetastore.MetastoreCacheScope.ALL, 0.0, metastoreClientConfig.getPartitionCacheColumnCountLimit(), (MetastoreCacheStats)NoopMetastoreCacheStats.NOOP_METASTORE_CACHE_STATS);
        this.stats = thriftHiveMetastore.getStats();
    }

    @Test
    public void testGetAllDatabases() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testGetAllTable() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)((Collection)this.metastore.getAllTables(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb").get()), (Collection)ImmutableList.of((Object)"testtbl", (Object)"testtbl_constraints"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)((Collection)this.metastore.getAllTables(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb").get()), (Collection)ImmutableList.of((Object)"testtbl", (Object)"testtbl_constraints"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)((Collection)this.metastore.getAllTables(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb").get()), (Collection)ImmutableList.of((Object)"testtbl", (Object)"testtbl_constraints"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    public void testInvalidDbGetAllTAbles() {
        Assert.assertFalse((boolean)this.metastore.getAllTables(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "baddb").isPresent());
    }

    @Test
    public void testGetTable() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertNotNull((Object)this.metastore.getTable(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertNotNull((Object)this.metastore.getTable(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertNotNull((Object)this.metastore.getTable(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    public void testInvalidDbGetTable() {
        Assert.assertFalse((boolean)this.metastore.getTable(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "baddb", "testtbl").isPresent());
        Assert.assertEquals((long)this.stats.getGetTable().getThriftExceptions().getTotalCount(), (long)0L);
        Assert.assertEquals((long)this.stats.getGetTable().getTotalFailures().getTotalCount(), (long)0L);
        Assert.assertNotNull((Object)this.stats.getGetTable().getTime());
    }

    @Test
    public void testGetPartitionNames() {
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl").get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl").get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl").get()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testInvalidGetPartitionNames() {
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "baddb", "testtbl").get()), (Collection)ImmutableList.of());
    }

    @Test
    public void testGetPartitionNamesByParts() {
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.getPartitionNamesByFilter(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (Map)ImmutableMap.of()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.getPartitionNamesByFilter(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (Map)ImmutableMap.of()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.getPartitionNamesByFilter(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (Map)ImmutableMap.of()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testCachingWithPartitionVersioning() {
        MockHiveMetastoreClient mockClient = new MockHiveMetastoreClient();
        MockHiveCluster mockHiveCluster = new MockHiveCluster(mockClient);
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"partition-versioning-test-%s")));
        MockHiveMetastore mockHiveMetastore = new MockHiveMetastore(mockHiveCluster);
        MockPartitionMutator mockPartitionMutator = new MockPartitionMutator(UnaryOperator.identity());
        CachingHiveMetastore partitionCachingEnabledmetastore = new CachingHiveMetastore((ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)mockHiveMetastore, (PartitionMutator)mockPartitionMutator), (ExecutorService)executor, false, new Duration(5.0, TimeUnit.MINUTES), new Duration(1.0, TimeUnit.MINUTES), 1000L, true, CachingHiveMetastore.MetastoreCacheScope.PARTITION, 0.0, 10000, (MetastoreCacheStats)NoopMetastoreCacheStats.NOOP_METASTORE_CACHE_STATS);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)partitionCachingEnabledmetastore.getPartitionNamesByFilter(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (Map)ImmutableMap.of()), EXPECTED_PARTITIONS);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)partitionCachingEnabledmetastore.getPartitionNamesByFilter(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (Map)ImmutableMap.of()), EXPECTED_PARTITIONS);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((int)partitionCachingEnabledmetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)3);
        Assert.assertEquals((int)partitionCachingEnabledmetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)partitionCachingEnabledmetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition2")).size(), (int)1);
        Assert.assertEquals((int)partitionCachingEnabledmetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)3);
        Assert.assertEquals((Collection)partitionCachingEnabledmetastore.getPartitionNamesByFilter(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (Map)ImmutableMap.of()), EXPECTED_PARTITIONS);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)4);
        Assert.assertEquals((int)partitionCachingEnabledmetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)4);
        this.assertInvalidateCache(new MockPartitionMutator(version -> version + 1L));
        this.assertInvalidateCache(new MockPartitionMutator(version -> version - 1L));
    }

    private void assertInvalidateCache(MockPartitionMutator partitionMutator) {
        MockHiveMetastoreClient mockClient = new MockHiveMetastoreClient();
        MockHiveCluster mockHiveCluster = new MockHiveCluster(mockClient);
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"partition-versioning-test-%s")));
        MockHiveMetastore mockHiveMetastore = new MockHiveMetastore(mockHiveCluster);
        HiveColumnConverter hiveColumnConverter = new HiveColumnConverter();
        CachingHiveMetastore partitionCachingEnabledmetastore = new CachingHiveMetastore((ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)mockHiveMetastore, (PartitionMutator)partitionMutator), (ExecutorService)executor, false, new Duration(5.0, TimeUnit.MINUTES), new Duration(1.0, TimeUnit.MINUTES), 1000L, true, CachingHiveMetastore.MetastoreCacheScope.PARTITION, 0.0, 10000, (MetastoreCacheStats)NoopMetastoreCacheStats.NOOP_METASTORE_CACHE_STATS);
        int clientAccessCount = 0;
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((Collection)partitionCachingEnabledmetastore.getPartitionNamesByFilter(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (Map)ImmutableMap.of()), EXPECTED_PARTITIONS);
            Assert.assertEquals((int)mockClient.getAccessCount(), (int)(++clientAccessCount));
            Assert.assertEquals((int)partitionCachingEnabledmetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
            Assert.assertEquals((int)mockClient.getAccessCount(), (int)(++clientAccessCount));
        }
    }

    public void testInvalidGetPartitionNamesByParts() {
        Assert.assertTrue((boolean)this.metastore.getPartitionNamesByFilter(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "baddb", "testtbl", (Map)ImmutableMap.of()).isEmpty());
    }

    @Test
    public void testPartitionCacheValidation() {
        MockHiveMetastoreClient mockClient = new MockHiveMetastoreClient();
        MockHiveCluster mockHiveCluster = new MockHiveCluster(mockClient);
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"partition-versioning-test-%s")));
        MockHiveMetastore mockHiveMetastore = new MockHiveMetastore(mockHiveCluster);
        MockPartitionMutator mockPartitionMutator = new MockPartitionMutator(UnaryOperator.identity());
        HiveColumnConverter hiveColumnConverter = new HiveColumnConverter();
        CachingHiveMetastore partitionCacheVerificationEnabledMetastore = new CachingHiveMetastore((ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)mockHiveMetastore, (PartitionMutator)mockPartitionMutator), (ExecutorService)executor, false, new Duration(5.0, TimeUnit.MINUTES), new Duration(1.0, TimeUnit.MINUTES), 1000L, true, CachingHiveMetastore.MetastoreCacheScope.PARTITION, 100.0, 10000, (MetastoreCacheStats)NoopMetastoreCacheStats.NOOP_METASTORE_CACHE_STATS);
        partitionCacheVerificationEnabledMetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2"));
        partitionCacheVerificationEnabledMetastore.getPartition(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", MockHiveMetastoreClient.TEST_PARTITION_VALUES1);
        partitionCacheVerificationEnabledMetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1"));
        partitionCacheVerificationEnabledMetastore.getPartition(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", MockHiveMetastoreClient.TEST_PARTITION_VALUES2);
        partitionCacheVerificationEnabledMetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition2"));
    }

    @Test
    public void testPartitionCacheColumnCountLimit() {
        MockHiveMetastoreClient mockClient = new MockHiveMetastoreClient();
        MockHiveCluster mockHiveCluster = new MockHiveCluster(mockClient);
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"partition-versioning-test-%s")));
        MockHiveMetastore mockHiveMetastore = new MockHiveMetastore(mockHiveCluster);
        MockPartitionMutator mockPartitionMutator = new MockPartitionMutator(UnaryOperator.identity());
        CachingHiveMetastore partitionCachingEnabledMetastore = new CachingHiveMetastore((ExtendedHiveMetastore)new BridgingHiveMetastore((HiveMetastore)mockHiveMetastore, (PartitionMutator)mockPartitionMutator), (ExecutorService)executor, false, new Duration(5.0, TimeUnit.MINUTES), new Duration(1.0, TimeUnit.MINUTES), 1000L, true, CachingHiveMetastore.MetastoreCacheScope.PARTITION, 0.0, 1, (MetastoreCacheStats)NoopMetastoreCacheStats.NOOP_METASTORE_CACHE_STATS);
        Assert.assertEquals((int)partitionCachingEnabledMetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((int)partitionCachingEnabledMetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((int)partitionCachingEnabledMetastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)mockClient.getAccessCount(), (int)3);
    }

    @Test
    public void testGetPartitionsByNames() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        this.metastore.getTable(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition2")).size(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        this.metastore.flushCache();
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
    }

    @Test
    public void testListRoles() throws Exception {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.listRoles(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Collection)MockHiveMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.listRoles(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Collection)MockHiveMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.listRoles(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Collection)MockHiveMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        this.metastore.createRole(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "role", "grantor");
        Assert.assertEquals((Collection)this.metastore.listRoles(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Collection)MockHiveMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        this.metastore.dropRole(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testrole");
        Assert.assertEquals((Collection)this.metastore.listRoles(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT), (Collection)MockHiveMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
    }

    public void testInvalidGetPartitionsByNames() {
        Map partitionsByNames = this.metastore.getPartitionsByNames(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "baddb", "testtbl", (List)ImmutableList.of((Object)"key=testpartition1"));
        Assert.assertEquals((int)partitionsByNames.size(), (int)1);
        Optional onlyElement = (Optional)Iterables.getOnlyElement(partitionsByNames.values());
        Assert.assertFalse((boolean)onlyElement.isPresent());
    }

    @Test
    public void testNoCacheExceptions() {
        this.mockClient.setThrowException(true);
        try {
            this.metastore.getAllDatabases(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        try {
            this.metastore.getAllDatabases(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testTableConstraints() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        List tableConstraints = this.metastore.getTableConstraints(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl_constraints");
        Assert.assertEquals(tableConstraints.get(0), (Object)new PrimaryKeyConstraint("", (Set)ImmutableSet.of((Object)"c1"), true, true));
        Assert.assertEquals(tableConstraints.get(1), (Object)new UniqueConstraint("", (Set)ImmutableSet.of((Object)"c2"), true, true));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        this.metastore.getTableConstraints(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl_constraints");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        this.metastore.flushCache();
        this.metastore.getTableConstraints(MockHiveMetastoreClient.TEST_METASTORE_CONTEXT, "testdb", "testtbl_constraints");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
    }

    public static class MockHiveCluster
    implements HiveCluster {
        private final MockHiveMetastoreClient client;

        private MockHiveCluster(MockHiveMetastoreClient client) {
            this.client = client;
        }

        public HiveMetastoreClient createMetastoreClient(Optional<String> token) {
            return this.client;
        }

        public MockHiveMetastoreClient createPartitionVersionSupportedMetastoreClient() {
            return this.client;
        }
    }

    private static class MockPartitionMutator
    implements PartitionMutator {
        private final Function<Long, Long> versionUpdater;
        private long version = 1000L;

        public MockPartitionMutator(Function<Long, Long> versionUpdater) {
            this.versionUpdater = versionUpdater;
        }

        public void mutate(Partition.Builder builder, Partition partition) {
            this.version = this.versionUpdater.apply(this.version);
            builder.setPartitionVersion(this.version);
        }
    }
}

